/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.r2dbc;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.r2dbc.Binder;
import org.komapper.r2dbc.R2dbcDataOperator;
import org.komapper.r2dbc.R2dbcDataType;
import org.komapper.r2dbc.R2dbcDataTypeProvider;
import org.komapper.r2dbc.R2dbcDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J1\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u0001H\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u001b\u001a\u00020\u0013\"\b\b\u0000\u0010\t*\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u0001H\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\t0 \"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010!\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010 \"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\"\u001a\u00020\u0013\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/komapper/r2dbc/DefaultR2dbcDataOperator;", "Lorg/komapper/r2dbc/R2dbcDataOperator;", "dialect", "Lorg/komapper/r2dbc/R2dbcDialect;", "dataTypeProvider", "Lorg/komapper/r2dbc/R2dbcDataTypeProvider;", "<init>", "(Lorg/komapper/r2dbc/R2dbcDialect;Lorg/komapper/r2dbc/R2dbcDataTypeProvider;)V", "getValue", "T", "", "row", "Lio/r2dbc/spi/Row;", "index", "", "type", "Lkotlin/reflect/KType;", "(Lio/r2dbc/spi/Row;ILkotlin/reflect/KType;)Ljava/lang/Object;", "columnLabel", "", "(Lio/r2dbc/spi/Row;Ljava/lang/String;Lkotlin/reflect/KType;)Ljava/lang/Object;", "setValue", "", "statement", "Lio/r2dbc/spi/Statement;", "value", "(Lio/r2dbc/spi/Statement;ILjava/lang/Object;Lkotlin/reflect/KType;)V", "formatValue", "masking", "", "(Ljava/lang/Object;Lkotlin/reflect/KType;Z)Ljava/lang/String;", "getDataType", "Lorg/komapper/r2dbc/R2dbcDataType;", "getDataTypeOrNull", "getDataTypeName", "komapper-r2dbc"})
public final class DefaultR2dbcDataOperator
implements R2dbcDataOperator {
    @NotNull
    private final R2dbcDialect dialect;
    @NotNull
    private final R2dbcDataTypeProvider dataTypeProvider;

    public DefaultR2dbcDataOperator(@NotNull R2dbcDialect dialect, @NotNull R2dbcDataTypeProvider dataTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        this.dialect = dialect;
        this.dataTypeProvider = dataTypeProvider;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Row row, int index, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        R2dbcDataType<T> dataType = this.getDataType(type);
        return dataType.getValue(row, index);
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Row row, @NotNull String columnLabel, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        R2dbcDataType<T> dataType = this.getDataType(type);
        return dataType.getValue(row, columnLabel);
    }

    @Override
    public <T> void setValue(@NotNull Statement statement, int index, @Nullable T value, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        R2dbcDataType<T> dataType = this.getDataType(type);
        Binder bindMarker = this.dialect.getBinder();
        bindMarker.bind(statement, index, value, dataType);
    }

    @NotNull
    public <T> String formatValue(@Nullable T value, @NotNull KType type, boolean masking) {
        R2dbcDataType<T> r2dbcDataType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (masking) {
            r2dbcDataType = this.dialect.getMask();
        } else {
            R2dbcDataType<T> dataType = this.getDataTypeOrNull(type);
            r2dbcDataType = dataType;
            if (r2dbcDataType == null || (r2dbcDataType = r2dbcDataType.toString(value)) == null) {
                r2dbcDataType = String.valueOf(value);
            }
        }
        return r2dbcDataType;
    }

    @Override
    @NotNull
    public <T> R2dbcDataType<T> getDataType(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        R2dbcDataType<T> r2dbcDataType = this.getDataTypeOrNull(type);
        if (r2dbcDataType == null) {
            throw new IllegalStateException(("The dataType is not found for the type \"" + type + "\".").toString());
        }
        return r2dbcDataType;
    }

    @Override
    @Nullable
    public <T> R2dbcDataType<T> getDataTypeOrNull(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.dataTypeProvider.get(type);
    }

    @NotNull
    public <T> String getDataTypeName(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        R2dbcDataType<T> dataType = this.getDataType(type);
        return dataType.getName();
    }
}

