/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.r2dbc;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.komapper.r2dbc.AbstractR2dbcDataType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0002H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/komapper/r2dbc/R2dbcBooleanType;", "Lorg/komapper/r2dbc/AbstractR2dbcDataType;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "convertBeforeGetting", "value", "", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "doToString", "komapper-r2dbc"})
public final class R2dbcBooleanType
extends AbstractR2dbcDataType<Boolean> {
    @NotNull
    private final String name;

    public R2dbcBooleanType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(Reflection.typeOf(Boolean.TYPE), null, 2, null);
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected Boolean convertBeforeGetting(@NotNull Object value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Boolean) {
            bl = (Boolean)value;
        } else if (object instanceof Number) {
            bl = ((Number)value).intValue() == 1;
        } else {
            throw new IllegalStateException(("Cannot convert. value=" + value + ", type=" + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + ".").toString());
        }
        return bl;
    }

    @Override
    @NotNull
    protected String doToString(boolean value) {
        String string = String.valueOf(value).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }
}

