/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.spi.SpiUtilityKt;
import org.komapper.r2dbc.R2dbcDialect;
import org.komapper.r2dbc.spi.R2dbcDialectFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/komapper/r2dbc/R2dbcDialects;", "", "<init>", "()V", "r2dbcUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "get", "Lorg/komapper/r2dbc/R2dbcDialect;", "driver", "", "getOrNull", "getByOptions", "options", "Lio/r2dbc/spi/ConnectionFactoryOptions;", "Lkotlin/Function1;", "getByUrl", "url", "extractR2dbcDriver", "komapper-r2dbc"})
@SourceDebugExtension(value={"SMAP\nR2dbcDialects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 R2dbcDialects.kt\norg/komapper/r2dbc/R2dbcDialects\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n774#2:69\n865#2,2:70\n1#3:72\n*S KotlinDebug\n*F\n+ 1 R2dbcDialects.kt\norg/komapper/r2dbc/R2dbcDialects\n*L\n29#1:69\n29#1:70,2\n*E\n"})
public final class R2dbcDialects {
    @NotNull
    public static final R2dbcDialects INSTANCE = new R2dbcDialects();
    private static final Pattern r2dbcUrlPattern = Pattern.compile("^r2dbc[s]?:(tc:)?(pool:)?([^:]*):.*");

    private R2dbcDialects() {
    }

    @NotNull
    public final R2dbcDialect get(@NotNull String driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        R2dbcDialect r2dbcDialect = this.getOrNull(driver);
        if (r2dbcDialect == null) {
            throw new IllegalStateException(("The dialect is not found. Try to add the 'komapper-dialect-" + driver + "-r2dbc' dependency. driver='" + driver + "'").toString());
        }
        return r2dbcDialect;
    }

    /*
     * WARNING - void declaration
     */
    private final R2dbcDialect getOrNull(String driver) {
        R2dbcDialectFactory factory;
        void $this$filterTo$iv$iv;
        ServiceLoader<R2dbcDialectFactory> loader = ServiceLoader.load(R2dbcDialectFactory.class);
        Intrinsics.checkNotNull(loader);
        Iterable $this$filter$iv = loader;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            R2dbcDialectFactory it = (R2dbcDialectFactory)element$iv$iv;
            boolean bl = false;
            if (!it.supports(driver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        R2dbcDialectFactory r2dbcDialectFactory = factory = (R2dbcDialectFactory)SpiUtilityKt.findByPriority((Iterable)((List)destination$iv$iv));
        return r2dbcDialectFactory != null ? r2dbcDialectFactory.create() : null;
    }

    @NotNull
    public final R2dbcDialect getByOptions(@NotNull ConnectionFactoryOptions options, @NotNull Function1<? super String, ? extends R2dbcDialect> getOrNull) {
        R2dbcDialect dialect;
        R2dbcDialect r2dbcDialect;
        String driverDelegate;
        String protocol;
        String driver;
        block2: {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(getOrNull, (String)"getOrNull");
            Object object = options.getValue(ConnectionFactoryOptions.DRIVER);
            driver = object != null ? object.toString() : null;
            Object object2 = options.getValue(ConnectionFactoryOptions.PROTOCOL);
            protocol = object2 != null ? object2.toString() : null;
            Object object3 = protocol;
            driverDelegate = object3 != null && (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])(objectArray = new String[]{":"}), (boolean)false, (int)2, (int)2, null)) != null ? (String)CollectionsKt.first((List)object3) : null;
            objectArray = new String[]{driver, driverDelegate};
            for (String it : SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray))) {
                boolean bl = false;
                R2dbcDialect r2dbcDialect2 = (R2dbcDialect)getOrNull.invoke((Object)it);
                if (r2dbcDialect2 == null) continue;
                r2dbcDialect = r2dbcDialect2;
                break block2;
            }
            r2dbcDialect = null;
        }
        R2dbcDialect r2dbcDialect3 = dialect = r2dbcDialect;
        if (r2dbcDialect3 == null) {
            throw new IllegalStateException(("The dialect is not found. driver='" + driver + "', protocol='" + protocol + "', driverDelegate='" + driverDelegate + "'").toString());
        }
        return r2dbcDialect3;
    }

    public static /* synthetic */ R2dbcDialect getByOptions$default(R2dbcDialects r2dbcDialects, ConnectionFactoryOptions connectionFactoryOptions, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = (Function1)new Function1<String, R2dbcDialect>((Object)r2dbcDialects){

                public final R2dbcDialect invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return R2dbcDialects.access$getOrNull((R2dbcDialects)this.receiver, p0);
                }
            };
        }
        return r2dbcDialects.getByOptions(connectionFactoryOptions, (Function1<? super String, ? extends R2dbcDialect>)function1);
    }

    @NotNull
    public final R2dbcDialect getByUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String driver = this.extractR2dbcDriver(url);
        return this.get(driver);
    }

    @NotNull
    public final String extractR2dbcDriver(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Matcher matcher = r2dbcUrlPattern.matcher(url);
        if (matcher.matches()) {
            String string = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }
        throw new IllegalStateException(("The driver is not found in the R2DBC URL. url=" + url).toString());
    }

    public static final /* synthetic */ R2dbcDialect access$getOrNull(R2dbcDialects $this, String driver) {
        return $this.getOrNull(driver);
    }
}

