/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.r2dbc;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.komapper.r2dbc.AbstractR2dbcDataType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/komapper/r2dbc/R2dbcInstantAsTimestampWithTimezoneType;", "Lorg/komapper/r2dbc/AbstractR2dbcDataType;", "Ljava/time/Instant;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "convertBeforeGetting", "value", "", "convertBeforeBinding", "komapper-r2dbc"})
public final class R2dbcInstantAsTimestampWithTimezoneType
extends AbstractR2dbcDataType<Instant> {
    @NotNull
    private final String name;

    public R2dbcInstantAsTimestampWithTimezoneType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(Reflection.typeOf(Instant.class), OffsetDateTime.class);
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected Instant convertBeforeGetting(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof LocalDateTime) {
            Instant instant2 = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
        } else if (object instanceof OffsetDateTime) {
            Instant instant3 = ((OffsetDateTime)value).toInstant();
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"toInstant(...)");
        } else {
            throw new IllegalStateException(("Cannot convert. value=" + value + ", type=" + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + ".").toString());
        }
        return instant;
    }

    @Override
    @NotNull
    protected Object convertBeforeBinding(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        OffsetDateTime offsetDateTime = value.atOffset(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"atOffset(...)");
        return offsetDateTime;
    }
}

