/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.r2dbc.dsl.runner;

import io.r2dbc.spi.Row;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.DatabaseConfig;
import org.komapper.core.DryRunStatement;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.Statement;
import org.komapper.core.dsl.context.SelectContext;
import org.komapper.core.dsl.runner.SelectRunner;
import org.komapper.r2dbc.R2dbcDataOperator;
import org.komapper.r2dbc.R2dbcDatabaseConfig;
import org.komapper.r2dbc.R2dbcExecutor;
import org.komapper.r2dbc.dsl.runner.R2dbcFlowBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B5\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/komapper/r2dbc/dsl/runner/R2dbcSelectFlowBuilder;", "T", "Lorg/komapper/r2dbc/dsl/runner/R2dbcFlowBuilder;", "context", "Lorg/komapper/core/dsl/context/SelectContext;", "transform", "Lkotlin/Function2;", "Lorg/komapper/r2dbc/R2dbcDataOperator;", "Lio/r2dbc/spi/Row;", "<init>", "(Lorg/komapper/core/dsl/context/SelectContext;Lkotlin/jvm/functions/Function2;)V", "runner", "Lorg/komapper/core/dsl/runner/SelectRunner;", "check", "", "config", "Lorg/komapper/core/DatabaseConfig;", "build", "Lkotlinx/coroutines/flow/Flow;", "Lorg/komapper/r2dbc/R2dbcDatabaseConfig;", "dryRun", "Lorg/komapper/core/DryRunStatement;", "komapper-r2dbc"})
public final class R2dbcSelectFlowBuilder<T>
implements R2dbcFlowBuilder<T> {
    @NotNull
    private final SelectContext<?, ?, ?> context;
    @NotNull
    private final Function2<R2dbcDataOperator, Row, T> transform;
    @NotNull
    private final SelectRunner runner;

    public R2dbcSelectFlowBuilder(@NotNull SelectContext<?, ?, ?> context, @NotNull Function2<? super R2dbcDataOperator, ? super Row, ? extends T> transform) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.context = context;
        this.transform = transform;
        this.runner = new SelectRunner(this.context);
    }

    @Override
    public void check(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.runner.check(config);
    }

    @Override
    @NotNull
    public Flow<T> build(@NotNull R2dbcDatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Statement statement = this.runner.buildStatement((DatabaseConfig)config);
        R2dbcExecutor executor = new R2dbcExecutor(config, (ExecutionOptionsProvider)this.context.getOptions(), null, 4, null);
        return executor.executeQuery(statement, this.transform);
    }

    @Override
    @NotNull
    public DryRunStatement dryRun(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.runner.dryRun(config);
    }
}

