/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.tx.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.LoggerFacade;
import org.komapper.r2dbc.R2dbcSession;
import org.komapper.tx.core.CoroutineTransactionOperator;
import org.komapper.tx.core.EmptyTransactionProperty;
import org.komapper.tx.core.FlowTransactionOperator;
import org.komapper.tx.core.TransactionProperty;
import org.komapper.tx.r2dbc.R2dbcCoroutineTransactionOperator;
import org.komapper.tx.r2dbc.R2dbcFlowTransactionOperator;
import org.komapper.tx.r2dbc.R2dbcTransactionManager;
import org.komapper.tx.r2dbc.R2dbcTransactionManagerImpl;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/komapper/tx/r2dbc/R2dbcTransactionSession;", "Lorg/komapper/r2dbc/R2dbcSession;", "connectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "loggerFacade", "Lorg/komapper/core/LoggerFacade;", "transactionProperty", "Lorg/komapper/tx/core/TransactionProperty;", "<init>", "(Lio/r2dbc/spi/ConnectionFactory;Lorg/komapper/core/LoggerFacade;Lorg/komapper/tx/core/TransactionProperty;)V", "getConnectionFactory", "()Lio/r2dbc/spi/ConnectionFactory;", "transactionManager", "Lorg/komapper/tx/r2dbc/R2dbcTransactionManager;", "coroutineTransactionOperator", "Lorg/komapper/tx/core/CoroutineTransactionOperator;", "getCoroutineTransactionOperator", "()Lorg/komapper/tx/core/CoroutineTransactionOperator;", "flowTransactionOperator", "Lorg/komapper/tx/core/FlowTransactionOperator;", "getFlowTransactionOperator", "()Lorg/komapper/tx/core/FlowTransactionOperator;", "getConnection", "Lio/r2dbc/spi/Connection;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "releaseConnection", "", "connection", "(Lio/r2dbc/spi/Connection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "komapper-tx-r2dbc"})
public final class R2dbcTransactionSession
implements R2dbcSession {
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final R2dbcTransactionManager transactionManager;
    @NotNull
    private final CoroutineTransactionOperator coroutineTransactionOperator;
    @NotNull
    private final FlowTransactionOperator flowTransactionOperator;

    public R2dbcTransactionSession(@NotNull ConnectionFactory connectionFactory, @NotNull LoggerFacade loggerFacade, @NotNull TransactionProperty transactionProperty) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)loggerFacade, (String)"loggerFacade");
        Intrinsics.checkNotNullParameter((Object)transactionProperty, (String)"transactionProperty");
        this.connectionFactory = connectionFactory;
        this.transactionManager = new R2dbcTransactionManagerImpl(this.getConnectionFactory(), loggerFacade);
        this.coroutineTransactionOperator = new R2dbcCoroutineTransactionOperator(this.transactionManager, transactionProperty);
        this.flowTransactionOperator = new R2dbcFlowTransactionOperator(this.transactionManager, transactionProperty);
    }

    public /* synthetic */ R2dbcTransactionSession(ConnectionFactory connectionFactory, LoggerFacade loggerFacade, TransactionProperty transactionProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            transactionProperty = (TransactionProperty)EmptyTransactionProperty.INSTANCE;
        }
        this(connectionFactory, loggerFacade, transactionProperty);
    }

    @NotNull
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @NotNull
    public CoroutineTransactionOperator getCoroutineTransactionOperator() {
        return this.coroutineTransactionOperator;
    }

    @NotNull
    public FlowTransactionOperator getFlowTransactionOperator() {
        return this.flowTransactionOperator;
    }

    @Nullable
    public Object getConnection(@NotNull Continuation<? super Connection> $completion) {
        return this.transactionManager.getConnection($completion);
    }

    @Nullable
    public Object releaseConnection(@NotNull Connection connection, @NotNull Continuation<? super Unit> $completion) {
        Publisher publisher = connection.close();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"close(...)");
        Object object = FlowKt.collect((Flow)ReactiveFlowKt.asFlow((Publisher)publisher), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public <R> Object useConnection(@NotNull Function2<? super Connection, ? super Continuation<? super R>, ? extends Object> block, @NotNull Continuation<? super R> $completion) {
        return R2dbcSession.DefaultImpls.useConnection((R2dbcSession)this, block, $completion);
    }
}

