/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONUtil;
import org.kopitubruk.util.json.StringProcessor;

public final class BadPropertyNameException
extends JSONException {
    private String propertyName;
    private JSONConfig cfg;
    private static final long serialVersionUID = 1L;

    BadPropertyNameException(String propertyName, JSONConfig cfg) {
        super(cfg);
        this.propertyName = propertyName;
        this.cfg = cfg.clone();
        this.cfg.setBadCharacterPolicy(3);
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        if (this.propertyName == null || this.propertyName.length() < 1) {
            return bundle.getString("zeroLengthPropertyName");
        }
        if (JSONUtil.isReservedWord(this.propertyName)) {
            return String.format(bundle.getString("reservedWord"), this.propertyName);
        }
        LinkedHashSet<Integer> badCodePoints = new LinkedHashSet<Integer>();
        boolean badStart = false;
        boolean useSingleLetterEscapes = this.cfg.isFullJSONIdentifierCodePoints();
        Pattern escapePassThroughPat = StringProcessor.getEscapePassThroughPattern(this.cfg, useSingleLetterEscapes);
        Matcher passThroughMatcher = escapePassThroughPat.matcher(this.propertyName);
        int passThroughRegionLength = StringProcessor.getEscapePassThroughRegionLength(this.cfg);
        StringBuilder codePointList = new StringBuilder();
        StringProcessor cp = new StringProcessor(this.propertyName, this.cfg);
        while (cp.nextReady()) {
            if (cp.getCodePoint() == 92) {
                if (StringProcessor.gotMatch(passThroughMatcher, cp.getIndex(), cp.end(passThroughRegionLength))) {
                    cp.setIndex(passThroughMatcher.group(1).length());
                } else {
                    badCodePoints.add(cp.getCodePoint());
                    if (cp.getIndex() == 0) {
                        badStart = true;
                    }
                }
            } else if (!(cp.getIndex() == 0 && JSONUtil.isValidIdentifierStart(cp.getCodePoint(), this.cfg) || cp.getIndex() > 0 && JSONUtil.isValidIdentifierPart(cp.getCodePoint(), this.cfg))) {
                badCodePoints.add(cp.getCodePoint());
                if (cp.getIndex() == 0) {
                    badStart = true;
                }
            }
            if (cp.getIndex() > 0) {
                codePointList.append(' ');
            }
            codePointList.append(String.format("%04X", cp.getCodePoint()));
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format(bundle.getString("invalidPropertyName"), this.propertyName.replaceAll("[\\p{Cntrl}\\p{Co}\\p{Cn}]", "."), codePointList.toString()));
        codePointList = null;
        if (badCodePoints.size() > 0) {
            String mfmt = bundle.getString("badCodePoint");
            boolean firstCodePoint = badStart;
            Iterator i$ = badCodePoints.iterator();
            while (i$.hasNext()) {
                String fmt;
                int badCodePoint = (Integer)i$.next();
                if (firstCodePoint) {
                    fmt = bundle.getString("badStart");
                    firstCodePoint = false;
                } else {
                    fmt = mfmt;
                }
                message.append(String.format(fmt, badCodePoint, Character.getName(badCodePoint)));
            }
        }
        return message.toString();
    }
}

