/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kopitubruk.util.json.IndentPadding;
import org.kopitubruk.util.json.JMXUtil;
import org.kopitubruk.util.json.JNDIUtil;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONConfigDefaultsMBean;
import org.kopitubruk.util.json.JSONConfigUtil;
import org.kopitubruk.util.json.JSONReflectedClass;
import org.kopitubruk.util.json.JSONReflectionException;
import org.kopitubruk.util.json.JSONUtil;
import org.kopitubruk.util.json.ReflectUtil;
import org.kopitubruk.util.json.ReflectedObjectMapBuilder;

public class JSONConfigDefaults
implements JSONConfigDefaultsMBean,
Serializable {
    private static volatile boolean validatePropertyNames;
    private static volatile boolean detectDataStructureLoops;
    private static volatile boolean escapeBadIdentifierCodePoints;
    private static volatile boolean fullJSONIdentifierCodePoints;
    private static volatile boolean fastStrings;
    private static volatile boolean encodeNumericStringsAsNumbers;
    private static volatile boolean escapeNonAscii;
    private static volatile boolean unEscapeWherePossible;
    private static volatile boolean escapeSurrogates;
    private static volatile boolean passThroughEscapes;
    private static volatile boolean encodeDatesAsStrings;
    private static volatile boolean reflectUnknownObjects;
    private static volatile boolean preciseNumbers;
    private static volatile boolean smallNumbers;
    private static volatile boolean usePrimitiveArrays;
    private static volatile boolean cacheReflectionData;
    private static volatile boolean quoteIdentifier;
    private static volatile boolean useECMA6;
    private static volatile boolean allowReservedWordsInIdentifiers;
    private static volatile boolean encodeDatesAsObjects;
    private static volatile Locale locale;
    private static volatile Map<Class<? extends Number>, NumberFormat> numberFormatMap;
    private static volatile DateFormat dateGenFormat;
    private static volatile List<DateFormat> dateParseFormats;
    private static volatile IndentPadding indentPadding;
    private static volatile Map<Class<?>, JSONReflectedClass> reflectClasses;
    private static volatile int reflectionPrivacy;
    private static volatile int unmatchedSurrogatePolicy;
    private static volatile int undefinedCodePointPolicy;
    private static ObjectName mBeanName;
    private static JSONConfigDefaults jsonConfigDefaults;
    private static boolean logging;
    private static LogFactory logFactory;
    private static Log log;
    private static final Pattern DATE_PARSE_FORMAT_PAT;
    private static final Pattern REFLECT_CLASS_PAT;
    private static final long serialVersionUID = 1L;

    private static synchronized void ensureLogger() {
        if (log == null) {
            logFactory = LogFactory.getFactory();
            log = logFactory.getInstance(JSONConfigDefaults.class);
        }
    }

    private static synchronized void releaseLogger() {
        if (log != null) {
            logFactory.release();
            log = null;
            logFactory = null;
        }
    }

    private static boolean initJNDI(String loggingProperty, boolean registerMBean, String appName, Map<String, String> results) {
        block12: {
            JNDIUtil.setLogging(logging);
            try {
                String languageTag;
                Context ctx = JNDIUtil.getEnvContext(jsonConfigDefaults.getClass().getPackage().getName().replaceAll("\\.", "/"));
                Map<String, Object> jndiData = JNDIUtil.getJNDIVariables(ctx);
                if (loggingProperty == null) {
                    logging = JNDIUtil.getBoolean(jndiData, "logging", logging);
                    JNDIUtil.setLogging(logging);
                }
                if ((registerMBean = JNDIUtil.getBoolean(jndiData, "registerMBean", registerMBean)) && appName == null) {
                    appName = JNDIUtil.getString(jndiData, "appName", null);
                    results.put("appName", appName);
                }
                if ((languageTag = JNDIUtil.getString(jndiData, "locale", null)) != null) {
                    jsonConfigDefaults.setLocaleLanguageTag(languageTag);
                } else {
                    languageTag = JNDIUtil.getString(jndiData, "defaultLocale", null);
                    if (languageTag != null) {
                        jsonConfigDefaults.setLocaleLanguageTag(languageTag);
                    }
                }
                JSONConfigDefaults.loadDateFormatsFromJNDI(jndiData);
                JSONConfigDefaults.loadReflectClassesFromJNDI(jndiData);
                JSONConfigDefaults.setFlagsFromJNDI(jndiData);
                try {
                    jsonConfigDefaults.setReflectionPrivacy(JNDIUtil.getInt(jndiData, "reflectionPrivacy", reflectionPrivacy));
                }
                catch (JSONReflectionException ex) {
                    if (logging) {
                        JSONConfigDefaults.ensureLogger();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
                        }
                    }
                    reflectionPrivacy = 3;
                }
                if (jndiData.containsKey("badCharacterPolicy")) {
                    JSONConfigDefaults.setBadCharacterPolicy(JNDIUtil.getInt(jndiData, "badCharacterPolicy", 0));
                }
                jsonConfigDefaults.setUndefinedCodePointPolicy(JNDIUtil.getInt(jndiData, "undefinedCodePointPolicy", undefinedCodePointPolicy));
                jsonConfigDefaults.setUnmatchedSurrogatePolicy(JNDIUtil.getInt(jndiData, "unmatchedSurrogatePolicy", unmatchedSurrogatePolicy));
            }
            catch (Exception e) {
                if (!logging) break block12;
                JSONConfigDefaults.ensureLogger();
                if (!log.isDebugEnabled()) break block12;
                ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
                log.debug((Object)bundle.getString("badJNDIforConfig"), (Throwable)e);
            }
        }
        return registerMBean;
    }

    private static void loadDateFormatsFromJNDI(Map<String, Object> jndiData) {
        String dgf = JNDIUtil.getString(jndiData, "dateGenFormat", null);
        if (dgf != null) {
            jsonConfigDefaults.setDateGenFormat(dgf);
        }
        ArrayList<String> fmtNums = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : jndiData.entrySet()) {
            Matcher matcher;
            if (!(entry.getValue() instanceof String) || !(matcher = DATE_PARSE_FORMAT_PAT.matcher(entry.getKey())).matches()) continue;
            fmtNums.add(matcher.group(1));
        }
        if (fmtNums.size() > 0) {
            Collections.sort(fmtNums, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return new Integer(o1).compareTo(new Integer(o2));
                }
            });
            for (String num : fmtNums) {
                String dpf = JNDIUtil.getString(jndiData, "dateParseFormat" + num, null);
                if (dpf == null) continue;
                jsonConfigDefaults.addDateParseFormat(dpf);
            }
        }
    }

    private static void loadReflectClassesFromJNDI(Map<String, Object> jndiData) {
        ArrayList<JSONReflectedClass> classes = new ArrayList<JSONReflectedClass>();
        for (Map.Entry<String, Object> entry : jndiData.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String) || !REFLECT_CLASS_PAT.matcher(entry.getKey()).matches()) continue;
            String className = (String)value;
            try {
                classes.add(new JSONReflectedClass(className));
            }
            catch (ClassNotFoundException e) {
                if (!logging) continue;
                JSONConfigDefaults.ensureLogger();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)JSONConfigDefaults.getClassNotFoundExceptionMsg(e, className, false), (Throwable)e);
            }
        }
        JSONConfigDefaults.addReflectClasses(classes);
    }

    private static void setFlagsFromJNDI(Map<String, Object> jndiData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<Map.Entry<String, Object>> booleans = new ArrayList<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : jndiData.entrySet()) {
            if (!(entry.getValue() instanceof Boolean)) continue;
            booleans.add(entry);
        }
        if (booleans.size() < 1) {
            return;
        }
        Class<?> clazz = jsonConfigDefaults.getClass();
        Map<String, Field> fields = ReflectUtil.getFields(clazz, Boolean.TYPE);
        for (Map.Entry entry : booleans) {
            Method setter;
            Field field = fields.get(entry.getKey());
            if (field == null) continue;
            ReflectUtil.ensureAccessible(field);
            boolean currentValue = field.getBoolean(jsonConfigDefaults);
            boolean jndiValue = (Boolean)entry.getValue();
            if (jndiValue == currentValue || (setter = ReflectUtil.getSetter(clazz, field)) == null) continue;
            ReflectUtil.ensureAccessible(setter);
            setter.invoke((Object)jsonConfigDefaults, jndiValue);
        }
    }

    private static void initMBean(String appName) {
        block8: {
            if (appName == null) {
                appName = String.format("%X", new Random().nextLong());
            }
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanName = JMXUtil.getObjectName(jsonConfigDefaults, appName);
                try {
                    ObjectInstance instance = mBeanServer.getObjectInstance(mBeanName);
                    if (instance != null) {
                        mBeanServer.unregisterMBean(mBeanName);
                    }
                }
                catch (Exception instance) {
                    // empty catch block
                }
                mBeanServer.registerMBean(jsonConfigDefaults, mBeanName);
                if (logging) {
                    JSONConfigDefaults.ensureLogger();
                    if (log.isDebugEnabled()) {
                        ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
                        log.debug((Object)String.format(bundle.getString("registeredMbean"), mBeanName));
                    }
                }
            }
            catch (Exception e) {
                if (!logging) break block8;
                JSONConfigDefaults.ensureLogger();
                if (!log.isDebugEnabled()) break block8;
                ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
                log.debug((Object)bundle.getString("couldntRegisterMBean"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearMBean() {
        if (mBeanName != null) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(mBeanName);
                if (logging) {
                    JSONConfigDefaults.ensureLogger();
                    if (log.isDebugEnabled()) {
                        ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
                        log.debug((Object)String.format(bundle.getString("unregistered"), mBeanName));
                    }
                }
            }
            catch (Exception e) {
                if (logging) {
                    JSONConfigDefaults.ensureLogger();
                    if (log.isErrorEnabled()) {
                        ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
                        log.error((Object)String.format(bundle.getString("couldntUnregister"), mBeanName), (Throwable)e);
                    }
                }
            }
            finally {
                mBeanName = null;
            }
        }
        JSONConfigDefaults.releaseLogger();
    }

    public static JSONConfigDefaults getInstance() {
        return jsonConfigDefaults;
    }

    private JSONConfigDefaults() {
        this.setCodeDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodeDefaults() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            validatePropertyNames = true;
            detectDataStructureLoops = true;
            escapeBadIdentifierCodePoints = false;
            fullJSONIdentifierCodePoints = false;
            fastStrings = false;
            encodeNumericStringsAsNumbers = false;
            escapeNonAscii = false;
            unEscapeWherePossible = false;
            escapeSurrogates = false;
            passThroughEscapes = false;
            encodeDatesAsStrings = false;
            reflectUnknownObjects = false;
            preciseNumbers = false;
            smallNumbers = false;
            usePrimitiveArrays = false;
            cacheReflectionData = false;
            quoteIdentifier = true;
            useECMA6 = false;
            allowReservedWordsInIdentifiers = false;
            encodeDatesAsObjects = false;
            locale = null;
            numberFormatMap = null;
            dateGenFormat = null;
            dateParseFormats = null;
            indentPadding = null;
            reflectClasses = null;
            reflectionPrivacy = 3;
            unmatchedSurrogatePolicy = 0;
            undefinedCodePointPolicy = 4;
        }
    }

    static synchronized void initJSONConfig(JSONConfig cfg, Locale loc) {
        cfg.setLocale(loc);
        cfg.addNumberFormats(JSONConfigDefaults.getNumberFormatMap());
        cfg.setDateGenFormat(JSONConfigDefaults.getDateGenFormat());
        cfg.addDateParseFormats(JSONConfigDefaults.getDateParseFormats());
        cfg.setReflectionPrivacy(reflectionPrivacy);
        cfg.setUndefinedCodePointPolicy(undefinedCodePointPolicy);
        cfg.setUnmatchedSurrogatePolicy(unmatchedSurrogatePolicy);
        HashMap refClasses = null;
        if (reflectClasses != null) {
            refClasses = new HashMap(reflectClasses.size());
        }
        if (refClasses != null) {
            for (Map.Entry<Class<?>, JSONReflectedClass> entry : reflectClasses.entrySet()) {
                refClasses.put(entry.getKey(), entry.getValue().clone());
            }
        }
        cfg.setReflectClasses(refClasses);
        cfg.setValidatePropertyNames(validatePropertyNames);
        cfg.setDetectDataStructureLoops(detectDataStructureLoops);
        cfg.setEscapeBadIdentifierCodePoints(escapeBadIdentifierCodePoints);
        cfg.setFullJSONIdentifierCodePoints(fullJSONIdentifierCodePoints);
        cfg.setFastStrings(fastStrings);
        cfg.setEncodeNumericStringsAsNumbers(encodeNumericStringsAsNumbers);
        cfg.setEscapeNonAscii(escapeNonAscii);
        cfg.setUnEscapeWherePossible(unEscapeWherePossible);
        cfg.setEscapeSurrogates(escapeSurrogates);
        cfg.setPassThroughEscapes(passThroughEscapes);
        cfg.setEncodeDatesAsStrings(encodeDatesAsStrings);
        cfg.setReflectUnknownObjects(reflectUnknownObjects);
        cfg.setPreciseNumbers(preciseNumbers);
        cfg.setSmallNumbers(smallNumbers);
        cfg.setUsePrimitiveArrays(usePrimitiveArrays);
        cfg.setCacheReflectionData(cacheReflectionData);
        cfg.setQuoteIdentifier(quoteIdentifier);
        cfg.setUseECMA6(useECMA6);
        cfg.setAllowReservedWordsInIdentifiers(allowReservedWordsInIdentifiers);
        cfg.setEncodeDatesAsObjects(encodeDatesAsObjects);
        if (indentPadding == null) {
            cfg.setIndentPadding(indentPadding);
        } else {
            cfg.setIndentPadding(indentPadding.clone());
        }
    }

    @Override
    public String getLocaleLanguageTag() {
        return JSONConfigDefaults.getLocale().toLanguageTag();
    }

    @Override
    public void setLocaleLanguageTag(String languageTag) {
        if (languageTag != null) {
            JSONConfigDefaults.setLocale(Locale.forLanguageTag(languageTag.replaceAll("_", "-")));
        } else {
            JSONConfigDefaults.setLocale(null);
        }
    }

    @Deprecated
    public void setLocale(String languageTag) {
        this.setLocaleLanguageTag(languageTag);
    }

    public static synchronized Locale getLocale() {
        return locale != null ? locale : Locale.getDefault();
    }

    public static synchronized void setLocale(Locale loc) {
        locale = loc;
    }

    static Map<Class<? extends Number>, NumberFormat> getNumberFormatMap() {
        return numberFormatMap;
    }

    public static synchronized NumberFormat getNumberFormat(Class<? extends Number> numericClass) {
        return numberFormatMap != null ? numberFormatMap.get(numericClass) : null;
    }

    public static NumberFormat getNumberFormat(Number num) {
        return num != null ? JSONConfigDefaults.getNumberFormat(num.getClass()) : null;
    }

    public static void addNumberFormat(Class<? extends Number> numericClass, NumberFormat fmt) {
        if (numericClass != null) {
            if (fmt == null) {
                JSONConfigDefaults.removeNumberFormat(numericClass);
            } else {
                HashMap<Class<? extends Number>, NumberFormat> numFmtMap = new HashMap<Class<? extends Number>, NumberFormat>(2);
                numFmtMap.put(numericClass, fmt);
                JSONConfigDefaults.addNumberFormats(numFmtMap);
            }
        }
    }

    public static void addNumberFormat(Number numericType, NumberFormat fmt) {
        if (numericType != null) {
            JSONConfigDefaults.addNumberFormat(numericType.getClass(), fmt);
        }
    }

    public static synchronized void addNumberFormats(Map<Class<? extends Number>, NumberFormat> numFmtMap) {
        numberFormatMap = JSONConfigUtil.mergeFormatMaps(numberFormatMap, numFmtMap);
    }

    public static synchronized void removeNumberFormat(Class<? extends Number> numericClass) {
        if (numberFormatMap != null && numericClass != null) {
            int size = numberFormatMap.size();
            numberFormatMap.remove(numericClass);
            if (numberFormatMap.size() < 1) {
                numberFormatMap = null;
            } else if (JSONConfigUtil.tableSizeFor(size) > JSONConfigUtil.tableSizeFor(numberFormatMap.size())) {
                numberFormatMap = new HashMap<Class<? extends Number>, NumberFormat>(numberFormatMap);
            }
        }
    }

    public static void removeNumberFormat(Number num) {
        if (num != null) {
            JSONConfigDefaults.removeNumberFormat(num.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearNumberFormats() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            numberFormatMap = null;
        }
    }

    static DateFormat getDateGenFormat() {
        return dateGenFormat;
    }

    @Override
    public DateFormat setDateGenFormat(String fmtStr) {
        SimpleDateFormat fmt = null;
        if (fmtStr != null) {
            fmt = new SimpleDateFormat(fmtStr, JSONConfigDefaults.getLocale());
            JSONConfigDefaults.setDateGenFormat(fmt);
        } else {
            JSONConfigDefaults.setDateGenFormat(null);
        }
        return fmt;
    }

    public static synchronized void setDateGenFormat(DateFormat fmt) {
        dateGenFormat = fmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDateGenFormat() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            dateGenFormat = null;
        }
    }

    static List<DateFormat> getDateParseFormats() {
        return dateParseFormats;
    }

    @Override
    public DateFormat addDateParseFormat(String fmtStr) {
        SimpleDateFormat fmt = new SimpleDateFormat(fmtStr, JSONConfigDefaults.getLocale());
        JSONConfigDefaults.addDateParseFormat(fmt);
        return fmt;
    }

    public static void addDateParseFormat(DateFormat fmt) {
        if (fmt != null) {
            JSONConfigDefaults.addDateParseFormats(Arrays.asList(fmt));
        }
    }

    public static synchronized void addDateParseFormats(Collection<? extends DateFormat> fmts) {
        dateParseFormats = JSONConfigUtil.addDateParseFormats(dateParseFormats, fmts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDateParseFormats() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            dateParseFormats = null;
        }
    }

    public static synchronized IndentPadding getIndentPadding() {
        return indentPadding;
    }

    public static synchronized void setIndentPadding(IndentPadding indentPadding) {
        JSONConfigDefaults.indentPadding = indentPadding;
    }

    @Override
    public int getReflectionPrivacy() {
        return reflectionPrivacy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReflectionPrivacy(int dflt) throws MBeanException {
        try {
            int privacyLevel = ReflectUtil.confirmPrivacyLevel(dflt, new JSONConfig());
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                reflectionPrivacy = privacyLevel;
            }
        }
        catch (JSONReflectionException e) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (logging) {
                    JSONConfigDefaults.ensureLogger();
                    if (log.isErrorEnabled()) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    JSONConfigDefaults.releaseLogger();
                }
                throw new MBeanException(e);
            }
        }
    }

    public static boolean isReflectClass(Object obj) {
        return JSONConfigDefaults.getReflectedClass(obj) != null;
    }

    public static synchronized JSONReflectedClass getReflectedClass(Object obj) {
        return reflectClasses == null || obj == null ? null : reflectClasses.get(ReflectUtil.getClass(obj));
    }

    @Override
    public void addReflectClassByName(String className) throws MBeanException {
        try {
            JSONConfigDefaults.addReflectClass(new JSONReflectedClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e, JSONConfigDefaults.getClassNotFoundExceptionMsg(e, className, logging));
        }
    }

    public static synchronized void addReflectClass(Object obj) {
        reflectClasses = JSONConfigUtil.addReflectClass(reflectClasses, obj);
    }

    public static synchronized void addReflectClasses(Collection<?> classes) {
        reflectClasses = JSONConfigUtil.addReflectClasses(reflectClasses, classes);
    }

    @Override
    public void removeReflectClassByName(String className) throws MBeanException {
        String[] parts = className.split(",");
        try {
            JSONConfigDefaults.removeReflectClass(ReflectUtil.getClassByName(parts[0].trim()));
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e, JSONConfigDefaults.getClassNotFoundExceptionMsg(e, parts[0], logging));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getClassNotFoundExceptionMsg(ClassNotFoundException e, String className, boolean isLogging) {
        ResourceBundle bundle = JSONUtil.getBundle(JSONConfigDefaults.getLocale());
        String msg = String.format(bundle.getString("couldntLoadClass"), className);
        if (isLogging) {
            Class<?> clazz = jsonConfigDefaults.getClass();
            synchronized (clazz) {
                JSONConfigDefaults.ensureLogger();
                if (log.isErrorEnabled()) {
                    log.error((Object)msg, (Throwable)e);
                }
                JSONConfigDefaults.releaseLogger();
            }
        }
        return msg;
    }

    public static synchronized void removeReflectClass(Object obj) {
        reflectClasses = JSONConfigUtil.removeReflectClass(reflectClasses, obj);
    }

    public static synchronized void removeReflectClasses(Collection<?> classes) {
        reflectClasses = JSONConfigUtil.removeReflectClasses(reflectClasses, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearReflectClasses() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            reflectClasses = null;
        }
    }

    @Override
    public void clearReflectionCache() {
        ReflectedObjectMapBuilder.clearReflectionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listReflectedClasses() {
        ArrayList<JSONReflectedClass> refClasses = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (reflectClasses != null) {
                refClasses = new ArrayList<JSONReflectedClass>(reflectClasses.values());
            }
        }
        StringBuilder result = new StringBuilder();
        if (refClasses != null) {
            ArrayList<String> classes = new ArrayList<String>(refClasses.size());
            for (JSONReflectedClass refClass : refClasses) {
                Map<String, String> customNames;
                Class<?> clazz2 = refClass.getObjClass();
                StringBuilder buf = new StringBuilder(clazz2.getCanonicalName());
                Set<String> fieldNames = refClass.getFieldNamesRaw();
                if (fieldNames != null) {
                    for (String fieldName : fieldNames) {
                        buf.append(',').append(fieldName);
                    }
                }
                if ((customNames = refClass.getFieldAliases()) != null) {
                    for (Map.Entry<String, String> entry : customNames.entrySet()) {
                        buf.append(',').append(entry.getKey()).append('=').append(entry.getValue());
                    }
                }
                classes.add(buf.toString());
            }
            Collections.sort(classes);
            for (String className : classes) {
                result.append(className).append('\n');
            }
        }
        return result.toString();
    }

    @Override
    public int getUnmatchedSurrogatePolicy() {
        return unmatchedSurrogatePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnmatchedSurrogatePolicy(int dflt) {
        switch (dflt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    unmatchedSurrogatePolicy = dflt;
                    break;
                }
            }
        }
    }

    @Override
    public int getUndefinedCodePointPolicy() {
        return undefinedCodePointPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUndefinedCodePointPolicy(int dflt) {
        switch (dflt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    undefinedCodePointPolicy = dflt;
                    break;
                }
            }
        }
    }

    public static synchronized void setBadCharacterPolicy(int badCharacterPolicy) {
        jsonConfigDefaults.setUnmatchedSurrogatePolicy(badCharacterPolicy);
        jsonConfigDefaults.setUndefinedCodePointPolicy(badCharacterPolicy);
    }

    @Override
    public boolean isValidatePropertyNames() {
        return validatePropertyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidatePropertyNames(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            validatePropertyNames = dflt;
        }
    }

    @Override
    public boolean isDetectDataStructureLoops() {
        return detectDataStructureLoops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetectDataStructureLoops(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            detectDataStructureLoops = dflt;
        }
    }

    @Override
    public boolean isEscapeBadIdentifierCodePoints() {
        return escapeBadIdentifierCodePoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeBadIdentifierCodePoints(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            escapeBadIdentifierCodePoints = dflt;
        }
    }

    @Override
    public boolean isFullJSONIdentifierCodePoints() {
        return fullJSONIdentifierCodePoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFullJSONIdentifierCodePoints(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            fullJSONIdentifierCodePoints = dflt;
            if (fullJSONIdentifierCodePoints) {
                quoteIdentifier = true;
            }
        }
    }

    @Override
    public boolean isFastStrings() {
        return fastStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFastStrings(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            fastStrings = dflt;
        }
    }

    @Override
    public boolean isEncodeNumericStringsAsNumbers() {
        return encodeNumericStringsAsNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncodeNumericStringsAsNumbers(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            encodeNumericStringsAsNumbers = dflt;
        }
    }

    @Override
    public boolean isEscapeNonAscii() {
        return escapeNonAscii;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeNonAscii(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            escapeNonAscii = dflt;
            if (escapeNonAscii) {
                escapeSurrogates = false;
            }
        }
    }

    @Override
    public boolean isEscapeSurrogates() {
        return escapeSurrogates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeSurrogates(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            escapeSurrogates = dflt;
            if (escapeSurrogates) {
                escapeNonAscii = false;
            }
        }
    }

    @Override
    public boolean isUnEscapeWherePossible() {
        return unEscapeWherePossible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnEscapeWherePossible(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            unEscapeWherePossible = dflt;
        }
    }

    @Override
    public boolean isPassThroughEscapes() {
        return passThroughEscapes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassThroughEscapes(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            passThroughEscapes = dflt;
        }
    }

    @Override
    public boolean isEncodeDatesAsStrings() {
        return encodeDatesAsStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEncodeDatesAsStrings(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            encodeDatesAsStrings = dflt;
            if (encodeDatesAsStrings) {
                encodeDatesAsObjects = false;
            }
        }
    }

    @Override
    public boolean isReflectUnknownObjects() {
        return reflectUnknownObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReflectUnknownObjects(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            reflectUnknownObjects = dflt;
        }
    }

    @Override
    public boolean isPreciseNumbers() {
        return preciseNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreciseNumbers(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            preciseNumbers = dflt;
        }
    }

    @Override
    public boolean isSmallNumbers() {
        return smallNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSmallNumbers(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            smallNumbers = dflt;
        }
    }

    @Override
    public boolean isUsePrimitiveArrays() {
        return usePrimitiveArrays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsePrimitiveArrays(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            usePrimitiveArrays = dflt;
        }
    }

    @Override
    public boolean isCacheReflectionData() {
        return cacheReflectionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheReflectionData(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            cacheReflectionData = dflt;
            if (!cacheReflectionData) {
                ReflectedObjectMapBuilder.clearReflectionCache();
            }
        }
    }

    @Override
    public boolean isQuoteIdentifier() {
        return quoteIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuoteIdentifier(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            quoteIdentifier = fullJSONIdentifierCodePoints || dflt;
        }
    }

    @Override
    public boolean isUseECMA6() {
        return useECMA6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseECMA6(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            useECMA6 = dflt;
        }
    }

    @Override
    public boolean isAllowReservedWordsInIdentifiers() {
        return allowReservedWordsInIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllowReservedWordsInIdentifiers(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            allowReservedWordsInIdentifiers = dflt;
        }
    }

    @Override
    public boolean isEncodeDatesAsObjects() {
        return encodeDatesAsObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEncodeDatesAsObjects(boolean dflt) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            encodeDatesAsObjects = dflt;
            if (encodeDatesAsObjects) {
                encodeDatesAsStrings = false;
            }
        }
    }

    static {
        indentPadding = null;
        reflectClasses = null;
        mBeanName = null;
        logFactory = null;
        log = null;
        DATE_PARSE_FORMAT_PAT = Pattern.compile("^dateParseFormat(\\d+)$");
        REFLECT_CLASS_PAT = Pattern.compile("^reflectClass\\d+$");
        jsonConfigDefaults = new JSONConfigDefaults();
        String pkgName = jsonConfigDefaults.getClass().getPackage().getName();
        String appName = System.getProperty(pkgName + '.' + "appName", null);
        boolean useJNDI = Boolean.parseBoolean(System.getProperty(pkgName + ".useJNDI", "true"));
        boolean registerMBean = Boolean.parseBoolean(System.getProperty(pkgName + '.' + "registerMBean", "true"));
        String loggingProperty = System.getProperty(pkgName + '.' + "logging");
        logging = loggingProperty != null ? Boolean.parseBoolean(loggingProperty) : true;
        if (useJNDI) {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("appName", appName);
            registerMBean = JSONConfigDefaults.initJNDI(loggingProperty, registerMBean, appName, results);
            appName = (String)results.get("appName");
        }
        if (registerMBean) {
            JSONConfigDefaults.initMBean(appName);
        }
        JSONConfigDefaults.releaseLogger();
    }
}

