/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.fontawesome5;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum FontAwesomeBrands implements Ikon {
    ACCESSIBLE_ICON("fab-accessible-icon", '\uf368'),
    ACCUSOFT("fab-accusoft", '\uf369'),
    ACQUISITIONS_INCORPORATED("fab-acquisitions-incorporated", '\uf6af'),
    ADN("fab-adn", '\uf170'),
    ADVERSAL("fab-adversal", '\uf36a'),
    AFFILIATETHEME("fab-affiliatetheme", '\uf36b'),
    AIRBNB("fab-airbnb", '\uf834'),
    ALGOLIA("fab-algolia", '\uf36c'),
    ALIPAY("fab-alipay", '\uf642'),
    AMAZON("fab-amazon", '\uf270'),
    AMAZON_PAY("fab-amazon-pay", '\uf42c'),
    AMILIA("fab-amilia", '\uf36d'),
    ANDROID("fab-android", '\uf17b'),
    ANGELLIST("fab-angellist", '\uf209'),
    ANGRYCREATIVE("fab-angrycreative", '\uf36e'),
    ANGULAR("fab-angular", '\uf420'),
    APPER("fab-apper", '\uf371'),
    APPLE("fab-apple", '\uf179'),
    APPLE_PAY("fab-apple-pay", '\uf415'),
    APP_STORE("fab-app-store", '\uf36f'),
    APP_STORE_IOS("fab-app-store-ios", '\uf370'),
    ARTSTATION("fab-artstation", '\uf77a'),
    ASYMMETRIK("fab-asymmetrik", '\uf372'),
    ATLASSIAN("fab-atlassian", '\uf77b'),
    AUDIBLE("fab-audible", '\uf373'),
    AUTOPREFIXER("fab-autoprefixer", '\uf41c'),
    AVIANEX("fab-avianex", '\uf374'),
    AVIATO("fab-aviato", '\uf421'),
    AWS("fab-aws", '\uf375'),
    BANDCAMP("fab-bandcamp", '\uf2d5'),
    BATTLE_NET("fab-battle-net", '\uf835'),
    BEHANCE("fab-behance", '\uf1b4'),
    BEHANCE_SQUARE("fab-behance-square", '\uf1b5'),
    BIMOBJECT("fab-bimobject", '\uf378'),
    BITBUCKET("fab-bitbucket", '\uf171'),
    BITCOIN("fab-bitcoin", '\uf379'),
    BITY("fab-bity", '\uf37a'),
    BLACKBERRY("fab-blackberry", '\uf37b'),
    BLACK_TIE("fab-black-tie", '\uf27e'),
    BLOGGER("fab-blogger", '\uf37c'),
    BLOGGER_B("fab-blogger-b", '\uf37d'),
    BLUETOOTH("fab-bluetooth", '\uf293'),
    BLUETOOTH_B("fab-bluetooth-b", '\uf294'),
    BOOTSTRAP("fab-bootstrap", '\uf836'),
    BTC("fab-btc", '\uf15a'),
    BUFFER("fab-buffer", '\uf837'),
    BUROMOBELEXPERTE("fab-buromobelexperte", '\uf37f'),
    BUYSELLADS("fab-buysellads", '\uf20d'),
    BUY_N_LARGE("fab-buy-n-large", '\uf8a6'),
    CANADIAN_MAPLE_LEAF("fab-canadian-maple-leaf", '\uf785'),
    CC_AMAZON_PAY("fab-cc-amazon-pay", '\uf42d'),
    CC_AMEX("fab-cc-amex", '\uf1f3'),
    CC_APPLE_PAY("fab-cc-apple-pay", '\uf416'),
    CC_DINERS_CLUB("fab-cc-diners-club", '\uf24c'),
    CC_DISCOVER("fab-cc-discover", '\uf1f2'),
    CC_JCB("fab-cc-jcb", '\uf24b'),
    CC_MASTERCARD("fab-cc-mastercard", '\uf1f1'),
    CC_PAYPAL("fab-cc-paypal", '\uf1f4'),
    CC_STRIPE("fab-cc-stripe", '\uf1f5'),
    CC_VISA("fab-cc-visa", '\uf1f0'),
    CENTERCODE("fab-centercode", '\uf380'),
    CENTOS("fab-centos", '\uf789'),
    CHROME("fab-chrome", '\uf268'),
    CHROMECAST("fab-chromecast", '\uf838'),
    CLOUDFARE("fab-cloudfare", '\ue07d'),
    CLOUDSCALE("fab-cloudscale", '\uf383'),
    CLOUDSMITH("fab-cloudsmith", '\uf384'),
    CLOUDVERSIFY("fab-cloudversify", '\uf385'),
    CODEPEN("fab-codepen", '\uf1cb'),
    CODIEPIE("fab-codiepie", '\uf284'),
    CONFLUENCE("fab-confluence", '\uf78d'),
    CONNECTDEVELOP("fab-connectdevelop", '\uf20e'),
    CONTAO("fab-contao", '\uf26d'),
    COTTON_BUREAU("fab-cotton-bureau", '\uf89e'),
    CPANEL("fab-cpanel", '\uf388'),
    CREATIVE_COMMONS("fab-creative-commons", '\uf25e'),
    CREATIVE_COMMONS_BY("fab-creative-commons-by", '\uf4e7'),
    CREATIVE_COMMONS_NC("fab-creative-commons-nc", '\uf4e8'),
    CREATIVE_COMMONS_NC_EU("fab-creative-commons-nc-eu", '\uf4e9'),
    CREATIVE_COMMONS_NC_JP("fab-creative-commons-nc-jp", '\uf4ea'),
    CREATIVE_COMMONS_ND("fab-creative-commons-nd", '\uf4eb'),
    CREATIVE_COMMONS_PD("fab-creative-commons-pd", '\uf4ec'),
    CREATIVE_COMMONS_PD_ALT("fab-creative-commons-pd-alt", '\uf4ed'),
    CREATIVE_COMMONS_REMIX("fab-creative-commons-remix", '\uf4ee'),
    CREATIVE_COMMONS_SA("fab-creative-commons-sa", '\uf4ef'),
    CREATIVE_COMMONS_SAMPLING("fab-creative-commons-sampling", '\uf4f0'),
    CREATIVE_COMMONS_SAMPLING_PLUS("fab-creative-commons-sampling-plus", '\uf4f1'),
    CREATIVE_COMMONS_SHARE("fab-creative-commons-share", '\uf4f2'),
    CREATIVE_COMMONS_ZERO("fab-creative-commons-zero", '\uf4f3'),
    CRITICAL_ROLE("fab-critical-role", '\uf6c9'),
    CSS3("fab-css3", '\uf13c'),
    CSS3_ALT("fab-css3-alt", '\uf38b'),
    CUTTLEFISH("fab-cuttlefish", '\uf38c'),
    DAILYMOTION("fab-dailymotion", '\ue052'),
    DASHCUBE("fab-dashcube", '\uf210'),
    DEEZER("fab-deezer", '\ue077'),
    DELICIOUS("fab-delicious", '\uf1a5'),
    DEPLOYDOG("fab-deploydog", '\uf38e'),
    DESKPRO("fab-deskpro", '\uf38f'),
    DEV("fab-dev", '\uf6cc'),
    DEVIANTART("fab-deviantart", '\uf1bd'),
    DHL("fab-dhl", '\uf790'),
    DIASPORA("fab-diaspora", '\uf791'),
    DIGG("fab-digg", '\uf1a6'),
    DIGITAL_OCEAN("fab-digital-ocean", '\uf391'),
    DISCORD("fab-discord", '\uf392'),
    DISCOURSE("fab-discourse", '\uf393'),
    DOCHUB("fab-dochub", '\uf394'),
    DOCKER("fab-docker", '\uf395'),
    DRAFT2DIGITAL("fab-draft2digital", '\uf396'),
    DRIBBBLE("fab-dribbble", '\uf17d'),
    DRIBBBLE_SQUARE("fab-dribbble-square", '\uf397'),
    DROPBOX("fab-dropbox", '\uf16b'),
    DRUPAL("fab-drupal", '\uf1a9'),
    DYALOG("fab-dyalog", '\uf399'),
    D_AND_D("fab-d-and-d", '\uf38d'),
    D_AND_D_BEYOND("fab-d-and-d-beyond", '\uf6ca'),
    EARLYBIRDS("fab-earlybirds", '\uf39a'),
    EBAY("fab-ebay", '\uf4f4'),
    EDGE("fab-edge", '\uf282'),
    EDGE_LEGACY("fab-edge-legacy", '\ue078'),
    ELEMENTOR("fab-elementor", '\uf430'),
    ELLO("fab-ello", '\uf5f1'),
    EMBER("fab-ember", '\uf423'),
    EMPIRE("fab-empire", '\uf1d1'),
    ENVIRA("fab-envira", '\uf299'),
    ERLANG("fab-erlang", '\uf39d'),
    ETHEREUM("fab-ethereum", '\uf42e'),
    ETSY("fab-etsy", '\uf2d7'),
    EVERNOTE("fab-evernote", '\uf839'),
    EXPEDITEDSSL("fab-expeditedssl", '\uf23e'),
    FAB_500PX("fab-500px", '\uf26e'),
    FACEBOOK("fab-facebook", '\uf09a'),
    FACEBOOK_F("fab-facebook-f", '\uf39e'),
    FACEBOOK_MESSENGER("fab-facebook-messenger", '\uf39f'),
    FACEBOOK_SQUARE("fab-facebook-square", '\uf082'),
    FANTASY_FLIGHT_GAMES("fab-fantasy-flight-games", '\uf6dc'),
    FEDEX("fab-fedex", '\uf797'),
    FEDORA("fab-fedora", '\uf798'),
    FIGMA("fab-figma", '\uf799'),
    FIREFOX("fab-firefox", '\uf269'),
    FIREFOX_BROWSER("fab-firefox-browser", '\ue007'),
    FIRSTDRAFT("fab-firstdraft", '\uf3a1'),
    FIRST_ORDER("fab-first-order", '\uf2b0'),
    FIRST_ORDER_ALT("fab-first-order-alt", '\uf50a'),
    FLICKR("fab-flickr", '\uf16e'),
    FLIPBOARD("fab-flipboard", '\uf44d'),
    FLY("fab-fly", '\uf417'),
    FONTICONS("fab-fonticons", '\uf280'),
    FONTICONS_FI("fab-fonticons-fi", '\uf3a2'),
    FONT_AWESOME("fab-font-awesome", '\uf2b4'),
    FONT_AWESOME_ALT("fab-font-awesome-alt", '\uf35c'),
    FONT_AWESOME_FLAG("fab-font-awesome-flag", '\uf425'),
    FORT_AWESOME("fab-fort-awesome", '\uf286'),
    FORT_AWESOME_ALT("fab-fort-awesome-alt", '\uf3a3'),
    FORUMBEE("fab-forumbee", '\uf211'),
    FOURSQUARE("fab-foursquare", '\uf180'),
    FREEBSD("fab-freebsd", '\uf3a4'),
    FREE_CODE_CAMP("fab-free-code-camp", '\uf2c5'),
    FULCRUM("fab-fulcrum", '\uf50b'),
    GALACTIC_REPUBLIC("fab-galactic-republic", '\uf50c'),
    GALACTIC_SENATE("fab-galactic-senate", '\uf50d'),
    GET_POCKET("fab-get-pocket", '\uf265'),
    GG("fab-gg", '\uf260'),
    GG_CIRCLE("fab-gg-circle", '\uf261'),
    GIT("fab-git", '\uf1d3'),
    GITHUB("fab-github", '\uf09b'),
    GITHUB_ALT("fab-github-alt", '\uf113'),
    GITHUB_SQUARE("fab-github-square", '\uf092'),
    GITKRAKEN("fab-gitkraken", '\uf3a6'),
    GITLAB("fab-gitlab", '\uf296'),
    GITTER("fab-gitter", '\uf426'),
    GIT_ALT("fab-git-alt", '\uf841'),
    GIT_SQUARE("fab-git-square", '\uf1d2'),
    GLIDE("fab-glide", '\uf2a5'),
    GLIDE_G("fab-glide-g", '\uf2a6'),
    GOFORE("fab-gofore", '\uf3a7'),
    GOODREADS("fab-goodreads", '\uf3a8'),
    GOODREADS_G("fab-goodreads-g", '\uf3a9'),
    GOOGLE("fab-google", '\uf1a0'),
    GOOGLE_DRIVE("fab-google-drive", '\uf3aa'),
    GOOGLE_PAY("fab-google-pay", '\ue079'),
    GOOGLE_PLAY("fab-google-play", '\uf3ab'),
    GOOGLE_PLUS("fab-google-plus", '\uf2b3'),
    GOOGLE_PLUS_G("fab-google-plus-g", '\uf0d5'),
    GOOGLE_PLUS_SQUARE("fab-google-plus-square", '\uf0d4'),
    GOOGLE_WALLET("fab-google-wallet", '\uf1ee'),
    GRATIPAY("fab-gratipay", '\uf184'),
    GRAV("fab-grav", '\uf2d6'),
    GRIPFIRE("fab-gripfire", '\uf3ac'),
    GRUNT("fab-grunt", '\uf3ad'),
    GUILDED("fab-guilded", '\ue07e'),
    GULP("fab-gulp", '\uf3ae'),
    HACKERRANK("fab-hackerrank", '\uf5f7'),
    HACKER_NEWS("fab-hacker-news", '\uf1d4'),
    HACKER_NEWS_SQUARE("fab-hacker-news-square", '\uf3af'),
    HIPS("fab-hips", '\uf452'),
    HIRE_A_HELPER("fab-hire-a-helper", '\uf3b0'),
    HIVE("fab-hive", '\ue07f'),
    HOOLI("fab-hooli", '\uf427'),
    HORNBILL("fab-hornbill", '\uf592'),
    HOTJAR("fab-hotjar", '\uf3b1'),
    HOUZZ("fab-houzz", '\uf27c'),
    HTML5("fab-html5", '\uf13b'),
    HUBSPOT("fab-hubspot", '\uf3b2'),
    IDEAL("fab-ideal", '\ue013'),
    IMDB("fab-imdb", '\uf2d8'),
    INNOSOFT("fab-innosoft", '\ue080'),
    INSTAGRAM("fab-instagram", '\uf16d'),
    INSTAGRAM_SQUARE("fab-instagram-square", '\ue055'),
    INSTALOD("fab-instalod", '\ue081'),
    INTERCOM("fab-intercom", '\uf7af'),
    INTERNET_EXPLORER("fab-internet-explorer", '\uf26b'),
    INVISION("fab-invision", '\uf7b0'),
    IOXHOST("fab-ioxhost", '\uf208'),
    ITCH_IO("fab-itch-io", '\uf83a'),
    ITUNES("fab-itunes", '\uf3b4'),
    ITUNES_NOTE("fab-itunes-note", '\uf3b5'),
    JAVA("fab-java", '\uf4e4'),
    JEDI_ORDER("fab-jedi-order", '\uf50e'),
    JENKINS("fab-jenkins", '\uf3b6'),
    JIRA("fab-jira", '\uf7b1'),
    JOGET("fab-joget", '\uf3b7'),
    JOOMLA("fab-joomla", '\uf1aa'),
    JS("fab-js", '\uf3b8'),
    JSFIDDLE("fab-jsfiddle", '\uf1cc'),
    JS_SQUARE("fab-js-square", '\uf3b9'),
    KAGGLE("fab-kaggle", '\uf5fa'),
    KEYBASE("fab-keybase", '\uf4f5'),
    KEYCDN("fab-keycdn", '\uf3ba'),
    KICKSTARTER("fab-kickstarter", '\uf3bb'),
    KICKSTARTER_K("fab-kickstarter-k", '\uf3bc'),
    KORVUE("fab-korvue", '\uf42f'),
    LARAVEL("fab-laravel", '\uf3bd'),
    LASTFM("fab-lastfm", '\uf202'),
    LASTFM_SQUARE("fab-lastfm-square", '\uf203'),
    LEANPUB("fab-leanpub", '\uf212'),
    LESS("fab-less", '\uf41d'),
    LINE("fab-line", '\uf3c0'),
    LINKEDIN("fab-linkedin", '\uf08c'),
    LINKEDIN_IN("fab-linkedin-in", '\uf0e1'),
    LINODE("fab-linode", '\uf2b8'),
    LINUX("fab-linux", '\uf17c'),
    LYFT("fab-lyft", '\uf3c3'),
    MAGENTO("fab-magento", '\uf3c4'),
    MAILCHIMP("fab-mailchimp", '\uf59e'),
    MANDALORIAN("fab-mandalorian", '\uf50f'),
    MARKDOWN("fab-markdown", '\uf60f'),
    MASTODON("fab-mastodon", '\uf4f6'),
    MAXCDN("fab-maxcdn", '\uf136'),
    MDB("fab-mdb", '\uf8ca'),
    MEDAPPS("fab-medapps", '\uf3c6'),
    MEDIUM("fab-medium", '\uf23a'),
    MEDIUM_M("fab-medium-m", '\uf3c7'),
    MEDRT("fab-medrt", '\uf3c8'),
    MEETUP("fab-meetup", '\uf2e0'),
    MEGAPORT("fab-megaport", '\uf5a3'),
    MENDELEY("fab-mendeley", '\uf7b3'),
    MICROBLOG("fab-microblog", '\ue01a'),
    MICROSOFT("fab-microsoft", '\uf3ca'),
    MIX("fab-mix", '\uf3cb'),
    MIXCLOUD("fab-mixcloud", '\uf289'),
    MIXER("fab-mixer", '\ue056'),
    MIZUNI("fab-mizuni", '\uf3cc'),
    MODX("fab-modx", '\uf285'),
    MONERO("fab-monero", '\uf3d0'),
    NAPSTER("fab-napster", '\uf3d2'),
    NEOS("fab-neos", '\uf612'),
    NIMBLR("fab-nimblr", '\uf5a8'),
    NODE("fab-node", '\uf419'),
    NODE_JS("fab-node-js", '\uf3d3'),
    NPM("fab-npm", '\uf3d4'),
    NS8("fab-ns8", '\uf3d5'),
    NUTRITIONIX("fab-nutritionix", '\uf3d6'),
    OCTOPUS_DEPLOY("fab-octopus-deploy", '\ue082'),
    ODNOKLASSNIKI("fab-odnoklassniki", '\uf263'),
    ODNOKLASSNIKI_SQUARE("fab-odnoklassniki-square", '\uf264'),
    OLD_REPUBLIC("fab-old-republic", '\uf510'),
    OPENCART("fab-opencart", '\uf23d'),
    OPENID("fab-openid", '\uf19b'),
    OPERA("fab-opera", '\uf26a'),
    OPTIN_MONSTER("fab-optin-monster", '\uf23c'),
    ORCID("fab-orcid", '\uf8d2'),
    OSI("fab-osi", '\uf41a'),
    PAGE4("fab-page4", '\uf3d7'),
    PAGELINES("fab-pagelines", '\uf18c'),
    PALFED("fab-palfed", '\uf3d8'),
    PATREON("fab-patreon", '\uf3d9'),
    PAYPAL("fab-paypal", '\uf1ed'),
    PENNY_ARCADE("fab-penny-arcade", '\uf704'),
    PERBYTE("fab-perbyte", '\ue083'),
    PERISCOPE("fab-periscope", '\uf3da'),
    PHABRICATOR("fab-phabricator", '\uf3db'),
    PHOENIX_FRAMEWORK("fab-phoenix-framework", '\uf3dc'),
    PHOENIX_SQUADRON("fab-phoenix-squadron", '\uf511'),
    PHP("fab-php", '\uf457'),
    PIED_PIPER("fab-pied-piper", '\uf2ae'),
    PIED_PIPER_ALT("fab-pied-piper-alt", '\uf1a8'),
    PIED_PIPER_HAT("fab-pied-piper-hat", '\uf4e5'),
    PIED_PIPER_PP("fab-pied-piper-pp", '\uf1a7'),
    PIED_PIPER_SQUARE("fab-pied-piper-square", '\ue01e'),
    PINTEREST("fab-pinterest", '\uf0d2'),
    PINTEREST_P("fab-pinterest-p", '\uf231'),
    PINTEREST_SQUARE("fab-pinterest-square", '\uf0d3'),
    PLAYSTATION("fab-playstation", '\uf3df'),
    PRODUCT_HUNT("fab-product-hunt", '\uf288'),
    PUSHED("fab-pushed", '\uf3e1'),
    PYTHON("fab-python", '\uf3e2'),
    QQ("fab-qq", '\uf1d6'),
    QUINSCAPE("fab-quinscape", '\uf459'),
    QUORA("fab-quora", '\uf2c4'),
    RASPBERRY_PI("fab-raspberry-pi", '\uf7bb'),
    RAVELRY("fab-ravelry", '\uf2d9'),
    REACT("fab-react", '\uf41b'),
    REACTEUROPE("fab-reacteurope", '\uf75d'),
    README("fab-readme", '\uf4d5'),
    REBEL("fab-rebel", '\uf1d0'),
    REDDIT("fab-reddit", '\uf1a1'),
    REDDIT_ALIEN("fab-reddit-alien", '\uf281'),
    REDDIT_SQUARE("fab-reddit-square", '\uf1a2'),
    REDHAT("fab-redhat", '\uf7bc'),
    RED_RIVER("fab-red-river", '\uf3e3'),
    RENREN("fab-renren", '\uf18b'),
    REPLYD("fab-replyd", '\uf3e6'),
    RESEARCHGATE("fab-researchgate", '\uf4f8'),
    RESOLVING("fab-resolving", '\uf3e7'),
    REV("fab-rev", '\uf5b2'),
    ROCKETCHAT("fab-rocketchat", '\uf3e8'),
    ROCKRMS("fab-rockrms", '\uf3e9'),
    RUST("fab-rust", '\ue07a'),
    R_PROJECT("fab-r-project", '\uf4f7'),
    SAFARI("fab-safari", '\uf267'),
    SALESFORCE("fab-salesforce", '\uf83b'),
    SASS("fab-sass", '\uf41e'),
    SCHLIX("fab-schlix", '\uf3ea'),
    SCRIBD("fab-scribd", '\uf28a'),
    SEARCHENGIN("fab-searchengin", '\uf3eb'),
    SELLCAST("fab-sellcast", '\uf2da'),
    SELLSY("fab-sellsy", '\uf213'),
    SERVICESTACK("fab-servicestack", '\uf3ec'),
    SHIRTSINBULK("fab-shirtsinbulk", '\uf214'),
    SHOPIFY("fab-shopify", '\ue057'),
    SHOPWARE("fab-shopware", '\uf5b5'),
    SIMPLYBUILT("fab-simplybuilt", '\uf215'),
    SISTRIX("fab-sistrix", '\uf3ee'),
    SITH("fab-sith", '\uf512'),
    SKETCH("fab-sketch", '\uf7c6'),
    SKYATLAS("fab-skyatlas", '\uf216'),
    SKYPE("fab-skype", '\uf17e'),
    SLACK("fab-slack", '\uf198'),
    SLACK_HASH("fab-slack-hash", '\uf3ef'),
    SLIDESHARE("fab-slideshare", '\uf1e7'),
    SNAPCHAT("fab-snapchat", '\uf2ab'),
    SNAPCHAT_GHOST("fab-snapchat-ghost", '\uf2ac'),
    SNAPCHAT_SQUARE("fab-snapchat-square", '\uf2ad'),
    SOUNDCLOUD("fab-soundcloud", '\uf1be'),
    SOURCETREE("fab-sourcetree", '\uf7d3'),
    SPEAKAP("fab-speakap", '\uf3f3'),
    SPEAKER_DECK("fab-speaker-deck", '\uf83c'),
    SPOTIFY("fab-spotify", '\uf1bc'),
    SQUARESPACE("fab-squarespace", '\uf5be'),
    STACKPATH("fab-stackpath", '\uf842'),
    STACK_EXCHANGE("fab-stack-exchange", '\uf18d'),
    STACK_OVERFLOW("fab-stack-overflow", '\uf16c'),
    STAYLINKED("fab-staylinked", '\uf3f5'),
    STEAM("fab-steam", '\uf1b6'),
    STEAM_SQUARE("fab-steam-square", '\uf1b7'),
    STEAM_SYMBOL("fab-steam-symbol", '\uf3f6'),
    STICKER_MULE("fab-sticker-mule", '\uf3f7'),
    STRAVA("fab-strava", '\uf428'),
    STRIPE("fab-stripe", '\uf429'),
    STRIPE_S("fab-stripe-s", '\uf42a'),
    STUDIOVINARI("fab-studiovinari", '\uf3f8'),
    STUMBLEUPON("fab-stumbleupon", '\uf1a4'),
    STUMBLEUPON_CIRCLE("fab-stumbleupon-circle", '\uf1a3'),
    SUPERPOWERS("fab-superpowers", '\uf2dd'),
    SUPPLE("fab-supple", '\uf3f9'),
    SUSE("fab-suse", '\uf7d6'),
    SWIFT("fab-swift", '\uf8e1'),
    SYMFONY("fab-symfony", '\uf83d'),
    TEAMSPEAK("fab-teamspeak", '\uf4f9'),
    TELEGRAM("fab-telegram", '\uf2c6'),
    TELEGRAM_PLANE("fab-telegram-plane", '\uf3fe'),
    TENCENT_WEIBO("fab-tencent-weibo", '\uf1d5'),
    THEMECO("fab-themeco", '\uf5c6'),
    THEMEISLE("fab-themeisle", '\uf2b2'),
    THE_RED_YETI("fab-the-red-yeti", '\uf69d'),
    THINK_PEAKS("fab-think-peaks", '\uf731'),
    TIKTOK("fab-tiktok", '\ue07b'),
    TRADE_FEDERATION("fab-trade-federation", '\uf513'),
    TRELLO("fab-trello", '\uf181'),
    TRIPADVISOR("fab-tripadvisor", '\uf262'),
    TUMBLR("fab-tumblr", '\uf173'),
    TUMBLR_SQUARE("fab-tumblr-square", '\uf174'),
    TWITCH("fab-twitch", '\uf1e8'),
    TWITTER("fab-twitter", '\uf099'),
    TWITTER_SQUARE("fab-twitter-square", '\uf081'),
    TYPO3("fab-typo3", '\uf42b'),
    UBER("fab-uber", '\uf402'),
    UBUNTU("fab-ubuntu", '\uf7df'),
    UIKIT("fab-uikit", '\uf403'),
    UMBRACO("fab-umbraco", '\uf8e8'),
    UNCHARTED("fab-uncharted", '\ue084'),
    UNIREGISTRY("fab-uniregistry", '\uf404'),
    UNITY("fab-unity", '\ue049'),
    UNSPLASH("fab-unsplash", '\ue07c'),
    UNTAPPD("fab-untappd", '\uf405'),
    UPS("fab-ups", '\uf7e0'),
    USB("fab-usb", '\uf287'),
    USPS("fab-usps", '\uf7e1'),
    USSUNNAH("fab-ussunnah", '\uf407'),
    VAADIN("fab-vaadin", '\uf408'),
    VIACOIN("fab-viacoin", '\uf237'),
    VIADEO("fab-viadeo", '\uf2a9'),
    VIADEO_SQUARE("fab-viadeo-square", '\uf2aa'),
    VIBER("fab-viber", '\uf409'),
    VIMEO("fab-vimeo", '\uf40a'),
    VIMEO_SQUARE("fab-vimeo-square", '\uf194'),
    VIMEO_V("fab-vimeo-v", '\uf27d'),
    VINE("fab-vine", '\uf1ca'),
    VK("fab-vk", '\uf189'),
    VNV("fab-vnv", '\uf40b'),
    VUEJS("fab-vuejs", '\uf41f'),
    WATCHAMN_MONITORING("fab-watchman-monitoring", '\ue087'),
    WAZE("fab-waze", '\uf83f'),
    WEEBLY("fab-weebly", '\uf5cc'),
    WEIBO("fab-weibo", '\uf18a'),
    WEIXIN("fab-weixin", '\uf1d7'),
    WHATSAPP("fab-whatsapp", '\uf232'),
    WHATSAPP_SQUARE("fab-whatsapp-square", '\uf40c'),
    WHMCS("fab-whmcs", '\uf40d'),
    WIKIPEDIA_W("fab-wikipedia-w", '\uf266'),
    WINDOWS("fab-windows", '\uf17a'),
    WIX("fab-wix", '\uf5cf'),
    WIZARDS_OF_THE_COAST("fab-wizards-of-the-coast", '\uf730'),
    WODU("fab-wodu", '\ue088'),
    WOLF_PACK_BATTALION("fab-wolf-pack-battalion", '\uf514'),
    WORDPRESS("fab-wordpress", '\uf19a'),
    WORDPRESS_SIMPLE("fab-wordpress-simple", '\uf411'),
    WPBEGINNER("fab-wpbeginner", '\uf297'),
    WPEXPLORER("fab-wpexplorer", '\uf2de'),
    WPFORMS("fab-wpforms", '\uf298'),
    WPRESSR("fab-wpressr", '\uf3e4'),
    XBOX("fab-xbox", '\uf412'),
    XING("fab-xing", '\uf168'),
    XING_SQUARE("fab-xing-square", '\uf169'),
    YAHOO("fab-yahoo", '\uf19e'),
    YAMMER("fab-yammer", '\uf840'),
    YANDEX("fab-yandex", '\uf413'),
    YANDEX_INTERNATIONAL("fab-yandex-international", '\uf414'),
    YARN("fab-yarn", '\uf7e3'),
    YELP("fab-yelp", '\uf1e9'),
    YOAST("fab-yoast", '\uf2b1'),
    YOUTUBE("fab-youtube", '\uf167'),
    YOUTUBE_SQUARE("fab-youtube-square", '\uf431'),
    Y_COMBINATOR("fab-y-combinator", '\uf23b'),
    ZHIHU("fab-zhihu", '\uf63f');

    public static FontAwesomeBrands findByDescription(String description) {
        for (FontAwesomeBrands font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    FontAwesomeBrands(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}
