/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.fontawesome5;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum FontAwesomeSolid implements Ikon {
    AD("fas-ad", '\uf641'),
    ADDRESS_BOOK("fas-address-book", '\uf2b9'),
    ADDRESS_CARD("fas-address-card", '\uf2bb'),
    ADJUST("fas-adjust", '\uf042'),
    AIR_FRESHENER("fas-air-freshener", '\uf5d0'),
    ALIGN_CENTER("fas-align-center", '\uf037'),
    ALIGN_JUSTIFY("fas-align-justify", '\uf039'),
    ALIGN_LEFT("fas-align-left", '\uf036'),
    ALIGN_RIGHT("fas-align-right", '\uf038'),
    ALLERGIES("fas-allergies", '\uf461'),
    AMBULANCE("fas-ambulance", '\uf0f9'),
    AMERICAN_SIGN_LANGUAGE_INTERPRETING("fas-american-sign-language-interpreting", '\uf2a3'),
    ANCHOR("fas-anchor", '\uf13d'),
    ANGLE_DOUBLE_DOWN("fas-angle-double-down", '\uf103'),
    ANGLE_DOUBLE_LEFT("fas-angle-double-left", '\uf100'),
    ANGLE_DOUBLE_RIGHT("fas-angle-double-right", '\uf101'),
    ANGLE_DOUBLE_UP("fas-angle-double-up", '\uf102'),
    ANGLE_DOWN("fas-angle-down", '\uf107'),
    ANGLE_LEFT("fas-angle-left", '\uf104'),
    ANGLE_RIGHT("fas-angle-right", '\uf105'),
    ANGLE_UP("fas-angle-up", '\uf106'),
    ANGRY("fas-angry", '\uf556'),
    ANKH("fas-ankh", '\uf644'),
    APPLE_ALT("fas-apple-alt", '\uf5d1'),
    ARCHIVE("fas-archive", '\uf187'),
    ARCHWAY("fas-archway", '\uf557'),
    ARROWS_ALT("fas-arrows-alt", '\uf0b2'),
    ARROWS_ALT_H("fas-arrows-alt-h", '\uf337'),
    ARROWS_ALT_V("fas-arrows-alt-v", '\uf338'),
    ARROW_ALT_CIRCLE_DOWN("fas-arrow-alt-circle-down", '\uf358'),
    ARROW_ALT_CIRCLE_LEFT("fas-arrow-alt-circle-left", '\uf359'),
    ARROW_ALT_CIRCLE_RIGHT("fas-arrow-alt-circle-right", '\uf35a'),
    ARROW_ALT_CIRCLE_UP("fas-arrow-alt-circle-up", '\uf35b'),
    ARROW_CIRCLE_DOWN("fas-arrow-circle-down", '\uf0ab'),
    ARROW_CIRCLE_LEFT("fas-arrow-circle-left", '\uf0a8'),
    ARROW_CIRCLE_RIGHT("fas-arrow-circle-right", '\uf0a9'),
    ARROW_CIRCLE_UP("fas-arrow-circle-up", '\uf0aa'),
    ARROW_DOWN("fas-arrow-down", '\uf063'),
    ARROW_LEFT("fas-arrow-left", '\uf060'),
    ARROW_RIGHT("fas-arrow-right", '\uf061'),
    ARROW_UP("fas-arrow-up", '\uf062'),
    ASSISTIVE_LISTENING_SYSTEMS("fas-assistive-listening-systems", '\uf2a2'),
    ASTERISK("fas-asterisk", '\uf069'),
    AT("fas-at", '\uf1fa'),
    ATLAS("fas-atlas", '\uf558'),
    ATOM("fas-atom", '\uf5d2'),
    AUDIO_DESCRIPTION("fas-audio-description", '\uf29e'),
    AWARD("fas-award", '\uf559'),
    BABY("fas-baby", '\uf77c'),
    BABY_CARRIAGE("fas-baby-carriage", '\uf77d'),
    BACKSPACE("fas-backspace", '\uf55a'),
    BACKWARD("fas-backward", '\uf04a'),
    BACON("fas-bacon", '\uf7e5'),
    BACTERIA("fas-bacteria", '\ue059'),
    BACTERIUM("fas-bacterium", '\ue05a'),
    BAHAI("fas-bahai", '\uf666'),
    BALANCE_SCALE("fas-balance-scale", '\uf24e'),
    BALANCE_SCALE_LEFT("fas-balance-scale-left", '\uf515'),
    BALANCE_SCALE_RIGHT("fas-balance-scale-right", '\uf516'),
    BAN("fas-ban", '\uf05e'),
    BAND_AID("fas-band-aid", '\uf462'),
    BARCODE("fas-barcode", '\uf02a'),
    BARS("fas-bars", '\uf0c9'),
    BASEBALL_BALL("fas-baseball-ball", '\uf433'),
    BASKETBALL_BALL("fas-basketball-ball", '\uf434'),
    BATH("fas-bath", '\uf2cd'),
    BATTERY_EMPTY("fas-battery-empty", '\uf244'),
    BATTERY_FULL("fas-battery-full", '\uf240'),
    BATTERY_HALF("fas-battery-half", '\uf242'),
    BATTERY_QUARTER("fas-battery-quarter", '\uf243'),
    BATTERY_THREE_QUARTERS("fas-battery-three-quarters", '\uf241'),
    BED("fas-bed", '\uf236'),
    BEER("fas-beer", '\uf0fc'),
    BELL("fas-bell", '\uf0f3'),
    BELL_SLASH("fas-bell-slash", '\uf1f6'),
    BEZIER_CURVE("fas-bezier-curve", '\uf55b'),
    BIBLE("fas-bible", '\uf647'),
    BICYCLE("fas-bicycle", '\uf206'),
    BIKING("fas-biking", '\uf84a'),
    BINOCULARS("fas-binoculars", '\uf1e5'),
    BIOHAZARD("fas-biohazard", '\uf780'),
    BIRTHDAY_CAKE("fas-birthday-cake", '\uf1fd'),
    BLENDER("fas-blender", '\uf517'),
    BLENDER_PHONE("fas-blender-phone", '\uf6b6'),
    BLIND("fas-blind", '\uf29d'),
    BLOG("fas-blog", '\uf781'),
    BOLD("fas-bold", '\uf032'),
    BOLT("fas-bolt", '\uf0e7'),
    BOMB("fas-bomb", '\uf1e2'),
    BONE("fas-bone", '\uf5d7'),
    BONG("fas-bong", '\uf55c'),
    BOOK("fas-book", '\uf02d'),
    BOOKMARK("fas-bookmark", '\uf02e'),
    BOOK_DEAD("fas-book-dead", '\uf6b7'),
    BOOK_MEDICAL("fas-book-medical", '\uf7e6'),
    BOOK_OPEN("fas-book-open", '\uf518'),
    BOOK_READER("fas-book-reader", '\uf5da'),
    BORDER_ALL("fas-border-all", '\uf84c'),
    BORDER_NONE("fas-border-none", '\uf850'),
    BORDER_STYLE("fas-border-style", '\uf853'),
    BOWLING_BALL("fas-bowling-ball", '\uf436'),
    BOX("fas-box", '\uf466'),
    BOXES("fas-boxes", '\uf468'),
    BOX_OPEN("fas-box-open", '\uf49e'),
    BOX_TISSUE("fas-box-tissue", '\ue05b'),
    BRAILLE("fas-braille", '\uf2a1'),
    BRAIN("fas-brain", '\uf5dc'),
    BREAD_SLICE("fas-bread-slice", '\uf7ec'),
    BRIEFCASE("fas-briefcase", '\uf0b1'),
    BRIEFCASE_MEDICAL("fas-briefcase-medical", '\uf469'),
    BROADCAST_TOWER("fas-broadcast-tower", '\uf519'),
    BROOM("fas-broom", '\uf51a'),
    BRUSH("fas-brush", '\uf55d'),
    BUG("fas-bug", '\uf188'),
    BUILDING("fas-building", '\uf1ad'),
    BULLHORN("fas-bullhorn", '\uf0a1'),
    BULLSEYE("fas-bullseye", '\uf140'),
    BURN("fas-burn", '\uf46a'),
    BUS("fas-bus", '\uf207'),
    BUSINESS_TIME("fas-business-time", '\uf64a'),
    BUS_ALT("fas-bus-alt", '\uf55e'),
    CALCULATOR("fas-calculator", '\uf1ec'),
    CALENDAR("fas-calendar", '\uf133'),
    CALENDAR_ALT("fas-calendar-alt", '\uf073'),
    CALENDAR_CHECK("fas-calendar-check", '\uf274'),
    CALENDAR_DAY("fas-calendar-day", '\uf783'),
    CALENDAR_MINUS("fas-calendar-minus", '\uf272'),
    CALENDAR_PLUS("fas-calendar-plus", '\uf271'),
    CALENDAR_TIMES("fas-calendar-times", '\uf273'),
    CALENDAR_WEEK("fas-calendar-week", '\uf784'),
    CAMERA("fas-camera", '\uf030'),
    CAMERA_RETRO("fas-camera-retro", '\uf083'),
    CAMPGROUND("fas-campground", '\uf6bb'),
    CANDY_CANE("fas-candy-cane", '\uf786'),
    CANNABIS("fas-cannabis", '\uf55f'),
    CAPSULES("fas-capsules", '\uf46b'),
    CAR("fas-car", '\uf1b9'),
    CARAVAN("fas-caravan", '\uf8ff'),
    CARET_DOWN("fas-caret-down", '\uf0d7'),
    CARET_LEFT("fas-caret-left", '\uf0d9'),
    CARET_RIGHT("fas-caret-right", '\uf0da'),
    CARET_SQUARE_DOWN("fas-caret-square-down", '\uf150'),
    CARET_SQUARE_LEFT("fas-caret-square-left", '\uf191'),
    CARET_SQUARE_RIGHT("fas-caret-square-right", '\uf152'),
    CARET_SQUARE_UP("fas-caret-square-up", '\uf151'),
    CARET_UP("fas-caret-up", '\uf0d8'),
    CARROT("fas-carrot", '\uf787'),
    CART_ARROW_DOWN("fas-cart-arrow-down", '\uf218'),
    CART_PLUS("fas-cart-plus", '\uf217'),
    CAR_ALT("fas-car-alt", '\uf5de'),
    CAR_BATTERY("fas-car-battery", '\uf5df'),
    CAR_CRASH("fas-car-crash", '\uf5e1'),
    CAR_SIDE("fas-car-side", '\uf5e4'),
    CASH_REGISTER("fas-cash-register", '\uf788'),
    CAT("fas-cat", '\uf6be'),
    CERTIFICATE("fas-certificate", '\uf0a3'),
    CHAIR("fas-chair", '\uf6c0'),
    CHALKBOARD("fas-chalkboard", '\uf51b'),
    CHALKBOARD_TEACHER("fas-chalkboard-teacher", '\uf51c'),
    CHARGING_STATION("fas-charging-station", '\uf5e7'),
    CHART_AREA("fas-chart-area", '\uf1fe'),
    CHART_BAR("fas-chart-bar", '\uf080'),
    CHART_LINE("fas-chart-line", '\uf201'),
    CHART_PIE("fas-chart-pie", '\uf200'),
    CHECK("fas-check", '\uf00c'),
    CHECK_CIRCLE("fas-check-circle", '\uf058'),
    CHECK_DOUBLE("fas-check-double", '\uf560'),
    CHECK_SQUARE("fas-check-square", '\uf14a'),
    CHEESE("fas-cheese", '\uf7ef'),
    CHESS("fas-chess", '\uf439'),
    CHESS_BISHOP("fas-chess-bishop", '\uf43a'),
    CHESS_BOARD("fas-chess-board", '\uf43c'),
    CHESS_KING("fas-chess-king", '\uf43f'),
    CHESS_KNIGHT("fas-chess-knight", '\uf441'),
    CHESS_PAWN("fas-chess-pawn", '\uf443'),
    CHESS_QUEEN("fas-chess-queen", '\uf445'),
    CHESS_ROOK("fas-chess-rook", '\uf447'),
    CHEVRON_CIRCLE_DOWN("fas-chevron-circle-down", '\uf13a'),
    CHEVRON_CIRCLE_LEFT("fas-chevron-circle-left", '\uf137'),
    CHEVRON_CIRCLE_RIGHT("fas-chevron-circle-right", '\uf138'),
    CHEVRON_CIRCLE_UP("fas-chevron-circle-up", '\uf139'),
    CHEVRON_DOWN("fas-chevron-down", '\uf078'),
    CHEVRON_LEFT("fas-chevron-left", '\uf053'),
    CHEVRON_RIGHT("fas-chevron-right", '\uf054'),
    CHEVRON_UP("fas-chevron-up", '\uf077'),
    CHILD("fas-child", '\uf1ae'),
    CHURCH("fas-church", '\uf51d'),
    CIRCLE("fas-circle", '\uf111'),
    CIRCLE_NOTCH("fas-circle-notch", '\uf1ce'),
    CITY("fas-city", '\uf64f'),
    CLINIC_MEDICAL("fas-clinic-medical", '\uf7f2'),
    CLIPBOARD("fas-clipboard", '\uf328'),
    CLIPBOARD_CHECK("fas-clipboard-check", '\uf46c'),
    CLIPBOARD_LIST("fas-clipboard-list", '\uf46d'),
    CLOCK("fas-clock", '\uf017'),
    CLONE("fas-clone", '\uf24d'),
    CLOSED_CAPTIONING("fas-closed-captioning", '\uf20a'),
    CLOUD("fas-cloud", '\uf0c2'),
    CLOUD_DOWNLOAD_ALT("fas-cloud-download-alt", '\uf381'),
    CLOUD_MEATBALL("fas-cloud-meatball", '\uf73b'),
    CLOUD_MOON("fas-cloud-moon", '\uf6c3'),
    CLOUD_MOON_RAIN("fas-cloud-moon-rain", '\uf73c'),
    CLOUD_RAIN("fas-cloud-rain", '\uf73d'),
    CLOUD_SHOWERS_HEAVY("fas-cloud-showers-heavy", '\uf740'),
    CLOUD_SUN("fas-cloud-sun", '\uf6c4'),
    CLOUD_SUN_RAIN("fas-cloud-sun-rain", '\uf743'),
    CLOUD_UPLOAD_ALT("fas-cloud-upload-alt", '\uf382'),
    COCKTAIL("fas-cocktail", '\uf561'),
    CODE("fas-code", '\uf121'),
    CODE_BRANCH("fas-code-branch", '\uf126'),
    COFFEE("fas-coffee", '\uf0f4'),
    COG("fas-cog", '\uf013'),
    COGS("fas-cogs", '\uf085'),
    COINS("fas-coins", '\uf51e'),
    COLUMNS("fas-columns", '\uf0db'),
    COMMENT("fas-comment", '\uf075'),
    COMMENTS("fas-comments", '\uf086'),
    COMMENTS_DOLLAR("fas-comments-dollar", '\uf653'),
    COMMENT_ALT("fas-comment-alt", '\uf27a'),
    COMMENT_DOLLAR("fas-comment-dollar", '\uf651'),
    COMMENT_DOTS("fas-comment-dots", '\uf4ad'),
    COMMENT_MEDICAL("fas-comment-medical", '\uf7f5'),
    COMMENT_SLASH("fas-comment-slash", '\uf4b3'),
    COMPACT_DISC("fas-compact-disc", '\uf51f'),
    COMPASS("fas-compass", '\uf14e'),
    COMPRESS("fas-compress", '\uf066'),
    COMPRESS_ALT("fas-compress-alt", '\uf422'),
    COMPRESS_ARROWS_ALT("fas-compress-arrows-alt", '\uf78c'),
    CONCIERGE_BELL("fas-concierge-bell", '\uf562'),
    COOKIE("fas-cookie", '\uf563'),
    COOKIE_BITE("fas-cookie-bite", '\uf564'),
    COPY("fas-copy", '\uf0c5'),
    COPYRIGHT("fas-copyright", '\uf1f9'),
    COUCH("fas-couch", '\uf4b8'),
    CREDIT_CARD("fas-credit-card", '\uf09d'),
    CROP("fas-crop", '\uf125'),
    CROP_ALT("fas-crop-alt", '\uf565'),
    CROSS("fas-cross", '\uf654'),
    CROSSHAIRS("fas-crosshairs", '\uf05b'),
    CROW("fas-crow", '\uf520'),
    CROWN("fas-crown", '\uf521'),
    CRUTCH("fas-crutch", '\uf7f7'),
    CUBE("fas-cube", '\uf1b2'),
    CUBES("fas-cubes", '\uf1b3'),
    CUT("fas-cut", '\uf0c4'),
    DATABASE("fas-database", '\uf1c0'),
    DEAF("fas-deaf", '\uf2a4'),
    DEMOCRAT("fas-democrat", '\uf747'),
    DESKTOP("fas-desktop", '\uf108'),
    DHARMACHAKRA("fas-dharmachakra", '\uf655'),
    DIAGNOSES("fas-diagnoses", '\uf470'),
    DICE("fas-dice", '\uf522'),
    DICE_D20("fas-dice-d20", '\uf6cf'),
    DICE_D6("fas-dice-d6", '\uf6d1'),
    DICE_FIVE("fas-dice-five", '\uf523'),
    DICE_FOUR("fas-dice-four", '\uf524'),
    DICE_ONE("fas-dice-one", '\uf525'),
    DICE_SIX("fas-dice-six", '\uf526'),
    DICE_THREE("fas-dice-three", '\uf527'),
    DICE_TWO("fas-dice-two", '\uf528'),
    DIGITAL_TACHOGRAPH("fas-digital-tachograph", '\uf566'),
    DIRECTIONS("fas-directions", '\uf5eb'),
    DISEASE("fas-disease", '\uf7fa'),
    DIVIDE("fas-divide", '\uf529'),
    DIZZY("fas-dizzy", '\uf567'),
    DNA("fas-dna", '\uf471'),
    DOG("fas-dog", '\uf6d3'),
    DOLLAR_SIGN("fas-dollar-sign", '\uf155'),
    DOLLY("fas-dolly", '\uf472'),
    DOLLY_FLATBED("fas-dolly-flatbed", '\uf474'),
    DONATE("fas-donate", '\uf4b9'),
    DOOR_CLOSED("fas-door-closed", '\uf52a'),
    DOOR_OPEN("fas-door-open", '\uf52b'),
    DOT_CIRCLE("fas-dot-circle", '\uf192'),
    DOVE("fas-dove", '\uf4ba'),
    DOWNLOAD("fas-download", '\uf019'),
    DRAFTING_COMPASS("fas-drafting-compass", '\uf568'),
    DRAGON("fas-dragon", '\uf6d5'),
    DRAW_POLYGON("fas-draw-polygon", '\uf5ee'),
    DRUM("fas-drum", '\uf569'),
    DRUMSTICK_BITE("fas-drumstick-bite", '\uf6d7'),
    DRUM_STEELPAN("fas-drum-steelpan", '\uf56a'),
    DUMBBELL("fas-dumbbell", '\uf44b'),
    DUMPSTER("fas-dumpster", '\uf793'),
    DUMPSTER_FIRE("fas-dumpster-fire", '\uf794'),
    DUNGEON("fas-dungeon", '\uf6d9'),
    EDIT("fas-edit", '\uf044'),
    EGG("fas-egg", '\uf7fb'),
    EJECT("fas-eject", '\uf052'),
    ELLIPSIS_H("fas-ellipsis-h", '\uf141'),
    ELLIPSIS_V("fas-ellipsis-v", '\uf142'),
    ENVELOPE("fas-envelope", '\uf0e0'),
    ENVELOPE_OPEN("fas-envelope-open", '\uf2b6'),
    ENVELOPE_OPEN_TEXT("fas-envelope-open-text", '\uf658'),
    ENVELOPE_SQUARE("fas-envelope-square", '\uf199'),
    EQUALS("fas-equals", '\uf52c'),
    ERASER("fas-eraser", '\uf12d'),
    ETHERNET("fas-ethernet", '\uf796'),
    EURO_SIGN("fas-euro-sign", '\uf153'),
    EXCHANGE_ALT("fas-exchange-alt", '\uf362'),
    EXCLAMATION("fas-exclamation", '\uf12a'),
    EXCLAMATION_CIRCLE("fas-exclamation-circle", '\uf06a'),
    EXCLAMATION_TRIANGLE("fas-exclamation-triangle", '\uf071'),
    EXPAND("fas-expand", '\uf065'),
    EXPAND_ALT("fas-expand-alt", '\uf424'),
    EXPAND_ARROWS_ALT("fas-expand-arrows-alt", '\uf31e'),
    EXTERNAL_LINK_ALT("fas-external-link-alt", '\uf35d'),
    EXTERNAL_LINK_SQUARE_ALT("fas-external-link-square-alt", '\uf360'),
    EYE("fas-eye", '\uf06e'),
    EYE_DROPPER("fas-eye-dropper", '\uf1fb'),
    EYE_SLASH("fas-eye-slash", '\uf070'),
    FAN("fas-fan", '\uf863'),
    FAST_BACKWARD("fas-fast-backward", '\uf049'),
    FAST_FORWARD("fas-fast-forward", '\uf050'),
    FAUCET("fas-faucet", '\ue005'),
    FAX("fas-fax", '\uf1ac'),
    FEATHER("fas-feather", '\uf52d'),
    FEATHER_ALT("fas-feather-alt", '\uf56b'),
    FEMALE("fas-female", '\uf182'),
    FIGHTER_JET("fas-fighter-jet", '\uf0fb'),
    FILE("fas-file", '\uf15b'),
    FILE_ALT("fas-file-alt", '\uf15c'),
    FILE_ARCHIVE("fas-file-archive", '\uf1c6'),
    FILE_AUDIO("fas-file-audio", '\uf1c7'),
    FILE_CODE("fas-file-code", '\uf1c9'),
    FILE_CONTRACT("fas-file-contract", '\uf56c'),
    FILE_CSV("fas-file-csv", '\uf6dd'),
    FILE_DOWNLOAD("fas-file-download", '\uf56d'),
    FILE_EXCEL("fas-file-excel", '\uf1c3'),
    FILE_EXPORT("fas-file-export", '\uf56e'),
    FILE_IMAGE("fas-file-image", '\uf1c5'),
    FILE_IMPORT("fas-file-import", '\uf56f'),
    FILE_INVOICE("fas-file-invoice", '\uf570'),
    FILE_INVOICE_DOLLAR("fas-file-invoice-dollar", '\uf571'),
    FILE_MEDICAL("fas-file-medical", '\uf477'),
    FILE_MEDICAL_ALT("fas-file-medical-alt", '\uf478'),
    FILE_PDF("fas-file-pdf", '\uf1c1'),
    FILE_POWERPOINT("fas-file-powerpoint", '\uf1c4'),
    FILE_PRESCRIPTION("fas-file-prescription", '\uf572'),
    FILE_SIGNATURE("fas-file-signature", '\uf573'),
    FILE_UPLOAD("fas-file-upload", '\uf574'),
    FILE_VIDEO("fas-file-video", '\uf1c8'),
    FILE_WORD("fas-file-word", '\uf1c2'),
    FILL("fas-fill", '\uf575'),
    FILL_DRIP("fas-fill-drip", '\uf576'),
    FILM("fas-film", '\uf008'),
    FILTER("fas-filter", '\uf0b0'),
    FINGERPRINT("fas-fingerprint", '\uf577'),
    FIRE("fas-fire", '\uf06d'),
    FIRE_ALT("fas-fire-alt", '\uf7e4'),
    FIRE_EXTINGUISHER("fas-fire-extinguisher", '\uf134'),
    FIRST_AID("fas-first-aid", '\uf479'),
    FISH("fas-fish", '\uf578'),
    FIST_RAISED("fas-fist-raised", '\uf6de'),
    FLAG("fas-flag", '\uf024'),
    FLAG_CHECKERED("fas-flag-checkered", '\uf11e'),
    FLAG_USA("fas-flag-usa", '\uf74d'),
    FLASK("fas-flask", '\uf0c3'),
    FLUSHED("fas-flushed", '\uf579'),
    FOLDER("fas-folder", '\uf07b'),
    FOLDER_MINUS("fas-folder-minus", '\uf65d'),
    FOLDER_OPEN("fas-folder-open", '\uf07c'),
    FOLDER_PLUS("fas-folder-plus", '\uf65e'),
    FONT("fas-font", '\uf031'),
    FOOTBALL_BALL("fas-football-ball", '\uf44e'),
    FORWARD("fas-forward", '\uf04e'),
    FROG("fas-frog", '\uf52e'),
    FROWN("fas-frown", '\uf119'),
    FROWN_OPEN("fas-frown-open", '\uf57a'),
    FUNNEL_DOLLAR("fas-funnel-dollar", '\uf662'),
    FUTBOL("fas-futbol", '\uf1e3'),
    GAMEPAD("fas-gamepad", '\uf11b'),
    GAS_PUMP("fas-gas-pump", '\uf52f'),
    GAVEL("fas-gavel", '\uf0e3'),
    GEM("fas-gem", '\uf3a5'),
    GENDERLESS("fas-genderless", '\uf22d'),
    GHOST("fas-ghost", '\uf6e2'),
    GIFT("fas-gift", '\uf06b'),
    GIFTS("fas-gifts", '\uf79c'),
    GLASSES("fas-glasses", '\uf530'),
    GLASS_CHEERS("fas-glass-cheers", '\uf79f'),
    GLASS_MARTINI("fas-glass-martini", '\uf000'),
    GLASS_MARTINI_ALT("fas-glass-martini-alt", '\uf57b'),
    GLASS_WHISKEY("fas-glass-whiskey", '\uf7a0'),
    GLOBE("fas-globe", '\uf0ac'),
    GLOBE_AFRICA("fas-globe-africa", '\uf57c'),
    GLOBE_AMERICAS("fas-globe-americas", '\uf57d'),
    GLOBE_ASIA("fas-globe-asia", '\uf57e'),
    GLOBE_EUROPE("fas-globe-europe", '\uf7a2'),
    GOLF_BALL("fas-golf-ball", '\uf450'),
    GOPURAM("fas-gopuram", '\uf664'),
    GRADUATION_CAP("fas-graduation-cap", '\uf19d'),
    GREATER_THAN("fas-greater-than", '\uf531'),
    GREATER_THAN_EQUAL("fas-greater-than-equal", '\uf532'),
    GRIMACE("fas-grimace", '\uf57f'),
    GRIN("fas-grin", '\uf580'),
    GRIN_ALT("fas-grin-alt", '\uf581'),
    GRIN_BEAM("fas-grin-beam", '\uf582'),
    GRIN_BEAM_SWEAT("fas-grin-beam-sweat", '\uf583'),
    GRIN_HEARTS("fas-grin-hearts", '\uf584'),
    GRIN_SQUINT("fas-grin-squint", '\uf585'),
    GRIN_SQUINT_TEARS("fas-grin-squint-tears", '\uf586'),
    GRIN_STARS("fas-grin-stars", '\uf587'),
    GRIN_TEARS("fas-grin-tears", '\uf588'),
    GRIN_TONGUE("fas-grin-tongue", '\uf589'),
    GRIN_TONGUE_SQUINT("fas-grin-tongue-squint", '\uf58a'),
    GRIN_TONGUE_WINK("fas-grin-tongue-wink", '\uf58b'),
    GRIN_WINK("fas-grin-wink", '\uf58c'),
    GRIP_HORIZONTAL("fas-grip-horizontal", '\uf58d'),
    GRIP_LINES("fas-grip-lines", '\uf7a4'),
    GRIP_LINES_VERTICAL("fas-grip-lines-vertical", '\uf7a5'),
    GRIP_VERTICAL("fas-grip-vertical", '\uf58e'),
    GUITAR("fas-guitar", '\uf7a6'),
    HAMBURGER("fas-hamburger", '\uf805'),
    HAMMER("fas-hammer", '\uf6e3'),
    HAMSA("fas-hamsa", '\uf665'),
    HANDS("fas-hands", '\uf4c2'),
    HANDSHAKE("fas-handshake", '\uf2b5'),
    HANDSHAKE_ALT_SLASH("fas-handshake-alt-slash", '\ue05f'),
    HANDSHAKE_SLASH("fas-handshake-slash", '\ue060'),
    HANDS_HELPING("fas-hands-helping", '\uf4c4'),
    HANDS_WASH("fas-hands-wash", '\ue05e'),
    HAND_HOLDING("fas-hand-holding", '\uf4bd'),
    HAND_HOLDING_HEART("fas-hand-holding-heart", '\uf4be'),
    HAND_HOLDING_MEDICAL("fas-hand-holding-medical", '\ue05c'),
    HAND_HOLDING_USD("fas-hand-holding-usd", '\uf4c0'),
    HAND_HOLDING_WATER("fas-hand-holding-water", '\uf4c1'),
    HAND_LIZARD("fas-hand-lizard", '\uf258'),
    HAND_MIDDLE_FINGER("fas-hand-middle-finger", '\uf806'),
    HAND_PAPER("fas-hand-paper", '\uf256'),
    HAND_PEACE("fas-hand-peace", '\uf25b'),
    HAND_POINTER("fas-hand-pointer", '\uf25a'),
    HAND_POINT_DOWN("fas-hand-point-down", '\uf0a7'),
    HAND_POINT_LEFT("fas-hand-point-left", '\uf0a5'),
    HAND_POINT_RIGHT("fas-hand-point-right", '\uf0a4'),
    HAND_POINT_UP("fas-hand-point-up", '\uf0a6'),
    HAND_ROCK("fas-hand-rock", '\uf255'),
    HAND_SCISSORS("fas-hand-scissors", '\uf257'),
    HAND_SPARKLES("fas-hand-sparkles", '\ue05d'),
    HAND_SPOCK("fas-hand-spock", '\uf259'),
    HANUKIAH("fas-hanukiah", '\uf6e6'),
    HARD_HAT("fas-hard-hat", '\uf807'),
    HASHTAG("fas-hashtag", '\uf292'),
    HAT_COWBOY("fas-hat-cowboy", '\uf8c0'),
    HAT_COWBOY_SIDE("fas-hat-cowboy-side", '\uf8c1'),
    HAT_WIZARD("fas-hat-wizard", '\uf6e8'),
    HDD("fas-hdd", '\uf0a0'),
    HEADING("fas-heading", '\uf1dc'),
    HEADPHONES("fas-headphones", '\uf025'),
    HEADPHONES_ALT("fas-headphones-alt", '\uf58f'),
    HEADSET("fas-headset", '\uf590'),
    HEAD_SIDE_COUGH("fas-head-side-cough", '\ue061'),
    HEAD_SIDE_COUGH_SLASH("fas-head-side-cough-slash", '\ue062'),
    HEAD_SIDE_MASK("fas-head-side-mask", '\ue063'),
    HEAD_SIDE_VIRUS("fas-head-side-virus", '\ue064'),
    HEART("fas-heart", '\uf004'),
    HEARTBEAT("fas-heartbeat", '\uf21e'),
    HEART_BROKEN("fas-heart-broken", '\uf7a9'),
    HELICOPTER("fas-helicopter", '\uf533'),
    HIGHLIGHTER("fas-highlighter", '\uf591'),
    HIKING("fas-hiking", '\uf6ec'),
    HIPPO("fas-hippo", '\uf6ed'),
    HISTORY("fas-history", '\uf1da'),
    HOCKEY_PUCK("fas-hockey-puck", '\uf453'),
    HOLLY_BERRY("fas-holly-berry", '\uf7aa'),
    HOME("fas-home", '\uf015'),
    HORSE("fas-horse", '\uf6f0'),
    HORSE_HEAD("fas-horse-head", '\uf7ab'),
    HOSPITAL("fas-hospital", '\uf0f8'),
    HOSPITAL_ALT("fas-hospital-alt", '\uf47d'),
    HOSPITAL_SYMBOL("fas-hospital-symbol", '\uf47e'),
    HOSPITAL_USER("fas-hospital-user", '\uf80d'),
    HOTDOG("fas-hotdog", '\uf80f'),
    HOTEL("fas-hotel", '\uf594'),
    HOT_TUB("fas-hot-tub", '\uf593'),
    HOURGLASS("fas-hourglass", '\uf254'),
    HOURGLASS_END("fas-hourglass-end", '\uf253'),
    HOURGLASS_HALF("fas-hourglass-half", '\uf252'),
    HOURGLASS_START("fas-hourglass-start", '\uf251'),
    HOUSE_DAMAGE("fas-house-damage", '\uf6f1'),
    HOUSE_USER("fas-house-user", '\ue065'),
    HRYVNIA("fas-hryvnia", '\uf6f2'),
    H_SQUARE("fas-h-square", '\uf0fd'),
    ICE_CREAM("fas-ice-cream", '\uf810'),
    ICICLES("fas-icicles", '\uf7ad'),
    ICONS("fas-icons", '\uf86d'),
    ID_BADGE("fas-id-badge", '\uf2c1'),
    ID_CARD("fas-id-card", '\uf2c2'),
    ID_CARD_ALT("fas-id-card-alt", '\uf47f'),
    IGLOO("fas-igloo", '\uf7ae'),
    IMAGE("fas-image", '\uf03e'),
    IMAGES("fas-images", '\uf302'),
    INBOX("fas-inbox", '\uf01c'),
    INDENT("fas-indent", '\uf03c'),
    INDUSTRY("fas-industry", '\uf275'),
    INFINITY("fas-infinity", '\uf534'),
    INFO("fas-info", '\uf129'),
    INFO_CIRCLE("fas-info-circle", '\uf05a'),
    ITALIC("fas-italic", '\uf033'),
    I_CURSOR("fas-i-cursor", '\uf246'),
    JEDI("fas-jedi", '\uf669'),
    JOINT("fas-joint", '\uf595'),
    JOURNAL_WHILLS("fas-journal-whills", '\uf66a'),
    KAABA("fas-kaaba", '\uf66b'),
    KEY("fas-key", '\uf084'),
    KEYBOARD("fas-keyboard", '\uf11c'),
    KHANDA("fas-khanda", '\uf66d'),
    KISS("fas-kiss", '\uf596'),
    KISS_BEAM("fas-kiss-beam", '\uf597'),
    KISS_WINK_HEART("fas-kiss-wink-heart", '\uf598'),
    KIWI_BIRD("fas-kiwi-bird", '\uf535'),
    LANDMARK("fas-landmark", '\uf66f'),
    LANGUAGE("fas-language", '\uf1ab'),
    LAPTOP("fas-laptop", '\uf109'),
    LAPTOP_CODE("fas-laptop-code", '\uf5fc'),
    LAPTOP_HOUSE("fas-laptop-house", '\ue066'),
    LAPTOP_MEDICAL("fas-laptop-medical", '\uf812'),
    LAUGH("fas-laugh", '\uf599'),
    LAUGH_BEAM("fas-laugh-beam", '\uf59a'),
    LAUGH_SQUINT("fas-laugh-squint", '\uf59b'),
    LAUGH_WINK("fas-laugh-wink", '\uf59c'),
    LAYER_GROUP("fas-layer-group", '\uf5fd'),
    LEAF("fas-leaf", '\uf06c'),
    LEMON("fas-lemon", '\uf094'),
    LESS_THAN("fas-less-than", '\uf536'),
    LESS_THAN_EQUAL("fas-less-than-equal", '\uf537'),
    LEVEL_DOWN_ALT("fas-level-down-alt", '\uf3be'),
    LEVEL_UP_ALT("fas-level-up-alt", '\uf3bf'),
    LIFE_RING("fas-life-ring", '\uf1cd'),
    LIGHTBULB("fas-lightbulb", '\uf0eb'),
    LINK("fas-link", '\uf0c1'),
    LIRA_SIGN("fas-lira-sign", '\uf195'),
    LIST("fas-list", '\uf03a'),
    LIST_ALT("fas-list-alt", '\uf022'),
    LIST_OL("fas-list-ol", '\uf0cb'),
    LIST_UL("fas-list-ul", '\uf0ca'),
    LOCATION_ARROW("fas-location-arrow", '\uf124'),
    LOCK("fas-lock", '\uf023'),
    LOCK_OPEN("fas-lock-open", '\uf3c1'),
    LONG_ARROW_ALT_DOWN("fas-long-arrow-alt-down", '\uf309'),
    LONG_ARROW_ALT_LEFT("fas-long-arrow-alt-left", '\uf30a'),
    LONG_ARROW_ALT_RIGHT("fas-long-arrow-alt-right", '\uf30b'),
    LONG_ARROW_ALT_UP("fas-long-arrow-alt-up", '\uf30c'),
    LOW_VISION("fas-low-vision", '\uf2a8'),
    LUGGAGE_CART("fas-luggage-cart", '\uf59d'),
    LUNGS("fas-lungs", '\uf604'),
    LUNGS_VIRUS("fas-lungs-virus", '\ue067'),
    MAGIC("fas-magic", '\uf0d0'),
    MAGNET("fas-magnet", '\uf076'),
    MAIL_BULK("fas-mail-bulk", '\uf674'),
    MALE("fas-male", '\uf183'),
    MAP("fas-map", '\uf279'),
    MAP_MARKED("fas-map-marked", '\uf59f'),
    MAP_MARKED_ALT("fas-map-marked-alt", '\uf5a0'),
    MAP_MARKER("fas-map-marker", '\uf041'),
    MAP_MARKER_ALT("fas-map-marker-alt", '\uf3c5'),
    MAP_PIN("fas-map-pin", '\uf276'),
    MAP_SIGNS("fas-map-signs", '\uf277'),
    MARKER("fas-marker", '\uf5a1'),
    MARS("fas-mars", '\uf222'),
    MARS_DOUBLE("fas-mars-double", '\uf227'),
    MARS_STROKE("fas-mars-stroke", '\uf229'),
    MARS_STROKE_H("fas-mars-stroke-h", '\uf22b'),
    MARS_STROKE_V("fas-mars-stroke-v", '\uf22a'),
    MASK("fas-mask", '\uf6fa'),
    MEDAL("fas-medal", '\uf5a2'),
    MEDKIT("fas-medkit", '\uf0fa'),
    MEH("fas-meh", '\uf11a'),
    MEH_BLANK("fas-meh-blank", '\uf5a4'),
    MEH_ROLLING_EYES("fas-meh-rolling-eyes", '\uf5a5'),
    MEMORY("fas-memory", '\uf538'),
    MENORAH("fas-menorah", '\uf676'),
    MERCURY("fas-mercury", '\uf223'),
    METEOR("fas-meteor", '\uf753'),
    MICROCHIP("fas-microchip", '\uf2db'),
    MICROPHONE("fas-microphone", '\uf130'),
    MICROPHONE_ALT("fas-microphone-alt", '\uf3c9'),
    MICROPHONE_ALT_SLASH("fas-microphone-alt-slash", '\uf539'),
    MICROPHONE_SLASH("fas-microphone-slash", '\uf131'),
    MICROSCOPE("fas-microscope", '\uf610'),
    MINUS("fas-minus", '\uf068'),
    MINUS_CIRCLE("fas-minus-circle", '\uf056'),
    MINUS_SQUARE("fas-minus-square", '\uf146'),
    MITTEN("fas-mitten", '\uf7b5'),
    MOBILE("fas-mobile", '\uf10b'),
    MOBILE_ALT("fas-mobile-alt", '\uf3cd'),
    MONEY_BILL("fas-money-bill", '\uf0d6'),
    MONEY_BILL_ALT("fas-money-bill-alt", '\uf3d1'),
    MONEY_BILL_WAVE("fas-money-bill-wave", '\uf53a'),
    MONEY_BILL_WAVE_ALT("fas-money-bill-wave-alt", '\uf53b'),
    MONEY_CHECK("fas-money-check", '\uf53c'),
    MONEY_CHECK_ALT("fas-money-check-alt", '\uf53d'),
    MONUMENT("fas-monument", '\uf5a6'),
    MOON("fas-moon", '\uf186'),
    MORTAR_PESTLE("fas-mortar-pestle", '\uf5a7'),
    MOSQUE("fas-mosque", '\uf678'),
    MOTORCYCLE("fas-motorcycle", '\uf21c'),
    MOUNTAIN("fas-mountain", '\uf6fc'),
    MOUSE("fas-mouse", '\uf8cc'),
    MOUSE_POINTER("fas-mouse-pointer", '\uf245'),
    MUG_HOT("fas-mug-hot", '\uf7b6'),
    MUSIC("fas-music", '\uf001'),
    NETWORK_WIRED("fas-network-wired", '\uf6ff'),
    NEUTER("fas-neuter", '\uf22c'),
    NEWSPAPER("fas-newspaper", '\uf1ea'),
    NOTES_MEDICAL("fas-notes-medical", '\uf481'),
    NOT_EQUAL("fas-not-equal", '\uf53e'),
    OBJECT_GROUP("fas-object-group", '\uf247'),
    OBJECT_UNGROUP("fas-object-ungroup", '\uf248'),
    OIL_CAN("fas-oil-can", '\uf613'),
    OM("fas-om", '\uf679'),
    OTTER("fas-otter", '\uf700'),
    OUTDENT("fas-outdent", '\uf03b'),
    PAGER("fas-pager", '\uf815'),
    PAINT_BRUSH("fas-paint-brush", '\uf1fc'),
    PAINT_ROLLER("fas-paint-roller", '\uf5aa'),
    PALETTE("fas-palette", '\uf53f'),
    PALLET("fas-pallet", '\uf482'),
    PAPERCLIP("fas-paperclip", '\uf0c6'),
    PAPER_PLANE("fas-paper-plane", '\uf1d8'),
    PARACHUTE_BOX("fas-parachute-box", '\uf4cd'),
    PARAGRAPH("fas-paragraph", '\uf1dd'),
    PARKING("fas-parking", '\uf540'),
    PASSPORT("fas-passport", '\uf5ab'),
    PASTAFARIANISM("fas-pastafarianism", '\uf67b'),
    PASTE("fas-paste", '\uf0ea'),
    PAUSE("fas-pause", '\uf04c'),
    PAUSE_CIRCLE("fas-pause-circle", '\uf28b'),
    PAW("fas-paw", '\uf1b0'),
    PEACE("fas-peace", '\uf67c'),
    PEN("fas-pen", '\uf304'),
    PENCIL_ALT("fas-pencil-alt", '\uf303'),
    PENCIL_RULER("fas-pencil-ruler", '\uf5ae'),
    PEN_ALT("fas-pen-alt", '\uf305'),
    PEN_FANCY("fas-pen-fancy", '\uf5ac'),
    PEN_NIB("fas-pen-nib", '\uf5ad'),
    PEN_SQUARE("fas-pen-square", '\uf14b'),
    PEOPLE_ARROWS("fas-people-arrows", '\ue068'),
    PEOPLE_CARRY("fas-people-carry", '\uf4ce'),
    PEPPER_HOT("fas-pepper-hot", '\uf816'),
    PERCENT("fas-percent", '\uf295'),
    PERCENTAGE("fas-percentage", '\uf541'),
    PERSON_BOOTH("fas-person-booth", '\uf756'),
    PHONE("fas-phone", '\uf095'),
    PHONE_ALT("fas-phone-alt", '\uf879'),
    PHONE_SLASH("fas-phone-slash", '\uf3dd'),
    PHONE_SQUARE("fas-phone-square", '\uf098'),
    PHONE_SQUARE_ALT("fas-phone-square-alt", '\uf87b'),
    PHONE_VOLUME("fas-phone-volume", '\uf2a0'),
    PHOTO_VIDEO("fas-photo-video", '\uf87c'),
    PIGGY_BANK("fas-piggy-bank", '\uf4d3'),
    PILLS("fas-pills", '\uf484'),
    PIZZA_SLICE("fas-pizza-slice", '\uf818'),
    PLACE_OF_WORSHIP("fas-place-of-worship", '\uf67f'),
    PLANE("fas-plane", '\uf072'),
    PLANE_ARRIVAL("fas-plane-arrival", '\uf5af'),
    PLANE_DEPARTURE("fas-plane-departure", '\uf5b0'),
    PLANE_SLASH("fas-plane-slash", '\ue069'),
    PLAY("fas-play", '\uf04b'),
    PLAY_CIRCLE("fas-play-circle", '\uf144'),
    PLUG("fas-plug", '\uf1e6'),
    PLUS("fas-plus", '\uf067'),
    PLUS_CIRCLE("fas-plus-circle", '\uf055'),
    PLUS_SQUARE("fas-plus-square", '\uf0fe'),
    PODCAST("fas-podcast", '\uf2ce'),
    POLL("fas-poll", '\uf681'),
    POLL_H("fas-poll-h", '\uf682'),
    POO("fas-poo", '\uf2fe'),
    POOP("fas-poop", '\uf619'),
    POO_STORM("fas-poo-storm", '\uf75a'),
    PORTRAIT("fas-portrait", '\uf3e0'),
    POUND_SIGN("fas-pound-sign", '\uf154'),
    POWER_OFF("fas-power-off", '\uf011'),
    PRAY("fas-pray", '\uf683'),
    PRAYING_HANDS("fas-praying-hands", '\uf684'),
    PRESCRIPTION("fas-prescription", '\uf5b1'),
    PRESCRIPTION_BOTTLE("fas-prescription-bottle", '\uf485'),
    PRESCRIPTION_BOTTLE_ALT("fas-prescription-bottle-alt", '\uf486'),
    PRINT("fas-print", '\uf02f'),
    PROCEDURES("fas-procedures", '\uf487'),
    PROJECT_DIAGRAM("fas-project-diagram", '\uf542'),
    PUMP_MEDICAL("fas-pump-medical", '\ue06a'),
    PUMP_SOAP("fas-pump-soap", '\ue06b'),
    PUZZLE_PIECE("fas-puzzle-piece", '\uf12e'),
    QRCODE("fas-qrcode", '\uf029'),
    QUESTION("fas-question", '\uf128'),
    QUESTION_CIRCLE("fas-question-circle", '\uf059'),
    QUIDDITCH("fas-quidditch", '\uf458'),
    QUOTE_LEFT("fas-quote-left", '\uf10d'),
    QUOTE_RIGHT("fas-quote-right", '\uf10e'),
    QURAN("fas-quran", '\uf687'),
    RADIATION("fas-radiation", '\uf7b9'),
    RADIATION_ALT("fas-radiation-alt", '\uf7ba'),
    RAINBOW("fas-rainbow", '\uf75b'),
    RANDOM("fas-random", '\uf074'),
    RECEIPT("fas-receipt", '\uf543'),
    RECORD_VINYL("fas-record-vinyl", '\uf8d9'),
    RECYCLE("fas-recycle", '\uf1b8'),
    REDO("fas-redo", '\uf01e'),
    REDO_ALT("fas-redo-alt", '\uf2f9'),
    REGISTERED("fas-registered", '\uf25d'),
    REMOVE_FORMAT("fas-remove-format", '\uf87d'),
    REPLY("fas-reply", '\uf3e5'),
    REPLY_ALL("fas-reply-all", '\uf122'),
    REPUBLICAN("fas-republican", '\uf75e'),
    RESTROOM("fas-restroom", '\uf7bd'),
    RETWEET("fas-retweet", '\uf079'),
    RIBBON("fas-ribbon", '\uf4d6'),
    RING("fas-ring", '\uf70b'),
    ROAD("fas-road", '\uf018'),
    ROBOT("fas-robot", '\uf544'),
    ROCKET("fas-rocket", '\uf135'),
    ROUTE("fas-route", '\uf4d7'),
    RSS("fas-rss", '\uf09e'),
    RSS_SQUARE("fas-rss-square", '\uf143'),
    RUBLE_SIGN("fas-ruble-sign", '\uf158'),
    RULER("fas-ruler", '\uf545'),
    RULER_COMBINED("fas-ruler-combined", '\uf546'),
    RULER_HORIZONTAL("fas-ruler-horizontal", '\uf547'),
    RULER_VERTICAL("fas-ruler-vertical", '\uf548'),
    RUNNING("fas-running", '\uf70c'),
    RUPEE_SIGN("fas-rupee-sign", '\uf156'),
    SAD_CRY("fas-sad-cry", '\uf5b3'),
    SAD_TEAR("fas-sad-tear", '\uf5b4'),
    SATELLITE("fas-satellite", '\uf7bf'),
    SATELLITE_DISH("fas-satellite-dish", '\uf7c0'),
    SAVE("fas-save", '\uf0c7'),
    SCHOOL("fas-school", '\uf549'),
    SCREWDRIVER("fas-screwdriver", '\uf54a'),
    SCROLL("fas-scroll", '\uf70e'),
    SD_CARD("fas-sd-card", '\uf7c2'),
    SEARCH("fas-search", '\uf002'),
    SEARCH_DOLLAR("fas-search-dollar", '\uf688'),
    SEARCH_LOCATION("fas-search-location", '\uf689'),
    SEARCH_MINUS("fas-search-minus", '\uf010'),
    SEARCH_PLUS("fas-search-plus", '\uf00e'),
    SEEDLING("fas-seedling", '\uf4d8'),
    SERVER("fas-server", '\uf233'),
    SHAPES("fas-shapes", '\uf61f'),
    SHARE("fas-share", '\uf064'),
    SHARE_ALT("fas-share-alt", '\uf1e0'),
    SHARE_ALT_SQUARE("fas-share-alt-square", '\uf1e1'),
    SHARE_SQUARE("fas-share-square", '\uf14d'),
    SHEKEL_SIGN("fas-shekel-sign", '\uf20b'),
    SHIELD_ALT("fas-shield-alt", '\uf3ed'),
    SHIELD_VIRUS("fas-shield-virus", '\ue06c'),
    SHIP("fas-ship", '\uf21a'),
    SHIPPING_FAST("fas-shipping-fast", '\uf48b'),
    SHOE_PRINTS("fas-shoe-prints", '\uf54b'),
    SHOPPING_BAG("fas-shopping-bag", '\uf290'),
    SHOPPING_BASKET("fas-shopping-basket", '\uf291'),
    SHOPPING_CART("fas-shopping-cart", '\uf07a'),
    SHOWER("fas-shower", '\uf2cc'),
    SHUTTLE_VAN("fas-shuttle-van", '\uf5b6'),
    SIGN("fas-sign", '\uf4d9'),
    SIGNAL("fas-signal", '\uf012'),
    SIGNATURE("fas-signature", '\uf5b7'),
    SIGN_IN_ALT("fas-sign-in-alt", '\uf2f6'),
    SIGN_LANGUAGE("fas-sign-language", '\uf2a7'),
    SIGN_OUT_ALT("fas-sign-out-alt", '\uf2f5'),
    SIM_CARD("fas-sim-card", '\uf7c4'),
    SINK("fas-sink", '\ue06d'),
    SITEMAP("fas-sitemap", '\uf0e8'),
    SKATING("fas-skating", '\uf7c5'),
    SKIING("fas-skiing", '\uf7c9'),
    SKIING_NORDIC("fas-skiing-nordic", '\uf7ca'),
    SKULL("fas-skull", '\uf54c'),
    SKULL_CROSSBONES("fas-skull-crossbones", '\uf714'),
    SLASH("fas-slash", '\uf715'),
    SLEIGH("fas-sleigh", '\uf7cc'),
    SLIDERS_H("fas-sliders-h", '\uf1de'),
    SMILE("fas-smile", '\uf118'),
    SMILE_BEAM("fas-smile-beam", '\uf5b8'),
    SMILE_WINK("fas-smile-wink", '\uf4da'),
    SMOG("fas-smog", '\uf75f'),
    SMOKING("fas-smoking", '\uf48d'),
    SMOKING_BAN("fas-smoking-ban", '\uf54d'),
    SMS("fas-sms", '\uf7cd'),
    SNOWBOARDING("fas-snowboarding", '\uf7ce'),
    SNOWFLAKE("fas-snowflake", '\uf2dc'),
    SNOWMAN("fas-snowman", '\uf7d0'),
    SNOWPLOW("fas-snowplow", '\uf7d2'),
    SOAP("fas-soap", '\ue06e'),
    SOCKS("fas-socks", '\uf696'),
    SOLAR_PANEL("fas-solar-panel", '\uf5ba'),
    SORT("fas-sort", '\uf0dc'),
    SORT_ALPHA_DOWN("fas-sort-alpha-down", '\uf15d'),
    SORT_ALPHA_DOWN_ALT("fas-sort-alpha-down-alt", '\uf881'),
    SORT_ALPHA_UP("fas-sort-alpha-up", '\uf15e'),
    SORT_ALPHA_UP_ALT("fas-sort-alpha-up-alt", '\uf882'),
    SORT_AMOUNT_DOWN("fas-sort-amount-down", '\uf160'),
    SORT_AMOUNT_DOWN_ALT("fas-sort-amount-down-alt", '\uf884'),
    SORT_AMOUNT_UP("fas-sort-amount-up", '\uf161'),
    SORT_AMOUNT_UP_ALT("fas-sort-amount-up-alt", '\uf885'),
    SORT_DOWN("fas-sort-down", '\uf0dd'),
    SORT_NUMERIC_DOWN("fas-sort-numeric-down", '\uf162'),
    SORT_NUMERIC_DOWN_ALT("fas-sort-numeric-down-alt", '\uf886'),
    SORT_NUMERIC_UP("fas-sort-numeric-up", '\uf163'),
    SORT_NUMERIC_UP_ALT("fas-sort-numeric-up-alt", '\uf887'),
    SORT_UP("fas-sort-up", '\uf0de'),
    SPA("fas-spa", '\uf5bb'),
    SPACE_SHUTTLE("fas-space-shuttle", '\uf197'),
    SPELL_CHECK("fas-spell-check", '\uf891'),
    SPIDER("fas-spider", '\uf717'),
    SPINNER("fas-spinner", '\uf110'),
    SPLOTCH("fas-splotch", '\uf5bc'),
    SPRAY_CAN("fas-spray-can", '\uf5bd'),
    SQUARE("fas-square", '\uf0c8'),
    SQUARE_FULL("fas-square-full", '\uf45c'),
    SQUARE_ROOT_ALT("fas-square-root-alt", '\uf698'),
    STAMP("fas-stamp", '\uf5bf'),
    STAR("fas-star", '\uf005'),
    STAR_AND_CRESCENT("fas-star-and-crescent", '\uf699'),
    STAR_HALF("fas-star-half", '\uf089'),
    STAR_HALF_ALT("fas-star-half-alt", '\uf5c0'),
    STAR_OF_DAVID("fas-star-of-david", '\uf69a'),
    STAR_OF_LIFE("fas-star-of-life", '\uf621'),
    STEP_BACKWARD("fas-step-backward", '\uf048'),
    STEP_FORWARD("fas-step-forward", '\uf051'),
    STETHOSCOPE("fas-stethoscope", '\uf0f1'),
    STICKY_NOTE("fas-sticky-note", '\uf249'),
    STOP("fas-stop", '\uf04d'),
    STOPWATCH("fas-stopwatch", '\uf2f2'),
    STOPWATCH_20("fas-stopwatch-20", '\ue06f'),
    STOP_CIRCLE("fas-stop-circle", '\uf28d'),
    STORE("fas-store", '\uf54e'),
    STORE_ALT("fas-store-alt", '\uf54f'),
    STORE_ALT_SLASH("fas-store-alt-slash", '\ue070'),
    STORE_SLASH("fas-store-slash", '\ue071'),
    STREAM("fas-stream", '\uf550'),
    STREET_VIEW("fas-street-view", '\uf21d'),
    STRIKETHROUGH("fas-strikethrough", '\uf0cc'),
    STROOPWAFEL("fas-stroopwafel", '\uf551'),
    SUBSCRIPT("fas-subscript", '\uf12c'),
    SUBWAY("fas-subway", '\uf239'),
    SUITCASE("fas-suitcase", '\uf0f2'),
    SUITCASE_ROLLING("fas-suitcase-rolling", '\uf5c1'),
    SUN("fas-sun", '\uf185'),
    SUPERSCRIPT("fas-superscript", '\uf12b'),
    SURPRISE("fas-surprise", '\uf5c2'),
    SWATCHBOOK("fas-swatchbook", '\uf5c3'),
    SWIMMER("fas-swimmer", '\uf5c4'),
    SWIMMING_POOL("fas-swimming-pool", '\uf5c5'),
    SYNAGOGUE("fas-synagogue", '\uf69b'),
    SYNC("fas-sync", '\uf021'),
    SYNC_ALT("fas-sync-alt", '\uf2f1'),
    SYRINGE("fas-syringe", '\uf48e'),
    TABLE("fas-table", '\uf0ce'),
    TABLET("fas-tablet", '\uf10a'),
    TABLETS("fas-tablets", '\uf490'),
    TABLET_ALT("fas-tablet-alt", '\uf3fa'),
    TABLE_TENNIS("fas-table-tennis", '\uf45d'),
    TACHOMETER_ALT("fas-tachometer-alt", '\uf3fd'),
    TAG("fas-tag", '\uf02b'),
    TAGS("fas-tags", '\uf02c'),
    TAPE("fas-tape", '\uf4db'),
    TASKS("fas-tasks", '\uf0ae'),
    TAXI("fas-taxi", '\uf1ba'),
    TEETH("fas-teeth", '\uf62e'),
    TEETH_OPEN("fas-teeth-open", '\uf62f'),
    TEMPERATURE_HIGH("fas-temperature-high", '\uf769'),
    TEMPERATURE_LOW("fas-temperature-low", '\uf76b'),
    TENGE("fas-tenge", '\uf7d7'),
    TERMINAL("fas-terminal", '\uf120'),
    TEXT_HEIGHT("fas-text-height", '\uf034'),
    TEXT_WIDTH("fas-text-width", '\uf035'),
    TH("fas-th", '\uf00a'),
    THEATER_MASKS("fas-theater-masks", '\uf630'),
    THERMOMETER("fas-thermometer", '\uf491'),
    THERMOMETER_EMPTY("fas-thermometer-empty", '\uf2cb'),
    THERMOMETER_FULL("fas-thermometer-full", '\uf2c7'),
    THERMOMETER_HALF("fas-thermometer-half", '\uf2c9'),
    THERMOMETER_QUARTER("fas-thermometer-quarter", '\uf2ca'),
    THERMOMETER_THREE_QUARTERS("fas-thermometer-three-quarters", '\uf2c8'),
    THUMBS_DOWN("fas-thumbs-down", '\uf165'),
    THUMBS_UP("fas-thumbs-up", '\uf164'),
    THUMBTACK("fas-thumbtack", '\uf08d'),
    TH_LARGE("fas-th-large", '\uf009'),
    TH_LIST("fas-th-list", '\uf00b'),
    TICKET_ALT("fas-ticket-alt", '\uf3ff'),
    TIMES("fas-times", '\uf00d'),
    TIMES_CIRCLE("fas-times-circle", '\uf057'),
    TINT("fas-tint", '\uf043'),
    TINT_SLASH("fas-tint-slash", '\uf5c7'),
    TIRED("fas-tired", '\uf5c8'),
    TOGGLE_OFF("fas-toggle-off", '\uf204'),
    TOGGLE_ON("fas-toggle-on", '\uf205'),
    TOILET("fas-toilet", '\uf7d8'),
    TOILET_PAPER("fas-toilet-paper", '\uf71e'),
    TOILET_PAPER_SLASH("fas-toilet-paper-slash", '\ue072'),
    TOOLBOX("fas-toolbox", '\uf552'),
    TOOLS("fas-tools", '\uf7d9'),
    TOOTH("fas-tooth", '\uf5c9'),
    TORAH("fas-torah", '\uf6a0'),
    TORII_GATE("fas-torii-gate", '\uf6a1'),
    TRACTOR("fas-tractor", '\uf722'),
    TRADEMARK("fas-trademark", '\uf25c'),
    TRAFFIC_LIGHT("fas-traffic-light", '\uf637'),
    TRAILER("fas-trailer", '\ue041'),
    TRAIN("fas-train", '\uf238'),
    TRAM("fas-tram", '\uf7da'),
    TRANSGENDER("fas-transgender", '\uf224'),
    TRANSGENDER_ALT("fas-transgender-alt", '\uf225'),
    TRASH("fas-trash", '\uf1f8'),
    TRASH_ALT("fas-trash-alt", '\uf2ed'),
    TRASH_RESTORE("fas-trash-restore", '\uf829'),
    TRASH_RESTORE_ALT("fas-trash-restore-alt", '\uf82a'),
    TREE("fas-tree", '\uf1bb'),
    TROPHY("fas-trophy", '\uf091'),
    TRUCK("fas-truck", '\uf0d1'),
    TRUCK_LOADING("fas-truck-loading", '\uf4de'),
    TRUCK_MONSTER("fas-truck-monster", '\uf63b'),
    TRUCK_MOVING("fas-truck-moving", '\uf4df'),
    TRUCK_PICKUP("fas-truck-pickup", '\uf63c'),
    TSHIRT("fas-tshirt", '\uf553'),
    TTY("fas-tty", '\uf1e4'),
    TV("fas-tv", '\uf26c'),
    UMBRELLA("fas-umbrella", '\uf0e9'),
    UMBRELLA_BEACH("fas-umbrella-beach", '\uf5ca'),
    UNDERLINE("fas-underline", '\uf0cd'),
    UNDO("fas-undo", '\uf0e2'),
    UNDO_ALT("fas-undo-alt", '\uf2ea'),
    UNIVERSAL_ACCESS("fas-universal-access", '\uf29a'),
    UNIVERSITY("fas-university", '\uf19c'),
    UNLINK("fas-unlink", '\uf127'),
    UNLOCK("fas-unlock", '\uf09c'),
    UNLOCK_ALT("fas-unlock-alt", '\uf13e'),
    UPLOAD("fas-upload", '\uf093'),
    USER("fas-user", '\uf007'),
    USERS("fas-users", '\uf0c0'),
    USERS_COG("fas-users-cog", '\uf509'),
    USERS_SLASH("fas-users-slash", '\ue073'),
    USER_ALT("fas-user-alt", '\uf406'),
    USER_ALT_SLASH("fas-user-alt-slash", '\uf4fa'),
    USER_ASTRONAUT("fas-user-astronaut", '\uf4fb'),
    USER_CHECK("fas-user-check", '\uf4fc'),
    USER_CIRCLE("fas-user-circle", '\uf2bd'),
    USER_CLOCK("fas-user-clock", '\uf4fd'),
    USER_COG("fas-user-cog", '\uf4fe'),
    USER_EDIT("fas-user-edit", '\uf4ff'),
    USER_FRIENDS("fas-user-friends", '\uf500'),
    USER_GRADUATE("fas-user-graduate", '\uf501'),
    USER_INJURED("fas-user-injured", '\uf728'),
    USER_LOCK("fas-user-lock", '\uf502'),
    USER_MD("fas-user-md", '\uf0f0'),
    USER_MINUS("fas-user-minus", '\uf503'),
    USER_NINJA("fas-user-ninja", '\uf504'),
    USER_NURSE("fas-user-nurse", '\uf82f'),
    USER_PLUS("fas-user-plus", '\uf234'),
    USER_SECRET("fas-user-secret", '\uf21b'),
    USER_SHIELD("fas-user-shield", '\uf505'),
    USER_SLASH("fas-user-slash", '\uf506'),
    USER_TAG("fas-user-tag", '\uf507'),
    USER_TIE("fas-user-tie", '\uf508'),
    USER_TIMES("fas-user-times", '\uf235'),
    UTENSILS("fas-utensils", '\uf2e7'),
    UTENSIL_SPOON("fas-utensil-spoon", '\uf2e5'),
    VECTOR_SQUARE("fas-vector-square", '\uf5cb'),
    VENUS("fas-venus", '\uf221'),
    VENUS_DOUBLE("fas-venus-double", '\uf226'),
    VENUS_MARS("fas-venus-mars", '\uf228'),
    VEST("fas-vest", '\ue085'),
    VEST_PATCHES("fas-vest-patches", '\ue086'),
    VIAL("fas-vial", '\uf492'),
    VIALS("fas-vials", '\uf493'),
    VIDEO("fas-video", '\uf03d'),
    VIDEO_SLASH("fas-video-slash", '\uf4e2'),
    VIHARA("fas-vihara", '\uf6a7'),
    VIRUS("fas-virus", '\ue074'),
    VIRUSES("fas-viruses", '\ue076'),
    VIRUS_SLASH("fas-virus-slash", '\ue075'),
    VOICEMAIL("fas-voicemail", '\uf897'),
    VOLLEYBALL_BALL("fas-volleyball-ball", '\uf45f'),
    VOLUME_DOWN("fas-volume-down", '\uf027'),
    VOLUME_MUTE("fas-volume-mute", '\uf6a9'),
    VOLUME_OFF("fas-volume-off", '\uf026'),
    VOLUME_UP("fas-volume-up", '\uf028'),
    VOTE_YEA("fas-vote-yea", '\uf772'),
    VR_CARDBOARD("fas-vr-cardboard", '\uf729'),
    WALKING("fas-walking", '\uf554'),
    WALLET("fas-wallet", '\uf555'),
    WAREHOUSE("fas-warehouse", '\uf494'),
    WATER("fas-water", '\uf773'),
    WAVE_SQUARE("fas-wave-square", '\uf83e'),
    WEIGHT("fas-weight", '\uf496'),
    WEIGHT_HANGING("fas-weight-hanging", '\uf5cd'),
    WHEELCHAIR("fas-wheelchair", '\uf193'),
    WIFI("fas-wifi", '\uf1eb'),
    WIND("fas-wind", '\uf72e'),
    WINDOW_CLOSE("fas-window-close", '\uf410'),
    WINDOW_MAXIMIZE("fas-window-maximize", '\uf2d0'),
    WINDOW_MINIMIZE("fas-window-minimize", '\uf2d1'),
    WINDOW_RESTORE("fas-window-restore", '\uf2d2'),
    WINE_BOTTLE("fas-wine-bottle", '\uf72f'),
    WINE_GLASS("fas-wine-glass", '\uf4e3'),
    WINE_GLASS_ALT("fas-wine-glass-alt", '\uf5ce'),
    WON_SIGN("fas-won-sign", '\uf159'),
    WRENCH("fas-wrench", '\uf0ad'),
    X_RAY("fas-x-ray", '\uf497'),
    YEN_SIGN("fas-yen-sign", '\uf157'),
    YIN_YANG("fas-yin-yang", '\uf6ad');

    public static FontAwesomeSolid findByDescription(String description) {
        for (FontAwesomeSolid font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    FontAwesomeSolid(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}
