/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.javafx.FontIconConverter;
import org.kordamp.ikonli.javafx.Icon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class FontIcon
extends Text
implements Icon {
    protected StyleableIntegerProperty iconSize;
    protected StyleableObjectProperty<Paint> iconColor;
    private StyleableObjectProperty<Ikon> iconCode;

    public FontIcon() {
        this.getStyleClass().setAll((Object[])new String[]{"ikonli-font-icon"});
        this.setIconSize(16);
        this.setIconColor((Paint)Color.BLACK);
        this.fontProperty().addListener((ChangeListener)new ChangeListener<Font>(){

            public void changed(ObservableValue<? extends Font> observable, Font oldValue, Font newValue) {
                int size = (int)newValue.getSize();
                if (size != FontIcon.this.getIconSize()) {
                    FontIcon.this.setIconSize(size);
                }
            }
        });
        this.fillProperty().addListener((ChangeListener)new ChangeListener<Paint>(){

            public void changed(ObservableValue<? extends Paint> observable, Paint oldValue, Paint newValue) {
                Paint fill = FontIcon.this.getIconColor();
                if (!Objects.equals(fill, newValue)) {
                    FontIcon.this.setIconColor(newValue);
                }
            }
        });
    }

    public FontIcon(String iconCode) {
        this();
        this.setIconLiteral(iconCode);
    }

    public FontIcon(Ikon iconCode) {
        this();
        this.setIconCode(iconCode);
    }

    public String toString() {
        return this.getIconCode().getDescription() + ":" + this.getIconSize() + ":" + this.getIconColor();
    }

    @Override
    public IntegerProperty iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableIntegerProperty(16){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_SIZE;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconSize";
                }
            };
            this.iconSize.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    Font font = FontIcon.this.getFont();
                    FontIcon.this.setFont(Font.font((String)font.getFamily(), (double)newValue.doubleValue()));
                    FontIcon.this.setStyle(FontIcon.this.normalizeStyle(FontIcon.this.getStyle(), "-fx-font-size", newValue.intValue() + "px"));
                }
            });
        }
        return this.iconSize;
    }

    @Override
    public ObjectProperty<Paint> iconColorProperty() {
        if (this.iconColor == null) {
            this.iconColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_COLOR;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconColor";
                }
            };
            this.iconColor.addListener((ChangeListener)new ChangeListener<Paint>(){

                public void changed(ObservableValue<? extends Paint> observable, Paint oldValue, Paint newValue) {
                    FontIcon.this.setFill(newValue);
                }
            });
        }
        return this.iconColor;
    }

    public ObjectProperty<Ikon> iconCodeProperty() {
        if (this.iconCode == null) {
            this.iconCode = new StyleableObjectProperty<Ikon>(){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_CODE;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconCode";
                }
            };
            this.iconCode.addListener((ChangeListener)new ChangeListener<Ikon>(){

                public void changed(ObservableValue<? extends Ikon> observable, Ikon oldValue, Ikon newValue) {
                    FontIcon.this.setIconCode(newValue);
                }
            });
        }
        return this.iconCode;
    }

    public ObjectProperty<Ikon> getIconCodeProperty() {
        return this.iconCodeProperty();
    }

    @Override
    public void setIconSize(int size) {
        if (size <= 0) {
            throw new IllegalStateException("Argument 'size' must be greater than zero.");
        }
        this.iconSizeProperty().set(size);
    }

    @Override
    public int getIconSize() {
        return this.iconSizeProperty().get();
    }

    @Override
    public void setIconColor(Paint paint) {
        Objects.requireNonNull(paint, "Argument 'paint' must not be null");
        this.iconColorProperty().set((Object)paint);
    }

    @Override
    public Paint getIconColor() {
        return (Paint)this.iconColorProperty().get();
    }

    public Ikon getIconCode() {
        return (Ikon)this.iconCodeProperty().get();
    }

    public void setIconCode(Ikon iconCode) {
        this.iconCodeProperty().set((Object)Objects.requireNonNull(iconCode, "Argument 'code' must not be null"));
        IkonHandler ikonHandler = IkonResolver.getInstance().resolveIkonHandler(iconCode.getDescription());
        this.setStyle(this.normalizeStyle(this.getStyle(), "-fx-font-family", "'" + ikonHandler.getFontFamily() + "'"));
        this.setText(String.valueOf(iconCode.getCode()));
    }

    private String normalizeStyle(String style, String key, String value) {
        int start = style.indexOf(key);
        if (start != -1) {
            int end = style.indexOf(";", start);
            end = end >= start ? end : style.length() - 1;
            style = style.substring(0, start) + style.substring(end + 1);
        }
        return style + key + ": " + value + ";";
    }

    public void setIconLiteral(String iconCode) {
        String[] parts = iconCode.split(":");
        this.setIconCode(IkonResolver.getInstance().resolveIkonHandler(parts[0]).resolve(parts[0]));
        this.resolveSize(iconCode, parts);
        this.resolvePaint(iconCode, parts);
    }

    public String getIconLiteral() {
        Ikon ikon = (Ikon)this.iconCodeProperty().get();
        return ikon != null ? ikon.getDescription() : null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FontIcon.getClassCssMetaData();
    }

    private void resolveSize(String iconCode, String[] parts) {
        if (parts.length > 1) {
            try {
                this.setIconSize(Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                throw FontIcon.invalidDescription(iconCode, e);
            }
        } else {
            this.setIconSize(16);
        }
    }

    private void resolvePaint(String iconCode, String[] parts) {
        Paint paint;
        if (parts.length > 2 && (paint = FontIcon.resolvePaintValue(iconCode, parts[2])) != null) {
            this.setIconColor(paint);
        }
    }

    private static Paint resolvePaintValue(String iconCode, String value) {
        try {
            return Color.valueOf((String)value);
        }
        catch (IllegalArgumentException e1) {
            try {
                return LinearGradient.valueOf((String)value);
            }
            catch (IllegalArgumentException e2) {
                try {
                    return RadialGradient.valueOf((String)value);
                }
                catch (IllegalArgumentException e3) {
                    throw FontIcon.invalidDescription(iconCode, e3);
                }
            }
        }
    }

    public static IllegalArgumentException invalidDescription(String description, Exception e) {
        throw new IllegalArgumentException("Description " + description + " is not a valid icon description", e);
    }

    private static class StyleableProperties {
        private static final CssMetaData<FontIcon, Number> ICON_SIZE = new CssMetaData<FontIcon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)16.0){

            public boolean isSettable(FontIcon icon) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)icon.iconSizeProperty();
            }
        };
        private static final CssMetaData<FontIcon, Paint> ICON_COLOR = new CssMetaData<FontIcon, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(FontIcon node) {
                return true;
            }

            public StyleableProperty<Paint> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)icon.iconColorProperty();
            }
        };
        private static final CssMetaData<FontIcon, Ikon> ICON_CODE = new CssMetaData<FontIcon, Ikon>("-fx-icon-code", FontIconConverter.getInstance(), null){

            public boolean isSettable(FontIcon node) {
                return true;
            }

            public StyleableProperty<Ikon> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)icon.iconCodeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Text.getClassCssMetaData());
            styleables.add(ICON_SIZE);
            styleables.add(ICON_COLOR);
            styleables.add(ICON_CODE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

