/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.text.Font;
import org.kordamp.ikonli.FontLoader;
import org.kordamp.ikonli.IkonHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={FontLoader.class})
public class JavaFXFontLoader
implements FontLoader {
    private static final Map<String, Font> FONTS = new ConcurrentHashMap<String, Font>();

    public void loadFont(IkonHandler handler) {
        String fontResource = handler.getFontResource().toExternalForm();
        Font font = FONTS.computeIfAbsent(fontResource, key -> Font.loadFont((String)key, (double)16.0));
        handler.setFont((Object)font);
    }

    public static FontLoader getInstance() {
        return new JavaFXFontLoader();
    }
}

