/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2AL implements Ikon {
    MDAL_360("mdal-360", '\ue000'),
    MDAL_3D_ROTATION("mdal-3d_rotation", '\ue001'),
    MDAL_4K("mdal-4k", '\ue002'),
    MDAL_5G("mdal-5g", '\ue74a'),
    MDAL_6_FT_APART("mdal-6_ft_apart", '\ue89a'),
    AC_UNIT("mdal-ac_unit", '\ue004'),
    ACCESS_ALARM("mdal-access_alarm", '\ue005'),
    ACCESS_ALARMS("mdal-access_alarms", '\ue007'),
    ACCESS_TIME("mdal-access_time", '\ue009'),
    ACCESSIBILITY("mdal-accessibility", '\ue00b'),
    ACCESSIBILITY_NEW("mdal-accessibility_new", '\ue00c'),
    ACCESSIBLE("mdal-accessible", '\ue00d'),
    ACCESSIBLE_FORWARD("mdal-accessible_forward", '\ue00e'),
    ACCOUNT_BALANCE("mdal-account_balance", '\ue00f'),
    ACCOUNT_BALANCE_WALLET("mdal-account_balance_wallet", '\ue011'),
    ACCOUNT_BOX("mdal-account_box", '\ue013'),
    ACCOUNT_CIRCLE("mdal-account_circle", '\ue015'),
    ACCOUNT_TREE("mdal-account_tree", '\ue017'),
    AD_UNITS("mdal-ad_units", '\ue74b'),
    ADB("mdal-adb", '\ue019'),
    ADD("mdal-add", '\ue01a'),
    ADD_A_PHOTO("mdal-add_a_photo", '\ue01b'),
    ADD_ALARM("mdal-add_alarm", '\ue01d'),
    ADD_ALERT("mdal-add_alert", '\ue01f'),
    ADD_BOX("mdal-add_box", '\ue021'),
    ADD_BUSINESS("mdal-add_business", '\ue74d'),
    ADD_CIRCLE("mdal-add_circle", '\ue023'),
    ADD_CIRCLE_OUTLINE("mdal-add_circle_outline", '\ue025'),
    ADD_COMMENT("mdal-add_comment", '\ue026'),
    ADD_IC_CALL("mdal-add_ic_call", '\ue744'),
    ADD_LOCATION("mdal-add_location", '\ue028'),
    ADD_LOCATION_ALT("mdal-add_location_alt", '\ue74f'),
    ADD_PHOTO_ALTERNATE("mdal-add_photo_alternate", '\ue02a'),
    ADD_ROAD("mdal-add_road", '\ue751'),
    ADD_SHOPPING_CART("mdal-add_shopping_cart", '\ue02c'),
    ADD_TASK("mdal-add_task", '\ue8b3'),
    ADD_TO_HOME_SCREEN("mdal-add_to_home_screen", '\ue02d'),
    ADD_TO_PHOTOS("mdal-add_to_photos", '\ue02e'),
    ADD_TO_QUEUE("mdal-add_to_queue", '\ue030'),
    ADDCHART("mdal-addchart", '\ue752'),
    ADJUST("mdal-adjust", '\ue032'),
    ADMIN_PANEL_SETTINGS("mdal-admin_panel_settings", '\ue753'),
    AGRICULTURE("mdal-agriculture", '\ue755'),
    AIRLINE_SEAT_FLAT("mdal-airline_seat_flat", '\ue033'),
    AIRLINE_SEAT_FLAT_ANGLED("mdal-airline_seat_flat_angled", '\ue035'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("mdal-airline_seat_individual_suite", '\ue037'),
    AIRLINE_SEAT_LEGROOM_EXTRA("mdal-airline_seat_legroom_extra", '\ue039'),
    AIRLINE_SEAT_LEGROOM_NORMAL("mdal-airline_seat_legroom_normal", '\ue03a'),
    AIRLINE_SEAT_LEGROOM_REDUCED("mdal-airline_seat_legroom_reduced", '\ue03b'),
    AIRLINE_SEAT_RECLINE_EXTRA("mdal-airline_seat_recline_extra", '\ue03c'),
    AIRLINE_SEAT_RECLINE_NORMAL("mdal-airline_seat_recline_normal", '\ue03d'),
    AIRPLANEMODE_ACTIVE("mdal-airplanemode_active", '\ue03e'),
    AIRPLANEMODE_INACTIVE("mdal-airplanemode_inactive", '\ue03f'),
    AIRPLAY("mdal-airplay", '\ue040'),
    AIRPORT_SHUTTLE("mdal-airport_shuttle", '\ue041'),
    ALARM("mdal-alarm", '\ue043'),
    ALARM_ADD("mdal-alarm_add", '\ue045'),
    ALARM_OFF("mdal-alarm_off", '\ue047'),
    ALARM_ON("mdal-alarm_on", '\ue048'),
    ALBUM("mdal-album", '\ue04a'),
    ALIGN_HORIZONTAL_CENTER("mdal-align_horizontal_center", '\ue8ca'),
    ALIGN_HORIZONTAL_LEFT("mdal-align_horizontal_left", '\ue8cb'),
    ALIGN_HORIZONTAL_RIGHT("mdal-align_horizontal_right", '\ue8cc'),
    ALIGN_VERTICAL_BOTTOM("mdal-align_vertical_bottom", '\ue8cd'),
    ALIGN_VERTICAL_CENTER("mdal-align_vertical_center", '\ue8ce'),
    ALIGN_VERTICAL_TOP("mdal-align_vertical_top", '\ue8cf'),
    ALL_INBOX("mdal-all_inbox", '\ue04c'),
    ALL_INCLUSIVE("mdal-all_inclusive", '\ue04e'),
    ALL_OUT("mdal-all_out", '\ue04f'),
    ALT_ROUTE("mdal-alt_route", '\ue757'),
    ALTERNATE_EMAIL("mdal-alternate_email", '\ue051'),
    AMP_STORIES("mdal-amp_stories", '\ue053'),
    ANALYTICS("mdal-analytics", '\ue758'),
    ANCHOR("mdal-anchor", '\ue75a'),
    ANDROID("mdal-android", '\ue055'),
    ANNOUNCEMENT("mdal-announcement", '\ue056'),
    APARTMENT("mdal-apartment", '\ue058'),
    API("mdal-api", '\ue75b'),
    APP_BLOCKING("mdal-app_blocking", '\ue75c'),
    APP_SETTINGS_ALT("mdal-app_settings_alt", '\ue75e'),
    APPS("mdal-apps", '\ue059'),
    ARCHITECTURE("mdal-architecture", '\ue760'),
    ARCHIVE("mdal-archive", '\ue05a'),
    ARROW_BACK("mdal-arrow_back", '\ue05c'),
    ARROW_BACK_IOS("mdal-arrow_back_ios", '\ue05d'),
    ARROW_CIRCLE_DOWN("mdal-arrow_circle_down", '\ue761'),
    ARROW_CIRCLE_UP("mdal-arrow_circle_up", '\ue763'),
    ARROW_DOWNWARD("mdal-arrow_downward", '\ue05e'),
    ARROW_DROP_DOWN("mdal-arrow_drop_down", '\ue05f'),
    ARROW_DROP_DOWN_CIRCLE("mdal-arrow_drop_down_circle", '\ue060'),
    ARROW_DROP_UP("mdal-arrow_drop_up", '\ue062'),
    ARROW_FORWARD("mdal-arrow_forward", '\ue063'),
    ARROW_FORWARD_IOS("mdal-arrow_forward_ios", '\ue064'),
    ARROW_LEFT("mdal-arrow_left", '\ue065'),
    ARROW_RIGHT("mdal-arrow_right", '\ue066'),
    ARROW_RIGHT_ALT("mdal-arrow_right_alt", '\ue067'),
    ARROW_UPWARD("mdal-arrow_upward", '\ue068'),
    ART_TRACK("mdal-art_track", '\ue069'),
    ARTICLE("mdal-article", '\ue765'),
    ASPECT_RATIO("mdal-aspect_ratio", '\ue06a'),
    ASSESSMENT("mdal-assessment", '\ue06c'),
    ASSIGNMENT("mdal-assignment", '\ue06e'),
    ASSIGNMENT_IND("mdal-assignment_ind", '\ue070'),
    ASSIGNMENT_LATE("mdal-assignment_late", '\ue072'),
    ASSIGNMENT_RETURN("mdal-assignment_return", '\ue074'),
    ASSIGNMENT_RETURNED("mdal-assignment_returned", '\ue076'),
    ASSIGNMENT_TURNED_IN("mdal-assignment_turned_in", '\ue078'),
    ASSISTANT("mdal-assistant", '\ue07a'),
    ASSISTANT_PHOTO("mdal-assistant_photo", '\ue07c'),
    ATM("mdal-atm", '\ue07e'),
    ATTACH_EMAIL("mdal-attach_email", '\ue767'),
    ATTACH_FILE("mdal-attach_file", '\ue07f'),
    ATTACH_MONEY("mdal-attach_money", '\ue080'),
    ATTACHMENT("mdal-attachment", '\ue081'),
    AUDIOTRACK("mdal-audiotrack", '\ue082'),
    AUTO_DELETE("mdal-auto_delete", '\ue768'),
    AUTORENEW("mdal-autorenew", '\ue084'),
    AV_TIMER("mdal-av_timer", '\ue085'),
    BABY_CHANGING_STATION("mdal-baby_changing_station", '\ue76a'),
    BACKPACK("mdal-backpack", '\ue76b'),
    BACKSPACE("mdal-backspace", '\ue086'),
    BACKUP("mdal-backup", '\ue088'),
    BACKUP_TABLE("mdal-backup_table", '\ue76d'),
    BALLOT("mdal-ballot", '\ue08a'),
    BAR_CHART("mdal-bar_chart", '\ue08c'),
    BARCODE("mdal-barcode", '\ue08d'),
    BATCH_PREDICTION("mdal-batch_prediction", '\ue76f'),
    BATHTUB("mdal-bathtub", '\ue08e'),
    BATTERY_20("mdal-battery_20", '\ue090'),
    BATTERY_30("mdal-battery_30", '\ue092'),
    BATTERY_50("mdal-battery_50", '\ue094'),
    BATTERY_60("mdal-battery_60", '\ue096'),
    BATTERY_80("mdal-battery_80", '\ue098'),
    BATTERY_90("mdal-battery_90", '\ue09a'),
    BATTERY_ALERT("mdal-battery_alert", '\ue09c'),
    BATTERY_CHARGING_20("mdal-battery_charging_20", '\ue09d'),
    BATTERY_CHARGING_30("mdal-battery_charging_30", '\ue09f'),
    BATTERY_CHARGING_50("mdal-battery_charging_50", '\ue0a1'),
    BATTERY_CHARGING_60("mdal-battery_charging_60", '\ue0a3'),
    BATTERY_CHARGING_80("mdal-battery_charging_80", '\ue0a5'),
    BATTERY_CHARGING_90("mdal-battery_charging_90", '\ue0a7'),
    BATTERY_CHARGING_FULL("mdal-battery_charging_full", '\ue0a9'),
    BATTERY_FULL("mdal-battery_full", '\ue0aa'),
    BATTERY_STD("mdal-battery_std", '\ue0ab'),
    BATTERY_UNKNOWN("mdal-battery_unknown", '\ue0ac'),
    BEACH_ACCESS("mdal-beach_access", '\ue0ad'),
    BEDTIME("mdal-bedtime", '\ue771'),
    BEENHERE("mdal-beenhere", '\ue0af'),
    BENTO("mdal-bento", '\ue864'),
    BIKE_SCOOTER("mdal-bike_scooter", '\ue773'),
    BIOTECH("mdal-biotech", '\ue774'),
    BLOCK("mdal-block", '\ue0b1'),
    BLUETOOTH("mdal-bluetooth", '\ue0b2'),
    BLUETOOTH_AUDIO("mdal-bluetooth_audio", '\ue0b3'),
    BLUETOOTH_CONNECTED("mdal-bluetooth_connected", '\ue0b4'),
    BLUETOOTH_DISABLED("mdal-bluetooth_disabled", '\ue0b5'),
    BLUETOOTH_SEARCHING("mdal-bluetooth_searching", '\ue0b6'),
    BLUR_CIRCULAR("mdal-blur_circular", '\ue0b7'),
    BLUR_LINEAR("mdal-blur_linear", '\ue0b8'),
    BLUR_OFF("mdal-blur_off", '\ue0b9'),
    BLUR_ON("mdal-blur_on", '\ue0ba'),
    BOOK("mdal-book", '\ue0bb'),
    BOOK_ONLINE("mdal-book_online", '\ue89b'),
    BOOKMARK("mdal-bookmark", '\ue0bd'),
    BOOKMARK_BORDER("mdal-bookmark_border", '\ue0bf'),
    BOOKMARKS("mdal-bookmarks", '\ue0c0'),
    BORDER_ALL("mdal-border_all", '\ue0c2'),
    BORDER_BOTTOM("mdal-border_bottom", '\ue0c3'),
    BORDER_CLEAR("mdal-border_clear", '\ue0c4'),
    BORDER_COLOR("mdal-border_color", '\ue0c5'),
    BORDER_HORIZONTAL("mdal-border_horizontal", '\ue0c7'),
    BORDER_INNER("mdal-border_inner", '\ue0c8'),
    BORDER_LEFT("mdal-border_left", '\ue0c9'),
    BORDER_OUTER("mdal-border_outer", '\ue0ca'),
    BORDER_RIGHT("mdal-border_right", '\ue0cb'),
    BORDER_STYLE("mdal-border_style", '\ue0cc'),
    BORDER_TOP("mdal-border_top", '\ue0cd'),
    BORDER_VERTICAL("mdal-border_vertical", '\ue0ce'),
    BRANDING_WATERMARK("mdal-branding_watermark", '\ue0cf'),
    BRIGHTNESS_1("mdal-brightness_1", '\ue0d1'),
    BRIGHTNESS_2("mdal-brightness_2", '\ue0d3'),
    BRIGHTNESS_3("mdal-brightness_3", '\ue0d5'),
    BRIGHTNESS_4("mdal-brightness_4", '\ue0d7'),
    BRIGHTNESS_5("mdal-brightness_5", '\ue0d9'),
    BRIGHTNESS_6("mdal-brightness_6", '\ue0db'),
    BRIGHTNESS_7("mdal-brightness_7", '\ue0dd'),
    BRIGHTNESS_AUTO("mdal-brightness_auto", '\ue0df'),
    BRIGHTNESS_HIGH("mdal-brightness_high", '\ue0e1'),
    BRIGHTNESS_LOW("mdal-brightness_low", '\ue0e3'),
    BRIGHTNESS_MEDIUM("mdal-brightness_medium", '\ue0e5'),
    BROKEN_IMAGE("mdal-broken_image", '\ue0e7'),
    BROWSER_NOT_SUPPORTED("mdal-browser_not_supported", '\ue776'),
    BRUSH("mdal-brush", '\ue0e9'),
    BUBBLE_CHART("mdal-bubble_chart", '\ue0eb'),
    BUG_REPORT("mdal-bug_report", '\ue0ed'),
    BUILD("mdal-build", '\ue0ef'),
    BUILD_CIRCLE("mdal-build_circle", '\ue777'),
    BURST_MODE("mdal-burst_mode", '\ue0f1'),
    BUSINESS("mdal-business", '\ue0f3'),
    BUSINESS_CENTER("mdal-business_center", '\ue0f5'),
    CACHED("mdal-cached", '\ue0f7'),
    CAKE("mdal-cake", '\ue0f8'),
    CALCULATE("mdal-calculate", '\ue779'),
    CALENDAR_TODAY("mdal-calendar_today", '\ue0fa'),
    CALENDAR_VIEW_DAY("mdal-calendar_view_day", '\ue0fc'),
    CALL("mdal-call", '\ue0fe'),
    CALL_END("mdal-call_end", '\ue100'),
    CALL_MADE("mdal-call_made", '\ue102'),
    CALL_MERGE("mdal-call_merge", '\ue103'),
    CALL_MISSED("mdal-call_missed", '\ue104'),
    CALL_MISSED_OUTGOING("mdal-call_missed_outgoing", '\ue105'),
    CALL_RECEIVED("mdal-call_received", '\ue106'),
    CALL_SPLIT("mdal-call_split", '\ue107'),
    CALL_TO_ACTION("mdal-call_to_action", '\ue108'),
    CAMERA("mdal-camera", '\ue10a'),
    CAMERA_ALT("mdal-camera_alt", '\ue10c'),
    CAMERA_ENHANCE("mdal-camera_enhance", '\ue10e'),
    CAMERA_FRONT("mdal-camera_front", '\ue110'),
    CAMERA_REAR("mdal-camera_rear", '\ue112'),
    CAMERA_ROLL("mdal-camera_roll", '\ue114'),
    CAMPAIGN("mdal-campaign", '\ue77b'),
    CANCEL("mdal-cancel", '\ue116'),
    CANCEL_PRESENTATION("mdal-cancel_presentation", '\ue118'),
    CANCEL_SCHEDULE_SEND("mdal-cancel_schedule_send", '\ue11a'),
    CARD_GIFTCARD("mdal-card_giftcard", '\ue11c'),
    CARD_MEMBERSHIP("mdal-card_membership", '\ue11e'),
    CARD_TRAVEL("mdal-card_travel", '\ue120'),
    CARPENTER("mdal-carpenter", '\ue866'),
    CASINO("mdal-casino", '\ue122'),
    CAST("mdal-cast", '\ue124'),
    CAST_CONNECTED("mdal-cast_connected", '\ue125'),
    CAST_FOR_EDUCATION("mdal-cast_for_education", '\ue127'),
    CATEGORY("mdal-category", '\ue128'),
    CELL_WIFI("mdal-cell_wifi", '\ue12a'),
    CENTER_FOCUS_STRONG("mdal-center_focus_strong", '\ue12c'),
    CENTER_FOCUS_WEAK("mdal-center_focus_weak", '\ue12e'),
    CHANGE_HISTORY("mdal-change_history", '\ue130'),
    CHARGING_STATION("mdal-charging_station", '\ue77d'),
    CHAT("mdal-chat", '\ue132'),
    CHAT_BUBBLE("mdal-chat_bubble", '\ue134'),
    CHAT_BUBBLE_OUTLINE("mdal-chat_bubble_outline", '\ue136'),
    CHECK("mdal-check", '\ue137'),
    CHECK_BOX("mdal-check_box", '\ue138'),
    CHECK_BOX_OUTLINE_BLANK("mdal-check_box_outline_blank", '\ue13a'),
    CHECK_CIRCLE("mdal-check_circle", '\ue13b'),
    CHECK_CIRCLE_OUTLINE("mdal-check_circle_outline", '\ue13d'),
    CHECKROOM("mdal-checkroom", '\ue77f'),
    CHEVRON_LEFT("mdal-chevron_left", '\ue13e'),
    CHEVRON_RIGHT("mdal-chevron_right", '\ue13f'),
    CHILD_CARE("mdal-child_care", '\ue140'),
    CHILD_FRIENDLY("mdal-child_friendly", '\ue142'),
    CHROME_READER_MODE("mdal-chrome_reader_mode", '\ue144'),
    CLASS("mdal-class", '\ue146'),
    CLEAN_HANDS("mdal-clean_hands", '\ue89d'),
    CLEANING_SERVICES("mdal-cleaning_services", '\ue780'),
    CLEAR("mdal-clear", '\ue148'),
    CLEAR_ALL("mdal-clear_all", '\ue149'),
    CLOSE("mdal-close", '\ue14a'),
    CLOSE_FULLSCREEN("mdal-close_fullscreen", '\ue782'),
    CLOSED_CAPTION("mdal-closed_caption", '\ue14b'),
    CLOSED_CAPTION_DISABLED("mdal-closed_caption_disabled", '\ue868'),
    CLOUD("mdal-cloud", '\ue14d'),
    CLOUD_CIRCLE("mdal-cloud_circle", '\ue14f'),
    CLOUD_DONE("mdal-cloud_done", '\ue151'),
    CLOUD_DOWNLOAD("mdal-cloud_download", '\ue153'),
    CLOUD_OFF("mdal-cloud_off", '\ue155'),
    CLOUD_QUEUE("mdal-cloud_queue", '\ue157'),
    CLOUD_UPLOAD("mdal-cloud_upload", '\ue159'),
    CODE("mdal-code", '\ue15b'),
    COLLECTIONS("mdal-collections", '\ue15c'),
    COLLECTIONS_BOOKMARK("mdal-collections_bookmark", '\ue15e'),
    COLOR_LENS("mdal-color_lens", '\ue160'),
    COLORIZE("mdal-colorize", '\ue162'),
    COMMENT("mdal-comment", '\ue164'),
    COMMENT_BANK("mdal-comment_bank", '\ue783'),
    COMMUTE("mdal-commute", '\ue166'),
    COMPARE("mdal-compare", '\ue167'),
    COMPARE_ARROWS("mdal-compare_arrows", '\ue169'),
    COMPASS_CALIBRATION("mdal-compass_calibration", '\ue16a'),
    COMPUTER("mdal-computer", '\ue16c'),
    CONFIRMATION_NUMBER("mdal-confirmation_number", '\ue16e'),
    CONNECT_WITHOUT_CONTACT("mdal-connect_without_contact", '\ue89f'),
    CONSTRUCTION("mdal-construction", '\ue785'),
    CONTACT_MAIL("mdal-contact_mail", '\ue170'),
    CONTACT_PAGE("mdal-contact_page", '\ue8b4'),
    CONTACT_PHONE("mdal-contact_phone", '\ue172'),
    CONTACT_SUPPORT("mdal-contact_support", '\ue174'),
    CONTACTLESS("mdal-contactless", '\ue176'),
    CONTACTS("mdal-contacts", '\ue178'),
    CONTENT_COPY("mdal-content_copy", '\ue17a'),
    CONTENT_CUT("mdal-content_cut", '\ue17c'),
    CONTENT_PASTE("mdal-content_paste", '\ue17e'),
    CONTROL_CAMERA("mdal-control_camera", '\ue180'),
    CONTROL_POINT("mdal-control_point", '\ue181'),
    CONTROL_POINT_DUPLICATE("mdal-control_point_duplicate", '\ue183'),
    COPYRIGHT("mdal-copyright", '\ue185'),
    CORONAVIRUS("mdal-coronavirus", '\ue8a0'),
    CORPORATE_FARE("mdal-corporate_fare", '\ue786'),
    COUNTERTOPS("mdal-countertops", '\ue86a'),
    CREATE("mdal-create", '\ue187'),
    CREATE_NEW_FOLDER("mdal-create_new_folder", '\ue189'),
    CREDIT_CARD("mdal-credit_card", '\ue18b'),
    CROP("mdal-crop", '\ue18d'),
    CROP_16_9("mdal-crop_16_9", '\ue18e'),
    CROP_3_2("mdal-crop_3_2", '\ue18f'),
    CROP_5_4("mdal-crop_5_4", '\ue190'),
    CROP_7_5("mdal-crop_7_5", '\ue191'),
    CROP_DIN("mdal-crop_din", '\ue192'),
    CROP_FREE("mdal-crop_free", '\ue193'),
    CROP_LANDSCAPE("mdal-crop_landscape", '\ue194'),
    CROP_ORIGINAL("mdal-crop_original", '\ue195'),
    CROP_PORTRAIT("mdal-crop_portrait", '\ue196'),
    CROP_ROTATE("mdal-crop_rotate", '\ue197'),
    CROP_SQUARE("mdal-crop_square", '\ue198'),
    DASHBOARD("mdal-dashboard", '\ue199'),
    DATA_USAGE("mdal-data_usage", '\ue19b'),
    DATE_RANGE("mdal-date_range", '\ue19c'),
    DECK("mdal-deck", '\ue19e'),
    DEHAZE("mdal-dehaze", '\ue1a0'),
    DELETE("mdal-delete", '\ue1a1'),
    DELETE_FOREVER("mdal-delete_forever", '\ue1a3'),
    DELETE_OUTLINE("mdal-delete_outline", '\ue1a5'),
    DELETE_SWEEP("mdal-delete_sweep", '\ue1a6'),
    DEPARTURE_BOARD("mdal-departure_board", '\ue1a8'),
    DESCRIPTION("mdal-description", '\ue1aa'),
    DESIGN_SERVICES("mdal-design_services", '\ue788'),
    DESKTOP_ACCESS_DISABLED("mdal-desktop_access_disabled", '\ue1ac'),
    DESKTOP_MAC("mdal-desktop_mac", '\ue1ae'),
    DESKTOP_WINDOWS("mdal-desktop_windows", '\ue1b0'),
    DETAILS("mdal-details", '\ue1b2'),
    DEVELOPER_BOARD("mdal-developer_board", '\ue1b4'),
    DEVELOPER_MODE("mdal-developer_mode", '\ue1b6'),
    DEVICE_HUB("mdal-device_hub", '\ue1b7'),
    DEVICE_UNKNOWN("mdal-device_unknown", '\ue1b8'),
    DEVICES("mdal-devices", '\ue1ba'),
    DEVICES_OTHER("mdal-devices_other", '\ue1bc'),
    DIALER_SIP("mdal-dialer_sip", '\ue1be'),
    DIALPAD("mdal-dialpad", '\ue1c0'),
    DIRECTIONS("mdal-directions", '\ue1c1'),
    DIRECTIONS_BIKE("mdal-directions_bike", '\ue1c3'),
    DIRECTIONS_BOAT("mdal-directions_boat", '\ue1c4'),
    DIRECTIONS_BUS("mdal-directions_bus", '\ue1c6'),
    DIRECTIONS_CAR("mdal-directions_car", '\ue1c8'),
    DIRECTIONS_OFF("mdal-directions_off", '\ue78a'),
    DIRECTIONS_RAILWAY("mdal-directions_railway", '\ue1ca'),
    DIRECTIONS_RUN("mdal-directions_run", '\ue1cc'),
    DIRECTIONS_SUBWAY("mdal-directions_subway", '\ue1cd'),
    DIRECTIONS_TRANSIT("mdal-directions_transit", '\ue1cf'),
    DIRECTIONS_WALK("mdal-directions_walk", '\ue1d1'),
    DISABLED_BY_DEFAULT("mdal-disabled_by_default", '\ue8b6'),
    DISC_FULL("mdal-disc_full", '\ue1d2'),
    DIVIDE("mdal-divide", '\ue1d4'),
    DNS("mdal-dns", '\ue1d6'),
    DO_NOT_DISTURB("mdal-do_not_disturb", '\ue1d8'),
    DO_NOT_DISTURB_ALT("mdal-do_not_disturb_alt", '\ue1da'),
    DO_NOT_DISTURB_OFF("mdal-do_not_disturb_off", '\ue1dc'),
    DO_NOT_STEP("mdal-do_not_step", '\ue78b'),
    DO_NOT_TOUCH("mdal-do_not_touch", '\ue78d'),
    DOCK("mdal-dock", '\ue1de'),
    DOMAIN("mdal-domain", '\ue1e0'),
    DOMAIN_DISABLED("mdal-domain_disabled", '\ue1e2'),
    DOMAIN_VERIFICATION("mdal-domain_verification", '\ue78f'),
    DONE("mdal-done", '\ue1e4'),
    DONE_ALL("mdal-done_all", '\ue1e5'),
    DONE_OUTLINE("mdal-done_outline", '\ue1e6'),
    DONUT_LARGE("mdal-donut_large", '\ue1e7'),
    DONUT_SMALL("mdal-donut_small", '\ue1e8'),
    DOUBLE_ARROW("mdal-double_arrow", '\ue1ea'),
    DRAFTS("mdal-drafts", '\ue1eb'),
    DRAG_HANDLE("mdal-drag_handle", '\ue1ed'),
    DRAG_INDICATOR("mdal-drag_indicator", '\ue1ee'),
    DRIVE_ETA("mdal-drive_eta", '\ue1ef'),
    DRY("mdal-dry", '\ue791'),
    DUO("mdal-duo", '\ue1f1'),
    DVR("mdal-dvr", '\ue1f2'),
    DYNAMIC_FEED("mdal-dynamic_feed", '\ue1f4'),
    DYNAMIC_FORM("mdal-dynamic_form", '\ue793'),
    EAST("mdal-east", '\ue86c'),
    ECO("mdal-eco", '\ue1f6'),
    EDIT("mdal-edit", '\ue1f8'),
    EDIT_ATTRIBUTES("mdal-edit_attributes", '\ue1fa'),
    EDIT_LOCATION("mdal-edit_location", '\ue1fc'),
    EDIT_ROAD("mdal-edit_road", '\ue795'),
    EJECT("mdal-eject", '\ue1fe'),
    ELDERLY("mdal-elderly", '\ue8a2'),
    ELECTRIC_BIKE("mdal-electric_bike", '\ue797'),
    ELECTRIC_CAR("mdal-electric_car", '\ue798'),
    ELECTRIC_MOPED("mdal-electric_moped", '\ue79a'),
    ELECTRIC_SCOOTER("mdal-electric_scooter", '\ue79c'),
    ELECTRICAL_SERVICES("mdal-electrical_services", '\ue79d'),
    ELEVATOR("mdal-elevator", '\ue79e'),
    EMAIL("mdal-email", '\ue200'),
    EMOJI_EMOTIONS("mdal-emoji_emotions", '\ue202'),
    EMOJI_EVENTS("mdal-emoji_events", '\ue204'),
    EMOJI_FLAGS("mdal-emoji_flags", '\ue206'),
    EMOJI_FOOD_BEVERAGE("mdal-emoji_food_beverage", '\ue208'),
    EMOJI_NATURE("mdal-emoji_nature", '\ue20a'),
    EMOJI_OBJECTS("mdal-emoji_objects", '\ue20c'),
    EMOJI_PEOPLE("mdal-emoji_people", '\ue20e'),
    EMOJI_SYMBOLS("mdal-emoji_symbols", '\ue20f'),
    EMOJI_TRANSPORTATION("mdal-emoji_transportation", '\ue210'),
    ENGINEERING("mdal-engineering", '\ue7a0'),
    ENHANCED_ENCRYPTION("mdal-enhanced_encryption", '\ue211'),
    EQUALIZER("mdal-equalizer", '\ue213'),
    EQUALS("mdal-equals", '\ue214'),
    ERROR("mdal-error", '\ue215'),
    ERROR_OUTLINE("mdal-error_outline", '\ue217'),
    ESCALATOR("mdal-escalator", '\ue7a2'),
    ESCALATOR_WARNING("mdal-escalator_warning", '\ue7a4'),
    EURO("mdal-euro", '\ue218'),
    EURO_SYMBOL("mdal-euro_symbol", '\ue219'),
    EV_STATION("mdal-ev_station", '\ue21a'),
    EVENT("mdal-event", '\ue21c'),
    EVENT_AVAILABLE("mdal-event_available", '\ue21e'),
    EVENT_BUSY("mdal-event_busy", '\ue220'),
    EVENT_NOTE("mdal-event_note", '\ue222'),
    EVENT_SEAT("mdal-event_seat", '\ue224'),
    EXIT_TO_APP("mdal-exit_to_app", '\ue226'),
    EXPAND_LESS("mdal-expand_less", '\ue227'),
    EXPAND_MORE("mdal-expand_more", '\ue228'),
    EXPLICIT("mdal-explicit", '\ue229'),
    EXPLORE("mdal-explore", '\ue22b'),
    EXPLORE_OFF("mdal-explore_off", '\ue22d'),
    EXPOSURE("mdal-exposure", '\ue22f'),
    EXPOSURE_NEG_1("mdal-exposure_neg_1", '\ue231'),
    EXPOSURE_NEG_2("mdal-exposure_neg_2", '\ue232'),
    EXPOSURE_PLUS_1("mdal-exposure_plus_1", '\ue233'),
    EXPOSURE_PLUS_2("mdal-exposure_plus_2", '\ue234'),
    EXPOSURE_ZERO("mdal-exposure_zero", '\ue235'),
    EXTENSION("mdal-extension", '\ue236'),
    FACE("mdal-face", '\ue238'),
    FACEBOOK("mdal-facebook", '\ue8b8'),
    FACT_CHECK("mdal-fact_check", '\ue7a5'),
    FAMILY_RESTROOM("mdal-family_restroom", '\ue7a7'),
    FAST_FORWARD("mdal-fast_forward", '\ue23a'),
    FAST_REWIND("mdal-fast_rewind", '\ue23c'),
    FASTFOOD("mdal-fastfood", '\ue23e'),
    FAVORITE("mdal-favorite", '\ue240'),
    FAVORITE_BORDER("mdal-favorite_border", '\ue242'),
    FEATURED_PLAY_LIST("mdal-featured_play_list", '\ue243'),
    FEATURED_VIDEO("mdal-featured_video", '\ue245'),
    FEEDBACK("mdal-feedback", '\ue247'),
    FENCE("mdal-fence", '\ue86d'),
    FIBER_DVR("mdal-fiber_dvr", '\ue249'),
    FIBER_MANUAL_RECORD("mdal-fiber_manual_record", '\ue24b'),
    FIBER_NEW("mdal-fiber_new", '\ue24d'),
    FIBER_PIN("mdal-fiber_pin", '\ue24f'),
    FIBER_SMART_RECORD("mdal-fiber_smart_record", '\ue251'),
    FILE_COPY("mdal-file_copy", '\ue253'),
    FILE_UPLOAD("mdal-file_upload", '\ue255'),
    FILTER("mdal-filter", '\ue257'),
    FILTER_1("mdal-filter_1", '\ue259'),
    FILTER_2("mdal-filter_2", '\ue25b'),
    FILTER_3("mdal-filter_3", '\ue25d'),
    FILTER_4("mdal-filter_4", '\ue25f'),
    FILTER_5("mdal-filter_5", '\ue261'),
    FILTER_6("mdal-filter_6", '\ue263'),
    FILTER_7("mdal-filter_7", '\ue265'),
    FILTER_8("mdal-filter_8", '\ue267'),
    FILTER_9("mdal-filter_9", '\ue269'),
    FILTER_9_PLUS("mdal-filter_9_plus", '\ue26b'),
    FILTER_ALT("mdal-filter_alt", '\ue7a8'),
    FILTER_B_AND_W("mdal-filter_b_and_w", '\ue26d'),
    FILTER_CENTER_FOCUS("mdal-filter_center_focus", '\ue26f'),
    FILTER_DRAMA("mdal-filter_drama", '\ue270'),
    FILTER_FRAMES("mdal-filter_frames", '\ue272'),
    FILTER_HDR("mdal-filter_hdr", '\ue274'),
    FILTER_LIST("mdal-filter_list", '\ue276'),
    FILTER_NONE("mdal-filter_none", '\ue277'),
    FILTER_TILT_SHIFT("mdal-filter_tilt_shift", '\ue279'),
    FILTER_VINTAGE("mdal-filter_vintage", '\ue27a'),
    FIND_IN_PAGE("mdal-find_in_page", '\ue27c'),
    FIND_REPLACE("mdal-find_replace", '\ue27e'),
    FINGERPRINT("mdal-fingerprint", '\ue27f'),
    FIRE_EXTINGUISHER("mdal-fire_extinguisher", '\ue86f'),
    FIREPLACE("mdal-fireplace", '\ue280'),
    FIRST_PAGE("mdal-first_page", '\ue282'),
    FITNESS_CENTER("mdal-fitness_center", '\ue283'),
    FLAG("mdal-flag", '\ue284'),
    FLAKY("mdal-flaky", '\ue7aa'),
    FLARE("mdal-flare", '\ue286'),
    FLASH_AUTO("mdal-flash_auto", '\ue287'),
    FLASH_OFF("mdal-flash_off", '\ue288'),
    FLASH_ON("mdal-flash_on", '\ue289'),
    FLIGHT("mdal-flight", '\ue28a'),
    FLIGHT_LAND("mdal-flight_land", '\ue28b'),
    FLIGHT_TAKEOFF("mdal-flight_takeoff", '\ue28c'),
    FLIP("mdal-flip", '\ue28d'),
    FLIP_CAMERA_ANDROID("mdal-flip_camera_android", '\ue28e'),
    FLIP_CAMERA_IOS("mdal-flip_camera_ios", '\ue290'),
    FLIP_TO_BACK("mdal-flip_to_back", '\ue292'),
    FLIP_TO_FRONT("mdal-flip_to_front", '\ue293'),
    FOLDER("mdal-folder", '\ue294'),
    FOLDER_OPEN("mdal-folder_open", '\ue296'),
    FOLDER_SHARED("mdal-folder_shared", '\ue298'),
    FOLDER_SPECIAL("mdal-folder_special", '\ue29a'),
    FOLLOW_THE_SIGNS("mdal-follow_the_signs", '\ue8a3'),
    FONT_DOWNLOAD("mdal-font_download", '\ue29c'),
    FOOD_BANK("mdal-food_bank", '\ue870'),
    FORMAT_ALIGN_CENTER("mdal-format_align_center", '\ue29e'),
    FORMAT_ALIGN_JUSTIFY("mdal-format_align_justify", '\ue29f'),
    FORMAT_ALIGN_LEFT("mdal-format_align_left", '\ue2a0'),
    FORMAT_ALIGN_RIGHT("mdal-format_align_right", '\ue2a1'),
    FORMAT_BOLD("mdal-format_bold", '\ue2a2'),
    FORMAT_CLEAR("mdal-format_clear", '\ue2a3'),
    FORMAT_COLOR_FILL("mdal-format_color_fill", '\ue2a4'),
    FORMAT_COLOR_RESET("mdal-format_color_reset", '\ue2a6'),
    FORMAT_COLOR_TEXT("mdal-format_color_text", '\ue2a8'),
    FORMAT_INDENT_DECREASE("mdal-format_indent_decrease", '\ue2aa'),
    FORMAT_INDENT_INCREASE("mdal-format_indent_increase", '\ue2ab'),
    FORMAT_ITALIC("mdal-format_italic", '\ue2ac'),
    FORMAT_LINE_SPACING("mdal-format_line_spacing", '\ue2ad'),
    FORMAT_LIST_BULLETED("mdal-format_list_bulleted", '\ue2ae'),
    FORMAT_LIST_NUMBERED("mdal-format_list_numbered", '\ue2af'),
    FORMAT_LIST_NUMBERED_RTL("mdal-format_list_numbered_rtl", '\ue2b0'),
    FORMAT_PAINT("mdal-format_paint", '\ue2b1'),
    FORMAT_QUOTE("mdal-format_quote", '\ue2b3'),
    FORMAT_SHAPES("mdal-format_shapes", '\ue2b5'),
    FORMAT_SIZE("mdal-format_size", '\ue2b7'),
    FORMAT_STRIKETHROUGH("mdal-format_strikethrough", '\ue2b8'),
    FORMAT_TEXTDIRECTION_L_TO_R("mdal-format_textdirection_l_to_r", '\ue2b9'),
    FORMAT_TEXTDIRECTION_R_TO_L("mdal-format_textdirection_r_to_l", '\ue2bb'),
    FORMAT_UNDERLINED("mdal-format_underlined", '\ue2bd'),
    FORUM("mdal-forum", '\ue2be'),
    FORWARD("mdal-forward", '\ue2c0'),
    FORWARD_10("mdal-forward_10", '\ue2c2'),
    FORWARD_30("mdal-forward_30", '\ue2c3'),
    FORWARD_5("mdal-forward_5", '\ue2c4'),
    FORWARD_TO_INBOX("mdal-forward_to_inbox", '\ue7ab'),
    FOUNDATION("mdal-foundation", '\ue872'),
    FREE_BREAKFAST("mdal-free_breakfast", '\ue2c5'),
    FULLSCREEN("mdal-fullscreen", '\ue2c7'),
    FULLSCREEN_EXIT("mdal-fullscreen_exit", '\ue2c8'),
    FUNCTIONS("mdal-functions", '\ue2c9'),
    G_TRANSLATE("mdal-g_translate", '\ue2ca'),
    GAMEPAD("mdal-gamepad", '\ue2cb'),
    GAMES("mdal-games", '\ue2cd'),
    GAVEL("mdal-gavel", '\ue2cf'),
    GESTURE("mdal-gesture", '\ue2d0'),
    GET_APP("mdal-get_app", '\ue2d1'),
    GIF("mdal-gif", '\ue2d3'),
    GOLF_COURSE("mdal-golf_course", '\ue2d5'),
    GPS_FIXED("mdal-gps_fixed", '\ue2d7'),
    GPS_NOT_FIXED("mdal-gps_not_fixed", '\ue2d9'),
    GPS_OFF("mdal-gps_off", '\ue2da'),
    GRADE("mdal-grade", '\ue2db'),
    GRADIENT("mdal-gradient", '\ue2dd'),
    GRADING("mdal-grading", '\ue7ad'),
    GRAIN("mdal-grain", '\ue2de'),
    GRAPHIC_EQ("mdal-graphic_eq", '\ue2df'),
    GRASS("mdal-grass", '\ue874'),
    GREATER_THAN("mdal-greater_than", '\ue2e0'),
    GREATER_THAN_EQUAL("mdal-greater_than_equal", '\ue2e1'),
    GRID_OFF("mdal-grid_off", '\ue2e2'),
    GRID_ON("mdal-grid_on", '\ue2e4'),
    GROUP("mdal-group", '\ue2e6'),
    GROUP_ADD("mdal-group_add", '\ue2e8'),
    GROUP_WORK("mdal-group_work", '\ue2ea'),
    GROUPS("mdal-groups", '\ue8b9'),
    HANDYMAN("mdal-handyman", '\ue7ae'),
    HD("mdal-hd", '\ue2ec'),
    HDR_OFF("mdal-hdr_off", '\ue2ee'),
    HDR_ON("mdal-hdr_on", '\ue2ef'),
    HDR_STRONG("mdal-hdr_strong", '\ue2f0'),
    HDR_WEAK("mdal-hdr_weak", '\ue2f2'),
    HEADSET("mdal-headset", '\ue2f4'),
    HEADSET_MIC("mdal-headset_mic", '\ue2f6'),
    HEALING("mdal-healing", '\ue2f8'),
    HEARING("mdal-hearing", '\ue2fa'),
    HEARING_DISABLED("mdal-hearing_disabled", '\ue7b0'),
    HEIGHT("mdal-height", '\ue2fb'),
    HELP("mdal-help", '\ue2fc'),
    HELP_CENTER("mdal-help_center", '\ue7b1'),
    HELP_OUTLINE("mdal-help_outline", '\ue2fe'),
    HIGH_QUALITY("mdal-high_quality", '\ue2ff'),
    HIGHLIGHT("mdal-highlight", '\ue301'),
    HIGHLIGHT_ALT("mdal-highlight_alt", '\ue7b3'),
    HIGHLIGHT_OFF("mdal-highlight_off", '\ue303'),
    HISTORY("mdal-history", '\ue305'),
    HISTORY_EDU("mdal-history_edu", '\ue7b4'),
    HISTORY_TOGGLE_OFF("mdal-history_toggle_off", '\ue7b6'),
    HOME("mdal-home", '\ue306'),
    HOME_REPAIR_SERVICE("mdal-home_repair_service", '\ue7b7'),
    HOME_WORK("mdal-home_work", '\ue308'),
    HORIZONTAL_DISTRIBUTE("mdal-horizontal_distribute", '\ue8d0'),
    HORIZONTAL_RULE("mdal-horizontal_rule", '\ue7b9'),
    HORIZONTAL_SPLIT("mdal-horizontal_split", '\ue30a'),
    HOT_TUB("mdal-hot_tub", '\ue30c'),
    HOTEL("mdal-hotel", '\ue30d'),
    HOURGLASS_BOTTOM("mdal-hourglass_bottom", '\ue7ba'),
    HOURGLASS_DISABLED("mdal-hourglass_disabled", '\ue7bc'),
    HOURGLASS_EMPTY("mdal-hourglass_empty", '\ue30f'),
    HOURGLASS_FULL("mdal-hourglass_full", '\ue310'),
    HOURGLASS_TOP("mdal-hourglass_top", '\ue7bd'),
    HOUSE("mdal-house", '\ue312'),
    HOUSE_SIDING("mdal-house_siding", '\ue875'),
    HOW_TO_REG("mdal-how_to_reg", '\ue314'),
    HOW_TO_VOTE("mdal-how_to_vote", '\ue316'),
    HTTP("mdal-http", '\ue318'),
    HTTPS("mdal-https", '\ue319'),
    HVAC("mdal-hvac", '\ue7bf'),
    IMAGE("mdal-image", '\ue31b'),
    IMAGE_ASPECT_RATIO("mdal-image_aspect_ratio", '\ue31d'),
    IMAGE_NOT_SUPPORTED("mdal-image_not_supported", '\ue7c1'),
    IMAGE_SEARCH("mdal-image_search", '\ue31f'),
    IMPORT_CONTACTS("mdal-import_contacts", '\ue321'),
    IMPORT_EXPORT("mdal-import_export", '\ue323'),
    IMPORTANT_DEVICES("mdal-important_devices", '\ue324'),
    INBOX("mdal-inbox", '\ue326'),
    INDETERMINATE_CHECK_BOX("mdal-indeterminate_check_box", '\ue328'),
    INFO("mdal-info", '\ue32a'),
    INPUT("mdal-input", '\ue32c'),
    INSERT_CHART("mdal-insert_chart", '\ue32d'),
    INSERT_CHART_OUTLINED("mdal-insert_chart_outlined", '\ue32f'),
    INSERT_COMMENT("mdal-insert_comment", '\ue330'),
    INSERT_DRIVE_FILE("mdal-insert_drive_file", '\ue332'),
    INSERT_EMOTICON("mdal-insert_emoticon", '\ue334'),
    INSERT_INVITATION("mdal-insert_invitation", '\ue336'),
    INSERT_LINK("mdal-insert_link", '\ue338'),
    INSERT_PHOTO("mdal-insert_photo", '\ue339'),
    INSIGHTS("mdal-insights", '\ue7c3'),
    INTEGRATION_INSTRUCTIONS("mdal-integration_instructions", '\ue7c4'),
    INVERT_COLORS("mdal-invert_colors", '\ue33b'),
    INVERT_COLORS_OFF("mdal-invert_colors_off", '\ue33d'),
    ISO("mdal-iso", '\ue33f'),
    KEYBOARD("mdal-keyboard", '\ue341'),
    KEYBOARD_ARROW_DOWN("mdal-keyboard_arrow_down", '\ue343'),
    KEYBOARD_ARROW_LEFT("mdal-keyboard_arrow_left", '\ue344'),
    KEYBOARD_ARROW_RIGHT("mdal-keyboard_arrow_right", '\ue345'),
    KEYBOARD_ARROW_UP("mdal-keyboard_arrow_up", '\ue346'),
    KEYBOARD_BACKSPACE("mdal-keyboard_backspace", '\ue347'),
    KEYBOARD_CAPSLOCK("mdal-keyboard_capslock", '\ue348'),
    KEYBOARD_HIDE("mdal-keyboard_hide", '\ue349'),
    KEYBOARD_RETURN("mdal-keyboard_return", '\ue34b'),
    KEYBOARD_TAB("mdal-keyboard_tab", '\ue34c'),
    KEYBOARD_VOICE("mdal-keyboard_voice", '\ue34d'),
    KING_BED("mdal-king_bed", '\ue34f'),
    KITCHEN("mdal-kitchen", '\ue351'),
    LABEL("mdal-label", '\ue353'),
    LABEL_IMPORTANT("mdal-label_important", '\ue355'),
    LABEL_OFF("mdal-label_off", '\ue357'),
    LANDSCAPE("mdal-landscape", '\ue359'),
    LANGUAGE("mdal-language", '\ue35b'),
    LAPTOP("mdal-laptop", '\ue35d'),
    LAPTOP_CHROMEBOOK("mdal-laptop_chromebook", '\ue35f'),
    LAPTOP_MAC("mdal-laptop_mac", '\ue361'),
    LAPTOP_WINDOWS("mdal-laptop_windows", '\ue363'),
    LAST_PAGE("mdal-last_page", '\ue365'),
    LAUNCH("mdal-launch", '\ue366'),
    LAYERS("mdal-layers", '\ue367'),
    LAYERS_CLEAR("mdal-layers_clear", '\ue369'),
    LEADERBOARD("mdal-leaderboard", '\ue877'),
    LEAK_ADD("mdal-leak_add", '\ue36b'),
    LEAK_REMOVE("mdal-leak_remove", '\ue36c'),
    LEAVE_BAGS_AT_HOME("mdal-leave_bags_at_home", '\ue8a5'),
    LEGEND_TOGGLE("mdal-legend_toggle", '\ue7c6'),
    LENS("mdal-lens", '\ue36d'),
    LESS_THAN("mdal-less_than", '\ue36f'),
    LESS_THAN_EQUAL("mdal-less_than_equal", '\ue370'),
    LIBRARY_ADD("mdal-library_add", '\ue371'),
    LIBRARY_ADD_CHECK("mdal-library_add_check", '\ue746'),
    LIBRARY_BOOKS("mdal-library_books", '\ue373'),
    LIBRARY_MUSIC("mdal-library_music", '\ue375'),
    LIGHTBULB("mdal-lightbulb", '\ue377'),
    LINE_STYLE("mdal-line_style", '\ue379'),
    LINE_WEIGHT("mdal-line_weight", '\ue37a'),
    LINEAR_SCALE("mdal-linear_scale", '\ue37b'),
    LINK("mdal-link", '\ue37c'),
    LINK_OFF("mdal-link_off", '\ue37e'),
    LINKED_CAMERA("mdal-linked_camera", '\ue37f'),
    LIST("mdal-list", '\ue381'),
    LIST_ALT("mdal-list_alt", '\ue382'),
    LIVE_HELP("mdal-live_help", '\ue384'),
    LIVE_TV("mdal-live_tv", '\ue386'),
    LOCAL_ACTIVITY("mdal-local_activity", '\ue388'),
    LOCAL_AIRPORT("mdal-local_airport", '\ue38a'),
    LOCAL_ATM("mdal-local_atm", '\ue38b'),
    LOCAL_BAR("mdal-local_bar", '\ue38d'),
    LOCAL_CAFE("mdal-local_cafe", '\ue38f'),
    LOCAL_CAR_WASH("mdal-local_car_wash", '\ue391'),
    LOCAL_CONVENIENCE_STORE("mdal-local_convenience_store", '\ue393'),
    LOCAL_DINING("mdal-local_dining", '\ue395'),
    LOCAL_DRINK("mdal-local_drink", '\ue396'),
    LOCAL_FIRE_DEPARTMENT("mdal-local_fire_department", '\ue8a7'),
    LOCAL_FLORIST("mdal-local_florist", '\ue398'),
    LOCAL_GAS_STATION("mdal-local_gas_station", '\ue39a'),
    LOCAL_GROCERY_STORE("mdal-local_grocery_store", '\ue39c'),
    LOCAL_HOSPITAL("mdal-local_hospital", '\ue39e'),
    LOCAL_HOTEL("mdal-local_hotel", '\ue3a0'),
    LOCAL_LAUNDRY_SERVICE("mdal-local_laundry_service", '\ue3a2'),
    LOCAL_LIBRARY("mdal-local_library", '\ue3a4'),
    LOCAL_MALL("mdal-local_mall", '\ue3a6'),
    LOCAL_MOVIES("mdal-local_movies", '\ue3a8'),
    LOCAL_OFFER("mdal-local_offer", '\ue3aa'),
    LOCAL_PARKING("mdal-local_parking", '\ue3ac'),
    LOCAL_PHARMACY("mdal-local_pharmacy", '\ue3ad'),
    LOCAL_PHONE("mdal-local_phone", '\ue3af'),
    LOCAL_PIZZA("mdal-local_pizza", '\ue3b1'),
    LOCAL_PLAY("mdal-local_play", '\ue3b3'),
    LOCAL_POLICE("mdal-local_police", '\ue8a9'),
    LOCAL_POST_OFFICE("mdal-local_post_office", '\ue3b5'),
    LOCAL_PRINTSHOP("mdal-local_printshop", '\ue3b7'),
    LOCAL_SEE("mdal-local_see", '\ue3b9'),
    LOCAL_SHIPPING("mdal-local_shipping", '\ue3bb'),
    LOCAL_TAXI("mdal-local_taxi", '\ue3bd'),
    LOCATION_CITY("mdal-location_city", '\ue3bf'),
    LOCATION_DISABLED("mdal-location_disabled", '\ue3c0'),
    LOCATION_OFF("mdal-location_off", '\ue3c1'),
    LOCATION_ON("mdal-location_on", '\ue3c2'),
    LOCATION_SEARCHING("mdal-location_searching", '\ue3c4'),
    LOCK("mdal-lock", '\ue3c5'),
    LOCK_OPEN("mdal-lock_open", '\ue3c7'),
    LOG_IN("mdal-log_in", '\ue3c9'),
    LOG_OUT("mdal-log_out", '\ue3ca'),
    LOGIN("mdal-login", '\ue7c7'),
    LOOKS("mdal-looks", '\ue3cb'),
    LOOKS_3("mdal-looks_3", '\ue3cc'),
    LOOKS_4("mdal-looks_4", '\ue3ce'),
    LOOKS_5("mdal-looks_5", '\ue3d0'),
    LOOKS_6("mdal-looks_6", '\ue3d2'),
    LOOKS_ONE("mdal-looks_one", '\ue3d4'),
    LOOKS_TWO("mdal-looks_two", '\ue3d6'),
    LOOP("mdal-loop", '\ue3d8'),
    LOUPE("mdal-loupe", '\ue3d9'),
    LOW_PRIORITY("mdal-low_priority", '\ue3db'),
    LOYALTY("mdal-loyalty", '\ue3dc'),
    LUGGAGE("mdal-luggage", '\ue8bb');
    
    public static Material2AL findByDescription(String description) {
        for (Material2AL font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2AL(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}