/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2MZ implements Ikon {
    MAIL("mdmz-mail", '\ue3de'),
    MAIL_OUTLINE("mdmz-mail_outline", '\ue3e0'),
    MAP("mdmz-map", '\ue3e1'),
    MAPS_UGC("mdmz-maps_ugc", '\ue7c8'),
    MARK_CHAT_READ("mdmz-mark_chat_read", '\ue7ca'),
    MARK_CHAT_UNREAD("mdmz-mark_chat_unread", '\ue7cc'),
    MARK_EMAIL_READ("mdmz-mark_email_read", '\ue7ce'),
    MARK_EMAIL_UNREAD("mdmz-mark_email_unread", '\ue7d0'),
    MARKUNREAD("mdmz-markunread", '\ue3e3'),
    MARKUNREAD_MAILBOX("mdmz-markunread_mailbox", '\ue3e5'),
    MASKS("mdmz-masks", '\ue8ab'),
    MAXIMIZE("mdmz-maximize", '\ue3e7'),
    MEDIATION("mdmz-mediation", '\ue7d2'),
    MEDICAL_SERVICES("mdmz-medical_services", '\ue7d3'),
    MEETING_ROOM("mdmz-meeting_room", '\ue3e8'),
    MEMORY("mdmz-memory", '\ue3ea'),
    MENU("mdmz-menu", '\ue3ec'),
    MENU_BOOK("mdmz-menu_book", '\ue3ed'),
    MENU_OPEN("mdmz-menu_open", '\ue3ef'),
    MERGE_TYPE("mdmz-merge_type", '\ue3f0'),
    MESSAGE("mdmz-message", '\ue3f1'),
    MIC("mdmz-mic", '\ue3f3'),
    MIC_NONE("mdmz-mic_none", '\ue3f5'),
    MIC_OFF("mdmz-mic_off", '\ue3f7'),
    MICROWAVE("mdmz-microwave", '\ue879'),
    MILITARY_TECH("mdmz-military_tech", '\ue7d5'),
    MINIMIZE("mdmz-minimize", '\ue3f9'),
    MINUS("mdmz-minus", '\ue3fa'),
    MISCELLANEOUS_SERVICES("mdmz-miscellaneous_services", '\ue7d7'),
    MISSED_VIDEO_CALL("mdmz-missed_video_call", '\ue3fb'),
    MMS("mdmz-mms", '\ue3fd'),
    MOBILE_FRIENDLY("mdmz-mobile_friendly", '\ue3ff'),
    MOBILE_OFF("mdmz-mobile_off", '\ue400'),
    MOBILE_SCREEN_SHARE("mdmz-mobile_screen_share", '\ue401'),
    MODE_COMMENT("mdmz-mode_comment", '\ue403'),
    MODEL_TRAINING("mdmz-model_training", '\ue7d8'),
    MONETIZATION_ON("mdmz-monetization_on", '\ue405'),
    MONEY("mdmz-money", '\ue407'),
    MONEY_OFF("mdmz-money_off", '\ue409'),
    MONOCHROME_PHOTOS("mdmz-monochrome_photos", '\ue40a'),
    MOOD("mdmz-mood", '\ue40c'),
    MOOD_BAD("mdmz-mood_bad", '\ue40e'),
    MOPED("mdmz-moped", '\ue7d9'),
    MORE("mdmz-more", '\ue410'),
    MORE_HORIZ("mdmz-more_horiz", '\ue412'),
    MORE_TIME("mdmz-more_time", '\ue7db'),
    MORE_VERT("mdmz-more_vert", '\ue413'),
    MOTION_PHOTOS_ON("mdmz-motion_photos_on", '\ue8ad'),
    MOTION_PHOTOS_PAUSE("mdmz-motion_photos_pause", '\ue8bd'),
    MOTION_PHOTOS_PAUSED("mdmz-motion_photos_paused", '\ue8ae'),
    MOTORCYCLE("mdmz-motorcycle", '\ue414'),
    MOUSE("mdmz-mouse", '\ue416'),
    MOVE_TO_INBOX("mdmz-move_to_inbox", '\ue418'),
    MOVIE("mdmz-movie", '\ue41a'),
    MOVIE_CREATION("mdmz-movie_creation", '\ue41c'),
    MOVIE_FILTER("mdmz-movie_filter", '\ue41e'),
    MULTILINE_CHART("mdmz-multiline_chart", '\ue420'),
    MULTIPLE_STOP("mdmz-multiple_stop", '\ue7dc'),
    MUSEUM("mdmz-museum", '\ue421'),
    MUSIC_NOTE("mdmz-music_note", '\ue423'),
    MUSIC_OFF("mdmz-music_off", '\ue425'),
    MUSIC_VIDEO("mdmz-music_video", '\ue427'),
    MY_LOCATION("mdmz-my_location", '\ue429'),
    NAT("mdmz-nat", '\ue7dd'),
    NATURE("mdmz-nature", '\ue42b'),
    NATURE_PEOPLE("mdmz-nature_people", '\ue42d'),
    NAVIGATE_BEFORE("mdmz-navigate_before", '\ue42f'),
    NAVIGATE_NEXT("mdmz-navigate_next", '\ue430'),
    NAVIGATION("mdmz-navigation", '\ue431'),
    NEAR_ME("mdmz-near_me", '\ue433'),
    NEAR_ME_DISABLED("mdmz-near_me_disabled", '\ue87b'),
    NETWORK_CELL("mdmz-network_cell", '\ue435'),
    NETWORK_CHECK("mdmz-network_check", '\ue437'),
    NETWORK_LOCKED("mdmz-network_locked", '\ue438'),
    NETWORK_WIFI("mdmz-network_wifi", '\ue439'),
    NEW_RELEASES("mdmz-new_releases", '\ue43b'),
    NEXT_PLAN("mdmz-next_plan", '\ue7df'),
    NEXT_WEEK("mdmz-next_week", '\ue43d'),
    NFC("mdmz-nfc", '\ue43f'),
    NIGHT_SHELTER("mdmz-night_shelter", '\ue87d'),
    NIGHTS_STAY("mdmz-nights_stay", '\ue440'),
    NO_BACKPACK("mdmz-no_backpack", '\ue8be'),
    NO_CELL("mdmz-no_cell", '\ue7e1'),
    NO_DRINKS("mdmz-no_drinks", '\ue7e3'),
    NO_ENCRYPTION("mdmz-no_encryption", '\ue442'),
    NO_FLASH("mdmz-no_flash", '\ue7e5'),
    NO_FOOD("mdmz-no_food", '\ue7e7'),
    NO_LUGGAGE("mdmz-no_luggage", '\ue8c0'),
    NO_MEALS("mdmz-no_meals", '\ue87f'),
    NO_MEETING_ROOM("mdmz-no_meeting_room", '\ue444'),
    NO_PHOTOGRAPHY("mdmz-no_photography", '\ue7e9'),
    NO_SIM("mdmz-no_sim", '\ue446'),
    NO_STROLLER("mdmz-no_stroller", '\ue7eb'),
    NO_TRANSFER("mdmz-no_transfer", '\ue880'),
    NORTH("mdmz-north", '\ue882'),
    NORTH_EAST("mdmz-north_east", '\ue883'),
    NORTH_WEST("mdmz-north_west", '\ue884'),
    NOT_ACCESSIBLE("mdmz-not_accessible", '\ue7ed'),
    NOT_EQUAL("mdmz-not_equal", '\ue448'),
    NOT_INTERESTED("mdmz-not_interested", '\ue449'),
    NOT_LISTED_LOCATION("mdmz-not_listed_location", '\ue44a'),
    NOT_STARTED("mdmz-not_started", '\ue7ee'),
    NOTE("mdmz-note", '\ue44c'),
    NOTE_ADD("mdmz-note_add", '\ue44e'),
    NOTES("mdmz-notes", '\ue450'),
    NOTIFICATION_IMPORTANT("mdmz-notification_important", '\ue451'),
    NOTIFICATIONS("mdmz-notifications", '\ue453'),
    NOTIFICATIONS_ACTIVE("mdmz-notifications_active", '\ue455'),
    NOTIFICATIONS_NONE("mdmz-notifications_none", '\ue457'),
    NOTIFICATIONS_OFF("mdmz-notifications_off", '\ue459'),
    NOTIFICATIONS_PAUSED("mdmz-notifications_paused", '\ue45b'),
    OFFLINE_BOLT("mdmz-offline_bolt", '\ue45d'),
    OFFLINE_PIN("mdmz-offline_pin", '\ue45f'),
    ONDEMAND_VIDEO("mdmz-ondemand_video", '\ue461'),
    ONLINE_PREDICTION("mdmz-online_prediction", '\ue7f0'),
    OPACITY("mdmz-opacity", '\ue463'),
    OPEN_IN_BROWSER("mdmz-open_in_browser", '\ue465'),
    OPEN_IN_FULL("mdmz-open_in_full", '\ue7f1'),
    OPEN_IN_NEW("mdmz-open_in_new", '\ue466'),
    OPEN_WITH("mdmz-open_with", '\ue467'),
    OUTBOND("mdmz-outbond", '\ue8c2'),
    OUTDOOR_GRILL("mdmz-outdoor_grill", '\ue468'),
    OUTLET("mdmz-outlet", '\ue7f2'),
    OUTLINED_FLAG("mdmz-outlined_flag", '\ue46a'),
    PAGES("mdmz-pages", '\ue46b'),
    PAGEVIEW("mdmz-pageview", '\ue46d'),
    PALETTE("mdmz-palette", '\ue46f'),
    PAN_TOOL("mdmz-pan_tool", '\ue471'),
    PANORAMA("mdmz-panorama", '\ue473'),
    PANORAMA_FISH_EYE("mdmz-panorama_fish_eye", '\ue475'),
    PANORAMA_HORIZONTAL("mdmz-panorama_horizontal", '\ue477'),
    PANORAMA_VERTICAL("mdmz-panorama_vertical", '\ue479'),
    PANORAMA_WIDE_ANGLE("mdmz-panorama_wide_angle", '\ue47b'),
    PARTY_MODE("mdmz-party_mode", '\ue47d'),
    PAUSE("mdmz-pause", '\ue47f'),
    PAUSE_CIRCLE_FILLED("mdmz-pause_circle_filled", '\ue480'),
    PAUSE_CIRCLE_OUTLINE("mdmz-pause_circle_outline", '\ue482'),
    PAUSE_PRESENTATION("mdmz-pause_presentation", '\ue483'),
    PAYMENT("mdmz-payment", '\ue485'),
    PAYMENTS("mdmz-payments", '\ue7f4'),
    PEDAL_BIKE("mdmz-pedal_bike", '\ue7f6'),
    PENDING("mdmz-pending", '\ue7f7'),
    PENDING_ACTIONS("mdmz-pending_actions", '\ue7f9'),
    PEOPLE("mdmz-people", '\ue487'),
    PEOPLE_ALT("mdmz-people_alt", '\ue489'),
    PEOPLE_OUTLINE("mdmz-people_outline", '\ue48b'),
    PERCENTAGE("mdmz-percentage", '\ue48d'),
    PERM_CAMERA_MIC("mdmz-perm_camera_mic", '\ue48f'),
    PERM_CONTACT_CALENDAR("mdmz-perm_contact_calendar", '\ue491'),
    PERM_DATA_SETTING("mdmz-perm_data_setting", '\ue493'),
    PERM_DEVICE_INFORMATION("mdmz-perm_device_information", '\ue494'),
    PERM_IDENTITY("mdmz-perm_identity", '\ue496'),
    PERM_MEDIA("mdmz-perm_media", '\ue498'),
    PERM_PHONE_MSG("mdmz-perm_phone_msg", '\ue49a'),
    PERM_SCAN_WIFI("mdmz-perm_scan_wifi", '\ue49c'),
    PERSON("mdmz-person", '\ue49e'),
    PERSON_ADD("mdmz-person_add", '\ue4a0'),
    PERSON_ADD_ALT_1("mdmz-person_add_alt_1", '\ue7fb'),
    PERSON_ADD_DISABLED("mdmz-person_add_disabled", '\ue4a2'),
    PERSON_OUTLINE("mdmz-person_outline", '\ue4a4'),
    PERSON_PIN("mdmz-person_pin", '\ue4a6'),
    PERSON_PIN_CIRCLE("mdmz-person_pin_circle", '\ue4a8'),
    PERSON_REMOVE("mdmz-person_remove", '\ue7fd'),
    PERSON_REMOVE_ALT_1("mdmz-person_remove_alt_1", '\ue7ff'),
    PERSON_SEARCH("mdmz-person_search", '\ue801'),
    PERSONAL_VIDEO("mdmz-personal_video", '\ue4aa'),
    PEST_CONTROL("mdmz-pest_control", '\ue803'),
    PEST_CONTROL_RODENT("mdmz-pest_control_rodent", '\ue805'),
    PETS("mdmz-pets", '\ue4ac'),
    PHONE("mdmz-phone", '\ue4ad'),
    PHONE_ANDROID("mdmz-phone_android", '\ue4af'),
    PHONE_BLUETOOTH_SPEAKER("mdmz-phone_bluetooth_speaker", '\ue4b1'),
    PHONE_CALLBACK("mdmz-phone_callback", '\ue4b3'),
    PHONE_DISABLED("mdmz-phone_disabled", '\ue4b5'),
    PHONE_ENABLED("mdmz-phone_enabled", '\ue4b6'),
    PHONE_FORWARDED("mdmz-phone_forwarded", '\ue4b7'),
    PHONE_IN_TALK("mdmz-phone_in_talk", '\ue4b9'),
    PHONE_IPHONE("mdmz-phone_iphone", '\ue4bb'),
    PHONE_LOCKED("mdmz-phone_locked", '\ue4bd'),
    PHONE_MISSED("mdmz-phone_missed", '\ue4bf'),
    PHONE_PAUSED("mdmz-phone_paused", '\ue4c1'),
    PHONELINK("mdmz-phonelink", '\ue4c3'),
    PHONELINK_ERASE("mdmz-phonelink_erase", '\ue4c5'),
    PHONELINK_LOCK("mdmz-phonelink_lock", '\ue4c6'),
    PHONELINK_OFF("mdmz-phonelink_off", '\ue4c7'),
    PHONELINK_RING("mdmz-phonelink_ring", '\ue4c9'),
    PHONELINK_SETUP("mdmz-phonelink_setup", '\ue4cb'),
    PHOTO("mdmz-photo", '\ue4cc'),
    PHOTO_ALBUM("mdmz-photo_album", '\ue4ce'),
    PHOTO_CAMERA("mdmz-photo_camera", '\ue4d0'),
    PHOTO_FILTER("mdmz-photo_filter", '\ue4d2'),
    PHOTO_LIBRARY("mdmz-photo_library", '\ue4d3'),
    PHOTO_SIZE_SELECT_ACTUAL("mdmz-photo_size_select_actual", '\ue4d5'),
    PHOTO_SIZE_SELECT_LARGE("mdmz-photo_size_select_large", '\ue4d7'),
    PHOTO_SIZE_SELECT_SMALL("mdmz-photo_size_select_small", '\ue4d8'),
    PICTURE_AS_PDF("mdmz-picture_as_pdf", '\ue4d9'),
    PICTURE_IN_PICTURE("mdmz-picture_in_picture", '\ue4db'),
    PICTURE_IN_PICTURE_ALT("mdmz-picture_in_picture_alt", '\ue4dd'),
    PIE_CHART("mdmz-pie_chart", '\ue4df'),
    PIN("mdmz-pin", '\ue4e1'),
    PIN_DROP("mdmz-pin_drop", '\ue4e3'),
    PIN_OFF("mdmz-pin_off", '\ue4e5'),
    PLACE("mdmz-place", '\ue4e7'),
    PLAGIARISM("mdmz-plagiarism", '\ue807'),
    PLAY_ARROW("mdmz-play_arrow", '\ue4e9'),
    PLAY_CIRCLE_FILLED("mdmz-play_circle_filled", '\ue4eb'),
    PLAY_CIRCLE_FILLED_WHITE("mdmz-play_circle_filled_white", '\ue4ed'),
    PLAY_CIRCLE_OUTLINE("mdmz-play_circle_outline", '\ue4ef'),
    PLAY_FOR_WORK("mdmz-play_for_work", '\ue4f0'),
    PLAYLIST_ADD("mdmz-playlist_add", '\ue4f1'),
    PLAYLIST_ADD_CHECK("mdmz-playlist_add_check", '\ue4f2'),
    PLAYLIST_PLAY("mdmz-playlist_play", '\ue4f3'),
    PLUMBING("mdmz-plumbing", '\ue809'),
    PLUS("mdmz-plus", '\ue4f4'),
    PLUS_MINUS("mdmz-plus_minus", '\ue4f5'),
    PLUS_MINUS_ALT("mdmz-plus_minus_alt", '\ue4f6'),
    PLUS_ONE("mdmz-plus_one", '\ue4f7'),
    POINT_OF_SALE("mdmz-point_of_sale", '\ue80a'),
    POLICY("mdmz-policy", '\ue4f8'),
    POLL("mdmz-poll", '\ue4fa'),
    POLYMER("mdmz-polymer", '\ue4fc'),
    POOL("mdmz-pool", '\ue4fd'),
    PORTABLE_WIFI_OFF("mdmz-portable_wifi_off", '\ue4ff'),
    PORTRAIT("mdmz-portrait", '\ue500'),
    POST_ADD("mdmz-post_add", '\ue502'),
    POWER("mdmz-power", '\ue503'),
    POWER_INPUT("mdmz-power_input", '\ue505'),
    POWER_OFF("mdmz-power_off", '\ue506'),
    POWER_SETTINGS_NEW("mdmz-power_settings_new", '\ue508'),
    PREGNANT_WOMAN("mdmz-pregnant_woman", '\ue509'),
    PRESENT_TO_ALL("mdmz-present_to_all", '\ue50a'),
    PREVIEW("mdmz-preview", '\ue80c'),
    PRINT("mdmz-print", '\ue50c'),
    PRINT_DISABLED("mdmz-print_disabled", '\ue50e'),
    PRIORITY_HIGH("mdmz-priority_high", '\ue510'),
    PRIVACY_TIP("mdmz-privacy_tip", '\ue80e'),
    PSYCHOLOGY("mdmz-psychology", '\ue810'),
    PUBLIC("mdmz-public", '\ue511'),
    PUBLIC_OFF("mdmz-public_off", '\ue812'),
    PUBLISH("mdmz-publish", '\ue513'),
    PUBLISHED_WITH_CHANGES("mdmz-published_with_changes", '\ue8c4'),
    PUSH_PIN("mdmz-push_pin", '\ue814'),
    QR_CODE("mdmz-qr_code", '\ue816'),
    QR_CODE_2("mdmz-qr_code_2", '\ue8d1'),
    QR_CODE_SCANNER("mdmz-qr_code_scanner", '\ue885'),
    QRCODE("mdmz-qrcode", '\ue515'),
    QUERY_BUILDER("mdmz-query_builder", '\ue517'),
    QUESTION_ANSWER("mdmz-question_answer", '\ue519'),
    QUEUE("mdmz-queue", '\ue51b'),
    QUEUE_MUSIC("mdmz-queue_music", '\ue51d'),
    QUEUE_PLAY_NEXT("mdmz-queue_play_next", '\ue51f'),
    QUICKREPLY("mdmz-quickreply", '\ue818'),
    RADIO("mdmz-radio", '\ue520'),
    RADIO_BUTTON_CHECKED("mdmz-radio_button_checked", '\ue522'),
    RADIO_BUTTON_UNCHECKED("mdmz-radio_button_unchecked", '\ue523'),
    RATE_REVIEW("mdmz-rate_review", '\ue524'),
    READ_MORE("mdmz-read_more", '\ue81a'),
    RECEIPT("mdmz-receipt", '\ue526'),
    RECEIPT_LONG("mdmz-receipt_long", '\ue81b'),
    RECENT_ACTORS("mdmz-recent_actors", '\ue528'),
    RECORD_VOICE_OVER("mdmz-record_voice_over", '\ue52a'),
    REDEEM("mdmz-redeem", '\ue52c'),
    REDO("mdmz-redo", '\ue52e'),
    REDUCE_CAPACITY("mdmz-reduce_capacity", '\ue8af'),
    REFRESH("mdmz-refresh", '\ue52f'),
    REMOVE("mdmz-remove", '\ue530'),
    REMOVE_CIRCLE("mdmz-remove_circle", '\ue531'),
    REMOVE_CIRCLE_OUTLINE("mdmz-remove_circle_outline", '\ue533'),
    REMOVE_FROM_QUEUE("mdmz-remove_from_queue", '\ue534'),
    REMOVE_RED_EYE("mdmz-remove_red_eye", '\ue536'),
    REMOVE_SHOPPING_CART("mdmz-remove_shopping_cart", '\ue538'),
    REORDER("mdmz-reorder", '\ue53a'),
    REPEAT("mdmz-repeat", '\ue53b'),
    REPEAT_ONE("mdmz-repeat_one", '\ue53c'),
    REPLAY("mdmz-replay", '\ue53d'),
    REPLAY_10("mdmz-replay_10", '\ue53e'),
    REPLAY_30("mdmz-replay_30", '\ue53f'),
    REPLAY_5("mdmz-replay_5", '\ue540'),
    REPLY("mdmz-reply", '\ue541'),
    REPLY_ALL("mdmz-reply_all", '\ue542'),
    REPORT("mdmz-report", '\ue543'),
    REPORT_OFF("mdmz-report_off", '\ue545'),
    REPORT_PROBLEM("mdmz-report_problem", '\ue547'),
    REQUEST_PAGE("mdmz-request_page", '\ue8c5'),
    REQUEST_QUOTE("mdmz-request_quote", '\ue81d'),
    RESTAURANT("mdmz-restaurant", '\ue549'),
    RESTAURANT_MENU("mdmz-restaurant_menu", '\ue54a'),
    RESTORE("mdmz-restore", '\ue54b'),
    RESTORE_FROM_TRASH("mdmz-restore_from_trash", '\ue54c'),
    RESTORE_PAGE("mdmz-restore_page", '\ue54e'),
    RICE_BOWL("mdmz-rice_bowl", '\ue886'),
    RING_VOLUME("mdmz-ring_volume", '\ue550'),
    ROCKET("mdmz-rocket", '\ue552'),
    ROOFING("mdmz-roofing", '\ue888'),
    ROOM("mdmz-room", '\ue554'),
    ROOM_PREFERENCES("mdmz-room_preferences", '\ue81f'),
    ROOM_SERVICE("mdmz-room_service", '\ue556'),
    ROTATE_90_DEGREES_CCW("mdmz-rotate_90_degrees_ccw", '\ue558'),
    ROTATE_LEFT("mdmz-rotate_left", '\ue55a'),
    ROTATE_RIGHT("mdmz-rotate_right", '\ue55b'),
    ROUNDED_CORNER("mdmz-rounded_corner", '\ue55c'),
    ROUTER("mdmz-router", '\ue55d'),
    ROWING("mdmz-rowing", '\ue55f'),
    RSS_FEED("mdmz-rss_feed", '\ue560'),
    RULE("mdmz-rule", '\ue821'),
    RULE_FOLDER("mdmz-rule_folder", '\ue822'),
    RUN_CIRCLE("mdmz-run_circle", '\ue824'),
    RV_HOOKUP("mdmz-rv_hookup", '\ue561'),
    SANITIZER("mdmz-sanitizer", '\ue8b0'),
    SATELLITE("mdmz-satellite", '\ue563'),
    SAVE("mdmz-save", '\ue565'),
    SAVE_ALT("mdmz-save_alt", '\ue567'),
    SCANNER("mdmz-scanner", '\ue568'),
    SCATTER_PLOT("mdmz-scatter_plot", '\ue56a'),
    SCHEDULE("mdmz-schedule", '\ue56c'),
    SCHOOL("mdmz-school", '\ue56e'),
    SCIENCE("mdmz-science", '\ue826'),
    SCORE("mdmz-score", '\ue570'),
    SCREEN_LOCK_LANDSCAPE("mdmz-screen_lock_landscape", '\ue572'),
    SCREEN_LOCK_PORTRAIT("mdmz-screen_lock_portrait", '\ue574'),
    SCREEN_LOCK_ROTATION("mdmz-screen_lock_rotation", '\ue576'),
    SCREEN_ROTATION("mdmz-screen_rotation", '\ue577'),
    SCREEN_SHARE("mdmz-screen_share", '\ue579'),
    SD_CARD("mdmz-sd_card", '\ue57b'),
    SD_STORAGE("mdmz-sd_storage", '\ue57d'),
    SEARCH("mdmz-search", '\ue57f'),
    SEARCH_OFF("mdmz-search_off", '\ue828'),
    SECURITY("mdmz-security", '\ue580'),
    SELECT_ALL("mdmz-select_all", '\ue582'),
    SELF_IMPROVEMENT("mdmz-self_improvement", '\ue829'),
    SEND("mdmz-send", '\ue583'),
    SENSOR_DOOR("mdmz-sensor_door", '\ue82a'),
    SENSOR_WINDOW("mdmz-sensor_window", '\ue82c'),
    SENTIMENT_DISSATISFIED("mdmz-sentiment_dissatisfied", '\ue585'),
    SENTIMENT_NEUTRAL("mdmz-sentiment_neutral", '\ue587'),
    SENTIMENT_SATISFIED("mdmz-sentiment_satisfied", '\ue589'),
    SENTIMENT_SATISFIED_ALT("mdmz-sentiment_satisfied_alt", '\ue58b'),
    SENTIMENT_SLIGHTLY_DISSATISFIED("mdmz-sentiment_slightly_dissatisfied", '\ue58d'),
    SENTIMENT_VERY_DISSATISFIED("mdmz-sentiment_very_dissatisfied", '\ue58f'),
    SENTIMENT_VERY_SATISFIED("mdmz-sentiment_very_satisfied", '\ue591'),
    SET_MEAL("mdmz-set_meal", '\ue88a'),
    SETTINGS("mdmz-settings", '\ue593'),
    SETTINGS_APPLICATIONS("mdmz-settings_applications", '\ue595'),
    SETTINGS_BACKUP_RESTORE("mdmz-settings_backup_restore", '\ue597'),
    SETTINGS_BLUETOOTH("mdmz-settings_bluetooth", '\ue598'),
    SETTINGS_BRIGHTNESS("mdmz-settings_brightness", '\ue599'),
    SETTINGS_CELL("mdmz-settings_cell", '\ue59b'),
    SETTINGS_ETHERNET("mdmz-settings_ethernet", '\ue59d'),
    SETTINGS_INPUT_ANTENNA("mdmz-settings_input_antenna", '\ue59e'),
    SETTINGS_INPUT_COMPONENT("mdmz-settings_input_component", '\ue59f'),
    SETTINGS_INPUT_COMPOSITE("mdmz-settings_input_composite", '\ue5a1'),
    SETTINGS_INPUT_HDMI("mdmz-settings_input_hdmi", '\ue5a3'),
    SETTINGS_INPUT_SVIDEO("mdmz-settings_input_svideo", '\ue5a5'),
    SETTINGS_OVERSCAN("mdmz-settings_overscan", '\ue5a7'),
    SETTINGS_PHONE("mdmz-settings_phone", '\ue5a9'),
    SETTINGS_POWER("mdmz-settings_power", '\ue5ab'),
    SETTINGS_REMOTE("mdmz-settings_remote", '\ue5ac'),
    SETTINGS_SYSTEM_DAYDREAM("mdmz-settings_system_daydream", '\ue5ae'),
    SETTINGS_VOICE("mdmz-settings_voice", '\ue5b0'),
    SHARE("mdmz-share", '\ue5b2'),
    SHOP("mdmz-shop", '\ue5b4'),
    SHOP_TWO("mdmz-shop_two", '\ue5b6'),
    SHOPPING_BAG("mdmz-shopping_bag", '\ue82e'),
    SHOPPING_BASKET("mdmz-shopping_basket", '\ue5b8'),
    SHOPPING_CART("mdmz-shopping_cart", '\ue5ba'),
    SHORT_TEXT("mdmz-short_text", '\ue5bc'),
    SHOW_CHART("mdmz-show_chart", '\ue5bd'),
    SHUFFLE("mdmz-shuffle", '\ue5be'),
    SHUTTER_SPEED("mdmz-shutter_speed", '\ue5bf'),
    SICK("mdmz-sick", '\ue8b2'),
    SIGNAL_CELLULAR_0_BAR("mdmz-signal_cellular_0_bar", '\ue5c1'),
    SIGNAL_CELLULAR_1_BAR("mdmz-signal_cellular_1_bar", '\ue5c3'),
    SIGNAL_CELLULAR_2_BAR("mdmz-signal_cellular_2_bar", '\ue5c5'),
    SIGNAL_CELLULAR_3_BAR("mdmz-signal_cellular_3_bar", '\ue5c7'),
    SIGNAL_CELLULAR_4_BAR("mdmz-signal_cellular_4_bar", '\ue5c9'),
    SIGNAL_CELLULAR_ALT("mdmz-signal_cellular_alt", '\ue5ca'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR("mdmz-signal_cellular_connected_no_internet_0_bar", '\ue5cb'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR("mdmz-signal_cellular_connected_no_internet_1_bar", '\ue5cd'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR("mdmz-signal_cellular_connected_no_internet_2_bar", '\ue5cf'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR("mdmz-signal_cellular_connected_no_internet_3_bar", '\ue5d1'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("mdmz-signal_cellular_connected_no_internet_4_bar", '\ue5d3'),
    SIGNAL_CELLULAR_NO_SIM("mdmz-signal_cellular_no_sim", '\ue5d4'),
    SIGNAL_CELLULAR_NULL("mdmz-signal_cellular_null", '\ue5d6'),
    SIGNAL_CELLULAR_OFF("mdmz-signal_cellular_off", '\ue5d7'),
    SIGNAL_WIFI_0_BAR("mdmz-signal_wifi_0_bar", '\ue5d8'),
    SIGNAL_WIFI_1_BAR("mdmz-signal_wifi_1_bar", '\ue5da'),
    SIGNAL_WIFI_1_BAR_LOCK("mdmz-signal_wifi_1_bar_lock", '\ue5dc'),
    SIGNAL_WIFI_2_BAR("mdmz-signal_wifi_2_bar", '\ue5de'),
    SIGNAL_WIFI_2_BAR_LOCK("mdmz-signal_wifi_2_bar_lock", '\ue5e0'),
    SIGNAL_WIFI_3_BAR("mdmz-signal_wifi_3_bar", '\ue5e2'),
    SIGNAL_WIFI_3_BAR_LOCK("mdmz-signal_wifi_3_bar_lock", '\ue5e4'),
    SIGNAL_WIFI_4_BAR("mdmz-signal_wifi_4_bar", '\ue5e6'),
    SIGNAL_WIFI_4_BAR_LOCK("mdmz-signal_wifi_4_bar_lock", '\ue5e7'),
    SIGNAL_WIFI_OFF("mdmz-signal_wifi_off", '\ue5e8'),
    SIM_CARD("mdmz-sim_card", '\ue5e9'),
    SIM_CARD_ALERT("mdmz-sim_card_alert", '\ue5eb'),
    SINGLE_BED("mdmz-single_bed", '\ue5ed'),
    SKIP_NEXT("mdmz-skip_next", '\ue5ef'),
    SKIP_PREVIOUS("mdmz-skip_previous", '\ue5f1'),
    SLIDESHOW("mdmz-slideshow", '\ue5f3'),
    SLOW_MOTION_VIDEO("mdmz-slow_motion_video", '\ue5f5'),
    SMART_BUTTON("mdmz-smart_button", '\ue830'),
    SMARTPHONE("mdmz-smartphone", '\ue5f6'),
    SMOKE_FREE("mdmz-smoke_free", '\ue5f8'),
    SMOKING_ROOMS("mdmz-smoking_rooms", '\ue5f9'),
    SMS("mdmz-sms", '\ue5fb'),
    SMS_FAILED("mdmz-sms_failed", '\ue5fd'),
    SNIPPET_FOLDER("mdmz-snippet_folder", '\ue831'),
    SNOOZE("mdmz-snooze", '\ue5ff'),
    SOAP("mdmz-soap", '\ue833'),
    SORT("mdmz-sort", '\ue600'),
    SORT_BY_ALPHA("mdmz-sort_by_alpha", '\ue601'),
    SOURCE("mdmz-source", '\ue835'),
    SOUTH("mdmz-south", '\ue88c'),
    SOUTH_EAST("mdmz-south_east", '\ue88d'),
    SOUTH_WEST("mdmz-south_west", '\ue88e'),
    SPA("mdmz-spa", '\ue602'),
    SPACE_BAR("mdmz-space_bar", '\ue604'),
    SPEAKER("mdmz-speaker", '\ue605'),
    SPEAKER_GROUP("mdmz-speaker_group", '\ue607'),
    SPEAKER_NOTES("mdmz-speaker_notes", '\ue609'),
    SPEAKER_NOTES_OFF("mdmz-speaker_notes_off", '\ue60b'),
    SPEAKER_PHONE("mdmz-speaker_phone", '\ue60d'),
    SPEED("mdmz-speed", '\ue60f'),
    SPELLCHECK("mdmz-spellcheck", '\ue610'),
    SPORTS("mdmz-sports", '\ue611'),
    SPORTS_BAR("mdmz-sports_bar", '\ue88f'),
    SPORTS_BASEBALL("mdmz-sports_baseball", '\ue612'),
    SPORTS_BASKETBALL("mdmz-sports_basketball", '\ue614'),
    SPORTS_CRICKET("mdmz-sports_cricket", '\ue616'),
    SPORTS_ESPORTS("mdmz-sports_esports", '\ue618'),
    SPORTS_FOOTBALL("mdmz-sports_football", '\ue61a'),
    SPORTS_GOLF("mdmz-sports_golf", '\ue61c'),
    SPORTS_HANDBALL("mdmz-sports_handball", '\ue61e'),
    SPORTS_HOCKEY("mdmz-sports_hockey", '\ue61f'),
    SPORTS_KABADDI("mdmz-sports_kabaddi", '\ue620'),
    SPORTS_MMA("mdmz-sports_mma", '\ue621'),
    SPORTS_MOTORSPORTS("mdmz-sports_motorsports", '\ue623'),
    SPORTS_RUGBY("mdmz-sports_rugby", '\ue625'),
    SPORTS_SOCCER("mdmz-sports_soccer", '\ue627'),
    SPORTS_TENNIS("mdmz-sports_tennis", '\ue629'),
    SPORTS_VOLLEYBALL("mdmz-sports_volleyball", '\ue62a'),
    SQUARE_FOOT("mdmz-square_foot", '\ue62c'),
    STACKED_LINE_CHART("mdmz-stacked_line_chart", '\ue8c7'),
    STAIRS("mdmz-stairs", '\ue837'),
    STAR("mdmz-star", '\ue62e'),
    STAR_BORDER("mdmz-star_border", '\ue630'),
    STAR_HALF("mdmz-star_half", '\ue631'),
    STAR_OUTLINE("mdmz-star_outline", '\ue748'),
    STAR_RATE("mdmz-star_rate", '\ue632'),
    STARS("mdmz-stars", '\ue633'),
    STAY_CURRENT_LANDSCAPE("mdmz-stay_current_landscape", '\ue635'),
    STAY_CURRENT_PORTRAIT("mdmz-stay_current_portrait", '\ue637'),
    STAY_PRIMARY_LANDSCAPE("mdmz-stay_primary_landscape", '\ue639'),
    STAY_PRIMARY_PORTRAIT("mdmz-stay_primary_portrait", '\ue63b'),
    STICKY_NOTE_2("mdmz-sticky_note_2", '\ue891'),
    STOP("mdmz-stop", '\ue63d'),
    STOP_CIRCLE("mdmz-stop_circle", '\ue63f'),
    STOP_SCREEN_SHARE("mdmz-stop_screen_share", '\ue641'),
    STORAGE("mdmz-storage", '\ue643'),
    STORE("mdmz-store", '\ue644'),
    STORE_MALL_DIRECTORY("mdmz-store_mall_directory", '\ue646'),
    STOREFRONT("mdmz-storefront", '\ue648'),
    STRAIGHTEN("mdmz-straighten", '\ue64a'),
    STREETVIEW("mdmz-streetview", '\ue64c'),
    STRIKETHROUGH_S("mdmz-strikethrough_s", '\ue64d'),
    STROLLER("mdmz-stroller", '\ue839'),
    STYLE("mdmz-style", '\ue64e'),
    SUBDIRECTORY_ARROW_LEFT("mdmz-subdirectory_arrow_left", '\ue650'),
    SUBDIRECTORY_ARROW_RIGHT("mdmz-subdirectory_arrow_right", '\ue651'),
    SUBJECT("mdmz-subject", '\ue652'),
    SUBSCRIPT("mdmz-subscript", '\ue83b'),
    SUBSCRIPTIONS("mdmz-subscriptions", '\ue653'),
    SUBTITLES("mdmz-subtitles", '\ue655'),
    SUBTITLES_OFF("mdmz-subtitles_off", '\ue83c'),
    SUBWAY("mdmz-subway", '\ue657'),
    SUPERSCRIPT("mdmz-superscript", '\ue83e'),
    SUPERVISED_USER_CIRCLE("mdmz-supervised_user_circle", '\ue659'),
    SUPERVISOR_ACCOUNT("mdmz-supervisor_account", '\ue65b'),
    SUPPORT("mdmz-support", '\ue83f'),
    SUPPORT_AGENT("mdmz-support_agent", '\ue841'),
    SURROUND_SOUND("mdmz-surround_sound", '\ue65d'),
    SWAP_CALLS("mdmz-swap_calls", '\ue65f'),
    SWAP_HORIZ("mdmz-swap_horiz", '\ue660'),
    SWAP_HORIZONTAL_CIRCLE("mdmz-swap_horizontal_circle", '\ue661'),
    SWAP_VERT("mdmz-swap_vert", '\ue663'),
    SWAP_VERTICAL_CIRCLE("mdmz-swap_vertical_circle", '\ue664'),
    SWITCH_CAMERA("mdmz-switch_camera", '\ue666'),
    SWITCH_LEFT("mdmz-switch_left", '\ue842'),
    SWITCH_RIGHT("mdmz-switch_right", '\ue844'),
    SWITCH_VIDEO("mdmz-switch_video", '\ue668'),
    SYNC("mdmz-sync", '\ue66a'),
    SYNC_ALT("mdmz-sync_alt", '\ue66b'),
    SYNC_DISABLED("mdmz-sync_disabled", '\ue66c'),
    SYNC_PROBLEM("mdmz-sync_problem", '\ue66d'),
    SYSTEM_UPDATE("mdmz-system_update", '\ue66e'),
    SYSTEM_UPDATE_ALT("mdmz-system_update_alt", '\ue670'),
    TAB("mdmz-tab", '\ue671'),
    TAB_UNSELECTED("mdmz-tab_unselected", '\ue672'),
    TABLE_CHART("mdmz-table_chart", '\ue673'),
    TABLE_ROWS("mdmz-table_rows", '\ue846'),
    TABLE_VIEW("mdmz-table_view", '\ue848'),
    TABLET("mdmz-tablet", '\ue675'),
    TABLET_ANDROID("mdmz-tablet_android", '\ue677'),
    TABLET_MAC("mdmz-tablet_mac", '\ue679'),
    TAG_FACES("mdmz-tag_faces", '\ue67b'),
    TAP_AND_PLAY("mdmz-tap_and_play", '\ue67d'),
    TAPAS("mdmz-tapas", '\ue893'),
    TERRAIN("mdmz-terrain", '\ue67e'),
    TEXT_FIELDS("mdmz-text_fields", '\ue680'),
    TEXT_FORMAT("mdmz-text_format", '\ue681'),
    TEXT_ROTATE_UP("mdmz-text_rotate_up", '\ue682'),
    TEXT_ROTATE_VERTICAL("mdmz-text_rotate_vertical", '\ue683'),
    TEXT_ROTATION_ANGLEDOWN("mdmz-text_rotation_angledown", '\ue684'),
    TEXT_ROTATION_ANGLEUP("mdmz-text_rotation_angleup", '\ue685'),
    TEXT_ROTATION_DOWN("mdmz-text_rotation_down", '\ue686'),
    TEXT_ROTATION_NONE("mdmz-text_rotation_none", '\ue687'),
    TEXT_SNIPPET("mdmz-text_snippet", '\ue84a'),
    TEXTSMS("mdmz-textsms", '\ue688'),
    TEXTURE("mdmz-texture", '\ue68a'),
    THEATERS("mdmz-theaters", '\ue68b'),
    THUMB_DOWN("mdmz-thumb_down", '\ue68d'),
    THUMB_DOWN_ALT("mdmz-thumb_down_alt", '\ue68f'),
    THUMB_UP("mdmz-thumb_up", '\ue691'),
    THUMB_UP_ALT("mdmz-thumb_up_alt", '\ue693'),
    THUMBS_UP_DOWN("mdmz-thumbs_up_down", '\ue695'),
    TIME_TO_LEAVE("mdmz-time_to_leave", '\ue697'),
    TIMELAPSE("mdmz-timelapse", '\ue699'),
    TIMELINE("mdmz-timeline", '\ue69b'),
    TIMER("mdmz-timer", '\ue69c'),
    TIMER_10("mdmz-timer_10", '\ue69e'),
    TIMER_3("mdmz-timer_3", '\ue69f'),
    TIMER_OFF("mdmz-timer_off", '\ue6a0'),
    TITLE("mdmz-title", '\ue6a2'),
    TOC("mdmz-toc", '\ue6a3'),
    TODAY("mdmz-today", '\ue6a4'),
    TOGGLE_OFF("mdmz-toggle_off", '\ue6a6'),
    TOGGLE_ON("mdmz-toggle_on", '\ue6a8'),
    TOLL("mdmz-toll", '\ue6aa'),
    TONALITY("mdmz-tonality", '\ue6ac'),
    TOPIC("mdmz-topic", '\ue84c'),
    TOUCH_APP("mdmz-touch_app", '\ue6ae'),
    TOUR("mdmz-tour", '\ue84e'),
    TOYS("mdmz-toys", '\ue6b0'),
    TRACK_CHANGES("mdmz-track_changes", '\ue6b2'),
    TRAFFIC("mdmz-traffic", '\ue6b3'),
    TRAIN("mdmz-train", '\ue6b5'),
    TRAM("mdmz-tram", '\ue6b7'),
    TRANSFER_WITHIN_A_STATION("mdmz-transfer_within_a_station", '\ue6b9'),
    TRANSFORM("mdmz-transform", '\ue6ba'),
    TRANSIT_ENTEREXIT("mdmz-transit_enterexit", '\ue6bb'),
    TRANSLATE("mdmz-translate", '\ue6bc'),
    TRENDING_DOWN("mdmz-trending_down", '\ue6bd'),
    TRENDING_FLAT("mdmz-trending_flat", '\ue6be'),
    TRENDING_UP("mdmz-trending_up", '\ue6bf'),
    TRIP_ORIGIN("mdmz-trip_origin", '\ue6c0'),
    TTY("mdmz-tty", '\ue850'),
    TUNE("mdmz-tune", '\ue6c1'),
    TURNED_IN("mdmz-turned_in", '\ue6c2'),
    TURNED_IN_NOT("mdmz-turned_in_not", '\ue6c4'),
    TV("mdmz-tv", '\ue6c5'),
    TV_OFF("mdmz-tv_off", '\ue6c7'),
    TWO_WHEELER("mdmz-two_wheeler", '\ue749'),
    UMBRELLA("mdmz-umbrella", '\ue852'),
    UNARCHIVE("mdmz-unarchive", '\ue6c9'),
    UNDO("mdmz-undo", '\ue6cb'),
    UNFOLD_LESS("mdmz-unfold_less", '\ue6cc'),
    UNFOLD_MORE("mdmz-unfold_more", '\ue6cd'),
    UNPUBLISHED("mdmz-unpublished", '\ue8c8'),
    UNSUBSCRIBE("mdmz-unsubscribe", '\ue6ce'),
    UPDATE("mdmz-update", '\ue6d0'),
    UPDATE_DISABLED("mdmz-update_disabled", '\ue8d2'),
    UPGRADE("mdmz-upgrade", '\ue854'),
    USB("mdmz-usb", '\ue6d1'),
    VERIFIED("mdmz-verified", '\ue855'),
    VERIFIED_USER("mdmz-verified_user", '\ue6d2'),
    VERTICAL_ALIGN_BOTTOM("mdmz-vertical_align_bottom", '\ue6d4'),
    VERTICAL_ALIGN_CENTER("mdmz-vertical_align_center", '\ue6d5'),
    VERTICAL_ALIGN_TOP("mdmz-vertical_align_top", '\ue6d6'),
    VERTICAL_DISTRIBUTE("mdmz-vertical_distribute", '\ue8d3'),
    VERTICAL_SPLIT("mdmz-vertical_split", '\ue6d7'),
    VIBRATION("mdmz-vibration", '\ue6d9'),
    VIDEO_CALL("mdmz-video_call", '\ue6db'),
    VIDEO_LABEL("mdmz-video_label", '\ue6dd'),
    VIDEO_LIBRARY("mdmz-video_library", '\ue6df'),
    VIDEO_SETTINGS("mdmz-video_settings", '\ue857'),
    VIDEOCAM("mdmz-videocam", '\ue6e1'),
    VIDEOCAM_OFF("mdmz-videocam_off", '\ue6e3'),
    VIDEOGAME_ASSET("mdmz-videogame_asset", '\ue6e5'),
    VIEW_AGENDA("mdmz-view_agenda", '\ue6e7'),
    VIEW_ARRAY("mdmz-view_array", '\ue6e9'),
    VIEW_CAROUSEL("mdmz-view_carousel", '\ue6eb'),
    VIEW_COLUMN("mdmz-view_column", '\ue6ed'),
    VIEW_COMFY("mdmz-view_comfy", '\ue6ef'),
    VIEW_COMPACT("mdmz-view_compact", '\ue6f1'),
    VIEW_DAY("mdmz-view_day", '\ue6f3'),
    VIEW_HEADLINE("mdmz-view_headline", '\ue6f5'),
    VIEW_LIST("mdmz-view_list", '\ue6f6'),
    VIEW_MODULE("mdmz-view_module", '\ue6f8'),
    VIEW_QUILT("mdmz-view_quilt", '\ue6fa'),
    VIEW_SIDEBAR("mdmz-view_sidebar", '\ue858'),
    VIEW_STREAM("mdmz-view_stream", '\ue6fc'),
    VIEW_WEEK("mdmz-view_week", '\ue6fe'),
    VIGNETTE("mdmz-vignette", '\ue700'),
    VISIBILITY("mdmz-visibility", '\ue702'),
    VISIBILITY_OFF("mdmz-visibility_off", '\ue704'),
    VOICE_CHAT("mdmz-voice_chat", '\ue706'),
    VOICE_OVER_OFF("mdmz-voice_over_off", '\ue708'),
    VOICEMAIL("mdmz-voicemail", '\ue70a'),
    VOLUME_DOWN("mdmz-volume_down", '\ue70b'),
    VOLUME_MUTE("mdmz-volume_mute", '\ue70d'),
    VOLUME_OFF("mdmz-volume_off", '\ue70f'),
    VOLUME_UP("mdmz-volume_up", '\ue711'),
    VPN_KEY("mdmz-vpn_key", '\ue713'),
    VPN_LOCK("mdmz-vpn_lock", '\ue715'),
    WALLPAPER("mdmz-wallpaper", '\ue717'),
    WARNING("mdmz-warning", '\ue718'),
    WASH("mdmz-wash", '\ue85a'),
    WATCH("mdmz-watch", '\ue71a'),
    WATCH_LATER("mdmz-watch_later", '\ue71c'),
    WATER_DAMAGE("mdmz-water_damage", '\ue895'),
    WAVES("mdmz-waves", '\ue71e'),
    WB_AUTO("mdmz-wb_auto", '\ue71f'),
    WB_CLOUDY("mdmz-wb_cloudy", '\ue721'),
    WB_INCANDESCENT("mdmz-wb_incandescent", '\ue723'),
    WB_IRIDESCENT("mdmz-wb_iridescent", '\ue725'),
    WB_SUNNY("mdmz-wb_sunny", '\ue727'),
    WC("mdmz-wc", '\ue729'),
    WEB("mdmz-web", '\ue72a'),
    WEB_ASSET("mdmz-web_asset", '\ue72c'),
    WEEKEND("mdmz-weekend", '\ue72e'),
    WEST("mdmz-west", '\ue897'),
    WHATSHOT("mdmz-whatshot", '\ue730'),
    WHEELCHAIR_PICKUP("mdmz-wheelchair_pickup", '\ue85c'),
    WHERE_TO_VOTE("mdmz-where_to_vote", '\ue732'),
    WIDGETS("mdmz-widgets", '\ue734'),
    WIFI("mdmz-wifi", '\ue736'),
    WIFI_CALLING("mdmz-wifi_calling", '\ue85d'),
    WIFI_LOCK("mdmz-wifi_lock", '\ue737'),
    WIFI_OFF("mdmz-wifi_off", '\ue738'),
    WIFI_PROTECTED_SETUP("mdmz-wifi_protected_setup", '\ue85f'),
    WIFI_TETHERING("mdmz-wifi_tethering", '\ue739'),
    WINE_BAR("mdmz-wine_bar", '\ue898'),
    WORK("mdmz-work", '\ue73a'),
    WORK_OFF("mdmz-work_off", '\ue73c'),
    WORK_OUTLINE("mdmz-work_outline", '\ue73e'),
    WRAP_TEXT("mdmz-wrap_text", '\ue73f'),
    WRONG_LOCATION("mdmz-wrong_location", '\ue860'),
    WYSIWYG("mdmz-wysiwyg", '\ue861'),
    YOUTUBE_SEARCHED_FOR("mdmz-youtube_searched_for", '\ue740'),
    ZOOM_IN("mdmz-zoom_in", '\ue741'),
    ZOOM_OUT("mdmz-zoom_out", '\ue742'),
    ZOOM_OUT_MAP("mdmz-zoom_out_map", '\ue743');
    
    public static Material2MZ findByDescription(String description) {
        for (Material2MZ font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2MZ(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}