/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2OutlinedAL implements Ikon {
    MDOAL_360("mdoal-360", '\ue000'),
    MDOAL_3D_ROTATION("mdoal-3d_rotation", '\ue001'),
    MDOAL_4K("mdoal-4k", '\ue002'),
    MDOAL_5G("mdoal-5g", '\ue74a'),
    MDOAL_6_FT_APART("mdoal-6_ft_apart", '\ue89a'),
    AC_UNIT("mdoal-ac_unit", '\ue004'),
    ACCESS_ALARM("mdoal-access_alarm", '\ue005'),
    ACCESS_ALARMS("mdoal-access_alarms", '\ue007'),
    ACCESS_TIME("mdoal-access_time", '\ue009'),
    ACCESSIBILITY("mdoal-accessibility", '\ue00b'),
    ACCESSIBILITY_NEW("mdoal-accessibility_new", '\ue00c'),
    ACCESSIBLE("mdoal-accessible", '\ue00d'),
    ACCESSIBLE_FORWARD("mdoal-accessible_forward", '\ue00e'),
    ACCOUNT_BALANCE("mdoal-account_balance", '\ue00f'),
    ACCOUNT_BALANCE_WALLET("mdoal-account_balance_wallet", '\ue011'),
    ACCOUNT_BOX("mdoal-account_box", '\ue013'),
    ACCOUNT_CIRCLE("mdoal-account_circle", '\ue015'),
    ACCOUNT_TREE("mdoal-account_tree", '\ue017'),
    AD_UNITS("mdoal-ad_units", '\ue74b'),
    ADB("mdoal-adb", '\ue019'),
    ADD("mdoal-add", '\ue01a'),
    ADD_A_PHOTO("mdoal-add_a_photo", '\ue01b'),
    ADD_ALARM("mdoal-add_alarm", '\ue01d'),
    ADD_ALERT("mdoal-add_alert", '\ue01f'),
    ADD_BOX("mdoal-add_box", '\ue021'),
    ADD_BUSINESS("mdoal-add_business", '\ue74d'),
    ADD_CIRCLE("mdoal-add_circle", '\ue023'),
    ADD_CIRCLE_OUTLINE("mdoal-add_circle_outline", '\ue025'),
    ADD_COMMENT("mdoal-add_comment", '\ue026'),
    ADD_IC_CALL("mdoal-add_ic_call", '\ue744'),
    ADD_LOCATION("mdoal-add_location", '\ue028'),
    ADD_LOCATION_ALT("mdoal-add_location_alt", '\ue74f'),
    ADD_PHOTO_ALTERNATE("mdoal-add_photo_alternate", '\ue02a'),
    ADD_ROAD("mdoal-add_road", '\ue751'),
    ADD_SHOPPING_CART("mdoal-add_shopping_cart", '\ue02c'),
    ADD_TASK("mdoal-add_task", '\ue8b3'),
    ADD_TO_HOME_SCREEN("mdoal-add_to_home_screen", '\ue02d'),
    ADD_TO_PHOTOS("mdoal-add_to_photos", '\ue02e'),
    ADD_TO_QUEUE("mdoal-add_to_queue", '\ue030'),
    ADDCHART("mdoal-addchart", '\ue752'),
    ADJUST("mdoal-adjust", '\ue032'),
    ADMIN_PANEL_SETTINGS("mdoal-admin_panel_settings", '\ue753'),
    AGRICULTURE("mdoal-agriculture", '\ue755'),
    AIRLINE_SEAT_FLAT("mdoal-airline_seat_flat", '\ue033'),
    AIRLINE_SEAT_FLAT_ANGLED("mdoal-airline_seat_flat_angled", '\ue035'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("mdoal-airline_seat_individual_suite", '\ue037'),
    AIRLINE_SEAT_LEGROOM_EXTRA("mdoal-airline_seat_legroom_extra", '\ue039'),
    AIRLINE_SEAT_LEGROOM_NORMAL("mdoal-airline_seat_legroom_normal", '\ue03a'),
    AIRLINE_SEAT_LEGROOM_REDUCED("mdoal-airline_seat_legroom_reduced", '\ue03b'),
    AIRLINE_SEAT_RECLINE_EXTRA("mdoal-airline_seat_recline_extra", '\ue03c'),
    AIRLINE_SEAT_RECLINE_NORMAL("mdoal-airline_seat_recline_normal", '\ue03d'),
    AIRPLANEMODE_ACTIVE("mdoal-airplanemode_active", '\ue03e'),
    AIRPLANEMODE_INACTIVE("mdoal-airplanemode_inactive", '\ue03f'),
    AIRPLAY("mdoal-airplay", '\ue040'),
    AIRPORT_SHUTTLE("mdoal-airport_shuttle", '\ue041'),
    ALARM("mdoal-alarm", '\ue043'),
    ALARM_ADD("mdoal-alarm_add", '\ue045'),
    ALARM_OFF("mdoal-alarm_off", '\ue047'),
    ALARM_ON("mdoal-alarm_on", '\ue048'),
    ALBUM("mdoal-album", '\ue04a'),
    ALIGN_HORIZONTAL_CENTER("mdoal-align_horizontal_center", '\ue8ca'),
    ALIGN_HORIZONTAL_LEFT("mdoal-align_horizontal_left", '\ue8cb'),
    ALIGN_HORIZONTAL_RIGHT("mdoal-align_horizontal_right", '\ue8cc'),
    ALIGN_VERTICAL_BOTTOM("mdoal-align_vertical_bottom", '\ue8cd'),
    ALIGN_VERTICAL_CENTER("mdoal-align_vertical_center", '\ue8ce'),
    ALIGN_VERTICAL_TOP("mdoal-align_vertical_top", '\ue8cf'),
    ALL_INBOX("mdoal-all_inbox", '\ue04c'),
    ALL_INCLUSIVE("mdoal-all_inclusive", '\ue04e'),
    ALL_OUT("mdoal-all_out", '\ue04f'),
    ALT_ROUTE("mdoal-alt_route", '\ue757'),
    ALTERNATE_EMAIL("mdoal-alternate_email", '\ue051'),
    AMP_STORIES("mdoal-amp_stories", '\ue053'),
    ANALYTICS("mdoal-analytics", '\ue758'),
    ANCHOR("mdoal-anchor", '\ue75a'),
    ANDROID("mdoal-android", '\ue055'),
    ANNOUNCEMENT("mdoal-announcement", '\ue056'),
    APARTMENT("mdoal-apartment", '\ue058'),
    API("mdoal-api", '\ue75b'),
    APP_BLOCKING("mdoal-app_blocking", '\ue75c'),
    APP_SETTINGS_ALT("mdoal-app_settings_alt", '\ue75e'),
    APPS("mdoal-apps", '\ue059'),
    ARCHITECTURE("mdoal-architecture", '\ue760'),
    ARCHIVE("mdoal-archive", '\ue05a'),
    ARROW_BACK("mdoal-arrow_back", '\ue05c'),
    ARROW_BACK_IOS("mdoal-arrow_back_ios", '\ue05d'),
    ARROW_CIRCLE_DOWN("mdoal-arrow_circle_down", '\ue761'),
    ARROW_CIRCLE_UP("mdoal-arrow_circle_up", '\ue763'),
    ARROW_DOWNWARD("mdoal-arrow_downward", '\ue05e'),
    ARROW_DROP_DOWN("mdoal-arrow_drop_down", '\ue05f'),
    ARROW_DROP_DOWN_CIRCLE("mdoal-arrow_drop_down_circle", '\ue060'),
    ARROW_DROP_UP("mdoal-arrow_drop_up", '\ue062'),
    ARROW_FORWARD("mdoal-arrow_forward", '\ue063'),
    ARROW_FORWARD_IOS("mdoal-arrow_forward_ios", '\ue064'),
    ARROW_LEFT("mdoal-arrow_left", '\ue065'),
    ARROW_RIGHT("mdoal-arrow_right", '\ue066'),
    ARROW_RIGHT_ALT("mdoal-arrow_right_alt", '\ue067'),
    ARROW_UPWARD("mdoal-arrow_upward", '\ue068'),
    ART_TRACK("mdoal-art_track", '\ue069'),
    ARTICLE("mdoal-article", '\ue765'),
    ASPECT_RATIO("mdoal-aspect_ratio", '\ue06a'),
    ASSESSMENT("mdoal-assessment", '\ue06c'),
    ASSIGNMENT("mdoal-assignment", '\ue06e'),
    ASSIGNMENT_IND("mdoal-assignment_ind", '\ue070'),
    ASSIGNMENT_LATE("mdoal-assignment_late", '\ue072'),
    ASSIGNMENT_RETURN("mdoal-assignment_return", '\ue074'),
    ASSIGNMENT_RETURNED("mdoal-assignment_returned", '\ue076'),
    ASSIGNMENT_TURNED_IN("mdoal-assignment_turned_in", '\ue078'),
    ASSISTANT("mdoal-assistant", '\ue07a'),
    ASSISTANT_PHOTO("mdoal-assistant_photo", '\ue07c'),
    ATM("mdoal-atm", '\ue07e'),
    ATTACH_EMAIL("mdoal-attach_email", '\ue767'),
    ATTACH_FILE("mdoal-attach_file", '\ue07f'),
    ATTACH_MONEY("mdoal-attach_money", '\ue080'),
    ATTACHMENT("mdoal-attachment", '\ue081'),
    AUDIOTRACK("mdoal-audiotrack", '\ue082'),
    AUTO_DELETE("mdoal-auto_delete", '\ue768'),
    AUTORENEW("mdoal-autorenew", '\ue084'),
    AV_TIMER("mdoal-av_timer", '\ue085'),
    BABY_CHANGING_STATION("mdoal-baby_changing_station", '\ue76a'),
    BACKPACK("mdoal-backpack", '\ue76b'),
    BACKSPACE("mdoal-backspace", '\ue086'),
    BACKUP("mdoal-backup", '\ue088'),
    BACKUP_TABLE("mdoal-backup_table", '\ue76d'),
    BALLOT("mdoal-ballot", '\ue08a'),
    BAR_CHART("mdoal-bar_chart", '\ue08c'),
    BARCODE("mdoal-barcode", '\ue08d'),
    BATCH_PREDICTION("mdoal-batch_prediction", '\ue76f'),
    BATHTUB("mdoal-bathtub", '\ue08e'),
    BATTERY_20("mdoal-battery_20", '\ue090'),
    BATTERY_30("mdoal-battery_30", '\ue092'),
    BATTERY_50("mdoal-battery_50", '\ue094'),
    BATTERY_60("mdoal-battery_60", '\ue096'),
    BATTERY_80("mdoal-battery_80", '\ue098'),
    BATTERY_90("mdoal-battery_90", '\ue09a'),
    BATTERY_ALERT("mdoal-battery_alert", '\ue09c'),
    BATTERY_CHARGING_20("mdoal-battery_charging_20", '\ue09d'),
    BATTERY_CHARGING_30("mdoal-battery_charging_30", '\ue09f'),
    BATTERY_CHARGING_50("mdoal-battery_charging_50", '\ue0a1'),
    BATTERY_CHARGING_60("mdoal-battery_charging_60", '\ue0a3'),
    BATTERY_CHARGING_80("mdoal-battery_charging_80", '\ue0a5'),
    BATTERY_CHARGING_90("mdoal-battery_charging_90", '\ue0a7'),
    BATTERY_CHARGING_FULL("mdoal-battery_charging_full", '\ue0a9'),
    BATTERY_FULL("mdoal-battery_full", '\ue0aa'),
    BATTERY_STD("mdoal-battery_std", '\ue0ab'),
    BATTERY_UNKNOWN("mdoal-battery_unknown", '\ue0ac'),
    BEACH_ACCESS("mdoal-beach_access", '\ue0ad'),
    BEDTIME("mdoal-bedtime", '\ue771'),
    BEENHERE("mdoal-beenhere", '\ue0af'),
    BENTO("mdoal-bento", '\ue864'),
    BIKE_SCOOTER("mdoal-bike_scooter", '\ue773'),
    BIOTECH("mdoal-biotech", '\ue774'),
    BLOCK("mdoal-block", '\ue0b1'),
    BLUETOOTH("mdoal-bluetooth", '\ue0b2'),
    BLUETOOTH_AUDIO("mdoal-bluetooth_audio", '\ue0b3'),
    BLUETOOTH_CONNECTED("mdoal-bluetooth_connected", '\ue0b4'),
    BLUETOOTH_DISABLED("mdoal-bluetooth_disabled", '\ue0b5'),
    BLUETOOTH_SEARCHING("mdoal-bluetooth_searching", '\ue0b6'),
    BLUR_CIRCULAR("mdoal-blur_circular", '\ue0b7'),
    BLUR_LINEAR("mdoal-blur_linear", '\ue0b8'),
    BLUR_OFF("mdoal-blur_off", '\ue0b9'),
    BLUR_ON("mdoal-blur_on", '\ue0ba'),
    BOOK("mdoal-book", '\ue0bb'),
    BOOK_ONLINE("mdoal-book_online", '\ue89b'),
    BOOKMARK("mdoal-bookmark", '\ue0bd'),
    BOOKMARK_BORDER("mdoal-bookmark_border", '\ue0bf'),
    BOOKMARKS("mdoal-bookmarks", '\ue0c0'),
    BORDER_ALL("mdoal-border_all", '\ue0c2'),
    BORDER_BOTTOM("mdoal-border_bottom", '\ue0c3'),
    BORDER_CLEAR("mdoal-border_clear", '\ue0c4'),
    BORDER_COLOR("mdoal-border_color", '\ue0c5'),
    BORDER_HORIZONTAL("mdoal-border_horizontal", '\ue0c7'),
    BORDER_INNER("mdoal-border_inner", '\ue0c8'),
    BORDER_LEFT("mdoal-border_left", '\ue0c9'),
    BORDER_OUTER("mdoal-border_outer", '\ue0ca'),
    BORDER_RIGHT("mdoal-border_right", '\ue0cb'),
    BORDER_STYLE("mdoal-border_style", '\ue0cc'),
    BORDER_TOP("mdoal-border_top", '\ue0cd'),
    BORDER_VERTICAL("mdoal-border_vertical", '\ue0ce'),
    BRANDING_WATERMARK("mdoal-branding_watermark", '\ue0cf'),
    BRIGHTNESS_1("mdoal-brightness_1", '\ue0d1'),
    BRIGHTNESS_2("mdoal-brightness_2", '\ue0d3'),
    BRIGHTNESS_3("mdoal-brightness_3", '\ue0d5'),
    BRIGHTNESS_4("mdoal-brightness_4", '\ue0d7'),
    BRIGHTNESS_5("mdoal-brightness_5", '\ue0d9'),
    BRIGHTNESS_6("mdoal-brightness_6", '\ue0db'),
    BRIGHTNESS_7("mdoal-brightness_7", '\ue0dd'),
    BRIGHTNESS_AUTO("mdoal-brightness_auto", '\ue0df'),
    BRIGHTNESS_HIGH("mdoal-brightness_high", '\ue0e1'),
    BRIGHTNESS_LOW("mdoal-brightness_low", '\ue0e3'),
    BRIGHTNESS_MEDIUM("mdoal-brightness_medium", '\ue0e5'),
    BROKEN_IMAGE("mdoal-broken_image", '\ue0e7'),
    BROWSER_NOT_SUPPORTED("mdoal-browser_not_supported", '\ue776'),
    BRUSH("mdoal-brush", '\ue0e9'),
    BUBBLE_CHART("mdoal-bubble_chart", '\ue0eb'),
    BUG_REPORT("mdoal-bug_report", '\ue0ed'),
    BUILD("mdoal-build", '\ue0ef'),
    BUILD_CIRCLE("mdoal-build_circle", '\ue777'),
    BURST_MODE("mdoal-burst_mode", '\ue0f1'),
    BUSINESS("mdoal-business", '\ue0f3'),
    BUSINESS_CENTER("mdoal-business_center", '\ue0f5'),
    CACHED("mdoal-cached", '\ue0f7'),
    CAKE("mdoal-cake", '\ue0f8'),
    CALCULATE("mdoal-calculate", '\ue779'),
    CALENDAR_TODAY("mdoal-calendar_today", '\ue0fa'),
    CALENDAR_VIEW_DAY("mdoal-calendar_view_day", '\ue0fc'),
    CALL("mdoal-call", '\ue0fe'),
    CALL_END("mdoal-call_end", '\ue100'),
    CALL_MADE("mdoal-call_made", '\ue102'),
    CALL_MERGE("mdoal-call_merge", '\ue103'),
    CALL_MISSED("mdoal-call_missed", '\ue104'),
    CALL_MISSED_OUTGOING("mdoal-call_missed_outgoing", '\ue105'),
    CALL_RECEIVED("mdoal-call_received", '\ue106'),
    CALL_SPLIT("mdoal-call_split", '\ue107'),
    CALL_TO_ACTION("mdoal-call_to_action", '\ue108'),
    CAMERA("mdoal-camera", '\ue10a'),
    CAMERA_ALT("mdoal-camera_alt", '\ue10c'),
    CAMERA_ENHANCE("mdoal-camera_enhance", '\ue10e'),
    CAMERA_FRONT("mdoal-camera_front", '\ue110'),
    CAMERA_REAR("mdoal-camera_rear", '\ue112'),
    CAMERA_ROLL("mdoal-camera_roll", '\ue114'),
    CAMPAIGN("mdoal-campaign", '\ue77b'),
    CANCEL("mdoal-cancel", '\ue116'),
    CANCEL_PRESENTATION("mdoal-cancel_presentation", '\ue118'),
    CANCEL_SCHEDULE_SEND("mdoal-cancel_schedule_send", '\ue11a'),
    CARD_GIFTCARD("mdoal-card_giftcard", '\ue11c'),
    CARD_MEMBERSHIP("mdoal-card_membership", '\ue11e'),
    CARD_TRAVEL("mdoal-card_travel", '\ue120'),
    CARPENTER("mdoal-carpenter", '\ue866'),
    CASINO("mdoal-casino", '\ue122'),
    CAST("mdoal-cast", '\ue124'),
    CAST_CONNECTED("mdoal-cast_connected", '\ue125'),
    CAST_FOR_EDUCATION("mdoal-cast_for_education", '\ue127'),
    CATEGORY("mdoal-category", '\ue128'),
    CELL_WIFI("mdoal-cell_wifi", '\ue12a'),
    CENTER_FOCUS_STRONG("mdoal-center_focus_strong", '\ue12c'),
    CENTER_FOCUS_WEAK("mdoal-center_focus_weak", '\ue12e'),
    CHANGE_HISTORY("mdoal-change_history", '\ue130'),
    CHARGING_STATION("mdoal-charging_station", '\ue77d'),
    CHAT("mdoal-chat", '\ue132'),
    CHAT_BUBBLE("mdoal-chat_bubble", '\ue134'),
    CHAT_BUBBLE_OUTLINE("mdoal-chat_bubble_outline", '\ue136'),
    CHECK("mdoal-check", '\ue137'),
    CHECK_BOX("mdoal-check_box", '\ue138'),
    CHECK_BOX_OUTLINE_BLANK("mdoal-check_box_outline_blank", '\ue13a'),
    CHECK_CIRCLE("mdoal-check_circle", '\ue13b'),
    CHECK_CIRCLE_OUTLINE("mdoal-check_circle_outline", '\ue13d'),
    CHECKROOM("mdoal-checkroom", '\ue77f'),
    CHEVRON_LEFT("mdoal-chevron_left", '\ue13e'),
    CHEVRON_RIGHT("mdoal-chevron_right", '\ue13f'),
    CHILD_CARE("mdoal-child_care", '\ue140'),
    CHILD_FRIENDLY("mdoal-child_friendly", '\ue142'),
    CHROME_READER_MODE("mdoal-chrome_reader_mode", '\ue144'),
    CLASS("mdoal-class", '\ue146'),
    CLEAN_HANDS("mdoal-clean_hands", '\ue89d'),
    CLEANING_SERVICES("mdoal-cleaning_services", '\ue780'),
    CLEAR("mdoal-clear", '\ue148'),
    CLEAR_ALL("mdoal-clear_all", '\ue149'),
    CLOSE("mdoal-close", '\ue14a'),
    CLOSE_FULLSCREEN("mdoal-close_fullscreen", '\ue782'),
    CLOSED_CAPTION("mdoal-closed_caption", '\ue14b'),
    CLOSED_CAPTION_DISABLED("mdoal-closed_caption_disabled", '\ue868'),
    CLOUD("mdoal-cloud", '\ue14d'),
    CLOUD_CIRCLE("mdoal-cloud_circle", '\ue14f'),
    CLOUD_DONE("mdoal-cloud_done", '\ue151'),
    CLOUD_DOWNLOAD("mdoal-cloud_download", '\ue153'),
    CLOUD_OFF("mdoal-cloud_off", '\ue155'),
    CLOUD_QUEUE("mdoal-cloud_queue", '\ue157'),
    CLOUD_UPLOAD("mdoal-cloud_upload", '\ue159'),
    CODE("mdoal-code", '\ue15b'),
    COLLECTIONS("mdoal-collections", '\ue15c'),
    COLLECTIONS_BOOKMARK("mdoal-collections_bookmark", '\ue15e'),
    COLOR_LENS("mdoal-color_lens", '\ue160'),
    COLORIZE("mdoal-colorize", '\ue162'),
    COMMENT("mdoal-comment", '\ue164'),
    COMMENT_BANK("mdoal-comment_bank", '\ue783'),
    COMMUTE("mdoal-commute", '\ue166'),
    COMPARE("mdoal-compare", '\ue167'),
    COMPARE_ARROWS("mdoal-compare_arrows", '\ue169'),
    COMPASS_CALIBRATION("mdoal-compass_calibration", '\ue16a'),
    COMPUTER("mdoal-computer", '\ue16c'),
    CONFIRMATION_NUMBER("mdoal-confirmation_number", '\ue16e'),
    CONNECT_WITHOUT_CONTACT("mdoal-connect_without_contact", '\ue89f'),
    CONSTRUCTION("mdoal-construction", '\ue785'),
    CONTACT_MAIL("mdoal-contact_mail", '\ue170'),
    CONTACT_PAGE("mdoal-contact_page", '\ue8b4'),
    CONTACT_PHONE("mdoal-contact_phone", '\ue172'),
    CONTACT_SUPPORT("mdoal-contact_support", '\ue174'),
    CONTACTLESS("mdoal-contactless", '\ue176'),
    CONTACTS("mdoal-contacts", '\ue178'),
    CONTENT_COPY("mdoal-content_copy", '\ue17a'),
    CONTENT_CUT("mdoal-content_cut", '\ue17c'),
    CONTENT_PASTE("mdoal-content_paste", '\ue17e'),
    CONTROL_CAMERA("mdoal-control_camera", '\ue180'),
    CONTROL_POINT("mdoal-control_point", '\ue181'),
    CONTROL_POINT_DUPLICATE("mdoal-control_point_duplicate", '\ue183'),
    COPYRIGHT("mdoal-copyright", '\ue185'),
    CORONAVIRUS("mdoal-coronavirus", '\ue8a0'),
    CORPORATE_FARE("mdoal-corporate_fare", '\ue786'),
    COUNTERTOPS("mdoal-countertops", '\ue86a'),
    CREATE("mdoal-create", '\ue187'),
    CREATE_NEW_FOLDER("mdoal-create_new_folder", '\ue189'),
    CREDIT_CARD("mdoal-credit_card", '\ue18b'),
    CROP("mdoal-crop", '\ue18d'),
    CROP_16_9("mdoal-crop_16_9", '\ue18e'),
    CROP_3_2("mdoal-crop_3_2", '\ue18f'),
    CROP_5_4("mdoal-crop_5_4", '\ue190'),
    CROP_7_5("mdoal-crop_7_5", '\ue191'),
    CROP_DIN("mdoal-crop_din", '\ue192'),
    CROP_FREE("mdoal-crop_free", '\ue193'),
    CROP_LANDSCAPE("mdoal-crop_landscape", '\ue194'),
    CROP_ORIGINAL("mdoal-crop_original", '\ue195'),
    CROP_PORTRAIT("mdoal-crop_portrait", '\ue196'),
    CROP_ROTATE("mdoal-crop_rotate", '\ue197'),
    CROP_SQUARE("mdoal-crop_square", '\ue198'),
    DASHBOARD("mdoal-dashboard", '\ue199'),
    DATA_USAGE("mdoal-data_usage", '\ue19b'),
    DATE_RANGE("mdoal-date_range", '\ue19c'),
    DECK("mdoal-deck", '\ue19e'),
    DEHAZE("mdoal-dehaze", '\ue1a0'),
    DELETE("mdoal-delete", '\ue1a1'),
    DELETE_FOREVER("mdoal-delete_forever", '\ue1a3'),
    DELETE_OUTLINE("mdoal-delete_outline", '\ue1a5'),
    DELETE_SWEEP("mdoal-delete_sweep", '\ue1a6'),
    DEPARTURE_BOARD("mdoal-departure_board", '\ue1a8'),
    DESCRIPTION("mdoal-description", '\ue1aa'),
    DESIGN_SERVICES("mdoal-design_services", '\ue788'),
    DESKTOP_ACCESS_DISABLED("mdoal-desktop_access_disabled", '\ue1ac'),
    DESKTOP_MAC("mdoal-desktop_mac", '\ue1ae'),
    DESKTOP_WINDOWS("mdoal-desktop_windows", '\ue1b0'),
    DETAILS("mdoal-details", '\ue1b2'),
    DEVELOPER_BOARD("mdoal-developer_board", '\ue1b4'),
    DEVELOPER_MODE("mdoal-developer_mode", '\ue1b6'),
    DEVICE_HUB("mdoal-device_hub", '\ue1b7'),
    DEVICE_UNKNOWN("mdoal-device_unknown", '\ue1b8'),
    DEVICES("mdoal-devices", '\ue1ba'),
    DEVICES_OTHER("mdoal-devices_other", '\ue1bc'),
    DIALER_SIP("mdoal-dialer_sip", '\ue1be'),
    DIALPAD("mdoal-dialpad", '\ue1c0'),
    DIRECTIONS("mdoal-directions", '\ue1c1'),
    DIRECTIONS_BIKE("mdoal-directions_bike", '\ue1c3'),
    DIRECTIONS_BOAT("mdoal-directions_boat", '\ue1c4'),
    DIRECTIONS_BUS("mdoal-directions_bus", '\ue1c6'),
    DIRECTIONS_CAR("mdoal-directions_car", '\ue1c8'),
    DIRECTIONS_OFF("mdoal-directions_off", '\ue78a'),
    DIRECTIONS_RAILWAY("mdoal-directions_railway", '\ue1ca'),
    DIRECTIONS_RUN("mdoal-directions_run", '\ue1cc'),
    DIRECTIONS_SUBWAY("mdoal-directions_subway", '\ue1cd'),
    DIRECTIONS_TRANSIT("mdoal-directions_transit", '\ue1cf'),
    DIRECTIONS_WALK("mdoal-directions_walk", '\ue1d1'),
    DISABLED_BY_DEFAULT("mdoal-disabled_by_default", '\ue8b6'),
    DISC_FULL("mdoal-disc_full", '\ue1d2'),
    DIVIDE("mdoal-divide", '\ue1d4'),
    DNS("mdoal-dns", '\ue1d6'),
    DO_NOT_DISTURB("mdoal-do_not_disturb", '\ue1d8'),
    DO_NOT_DISTURB_ALT("mdoal-do_not_disturb_alt", '\ue1da'),
    DO_NOT_DISTURB_OFF("mdoal-do_not_disturb_off", '\ue1dc'),
    DO_NOT_STEP("mdoal-do_not_step", '\ue78b'),
    DO_NOT_TOUCH("mdoal-do_not_touch", '\ue78d'),
    DOCK("mdoal-dock", '\ue1de'),
    DOMAIN("mdoal-domain", '\ue1e0'),
    DOMAIN_DISABLED("mdoal-domain_disabled", '\ue1e2'),
    DOMAIN_VERIFICATION("mdoal-domain_verification", '\ue78f'),
    DONE("mdoal-done", '\ue1e4'),
    DONE_ALL("mdoal-done_all", '\ue1e5'),
    DONE_OUTLINE("mdoal-done_outline", '\ue1e6'),
    DONUT_LARGE("mdoal-donut_large", '\ue1e7'),
    DONUT_SMALL("mdoal-donut_small", '\ue1e8'),
    DOUBLE_ARROW("mdoal-double_arrow", '\ue1ea'),
    DRAFTS("mdoal-drafts", '\ue1eb'),
    DRAG_HANDLE("mdoal-drag_handle", '\ue1ed'),
    DRAG_INDICATOR("mdoal-drag_indicator", '\ue1ee'),
    DRIVE_ETA("mdoal-drive_eta", '\ue1ef'),
    DRY("mdoal-dry", '\ue791'),
    DUO("mdoal-duo", '\ue1f1'),
    DVR("mdoal-dvr", '\ue1f2'),
    DYNAMIC_FEED("mdoal-dynamic_feed", '\ue1f4'),
    DYNAMIC_FORM("mdoal-dynamic_form", '\ue793'),
    EAST("mdoal-east", '\ue86c'),
    ECO("mdoal-eco", '\ue1f6'),
    EDIT("mdoal-edit", '\ue1f8'),
    EDIT_ATTRIBUTES("mdoal-edit_attributes", '\ue1fa'),
    EDIT_LOCATION("mdoal-edit_location", '\ue1fc'),
    EDIT_ROAD("mdoal-edit_road", '\ue795'),
    EJECT("mdoal-eject", '\ue1fe'),
    ELDERLY("mdoal-elderly", '\ue8a2'),
    ELECTRIC_BIKE("mdoal-electric_bike", '\ue797'),
    ELECTRIC_CAR("mdoal-electric_car", '\ue798'),
    ELECTRIC_MOPED("mdoal-electric_moped", '\ue79a'),
    ELECTRIC_SCOOTER("mdoal-electric_scooter", '\ue79c'),
    ELECTRICAL_SERVICES("mdoal-electrical_services", '\ue79d'),
    ELEVATOR("mdoal-elevator", '\ue79e'),
    EMAIL("mdoal-email", '\ue200'),
    EMOJI_EMOTIONS("mdoal-emoji_emotions", '\ue202'),
    EMOJI_EVENTS("mdoal-emoji_events", '\ue204'),
    EMOJI_FLAGS("mdoal-emoji_flags", '\ue206'),
    EMOJI_FOOD_BEVERAGE("mdoal-emoji_food_beverage", '\ue208'),
    EMOJI_NATURE("mdoal-emoji_nature", '\ue20a'),
    EMOJI_OBJECTS("mdoal-emoji_objects", '\ue20c'),
    EMOJI_PEOPLE("mdoal-emoji_people", '\ue20e'),
    EMOJI_SYMBOLS("mdoal-emoji_symbols", '\ue20f'),
    EMOJI_TRANSPORTATION("mdoal-emoji_transportation", '\ue210'),
    ENGINEERING("mdoal-engineering", '\ue7a0'),
    ENHANCED_ENCRYPTION("mdoal-enhanced_encryption", '\ue211'),
    EQUALIZER("mdoal-equalizer", '\ue213'),
    EQUALS("mdoal-equals", '\ue214'),
    ERROR("mdoal-error", '\ue215'),
    ERROR_OUTLINE("mdoal-error_outline", '\ue217'),
    ESCALATOR("mdoal-escalator", '\ue7a2'),
    ESCALATOR_WARNING("mdoal-escalator_warning", '\ue7a4'),
    EURO("mdoal-euro", '\ue218'),
    EURO_SYMBOL("mdoal-euro_symbol", '\ue219'),
    EV_STATION("mdoal-ev_station", '\ue21a'),
    EVENT("mdoal-event", '\ue21c'),
    EVENT_AVAILABLE("mdoal-event_available", '\ue21e'),
    EVENT_BUSY("mdoal-event_busy", '\ue220'),
    EVENT_NOTE("mdoal-event_note", '\ue222'),
    EVENT_SEAT("mdoal-event_seat", '\ue224'),
    EXIT_TO_APP("mdoal-exit_to_app", '\ue226'),
    EXPAND_LESS("mdoal-expand_less", '\ue227'),
    EXPAND_MORE("mdoal-expand_more", '\ue228'),
    EXPLICIT("mdoal-explicit", '\ue229'),
    EXPLORE("mdoal-explore", '\ue22b'),
    EXPLORE_OFF("mdoal-explore_off", '\ue22d'),
    EXPOSURE("mdoal-exposure", '\ue22f'),
    EXPOSURE_NEG_1("mdoal-exposure_neg_1", '\ue231'),
    EXPOSURE_NEG_2("mdoal-exposure_neg_2", '\ue232'),
    EXPOSURE_PLUS_1("mdoal-exposure_plus_1", '\ue233'),
    EXPOSURE_PLUS_2("mdoal-exposure_plus_2", '\ue234'),
    EXPOSURE_ZERO("mdoal-exposure_zero", '\ue235'),
    EXTENSION("mdoal-extension", '\ue236'),
    FACE("mdoal-face", '\ue238'),
    FACEBOOK("mdoal-facebook", '\ue8b8'),
    FACT_CHECK("mdoal-fact_check", '\ue7a5'),
    FAMILY_RESTROOM("mdoal-family_restroom", '\ue7a7'),
    FAST_FORWARD("mdoal-fast_forward", '\ue23a'),
    FAST_REWIND("mdoal-fast_rewind", '\ue23c'),
    FASTFOOD("mdoal-fastfood", '\ue23e'),
    FAVORITE("mdoal-favorite", '\ue240'),
    FAVORITE_BORDER("mdoal-favorite_border", '\ue242'),
    FEATURED_PLAY_LIST("mdoal-featured_play_list", '\ue243'),
    FEATURED_VIDEO("mdoal-featured_video", '\ue245'),
    FEEDBACK("mdoal-feedback", '\ue247'),
    FENCE("mdoal-fence", '\ue86d'),
    FIBER_DVR("mdoal-fiber_dvr", '\ue249'),
    FIBER_MANUAL_RECORD("mdoal-fiber_manual_record", '\ue24b'),
    FIBER_NEW("mdoal-fiber_new", '\ue24d'),
    FIBER_PIN("mdoal-fiber_pin", '\ue24f'),
    FIBER_SMART_RECORD("mdoal-fiber_smart_record", '\ue251'),
    FILE_COPY("mdoal-file_copy", '\ue253'),
    FILE_UPLOAD("mdoal-file_upload", '\ue255'),
    FILTER("mdoal-filter", '\ue257'),
    FILTER_1("mdoal-filter_1", '\ue259'),
    FILTER_2("mdoal-filter_2", '\ue25b'),
    FILTER_3("mdoal-filter_3", '\ue25d'),
    FILTER_4("mdoal-filter_4", '\ue25f'),
    FILTER_5("mdoal-filter_5", '\ue261'),
    FILTER_6("mdoal-filter_6", '\ue263'),
    FILTER_7("mdoal-filter_7", '\ue265'),
    FILTER_8("mdoal-filter_8", '\ue267'),
    FILTER_9("mdoal-filter_9", '\ue269'),
    FILTER_9_PLUS("mdoal-filter_9_plus", '\ue26b'),
    FILTER_ALT("mdoal-filter_alt", '\ue7a8'),
    FILTER_B_AND_W("mdoal-filter_b_and_w", '\ue26d'),
    FILTER_CENTER_FOCUS("mdoal-filter_center_focus", '\ue26f'),
    FILTER_DRAMA("mdoal-filter_drama", '\ue270'),
    FILTER_FRAMES("mdoal-filter_frames", '\ue272'),
    FILTER_HDR("mdoal-filter_hdr", '\ue274'),
    FILTER_LIST("mdoal-filter_list", '\ue276'),
    FILTER_NONE("mdoal-filter_none", '\ue277'),
    FILTER_TILT_SHIFT("mdoal-filter_tilt_shift", '\ue279'),
    FILTER_VINTAGE("mdoal-filter_vintage", '\ue27a'),
    FIND_IN_PAGE("mdoal-find_in_page", '\ue27c'),
    FIND_REPLACE("mdoal-find_replace", '\ue27e'),
    FINGERPRINT("mdoal-fingerprint", '\ue27f'),
    FIRE_EXTINGUISHER("mdoal-fire_extinguisher", '\ue86f'),
    FIREPLACE("mdoal-fireplace", '\ue280'),
    FIRST_PAGE("mdoal-first_page", '\ue282'),
    FITNESS_CENTER("mdoal-fitness_center", '\ue283'),
    FLAG("mdoal-flag", '\ue284'),
    FLAKY("mdoal-flaky", '\ue7aa'),
    FLARE("mdoal-flare", '\ue286'),
    FLASH_AUTO("mdoal-flash_auto", '\ue287'),
    FLASH_OFF("mdoal-flash_off", '\ue288'),
    FLASH_ON("mdoal-flash_on", '\ue289'),
    FLIGHT("mdoal-flight", '\ue28a'),
    FLIGHT_LAND("mdoal-flight_land", '\ue28b'),
    FLIGHT_TAKEOFF("mdoal-flight_takeoff", '\ue28c'),
    FLIP("mdoal-flip", '\ue28d'),
    FLIP_CAMERA_ANDROID("mdoal-flip_camera_android", '\ue28e'),
    FLIP_CAMERA_IOS("mdoal-flip_camera_ios", '\ue290'),
    FLIP_TO_BACK("mdoal-flip_to_back", '\ue292'),
    FLIP_TO_FRONT("mdoal-flip_to_front", '\ue293'),
    FOLDER("mdoal-folder", '\ue294'),
    FOLDER_OPEN("mdoal-folder_open", '\ue296'),
    FOLDER_SHARED("mdoal-folder_shared", '\ue298'),
    FOLDER_SPECIAL("mdoal-folder_special", '\ue29a'),
    FOLLOW_THE_SIGNS("mdoal-follow_the_signs", '\ue8a3'),
    FONT_DOWNLOAD("mdoal-font_download", '\ue29c'),
    FOOD_BANK("mdoal-food_bank", '\ue870'),
    FORMAT_ALIGN_CENTER("mdoal-format_align_center", '\ue29e'),
    FORMAT_ALIGN_JUSTIFY("mdoal-format_align_justify", '\ue29f'),
    FORMAT_ALIGN_LEFT("mdoal-format_align_left", '\ue2a0'),
    FORMAT_ALIGN_RIGHT("mdoal-format_align_right", '\ue2a1'),
    FORMAT_BOLD("mdoal-format_bold", '\ue2a2'),
    FORMAT_CLEAR("mdoal-format_clear", '\ue2a3'),
    FORMAT_COLOR_FILL("mdoal-format_color_fill", '\ue2a4'),
    FORMAT_COLOR_RESET("mdoal-format_color_reset", '\ue2a6'),
    FORMAT_COLOR_TEXT("mdoal-format_color_text", '\ue2a8'),
    FORMAT_INDENT_DECREASE("mdoal-format_indent_decrease", '\ue2aa'),
    FORMAT_INDENT_INCREASE("mdoal-format_indent_increase", '\ue2ab'),
    FORMAT_ITALIC("mdoal-format_italic", '\ue2ac'),
    FORMAT_LINE_SPACING("mdoal-format_line_spacing", '\ue2ad'),
    FORMAT_LIST_BULLETED("mdoal-format_list_bulleted", '\ue2ae'),
    FORMAT_LIST_NUMBERED("mdoal-format_list_numbered", '\ue2af'),
    FORMAT_LIST_NUMBERED_RTL("mdoal-format_list_numbered_rtl", '\ue2b0'),
    FORMAT_PAINT("mdoal-format_paint", '\ue2b1'),
    FORMAT_QUOTE("mdoal-format_quote", '\ue2b3'),
    FORMAT_SHAPES("mdoal-format_shapes", '\ue2b5'),
    FORMAT_SIZE("mdoal-format_size", '\ue2b7'),
    FORMAT_STRIKETHROUGH("mdoal-format_strikethrough", '\ue2b8'),
    FORMAT_TEXTDIRECTION_L_TO_R("mdoal-format_textdirection_l_to_r", '\ue2b9'),
    FORMAT_TEXTDIRECTION_R_TO_L("mdoal-format_textdirection_r_to_l", '\ue2bb'),
    FORMAT_UNDERLINED("mdoal-format_underlined", '\ue2bd'),
    FORUM("mdoal-forum", '\ue2be'),
    FORWARD("mdoal-forward", '\ue2c0'),
    FORWARD_10("mdoal-forward_10", '\ue2c2'),
    FORWARD_30("mdoal-forward_30", '\ue2c3'),
    FORWARD_5("mdoal-forward_5", '\ue2c4'),
    FORWARD_TO_INBOX("mdoal-forward_to_inbox", '\ue7ab'),
    FOUNDATION("mdoal-foundation", '\ue872'),
    FREE_BREAKFAST("mdoal-free_breakfast", '\ue2c5'),
    FULLSCREEN("mdoal-fullscreen", '\ue2c7'),
    FULLSCREEN_EXIT("mdoal-fullscreen_exit", '\ue2c8'),
    FUNCTIONS("mdoal-functions", '\ue2c9'),
    G_TRANSLATE("mdoal-g_translate", '\ue2ca'),
    GAMEPAD("mdoal-gamepad", '\ue2cb'),
    GAMES("mdoal-games", '\ue2cd'),
    GAVEL("mdoal-gavel", '\ue2cf'),
    GESTURE("mdoal-gesture", '\ue2d0'),
    GET_APP("mdoal-get_app", '\ue2d1'),
    GIF("mdoal-gif", '\ue2d3'),
    GOLF_COURSE("mdoal-golf_course", '\ue2d5'),
    GPS_FIXED("mdoal-gps_fixed", '\ue2d7'),
    GPS_NOT_FIXED("mdoal-gps_not_fixed", '\ue2d9'),
    GPS_OFF("mdoal-gps_off", '\ue2da'),
    GRADE("mdoal-grade", '\ue2db'),
    GRADIENT("mdoal-gradient", '\ue2dd'),
    GRADING("mdoal-grading", '\ue7ad'),
    GRAIN("mdoal-grain", '\ue2de'),
    GRAPHIC_EQ("mdoal-graphic_eq", '\ue2df'),
    GRASS("mdoal-grass", '\ue874'),
    GREATER_THAN("mdoal-greater_than", '\ue2e0'),
    GREATER_THAN_EQUAL("mdoal-greater_than_equal", '\ue2e1'),
    GRID_OFF("mdoal-grid_off", '\ue2e2'),
    GRID_ON("mdoal-grid_on", '\ue2e4'),
    GROUP("mdoal-group", '\ue2e6'),
    GROUP_ADD("mdoal-group_add", '\ue2e8'),
    GROUP_WORK("mdoal-group_work", '\ue2ea'),
    GROUPS("mdoal-groups", '\ue8b9'),
    HANDYMAN("mdoal-handyman", '\ue7ae'),
    HD("mdoal-hd", '\ue2ec'),
    HDR_OFF("mdoal-hdr_off", '\ue2ee'),
    HDR_ON("mdoal-hdr_on", '\ue2ef'),
    HDR_STRONG("mdoal-hdr_strong", '\ue2f0'),
    HDR_WEAK("mdoal-hdr_weak", '\ue2f2'),
    HEADSET("mdoal-headset", '\ue2f4'),
    HEADSET_MIC("mdoal-headset_mic", '\ue2f6'),
    HEALING("mdoal-healing", '\ue2f8'),
    HEARING("mdoal-hearing", '\ue2fa'),
    HEARING_DISABLED("mdoal-hearing_disabled", '\ue7b0'),
    HEIGHT("mdoal-height", '\ue2fb'),
    HELP("mdoal-help", '\ue2fc'),
    HELP_CENTER("mdoal-help_center", '\ue7b1'),
    HELP_OUTLINE("mdoal-help_outline", '\ue2fe'),
    HIGH_QUALITY("mdoal-high_quality", '\ue2ff'),
    HIGHLIGHT("mdoal-highlight", '\ue301'),
    HIGHLIGHT_ALT("mdoal-highlight_alt", '\ue7b3'),
    HIGHLIGHT_OFF("mdoal-highlight_off", '\ue303'),
    HISTORY("mdoal-history", '\ue305'),
    HISTORY_EDU("mdoal-history_edu", '\ue7b4'),
    HISTORY_TOGGLE_OFF("mdoal-history_toggle_off", '\ue7b6'),
    HOME("mdoal-home", '\ue306'),
    HOME_REPAIR_SERVICE("mdoal-home_repair_service", '\ue7b7'),
    HOME_WORK("mdoal-home_work", '\ue308'),
    HORIZONTAL_DISTRIBUTE("mdoal-horizontal_distribute", '\ue8d0'),
    HORIZONTAL_RULE("mdoal-horizontal_rule", '\ue7b9'),
    HORIZONTAL_SPLIT("mdoal-horizontal_split", '\ue30a'),
    HOT_TUB("mdoal-hot_tub", '\ue30c'),
    HOTEL("mdoal-hotel", '\ue30d'),
    HOURGLASS_BOTTOM("mdoal-hourglass_bottom", '\ue7ba'),
    HOURGLASS_DISABLED("mdoal-hourglass_disabled", '\ue7bc'),
    HOURGLASS_EMPTY("mdoal-hourglass_empty", '\ue30f'),
    HOURGLASS_FULL("mdoal-hourglass_full", '\ue310'),
    HOURGLASS_TOP("mdoal-hourglass_top", '\ue7bd'),
    HOUSE("mdoal-house", '\ue312'),
    HOUSE_SIDING("mdoal-house_siding", '\ue875'),
    HOW_TO_REG("mdoal-how_to_reg", '\ue314'),
    HOW_TO_VOTE("mdoal-how_to_vote", '\ue316'),
    HTTP("mdoal-http", '\ue318'),
    HTTPS("mdoal-https", '\ue319'),
    HVAC("mdoal-hvac", '\ue7bf'),
    IMAGE("mdoal-image", '\ue31b'),
    IMAGE_ASPECT_RATIO("mdoal-image_aspect_ratio", '\ue31d'),
    IMAGE_NOT_SUPPORTED("mdoal-image_not_supported", '\ue7c1'),
    IMAGE_SEARCH("mdoal-image_search", '\ue31f'),
    IMPORT_CONTACTS("mdoal-import_contacts", '\ue321'),
    IMPORT_EXPORT("mdoal-import_export", '\ue323'),
    IMPORTANT_DEVICES("mdoal-important_devices", '\ue324'),
    INBOX("mdoal-inbox", '\ue326'),
    INDETERMINATE_CHECK_BOX("mdoal-indeterminate_check_box", '\ue328'),
    INFO("mdoal-info", '\ue32a'),
    INPUT("mdoal-input", '\ue32c'),
    INSERT_CHART("mdoal-insert_chart", '\ue32d'),
    INSERT_CHART_OUTLINED("mdoal-insert_chart_outlined", '\ue32f'),
    INSERT_COMMENT("mdoal-insert_comment", '\ue330'),
    INSERT_DRIVE_FILE("mdoal-insert_drive_file", '\ue332'),
    INSERT_EMOTICON("mdoal-insert_emoticon", '\ue334'),
    INSERT_INVITATION("mdoal-insert_invitation", '\ue336'),
    INSERT_LINK("mdoal-insert_link", '\ue338'),
    INSERT_PHOTO("mdoal-insert_photo", '\ue339'),
    INSIGHTS("mdoal-insights", '\ue7c3'),
    INTEGRATION_INSTRUCTIONS("mdoal-integration_instructions", '\ue7c4'),
    INVERT_COLORS("mdoal-invert_colors", '\ue33b'),
    INVERT_COLORS_OFF("mdoal-invert_colors_off", '\ue33d'),
    ISO("mdoal-iso", '\ue33f'),
    KEYBOARD("mdoal-keyboard", '\ue341'),
    KEYBOARD_ARROW_DOWN("mdoal-keyboard_arrow_down", '\ue343'),
    KEYBOARD_ARROW_LEFT("mdoal-keyboard_arrow_left", '\ue344'),
    KEYBOARD_ARROW_RIGHT("mdoal-keyboard_arrow_right", '\ue345'),
    KEYBOARD_ARROW_UP("mdoal-keyboard_arrow_up", '\ue346'),
    KEYBOARD_BACKSPACE("mdoal-keyboard_backspace", '\ue347'),
    KEYBOARD_CAPSLOCK("mdoal-keyboard_capslock", '\ue348'),
    KEYBOARD_HIDE("mdoal-keyboard_hide", '\ue349'),
    KEYBOARD_RETURN("mdoal-keyboard_return", '\ue34b'),
    KEYBOARD_TAB("mdoal-keyboard_tab", '\ue34c'),
    KEYBOARD_VOICE("mdoal-keyboard_voice", '\ue34d'),
    KING_BED("mdoal-king_bed", '\ue34f'),
    KITCHEN("mdoal-kitchen", '\ue351'),
    LABEL("mdoal-label", '\ue353'),
    LABEL_IMPORTANT("mdoal-label_important", '\ue355'),
    LABEL_OFF("mdoal-label_off", '\ue357'),
    LANDSCAPE("mdoal-landscape", '\ue359'),
    LANGUAGE("mdoal-language", '\ue35b'),
    LAPTOP("mdoal-laptop", '\ue35d'),
    LAPTOP_CHROMEBOOK("mdoal-laptop_chromebook", '\ue35f'),
    LAPTOP_MAC("mdoal-laptop_mac", '\ue361'),
    LAPTOP_WINDOWS("mdoal-laptop_windows", '\ue363'),
    LAST_PAGE("mdoal-last_page", '\ue365'),
    LAUNCH("mdoal-launch", '\ue366'),
    LAYERS("mdoal-layers", '\ue367'),
    LAYERS_CLEAR("mdoal-layers_clear", '\ue369'),
    LEADERBOARD("mdoal-leaderboard", '\ue877'),
    LEAK_ADD("mdoal-leak_add", '\ue36b'),
    LEAK_REMOVE("mdoal-leak_remove", '\ue36c'),
    LEAVE_BAGS_AT_HOME("mdoal-leave_bags_at_home", '\ue8a5'),
    LEGEND_TOGGLE("mdoal-legend_toggle", '\ue7c6'),
    LENS("mdoal-lens", '\ue36d'),
    LESS_THAN("mdoal-less_than", '\ue36f'),
    LESS_THAN_EQUAL("mdoal-less_than_equal", '\ue370'),
    LIBRARY_ADD("mdoal-library_add", '\ue371'),
    LIBRARY_ADD_CHECK("mdoal-library_add_check", '\ue746'),
    LIBRARY_BOOKS("mdoal-library_books", '\ue373'),
    LIBRARY_MUSIC("mdoal-library_music", '\ue375'),
    LIGHTBULB("mdoal-lightbulb", '\ue377'),
    LINE_STYLE("mdoal-line_style", '\ue379'),
    LINE_WEIGHT("mdoal-line_weight", '\ue37a'),
    LINEAR_SCALE("mdoal-linear_scale", '\ue37b'),
    LINK("mdoal-link", '\ue37c'),
    LINK_OFF("mdoal-link_off", '\ue37e'),
    LINKED_CAMERA("mdoal-linked_camera", '\ue37f'),
    LIST("mdoal-list", '\ue381'),
    LIST_ALT("mdoal-list_alt", '\ue382'),
    LIVE_HELP("mdoal-live_help", '\ue384'),
    LIVE_TV("mdoal-live_tv", '\ue386'),
    LOCAL_ACTIVITY("mdoal-local_activity", '\ue388'),
    LOCAL_AIRPORT("mdoal-local_airport", '\ue38a'),
    LOCAL_ATM("mdoal-local_atm", '\ue38b'),
    LOCAL_BAR("mdoal-local_bar", '\ue38d'),
    LOCAL_CAFE("mdoal-local_cafe", '\ue38f'),
    LOCAL_CAR_WASH("mdoal-local_car_wash", '\ue391'),
    LOCAL_CONVENIENCE_STORE("mdoal-local_convenience_store", '\ue393'),
    LOCAL_DINING("mdoal-local_dining", '\ue395'),
    LOCAL_DRINK("mdoal-local_drink", '\ue396'),
    LOCAL_FIRE_DEPARTMENT("mdoal-local_fire_department", '\ue8a7'),
    LOCAL_FLORIST("mdoal-local_florist", '\ue398'),
    LOCAL_GAS_STATION("mdoal-local_gas_station", '\ue39a'),
    LOCAL_GROCERY_STORE("mdoal-local_grocery_store", '\ue39c'),
    LOCAL_HOSPITAL("mdoal-local_hospital", '\ue39e'),
    LOCAL_HOTEL("mdoal-local_hotel", '\ue3a0'),
    LOCAL_LAUNDRY_SERVICE("mdoal-local_laundry_service", '\ue3a2'),
    LOCAL_LIBRARY("mdoal-local_library", '\ue3a4'),
    LOCAL_MALL("mdoal-local_mall", '\ue3a6'),
    LOCAL_MOVIES("mdoal-local_movies", '\ue3a8'),
    LOCAL_OFFER("mdoal-local_offer", '\ue3aa'),
    LOCAL_PARKING("mdoal-local_parking", '\ue3ac'),
    LOCAL_PHARMACY("mdoal-local_pharmacy", '\ue3ad'),
    LOCAL_PHONE("mdoal-local_phone", '\ue3af'),
    LOCAL_PIZZA("mdoal-local_pizza", '\ue3b1'),
    LOCAL_PLAY("mdoal-local_play", '\ue3b3'),
    LOCAL_POLICE("mdoal-local_police", '\ue8a9'),
    LOCAL_POST_OFFICE("mdoal-local_post_office", '\ue3b5'),
    LOCAL_PRINTSHOP("mdoal-local_printshop", '\ue3b7'),
    LOCAL_SEE("mdoal-local_see", '\ue3b9'),
    LOCAL_SHIPPING("mdoal-local_shipping", '\ue3bb'),
    LOCAL_TAXI("mdoal-local_taxi", '\ue3bd'),
    LOCATION_CITY("mdoal-location_city", '\ue3bf'),
    LOCATION_DISABLED("mdoal-location_disabled", '\ue3c0'),
    LOCATION_OFF("mdoal-location_off", '\ue3c1'),
    LOCATION_ON("mdoal-location_on", '\ue3c2'),
    LOCATION_SEARCHING("mdoal-location_searching", '\ue3c4'),
    LOCK("mdoal-lock", '\ue3c5'),
    LOCK_OPEN("mdoal-lock_open", '\ue3c7'),
    LOG_IN("mdoal-log_in", '\ue3c9'),
    LOG_OUT("mdoal-log_out", '\ue3ca'),
    LOGIN("mdoal-login", '\ue7c7'),
    LOOKS("mdoal-looks", '\ue3cb'),
    LOOKS_3("mdoal-looks_3", '\ue3cc'),
    LOOKS_4("mdoal-looks_4", '\ue3ce'),
    LOOKS_5("mdoal-looks_5", '\ue3d0'),
    LOOKS_6("mdoal-looks_6", '\ue3d2'),
    LOOKS_ONE("mdoal-looks_one", '\ue3d4'),
    LOOKS_TWO("mdoal-looks_two", '\ue3d6'),
    LOOP("mdoal-loop", '\ue3d8'),
    LOUPE("mdoal-loupe", '\ue3d9'),
    LOW_PRIORITY("mdoal-low_priority", '\ue3db'),
    LOYALTY("mdoal-loyalty", '\ue3dc'),
    LUGGAGE("mdoal-luggage", '\ue8bb');
    
    public static Material2OutlinedAL findByDescription(String description) {
        for (Material2OutlinedAL font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2OutlinedAL(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}