/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2OutlinedMZ implements Ikon {
    MAIL("mdomz-mail", '\ue3de'),
    MAIL_OUTLINE("mdomz-mail_outline", '\ue3e0'),
    MAP("mdomz-map", '\ue3e1'),
    MAPS_UGC("mdomz-maps_ugc", '\ue7c8'),
    MARK_CHAT_READ("mdomz-mark_chat_read", '\ue7ca'),
    MARK_CHAT_UNREAD("mdomz-mark_chat_unread", '\ue7cc'),
    MARK_EMAIL_READ("mdomz-mark_email_read", '\ue7ce'),
    MARK_EMAIL_UNREAD("mdomz-mark_email_unread", '\ue7d0'),
    MARKUNREAD("mdomz-markunread", '\ue3e3'),
    MARKUNREAD_MAILBOX("mdomz-markunread_mailbox", '\ue3e5'),
    MASKS("mdomz-masks", '\ue8ab'),
    MAXIMIZE("mdomz-maximize", '\ue3e7'),
    MEDIATION("mdomz-mediation", '\ue7d2'),
    MEDICAL_SERVICES("mdomz-medical_services", '\ue7d3'),
    MEETING_ROOM("mdomz-meeting_room", '\ue3e8'),
    MEMORY("mdomz-memory", '\ue3ea'),
    MENU("mdomz-menu", '\ue3ec'),
    MENU_BOOK("mdomz-menu_book", '\ue3ed'),
    MENU_OPEN("mdomz-menu_open", '\ue3ef'),
    MERGE_TYPE("mdomz-merge_type", '\ue3f0'),
    MESSAGE("mdomz-message", '\ue3f1'),
    MIC("mdomz-mic", '\ue3f3'),
    MIC_NONE("mdomz-mic_none", '\ue3f5'),
    MIC_OFF("mdomz-mic_off", '\ue3f7'),
    MICROWAVE("mdomz-microwave", '\ue879'),
    MILITARY_TECH("mdomz-military_tech", '\ue7d5'),
    MINIMIZE("mdomz-minimize", '\ue3f9'),
    MINUS("mdomz-minus", '\ue3fa'),
    MISCELLANEOUS_SERVICES("mdomz-miscellaneous_services", '\ue7d7'),
    MISSED_VIDEO_CALL("mdomz-missed_video_call", '\ue3fb'),
    MMS("mdomz-mms", '\ue3fd'),
    MOBILE_FRIENDLY("mdomz-mobile_friendly", '\ue3ff'),
    MOBILE_OFF("mdomz-mobile_off", '\ue400'),
    MOBILE_SCREEN_SHARE("mdomz-mobile_screen_share", '\ue401'),
    MODE_COMMENT("mdomz-mode_comment", '\ue403'),
    MODEL_TRAINING("mdomz-model_training", '\ue7d8'),
    MONETIZATION_ON("mdomz-monetization_on", '\ue405'),
    MONEY("mdomz-money", '\ue407'),
    MONEY_OFF("mdomz-money_off", '\ue409'),
    MONOCHROME_PHOTOS("mdomz-monochrome_photos", '\ue40a'),
    MOOD("mdomz-mood", '\ue40c'),
    MOOD_BAD("mdomz-mood_bad", '\ue40e'),
    MOPED("mdomz-moped", '\ue7d9'),
    MORE("mdomz-more", '\ue410'),
    MORE_HORIZ("mdomz-more_horiz", '\ue412'),
    MORE_TIME("mdomz-more_time", '\ue7db'),
    MORE_VERT("mdomz-more_vert", '\ue413'),
    MOTION_PHOTOS_ON("mdomz-motion_photos_on", '\ue8ad'),
    MOTION_PHOTOS_PAUSE("mdomz-motion_photos_pause", '\ue8bd'),
    MOTION_PHOTOS_PAUSED("mdomz-motion_photos_paused", '\ue8ae'),
    MOTORCYCLE("mdomz-motorcycle", '\ue414'),
    MOUSE("mdomz-mouse", '\ue416'),
    MOVE_TO_INBOX("mdomz-move_to_inbox", '\ue418'),
    MOVIE("mdomz-movie", '\ue41a'),
    MOVIE_CREATION("mdomz-movie_creation", '\ue41c'),
    MOVIE_FILTER("mdomz-movie_filter", '\ue41e'),
    MULTILINE_CHART("mdomz-multiline_chart", '\ue420'),
    MULTIPLE_STOP("mdomz-multiple_stop", '\ue7dc'),
    MUSEUM("mdomz-museum", '\ue421'),
    MUSIC_NOTE("mdomz-music_note", '\ue423'),
    MUSIC_OFF("mdomz-music_off", '\ue425'),
    MUSIC_VIDEO("mdomz-music_video", '\ue427'),
    MY_LOCATION("mdomz-my_location", '\ue429'),
    NAT("mdomz-nat", '\ue7dd'),
    NATURE("mdomz-nature", '\ue42b'),
    NATURE_PEOPLE("mdomz-nature_people", '\ue42d'),
    NAVIGATE_BEFORE("mdomz-navigate_before", '\ue42f'),
    NAVIGATE_NEXT("mdomz-navigate_next", '\ue430'),
    NAVIGATION("mdomz-navigation", '\ue431'),
    NEAR_ME("mdomz-near_me", '\ue433'),
    NEAR_ME_DISABLED("mdomz-near_me_disabled", '\ue87b'),
    NETWORK_CELL("mdomz-network_cell", '\ue435'),
    NETWORK_CHECK("mdomz-network_check", '\ue437'),
    NETWORK_LOCKED("mdomz-network_locked", '\ue438'),
    NETWORK_WIFI("mdomz-network_wifi", '\ue439'),
    NEW_RELEASES("mdomz-new_releases", '\ue43b'),
    NEXT_PLAN("mdomz-next_plan", '\ue7df'),
    NEXT_WEEK("mdomz-next_week", '\ue43d'),
    NFC("mdomz-nfc", '\ue43f'),
    NIGHT_SHELTER("mdomz-night_shelter", '\ue87d'),
    NIGHTS_STAY("mdomz-nights_stay", '\ue440'),
    NO_BACKPACK("mdomz-no_backpack", '\ue8be'),
    NO_CELL("mdomz-no_cell", '\ue7e1'),
    NO_DRINKS("mdomz-no_drinks", '\ue7e3'),
    NO_ENCRYPTION("mdomz-no_encryption", '\ue442'),
    NO_FLASH("mdomz-no_flash", '\ue7e5'),
    NO_FOOD("mdomz-no_food", '\ue7e7'),
    NO_LUGGAGE("mdomz-no_luggage", '\ue8c0'),
    NO_MEALS("mdomz-no_meals", '\ue87f'),
    NO_MEETING_ROOM("mdomz-no_meeting_room", '\ue444'),
    NO_PHOTOGRAPHY("mdomz-no_photography", '\ue7e9'),
    NO_SIM("mdomz-no_sim", '\ue446'),
    NO_STROLLER("mdomz-no_stroller", '\ue7eb'),
    NO_TRANSFER("mdomz-no_transfer", '\ue880'),
    NORTH("mdomz-north", '\ue882'),
    NORTH_EAST("mdomz-north_east", '\ue883'),
    NORTH_WEST("mdomz-north_west", '\ue884'),
    NOT_ACCESSIBLE("mdomz-not_accessible", '\ue7ed'),
    NOT_EQUAL("mdomz-not_equal", '\ue448'),
    NOT_INTERESTED("mdomz-not_interested", '\ue449'),
    NOT_LISTED_LOCATION("mdomz-not_listed_location", '\ue44a'),
    NOT_STARTED("mdomz-not_started", '\ue7ee'),
    NOTE("mdomz-note", '\ue44c'),
    NOTE_ADD("mdomz-note_add", '\ue44e'),
    NOTES("mdomz-notes", '\ue450'),
    NOTIFICATION_IMPORTANT("mdomz-notification_important", '\ue451'),
    NOTIFICATIONS("mdomz-notifications", '\ue453'),
    NOTIFICATIONS_ACTIVE("mdomz-notifications_active", '\ue455'),
    NOTIFICATIONS_NONE("mdomz-notifications_none", '\ue457'),
    NOTIFICATIONS_OFF("mdomz-notifications_off", '\ue459'),
    NOTIFICATIONS_PAUSED("mdomz-notifications_paused", '\ue45b'),
    OFFLINE_BOLT("mdomz-offline_bolt", '\ue45d'),
    OFFLINE_PIN("mdomz-offline_pin", '\ue45f'),
    ONDEMAND_VIDEO("mdomz-ondemand_video", '\ue461'),
    ONLINE_PREDICTION("mdomz-online_prediction", '\ue7f0'),
    OPACITY("mdomz-opacity", '\ue463'),
    OPEN_IN_BROWSER("mdomz-open_in_browser", '\ue465'),
    OPEN_IN_FULL("mdomz-open_in_full", '\ue7f1'),
    OPEN_IN_NEW("mdomz-open_in_new", '\ue466'),
    OPEN_WITH("mdomz-open_with", '\ue467'),
    OUTBOND("mdomz-outbond", '\ue8c2'),
    OUTDOOR_GRILL("mdomz-outdoor_grill", '\ue468'),
    OUTLET("mdomz-outlet", '\ue7f2'),
    OUTLINED_FLAG("mdomz-outlined_flag", '\ue46a'),
    PAGES("mdomz-pages", '\ue46b'),
    PAGEVIEW("mdomz-pageview", '\ue46d'),
    PALETTE("mdomz-palette", '\ue46f'),
    PAN_TOOL("mdomz-pan_tool", '\ue471'),
    PANORAMA("mdomz-panorama", '\ue473'),
    PANORAMA_FISH_EYE("mdomz-panorama_fish_eye", '\ue475'),
    PANORAMA_HORIZONTAL("mdomz-panorama_horizontal", '\ue477'),
    PANORAMA_VERTICAL("mdomz-panorama_vertical", '\ue479'),
    PANORAMA_WIDE_ANGLE("mdomz-panorama_wide_angle", '\ue47b'),
    PARTY_MODE("mdomz-party_mode", '\ue47d'),
    PAUSE("mdomz-pause", '\ue47f'),
    PAUSE_CIRCLE_FILLED("mdomz-pause_circle_filled", '\ue480'),
    PAUSE_CIRCLE_OUTLINE("mdomz-pause_circle_outline", '\ue482'),
    PAUSE_PRESENTATION("mdomz-pause_presentation", '\ue483'),
    PAYMENT("mdomz-payment", '\ue485'),
    PAYMENTS("mdomz-payments", '\ue7f4'),
    PEDAL_BIKE("mdomz-pedal_bike", '\ue7f6'),
    PENDING("mdomz-pending", '\ue7f7'),
    PENDING_ACTIONS("mdomz-pending_actions", '\ue7f9'),
    PEOPLE("mdomz-people", '\ue487'),
    PEOPLE_ALT("mdomz-people_alt", '\ue489'),
    PEOPLE_OUTLINE("mdomz-people_outline", '\ue48b'),
    PERCENTAGE("mdomz-percentage", '\ue48d'),
    PERM_CAMERA_MIC("mdomz-perm_camera_mic", '\ue48f'),
    PERM_CONTACT_CALENDAR("mdomz-perm_contact_calendar", '\ue491'),
    PERM_DATA_SETTING("mdomz-perm_data_setting", '\ue493'),
    PERM_DEVICE_INFORMATION("mdomz-perm_device_information", '\ue494'),
    PERM_IDENTITY("mdomz-perm_identity", '\ue496'),
    PERM_MEDIA("mdomz-perm_media", '\ue498'),
    PERM_PHONE_MSG("mdomz-perm_phone_msg", '\ue49a'),
    PERM_SCAN_WIFI("mdomz-perm_scan_wifi", '\ue49c'),
    PERSON("mdomz-person", '\ue49e'),
    PERSON_ADD("mdomz-person_add", '\ue4a0'),
    PERSON_ADD_ALT_1("mdomz-person_add_alt_1", '\ue7fb'),
    PERSON_ADD_DISABLED("mdomz-person_add_disabled", '\ue4a2'),
    PERSON_OUTLINE("mdomz-person_outline", '\ue4a4'),
    PERSON_PIN("mdomz-person_pin", '\ue4a6'),
    PERSON_PIN_CIRCLE("mdomz-person_pin_circle", '\ue4a8'),
    PERSON_REMOVE("mdomz-person_remove", '\ue7fd'),
    PERSON_REMOVE_ALT_1("mdomz-person_remove_alt_1", '\ue7ff'),
    PERSON_SEARCH("mdomz-person_search", '\ue801'),
    PERSONAL_VIDEO("mdomz-personal_video", '\ue4aa'),
    PEST_CONTROL("mdomz-pest_control", '\ue803'),
    PEST_CONTROL_RODENT("mdomz-pest_control_rodent", '\ue805'),
    PETS("mdomz-pets", '\ue4ac'),
    PHONE("mdomz-phone", '\ue4ad'),
    PHONE_ANDROID("mdomz-phone_android", '\ue4af'),
    PHONE_BLUETOOTH_SPEAKER("mdomz-phone_bluetooth_speaker", '\ue4b1'),
    PHONE_CALLBACK("mdomz-phone_callback", '\ue4b3'),
    PHONE_DISABLED("mdomz-phone_disabled", '\ue4b5'),
    PHONE_ENABLED("mdomz-phone_enabled", '\ue4b6'),
    PHONE_FORWARDED("mdomz-phone_forwarded", '\ue4b7'),
    PHONE_IN_TALK("mdomz-phone_in_talk", '\ue4b9'),
    PHONE_IPHONE("mdomz-phone_iphone", '\ue4bb'),
    PHONE_LOCKED("mdomz-phone_locked", '\ue4bd'),
    PHONE_MISSED("mdomz-phone_missed", '\ue4bf'),
    PHONE_PAUSED("mdomz-phone_paused", '\ue4c1'),
    PHONELINK("mdomz-phonelink", '\ue4c3'),
    PHONELINK_ERASE("mdomz-phonelink_erase", '\ue4c5'),
    PHONELINK_LOCK("mdomz-phonelink_lock", '\ue4c6'),
    PHONELINK_OFF("mdomz-phonelink_off", '\ue4c7'),
    PHONELINK_RING("mdomz-phonelink_ring", '\ue4c9'),
    PHONELINK_SETUP("mdomz-phonelink_setup", '\ue4cb'),
    PHOTO("mdomz-photo", '\ue4cc'),
    PHOTO_ALBUM("mdomz-photo_album", '\ue4ce'),
    PHOTO_CAMERA("mdomz-photo_camera", '\ue4d0'),
    PHOTO_FILTER("mdomz-photo_filter", '\ue4d2'),
    PHOTO_LIBRARY("mdomz-photo_library", '\ue4d3'),
    PHOTO_SIZE_SELECT_ACTUAL("mdomz-photo_size_select_actual", '\ue4d5'),
    PHOTO_SIZE_SELECT_LARGE("mdomz-photo_size_select_large", '\ue4d7'),
    PHOTO_SIZE_SELECT_SMALL("mdomz-photo_size_select_small", '\ue4d8'),
    PICTURE_AS_PDF("mdomz-picture_as_pdf", '\ue4d9'),
    PICTURE_IN_PICTURE("mdomz-picture_in_picture", '\ue4db'),
    PICTURE_IN_PICTURE_ALT("mdomz-picture_in_picture_alt", '\ue4dd'),
    PIE_CHART("mdomz-pie_chart", '\ue4df'),
    PIN("mdomz-pin", '\ue4e1'),
    PIN_DROP("mdomz-pin_drop", '\ue4e3'),
    PIN_OFF("mdomz-pin_off", '\ue4e5'),
    PLACE("mdomz-place", '\ue4e7'),
    PLAGIARISM("mdomz-plagiarism", '\ue807'),
    PLAY_ARROW("mdomz-play_arrow", '\ue4e9'),
    PLAY_CIRCLE_FILLED("mdomz-play_circle_filled", '\ue4eb'),
    PLAY_CIRCLE_FILLED_WHITE("mdomz-play_circle_filled_white", '\ue4ed'),
    PLAY_CIRCLE_OUTLINE("mdomz-play_circle_outline", '\ue4ef'),
    PLAY_FOR_WORK("mdomz-play_for_work", '\ue4f0'),
    PLAYLIST_ADD("mdomz-playlist_add", '\ue4f1'),
    PLAYLIST_ADD_CHECK("mdomz-playlist_add_check", '\ue4f2'),
    PLAYLIST_PLAY("mdomz-playlist_play", '\ue4f3'),
    PLUMBING("mdomz-plumbing", '\ue809'),
    PLUS("mdomz-plus", '\ue4f4'),
    PLUS_MINUS("mdomz-plus_minus", '\ue4f5'),
    PLUS_MINUS_ALT("mdomz-plus_minus_alt", '\ue4f6'),
    PLUS_ONE("mdomz-plus_one", '\ue4f7'),
    POINT_OF_SALE("mdomz-point_of_sale", '\ue80a'),
    POLICY("mdomz-policy", '\ue4f8'),
    POLL("mdomz-poll", '\ue4fa'),
    POLYMER("mdomz-polymer", '\ue4fc'),
    POOL("mdomz-pool", '\ue4fd'),
    PORTABLE_WIFI_OFF("mdomz-portable_wifi_off", '\ue4ff'),
    PORTRAIT("mdomz-portrait", '\ue500'),
    POST_ADD("mdomz-post_add", '\ue502'),
    POWER("mdomz-power", '\ue503'),
    POWER_INPUT("mdomz-power_input", '\ue505'),
    POWER_OFF("mdomz-power_off", '\ue506'),
    POWER_SETTINGS_NEW("mdomz-power_settings_new", '\ue508'),
    PREGNANT_WOMAN("mdomz-pregnant_woman", '\ue509'),
    PRESENT_TO_ALL("mdomz-present_to_all", '\ue50a'),
    PREVIEW("mdomz-preview", '\ue80c'),
    PRINT("mdomz-print", '\ue50c'),
    PRINT_DISABLED("mdomz-print_disabled", '\ue50e'),
    PRIORITY_HIGH("mdomz-priority_high", '\ue510'),
    PRIVACY_TIP("mdomz-privacy_tip", '\ue80e'),
    PSYCHOLOGY("mdomz-psychology", '\ue810'),
    PUBLIC("mdomz-public", '\ue511'),
    PUBLIC_OFF("mdomz-public_off", '\ue812'),
    PUBLISH("mdomz-publish", '\ue513'),
    PUBLISHED_WITH_CHANGES("mdomz-published_with_changes", '\ue8c4'),
    PUSH_PIN("mdomz-push_pin", '\ue814'),
    QR_CODE("mdomz-qr_code", '\ue816'),
    QR_CODE_2("mdomz-qr_code_2", '\ue8d1'),
    QR_CODE_SCANNER("mdomz-qr_code_scanner", '\ue885'),
    QRCODE("mdomz-qrcode", '\ue515'),
    QUERY_BUILDER("mdomz-query_builder", '\ue517'),
    QUESTION_ANSWER("mdomz-question_answer", '\ue519'),
    QUEUE("mdomz-queue", '\ue51b'),
    QUEUE_MUSIC("mdomz-queue_music", '\ue51d'),
    QUEUE_PLAY_NEXT("mdomz-queue_play_next", '\ue51f'),
    QUICKREPLY("mdomz-quickreply", '\ue818'),
    RADIO("mdomz-radio", '\ue520'),
    RADIO_BUTTON_CHECKED("mdomz-radio_button_checked", '\ue522'),
    RADIO_BUTTON_UNCHECKED("mdomz-radio_button_unchecked", '\ue523'),
    RATE_REVIEW("mdomz-rate_review", '\ue524'),
    READ_MORE("mdomz-read_more", '\ue81a'),
    RECEIPT("mdomz-receipt", '\ue526'),
    RECEIPT_LONG("mdomz-receipt_long", '\ue81b'),
    RECENT_ACTORS("mdomz-recent_actors", '\ue528'),
    RECORD_VOICE_OVER("mdomz-record_voice_over", '\ue52a'),
    REDEEM("mdomz-redeem", '\ue52c'),
    REDO("mdomz-redo", '\ue52e'),
    REDUCE_CAPACITY("mdomz-reduce_capacity", '\ue8af'),
    REFRESH("mdomz-refresh", '\ue52f'),
    REMOVE("mdomz-remove", '\ue530'),
    REMOVE_CIRCLE("mdomz-remove_circle", '\ue531'),
    REMOVE_CIRCLE_OUTLINE("mdomz-remove_circle_outline", '\ue533'),
    REMOVE_FROM_QUEUE("mdomz-remove_from_queue", '\ue534'),
    REMOVE_RED_EYE("mdomz-remove_red_eye", '\ue536'),
    REMOVE_SHOPPING_CART("mdomz-remove_shopping_cart", '\ue538'),
    REORDER("mdomz-reorder", '\ue53a'),
    REPEAT("mdomz-repeat", '\ue53b'),
    REPEAT_ONE("mdomz-repeat_one", '\ue53c'),
    REPLAY("mdomz-replay", '\ue53d'),
    REPLAY_10("mdomz-replay_10", '\ue53e'),
    REPLAY_30("mdomz-replay_30", '\ue53f'),
    REPLAY_5("mdomz-replay_5", '\ue540'),
    REPLY("mdomz-reply", '\ue541'),
    REPLY_ALL("mdomz-reply_all", '\ue542'),
    REPORT("mdomz-report", '\ue543'),
    REPORT_OFF("mdomz-report_off", '\ue545'),
    REPORT_PROBLEM("mdomz-report_problem", '\ue547'),
    REQUEST_PAGE("mdomz-request_page", '\ue8c5'),
    REQUEST_QUOTE("mdomz-request_quote", '\ue81d'),
    RESTAURANT("mdomz-restaurant", '\ue549'),
    RESTAURANT_MENU("mdomz-restaurant_menu", '\ue54a'),
    RESTORE("mdomz-restore", '\ue54b'),
    RESTORE_FROM_TRASH("mdomz-restore_from_trash", '\ue54c'),
    RESTORE_PAGE("mdomz-restore_page", '\ue54e'),
    RICE_BOWL("mdomz-rice_bowl", '\ue886'),
    RING_VOLUME("mdomz-ring_volume", '\ue550'),
    ROCKET("mdomz-rocket", '\ue552'),
    ROOFING("mdomz-roofing", '\ue888'),
    ROOM("mdomz-room", '\ue554'),
    ROOM_PREFERENCES("mdomz-room_preferences", '\ue81f'),
    ROOM_SERVICE("mdomz-room_service", '\ue556'),
    ROTATE_90_DEGREES_CCW("mdomz-rotate_90_degrees_ccw", '\ue558'),
    ROTATE_LEFT("mdomz-rotate_left", '\ue55a'),
    ROTATE_RIGHT("mdomz-rotate_right", '\ue55b'),
    ROUNDED_CORNER("mdomz-rounded_corner", '\ue55c'),
    ROUTER("mdomz-router", '\ue55d'),
    ROWING("mdomz-rowing", '\ue55f'),
    RSS_FEED("mdomz-rss_feed", '\ue560'),
    RULE("mdomz-rule", '\ue821'),
    RULE_FOLDER("mdomz-rule_folder", '\ue822'),
    RUN_CIRCLE("mdomz-run_circle", '\ue824'),
    RV_HOOKUP("mdomz-rv_hookup", '\ue561'),
    SANITIZER("mdomz-sanitizer", '\ue8b0'),
    SATELLITE("mdomz-satellite", '\ue563'),
    SAVE("mdomz-save", '\ue565'),
    SAVE_ALT("mdomz-save_alt", '\ue567'),
    SCANNER("mdomz-scanner", '\ue568'),
    SCATTER_PLOT("mdomz-scatter_plot", '\ue56a'),
    SCHEDULE("mdomz-schedule", '\ue56c'),
    SCHOOL("mdomz-school", '\ue56e'),
    SCIENCE("mdomz-science", '\ue826'),
    SCORE("mdomz-score", '\ue570'),
    SCREEN_LOCK_LANDSCAPE("mdomz-screen_lock_landscape", '\ue572'),
    SCREEN_LOCK_PORTRAIT("mdomz-screen_lock_portrait", '\ue574'),
    SCREEN_LOCK_ROTATION("mdomz-screen_lock_rotation", '\ue576'),
    SCREEN_ROTATION("mdomz-screen_rotation", '\ue577'),
    SCREEN_SHARE("mdomz-screen_share", '\ue579'),
    SD_CARD("mdomz-sd_card", '\ue57b'),
    SD_STORAGE("mdomz-sd_storage", '\ue57d'),
    SEARCH("mdomz-search", '\ue57f'),
    SEARCH_OFF("mdomz-search_off", '\ue828'),
    SECURITY("mdomz-security", '\ue580'),
    SELECT_ALL("mdomz-select_all", '\ue582'),
    SELF_IMPROVEMENT("mdomz-self_improvement", '\ue829'),
    SEND("mdomz-send", '\ue583'),
    SENSOR_DOOR("mdomz-sensor_door", '\ue82a'),
    SENSOR_WINDOW("mdomz-sensor_window", '\ue82c'),
    SENTIMENT_DISSATISFIED("mdomz-sentiment_dissatisfied", '\ue585'),
    SENTIMENT_NEUTRAL("mdomz-sentiment_neutral", '\ue587'),
    SENTIMENT_SATISFIED("mdomz-sentiment_satisfied", '\ue589'),
    SENTIMENT_SATISFIED_ALT("mdomz-sentiment_satisfied_alt", '\ue58b'),
    SENTIMENT_SLIGHTLY_DISSATISFIED("mdomz-sentiment_slightly_dissatisfied", '\ue58d'),
    SENTIMENT_VERY_DISSATISFIED("mdomz-sentiment_very_dissatisfied", '\ue58f'),
    SENTIMENT_VERY_SATISFIED("mdomz-sentiment_very_satisfied", '\ue591'),
    SET_MEAL("mdomz-set_meal", '\ue88a'),
    SETTINGS("mdomz-settings", '\ue593'),
    SETTINGS_APPLICATIONS("mdomz-settings_applications", '\ue595'),
    SETTINGS_BACKUP_RESTORE("mdomz-settings_backup_restore", '\ue597'),
    SETTINGS_BLUETOOTH("mdomz-settings_bluetooth", '\ue598'),
    SETTINGS_BRIGHTNESS("mdomz-settings_brightness", '\ue599'),
    SETTINGS_CELL("mdomz-settings_cell", '\ue59b'),
    SETTINGS_ETHERNET("mdomz-settings_ethernet", '\ue59d'),
    SETTINGS_INPUT_ANTENNA("mdomz-settings_input_antenna", '\ue59e'),
    SETTINGS_INPUT_COMPONENT("mdomz-settings_input_component", '\ue59f'),
    SETTINGS_INPUT_COMPOSITE("mdomz-settings_input_composite", '\ue5a1'),
    SETTINGS_INPUT_HDMI("mdomz-settings_input_hdmi", '\ue5a3'),
    SETTINGS_INPUT_SVIDEO("mdomz-settings_input_svideo", '\ue5a5'),
    SETTINGS_OVERSCAN("mdomz-settings_overscan", '\ue5a7'),
    SETTINGS_PHONE("mdomz-settings_phone", '\ue5a9'),
    SETTINGS_POWER("mdomz-settings_power", '\ue5ab'),
    SETTINGS_REMOTE("mdomz-settings_remote", '\ue5ac'),
    SETTINGS_SYSTEM_DAYDREAM("mdomz-settings_system_daydream", '\ue5ae'),
    SETTINGS_VOICE("mdomz-settings_voice", '\ue5b0'),
    SHARE("mdomz-share", '\ue5b2'),
    SHOP("mdomz-shop", '\ue5b4'),
    SHOP_TWO("mdomz-shop_two", '\ue5b6'),
    SHOPPING_BAG("mdomz-shopping_bag", '\ue82e'),
    SHOPPING_BASKET("mdomz-shopping_basket", '\ue5b8'),
    SHOPPING_CART("mdomz-shopping_cart", '\ue5ba'),
    SHORT_TEXT("mdomz-short_text", '\ue5bc'),
    SHOW_CHART("mdomz-show_chart", '\ue5bd'),
    SHUFFLE("mdomz-shuffle", '\ue5be'),
    SHUTTER_SPEED("mdomz-shutter_speed", '\ue5bf'),
    SICK("mdomz-sick", '\ue8b2'),
    SIGNAL_CELLULAR_0_BAR("mdomz-signal_cellular_0_bar", '\ue5c1'),
    SIGNAL_CELLULAR_1_BAR("mdomz-signal_cellular_1_bar", '\ue5c3'),
    SIGNAL_CELLULAR_2_BAR("mdomz-signal_cellular_2_bar", '\ue5c5'),
    SIGNAL_CELLULAR_3_BAR("mdomz-signal_cellular_3_bar", '\ue5c7'),
    SIGNAL_CELLULAR_4_BAR("mdomz-signal_cellular_4_bar", '\ue5c9'),
    SIGNAL_CELLULAR_ALT("mdomz-signal_cellular_alt", '\ue5ca'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR("mdomz-signal_cellular_connected_no_internet_0_bar", '\ue5cb'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR("mdomz-signal_cellular_connected_no_internet_1_bar", '\ue5cd'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR("mdomz-signal_cellular_connected_no_internet_2_bar", '\ue5cf'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR("mdomz-signal_cellular_connected_no_internet_3_bar", '\ue5d1'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("mdomz-signal_cellular_connected_no_internet_4_bar", '\ue5d3'),
    SIGNAL_CELLULAR_NO_SIM("mdomz-signal_cellular_no_sim", '\ue5d4'),
    SIGNAL_CELLULAR_NULL("mdomz-signal_cellular_null", '\ue5d6'),
    SIGNAL_CELLULAR_OFF("mdomz-signal_cellular_off", '\ue5d7'),
    SIGNAL_WIFI_0_BAR("mdomz-signal_wifi_0_bar", '\ue5d8'),
    SIGNAL_WIFI_1_BAR("mdomz-signal_wifi_1_bar", '\ue5da'),
    SIGNAL_WIFI_1_BAR_LOCK("mdomz-signal_wifi_1_bar_lock", '\ue5dc'),
    SIGNAL_WIFI_2_BAR("mdomz-signal_wifi_2_bar", '\ue5de'),
    SIGNAL_WIFI_2_BAR_LOCK("mdomz-signal_wifi_2_bar_lock", '\ue5e0'),
    SIGNAL_WIFI_3_BAR("mdomz-signal_wifi_3_bar", '\ue5e2'),
    SIGNAL_WIFI_3_BAR_LOCK("mdomz-signal_wifi_3_bar_lock", '\ue5e4'),
    SIGNAL_WIFI_4_BAR("mdomz-signal_wifi_4_bar", '\ue5e6'),
    SIGNAL_WIFI_4_BAR_LOCK("mdomz-signal_wifi_4_bar_lock", '\ue5e7'),
    SIGNAL_WIFI_OFF("mdomz-signal_wifi_off", '\ue5e8'),
    SIM_CARD("mdomz-sim_card", '\ue5e9'),
    SIM_CARD_ALERT("mdomz-sim_card_alert", '\ue5eb'),
    SINGLE_BED("mdomz-single_bed", '\ue5ed'),
    SKIP_NEXT("mdomz-skip_next", '\ue5ef'),
    SKIP_PREVIOUS("mdomz-skip_previous", '\ue5f1'),
    SLIDESHOW("mdomz-slideshow", '\ue5f3'),
    SLOW_MOTION_VIDEO("mdomz-slow_motion_video", '\ue5f5'),
    SMART_BUTTON("mdomz-smart_button", '\ue830'),
    SMARTPHONE("mdomz-smartphone", '\ue5f6'),
    SMOKE_FREE("mdomz-smoke_free", '\ue5f8'),
    SMOKING_ROOMS("mdomz-smoking_rooms", '\ue5f9'),
    SMS("mdomz-sms", '\ue5fb'),
    SMS_FAILED("mdomz-sms_failed", '\ue5fd'),
    SNIPPET_FOLDER("mdomz-snippet_folder", '\ue831'),
    SNOOZE("mdomz-snooze", '\ue5ff'),
    SOAP("mdomz-soap", '\ue833'),
    SORT("mdomz-sort", '\ue600'),
    SORT_BY_ALPHA("mdomz-sort_by_alpha", '\ue601'),
    SOURCE("mdomz-source", '\ue835'),
    SOUTH("mdomz-south", '\ue88c'),
    SOUTH_EAST("mdomz-south_east", '\ue88d'),
    SOUTH_WEST("mdomz-south_west", '\ue88e'),
    SPA("mdomz-spa", '\ue602'),
    SPACE_BAR("mdomz-space_bar", '\ue604'),
    SPEAKER("mdomz-speaker", '\ue605'),
    SPEAKER_GROUP("mdomz-speaker_group", '\ue607'),
    SPEAKER_NOTES("mdomz-speaker_notes", '\ue609'),
    SPEAKER_NOTES_OFF("mdomz-speaker_notes_off", '\ue60b'),
    SPEAKER_PHONE("mdomz-speaker_phone", '\ue60d'),
    SPEED("mdomz-speed", '\ue60f'),
    SPELLCHECK("mdomz-spellcheck", '\ue610'),
    SPORTS("mdomz-sports", '\ue611'),
    SPORTS_BAR("mdomz-sports_bar", '\ue88f'),
    SPORTS_BASEBALL("mdomz-sports_baseball", '\ue612'),
    SPORTS_BASKETBALL("mdomz-sports_basketball", '\ue614'),
    SPORTS_CRICKET("mdomz-sports_cricket", '\ue616'),
    SPORTS_ESPORTS("mdomz-sports_esports", '\ue618'),
    SPORTS_FOOTBALL("mdomz-sports_football", '\ue61a'),
    SPORTS_GOLF("mdomz-sports_golf", '\ue61c'),
    SPORTS_HANDBALL("mdomz-sports_handball", '\ue61e'),
    SPORTS_HOCKEY("mdomz-sports_hockey", '\ue61f'),
    SPORTS_KABADDI("mdomz-sports_kabaddi", '\ue620'),
    SPORTS_MMA("mdomz-sports_mma", '\ue621'),
    SPORTS_MOTORSPORTS("mdomz-sports_motorsports", '\ue623'),
    SPORTS_RUGBY("mdomz-sports_rugby", '\ue625'),
    SPORTS_SOCCER("mdomz-sports_soccer", '\ue627'),
    SPORTS_TENNIS("mdomz-sports_tennis", '\ue629'),
    SPORTS_VOLLEYBALL("mdomz-sports_volleyball", '\ue62a'),
    SQUARE_FOOT("mdomz-square_foot", '\ue62c'),
    STACKED_LINE_CHART("mdomz-stacked_line_chart", '\ue8c7'),
    STAIRS("mdomz-stairs", '\ue837'),
    STAR("mdomz-star", '\ue62e'),
    STAR_BORDER("mdomz-star_border", '\ue630'),
    STAR_HALF("mdomz-star_half", '\ue631'),
    STAR_OUTLINE("mdomz-star_outline", '\ue748'),
    STAR_RATE("mdomz-star_rate", '\ue632'),
    STARS("mdomz-stars", '\ue633'),
    STAY_CURRENT_LANDSCAPE("mdomz-stay_current_landscape", '\ue635'),
    STAY_CURRENT_PORTRAIT("mdomz-stay_current_portrait", '\ue637'),
    STAY_PRIMARY_LANDSCAPE("mdomz-stay_primary_landscape", '\ue639'),
    STAY_PRIMARY_PORTRAIT("mdomz-stay_primary_portrait", '\ue63b'),
    STICKY_NOTE_2("mdomz-sticky_note_2", '\ue891'),
    STOP("mdomz-stop", '\ue63d'),
    STOP_CIRCLE("mdomz-stop_circle", '\ue63f'),
    STOP_SCREEN_SHARE("mdomz-stop_screen_share", '\ue641'),
    STORAGE("mdomz-storage", '\ue643'),
    STORE("mdomz-store", '\ue644'),
    STORE_MALL_DIRECTORY("mdomz-store_mall_directory", '\ue646'),
    STOREFRONT("mdomz-storefront", '\ue648'),
    STRAIGHTEN("mdomz-straighten", '\ue64a'),
    STREETVIEW("mdomz-streetview", '\ue64c'),
    STRIKETHROUGH_S("mdomz-strikethrough_s", '\ue64d'),
    STROLLER("mdomz-stroller", '\ue839'),
    STYLE("mdomz-style", '\ue64e'),
    SUBDIRECTORY_ARROW_LEFT("mdomz-subdirectory_arrow_left", '\ue650'),
    SUBDIRECTORY_ARROW_RIGHT("mdomz-subdirectory_arrow_right", '\ue651'),
    SUBJECT("mdomz-subject", '\ue652'),
    SUBSCRIPT("mdomz-subscript", '\ue83b'),
    SUBSCRIPTIONS("mdomz-subscriptions", '\ue653'),
    SUBTITLES("mdomz-subtitles", '\ue655'),
    SUBTITLES_OFF("mdomz-subtitles_off", '\ue83c'),
    SUBWAY("mdomz-subway", '\ue657'),
    SUPERSCRIPT("mdomz-superscript", '\ue83e'),
    SUPERVISED_USER_CIRCLE("mdomz-supervised_user_circle", '\ue659'),
    SUPERVISOR_ACCOUNT("mdomz-supervisor_account", '\ue65b'),
    SUPPORT("mdomz-support", '\ue83f'),
    SUPPORT_AGENT("mdomz-support_agent", '\ue841'),
    SURROUND_SOUND("mdomz-surround_sound", '\ue65d'),
    SWAP_CALLS("mdomz-swap_calls", '\ue65f'),
    SWAP_HORIZ("mdomz-swap_horiz", '\ue660'),
    SWAP_HORIZONTAL_CIRCLE("mdomz-swap_horizontal_circle", '\ue661'),
    SWAP_VERT("mdomz-swap_vert", '\ue663'),
    SWAP_VERTICAL_CIRCLE("mdomz-swap_vertical_circle", '\ue664'),
    SWITCH_CAMERA("mdomz-switch_camera", '\ue666'),
    SWITCH_LEFT("mdomz-switch_left", '\ue842'),
    SWITCH_RIGHT("mdomz-switch_right", '\ue844'),
    SWITCH_VIDEO("mdomz-switch_video", '\ue668'),
    SYNC("mdomz-sync", '\ue66a'),
    SYNC_ALT("mdomz-sync_alt", '\ue66b'),
    SYNC_DISABLED("mdomz-sync_disabled", '\ue66c'),
    SYNC_PROBLEM("mdomz-sync_problem", '\ue66d'),
    SYSTEM_UPDATE("mdomz-system_update", '\ue66e'),
    SYSTEM_UPDATE_ALT("mdomz-system_update_alt", '\ue670'),
    TAB("mdomz-tab", '\ue671'),
    TAB_UNSELECTED("mdomz-tab_unselected", '\ue672'),
    TABLE_CHART("mdomz-table_chart", '\ue673'),
    TABLE_ROWS("mdomz-table_rows", '\ue846'),
    TABLE_VIEW("mdomz-table_view", '\ue848'),
    TABLET("mdomz-tablet", '\ue675'),
    TABLET_ANDROID("mdomz-tablet_android", '\ue677'),
    TABLET_MAC("mdomz-tablet_mac", '\ue679'),
    TAG_FACES("mdomz-tag_faces", '\ue67b'),
    TAP_AND_PLAY("mdomz-tap_and_play", '\ue67d'),
    TAPAS("mdomz-tapas", '\ue893'),
    TERRAIN("mdomz-terrain", '\ue67e'),
    TEXT_FIELDS("mdomz-text_fields", '\ue680'),
    TEXT_FORMAT("mdomz-text_format", '\ue681'),
    TEXT_ROTATE_UP("mdomz-text_rotate_up", '\ue682'),
    TEXT_ROTATE_VERTICAL("mdomz-text_rotate_vertical", '\ue683'),
    TEXT_ROTATION_ANGLEDOWN("mdomz-text_rotation_angledown", '\ue684'),
    TEXT_ROTATION_ANGLEUP("mdomz-text_rotation_angleup", '\ue685'),
    TEXT_ROTATION_DOWN("mdomz-text_rotation_down", '\ue686'),
    TEXT_ROTATION_NONE("mdomz-text_rotation_none", '\ue687'),
    TEXT_SNIPPET("mdomz-text_snippet", '\ue84a'),
    TEXTSMS("mdomz-textsms", '\ue688'),
    TEXTURE("mdomz-texture", '\ue68a'),
    THEATERS("mdomz-theaters", '\ue68b'),
    THUMB_DOWN("mdomz-thumb_down", '\ue68d'),
    THUMB_DOWN_ALT("mdomz-thumb_down_alt", '\ue68f'),
    THUMB_UP("mdomz-thumb_up", '\ue691'),
    THUMB_UP_ALT("mdomz-thumb_up_alt", '\ue693'),
    THUMBS_UP_DOWN("mdomz-thumbs_up_down", '\ue695'),
    TIME_TO_LEAVE("mdomz-time_to_leave", '\ue697'),
    TIMELAPSE("mdomz-timelapse", '\ue699'),
    TIMELINE("mdomz-timeline", '\ue69b'),
    TIMER("mdomz-timer", '\ue69c'),
    TIMER_10("mdomz-timer_10", '\ue69e'),
    TIMER_3("mdomz-timer_3", '\ue69f'),
    TIMER_OFF("mdomz-timer_off", '\ue6a0'),
    TITLE("mdomz-title", '\ue6a2'),
    TOC("mdomz-toc", '\ue6a3'),
    TODAY("mdomz-today", '\ue6a4'),
    TOGGLE_OFF("mdomz-toggle_off", '\ue6a6'),
    TOGGLE_ON("mdomz-toggle_on", '\ue6a8'),
    TOLL("mdomz-toll", '\ue6aa'),
    TONALITY("mdomz-tonality", '\ue6ac'),
    TOPIC("mdomz-topic", '\ue84c'),
    TOUCH_APP("mdomz-touch_app", '\ue6ae'),
    TOUR("mdomz-tour", '\ue84e'),
    TOYS("mdomz-toys", '\ue6b0'),
    TRACK_CHANGES("mdomz-track_changes", '\ue6b2'),
    TRAFFIC("mdomz-traffic", '\ue6b3'),
    TRAIN("mdomz-train", '\ue6b5'),
    TRAM("mdomz-tram", '\ue6b7'),
    TRANSFER_WITHIN_A_STATION("mdomz-transfer_within_a_station", '\ue6b9'),
    TRANSFORM("mdomz-transform", '\ue6ba'),
    TRANSIT_ENTEREXIT("mdomz-transit_enterexit", '\ue6bb'),
    TRANSLATE("mdomz-translate", '\ue6bc'),
    TRENDING_DOWN("mdomz-trending_down", '\ue6bd'),
    TRENDING_FLAT("mdomz-trending_flat", '\ue6be'),
    TRENDING_UP("mdomz-trending_up", '\ue6bf'),
    TRIP_ORIGIN("mdomz-trip_origin", '\ue6c0'),
    TTY("mdomz-tty", '\ue850'),
    TUNE("mdomz-tune", '\ue6c1'),
    TURNED_IN("mdomz-turned_in", '\ue6c2'),
    TURNED_IN_NOT("mdomz-turned_in_not", '\ue6c4'),
    TV("mdomz-tv", '\ue6c5'),
    TV_OFF("mdomz-tv_off", '\ue6c7'),
    TWO_WHEELER("mdomz-two_wheeler", '\ue749'),
    UMBRELLA("mdomz-umbrella", '\ue852'),
    UNARCHIVE("mdomz-unarchive", '\ue6c9'),
    UNDO("mdomz-undo", '\ue6cb'),
    UNFOLD_LESS("mdomz-unfold_less", '\ue6cc'),
    UNFOLD_MORE("mdomz-unfold_more", '\ue6cd'),
    UNPUBLISHED("mdomz-unpublished", '\ue8c8'),
    UNSUBSCRIBE("mdomz-unsubscribe", '\ue6ce'),
    UPDATE("mdomz-update", '\ue6d0'),
    UPDATE_DISABLED("mdomz-update_disabled", '\ue8d2'),
    UPGRADE("mdomz-upgrade", '\ue854'),
    USB("mdomz-usb", '\ue6d1'),
    VERIFIED("mdomz-verified", '\ue855'),
    VERIFIED_USER("mdomz-verified_user", '\ue6d2'),
    VERTICAL_ALIGN_BOTTOM("mdomz-vertical_align_bottom", '\ue6d4'),
    VERTICAL_ALIGN_CENTER("mdomz-vertical_align_center", '\ue6d5'),
    VERTICAL_ALIGN_TOP("mdomz-vertical_align_top", '\ue6d6'),
    VERTICAL_DISTRIBUTE("mdomz-vertical_distribute", '\ue8d3'),
    VERTICAL_SPLIT("mdomz-vertical_split", '\ue6d7'),
    VIBRATION("mdomz-vibration", '\ue6d9'),
    VIDEO_CALL("mdomz-video_call", '\ue6db'),
    VIDEO_LABEL("mdomz-video_label", '\ue6dd'),
    VIDEO_LIBRARY("mdomz-video_library", '\ue6df'),
    VIDEO_SETTINGS("mdomz-video_settings", '\ue857'),
    VIDEOCAM("mdomz-videocam", '\ue6e1'),
    VIDEOCAM_OFF("mdomz-videocam_off", '\ue6e3'),
    VIDEOGAME_ASSET("mdomz-videogame_asset", '\ue6e5'),
    VIEW_AGENDA("mdomz-view_agenda", '\ue6e7'),
    VIEW_ARRAY("mdomz-view_array", '\ue6e9'),
    VIEW_CAROUSEL("mdomz-view_carousel", '\ue6eb'),
    VIEW_COLUMN("mdomz-view_column", '\ue6ed'),
    VIEW_COMFY("mdomz-view_comfy", '\ue6ef'),
    VIEW_COMPACT("mdomz-view_compact", '\ue6f1'),
    VIEW_DAY("mdomz-view_day", '\ue6f3'),
    VIEW_HEADLINE("mdomz-view_headline", '\ue6f5'),
    VIEW_LIST("mdomz-view_list", '\ue6f6'),
    VIEW_MODULE("mdomz-view_module", '\ue6f8'),
    VIEW_QUILT("mdomz-view_quilt", '\ue6fa'),
    VIEW_SIDEBAR("mdomz-view_sidebar", '\ue858'),
    VIEW_STREAM("mdomz-view_stream", '\ue6fc'),
    VIEW_WEEK("mdomz-view_week", '\ue6fe'),
    VIGNETTE("mdomz-vignette", '\ue700'),
    VISIBILITY("mdomz-visibility", '\ue702'),
    VISIBILITY_OFF("mdomz-visibility_off", '\ue704'),
    VOICE_CHAT("mdomz-voice_chat", '\ue706'),
    VOICE_OVER_OFF("mdomz-voice_over_off", '\ue708'),
    VOICEMAIL("mdomz-voicemail", '\ue70a'),
    VOLUME_DOWN("mdomz-volume_down", '\ue70b'),
    VOLUME_MUTE("mdomz-volume_mute", '\ue70d'),
    VOLUME_OFF("mdomz-volume_off", '\ue70f'),
    VOLUME_UP("mdomz-volume_up", '\ue711'),
    VPN_KEY("mdomz-vpn_key", '\ue713'),
    VPN_LOCK("mdomz-vpn_lock", '\ue715'),
    WALLPAPER("mdomz-wallpaper", '\ue717'),
    WARNING("mdomz-warning", '\ue718'),
    WASH("mdomz-wash", '\ue85a'),
    WATCH("mdomz-watch", '\ue71a'),
    WATCH_LATER("mdomz-watch_later", '\ue71c'),
    WATER_DAMAGE("mdomz-water_damage", '\ue895'),
    WAVES("mdomz-waves", '\ue71e'),
    WB_AUTO("mdomz-wb_auto", '\ue71f'),
    WB_CLOUDY("mdomz-wb_cloudy", '\ue721'),
    WB_INCANDESCENT("mdomz-wb_incandescent", '\ue723'),
    WB_IRIDESCENT("mdomz-wb_iridescent", '\ue725'),
    WB_SUNNY("mdomz-wb_sunny", '\ue727'),
    WC("mdomz-wc", '\ue729'),
    WEB("mdomz-web", '\ue72a'),
    WEB_ASSET("mdomz-web_asset", '\ue72c'),
    WEEKEND("mdomz-weekend", '\ue72e'),
    WEST("mdomz-west", '\ue897'),
    WHATSHOT("mdomz-whatshot", '\ue730'),
    WHEELCHAIR_PICKUP("mdomz-wheelchair_pickup", '\ue85c'),
    WHERE_TO_VOTE("mdomz-where_to_vote", '\ue732'),
    WIDGETS("mdomz-widgets", '\ue734'),
    WIFI("mdomz-wifi", '\ue736'),
    WIFI_CALLING("mdomz-wifi_calling", '\ue85d'),
    WIFI_LOCK("mdomz-wifi_lock", '\ue737'),
    WIFI_OFF("mdomz-wifi_off", '\ue738'),
    WIFI_PROTECTED_SETUP("mdomz-wifi_protected_setup", '\ue85f'),
    WIFI_TETHERING("mdomz-wifi_tethering", '\ue739'),
    WINE_BAR("mdomz-wine_bar", '\ue898'),
    WORK("mdomz-work", '\ue73a'),
    WORK_OFF("mdomz-work_off", '\ue73c'),
    WORK_OUTLINE("mdomz-work_outline", '\ue73e'),
    WRAP_TEXT("mdomz-wrap_text", '\ue73f'),
    WRONG_LOCATION("mdomz-wrong_location", '\ue860'),
    WYSIWYG("mdomz-wysiwyg", '\ue861'),
    YOUTUBE_SEARCHED_FOR("mdomz-youtube_searched_for", '\ue740'),
    ZOOM_IN("mdomz-zoom_in", '\ue741'),
    ZOOM_OUT("mdomz-zoom_out", '\ue742'),
    ZOOM_OUT_MAP("mdomz-zoom_out_map", '\ue743');
    
    public static Material2OutlinedMZ findByDescription(String description) {
        for (Material2OutlinedMZ font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2OutlinedMZ(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}