/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2RoundAL implements Ikon {
    MDRAL_360("mdral-360", '\ue000'),
    MDRAL_3D_ROTATION("mdral-3d_rotation", '\ue001'),
    MDRAL_4K("mdral-4k", '\ue002'),
    MDRAL_5G("mdral-5g", '\ue74a'),
    MDRAL_6_FT_APART("mdral-6_ft_apart", '\ue89a'),
    AC_UNIT("mdral-ac_unit", '\ue004'),
    ACCESS_ALARM("mdral-access_alarm", '\ue005'),
    ACCESS_ALARMS("mdral-access_alarms", '\ue007'),
    ACCESS_TIME("mdral-access_time", '\ue009'),
    ACCESSIBILITY("mdral-accessibility", '\ue00b'),
    ACCESSIBILITY_NEW("mdral-accessibility_new", '\ue00c'),
    ACCESSIBLE("mdral-accessible", '\ue00d'),
    ACCESSIBLE_FORWARD("mdral-accessible_forward", '\ue00e'),
    ACCOUNT_BALANCE("mdral-account_balance", '\ue00f'),
    ACCOUNT_BALANCE_WALLET("mdral-account_balance_wallet", '\ue011'),
    ACCOUNT_BOX("mdral-account_box", '\ue013'),
    ACCOUNT_CIRCLE("mdral-account_circle", '\ue015'),
    ACCOUNT_TREE("mdral-account_tree", '\ue017'),
    AD_UNITS("mdral-ad_units", '\ue74b'),
    ADB("mdral-adb", '\ue019'),
    ADD("mdral-add", '\ue01a'),
    ADD_A_PHOTO("mdral-add_a_photo", '\ue01b'),
    ADD_ALARM("mdral-add_alarm", '\ue01d'),
    ADD_ALERT("mdral-add_alert", '\ue01f'),
    ADD_BOX("mdral-add_box", '\ue021'),
    ADD_BUSINESS("mdral-add_business", '\ue74d'),
    ADD_CIRCLE("mdral-add_circle", '\ue023'),
    ADD_CIRCLE_OUTLINE("mdral-add_circle_outline", '\ue025'),
    ADD_COMMENT("mdral-add_comment", '\ue026'),
    ADD_IC_CALL("mdral-add_ic_call", '\ue744'),
    ADD_LOCATION("mdral-add_location", '\ue028'),
    ADD_LOCATION_ALT("mdral-add_location_alt", '\ue74f'),
    ADD_PHOTO_ALTERNATE("mdral-add_photo_alternate", '\ue02a'),
    ADD_ROAD("mdral-add_road", '\ue751'),
    ADD_SHOPPING_CART("mdral-add_shopping_cart", '\ue02c'),
    ADD_TASK("mdral-add_task", '\ue8b3'),
    ADD_TO_HOME_SCREEN("mdral-add_to_home_screen", '\ue02d'),
    ADD_TO_PHOTOS("mdral-add_to_photos", '\ue02e'),
    ADD_TO_QUEUE("mdral-add_to_queue", '\ue030'),
    ADDCHART("mdral-addchart", '\ue752'),
    ADJUST("mdral-adjust", '\ue032'),
    ADMIN_PANEL_SETTINGS("mdral-admin_panel_settings", '\ue753'),
    AGRICULTURE("mdral-agriculture", '\ue755'),
    AIRLINE_SEAT_FLAT("mdral-airline_seat_flat", '\ue033'),
    AIRLINE_SEAT_FLAT_ANGLED("mdral-airline_seat_flat_angled", '\ue035'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("mdral-airline_seat_individual_suite", '\ue037'),
    AIRLINE_SEAT_LEGROOM_EXTRA("mdral-airline_seat_legroom_extra", '\ue039'),
    AIRLINE_SEAT_LEGROOM_NORMAL("mdral-airline_seat_legroom_normal", '\ue03a'),
    AIRLINE_SEAT_LEGROOM_REDUCED("mdral-airline_seat_legroom_reduced", '\ue03b'),
    AIRLINE_SEAT_RECLINE_EXTRA("mdral-airline_seat_recline_extra", '\ue03c'),
    AIRLINE_SEAT_RECLINE_NORMAL("mdral-airline_seat_recline_normal", '\ue03d'),
    AIRPLANEMODE_ACTIVE("mdral-airplanemode_active", '\ue03e'),
    AIRPLANEMODE_INACTIVE("mdral-airplanemode_inactive", '\ue03f'),
    AIRPLAY("mdral-airplay", '\ue040'),
    AIRPORT_SHUTTLE("mdral-airport_shuttle", '\ue041'),
    ALARM("mdral-alarm", '\ue043'),
    ALARM_ADD("mdral-alarm_add", '\ue045'),
    ALARM_OFF("mdral-alarm_off", '\ue047'),
    ALARM_ON("mdral-alarm_on", '\ue048'),
    ALBUM("mdral-album", '\ue04a'),
    ALIGN_HORIZONTAL_CENTER("mdral-align_horizontal_center", '\ue8ca'),
    ALIGN_HORIZONTAL_LEFT("mdral-align_horizontal_left", '\ue8cb'),
    ALIGN_HORIZONTAL_RIGHT("mdral-align_horizontal_right", '\ue8cc'),
    ALIGN_VERTICAL_BOTTOM("mdral-align_vertical_bottom", '\ue8cd'),
    ALIGN_VERTICAL_CENTER("mdral-align_vertical_center", '\ue8ce'),
    ALIGN_VERTICAL_TOP("mdral-align_vertical_top", '\ue8cf'),
    ALL_INBOX("mdral-all_inbox", '\ue04c'),
    ALL_INCLUSIVE("mdral-all_inclusive", '\ue04e'),
    ALL_OUT("mdral-all_out", '\ue04f'),
    ALT_ROUTE("mdral-alt_route", '\ue757'),
    ALTERNATE_EMAIL("mdral-alternate_email", '\ue051'),
    AMP_STORIES("mdral-amp_stories", '\ue053'),
    ANALYTICS("mdral-analytics", '\ue758'),
    ANCHOR("mdral-anchor", '\ue75a'),
    ANDROID("mdral-android", '\ue055'),
    ANNOUNCEMENT("mdral-announcement", '\ue056'),
    APARTMENT("mdral-apartment", '\ue058'),
    API("mdral-api", '\ue75b'),
    APP_BLOCKING("mdral-app_blocking", '\ue75c'),
    APP_SETTINGS_ALT("mdral-app_settings_alt", '\ue75e'),
    APPS("mdral-apps", '\ue059'),
    ARCHITECTURE("mdral-architecture", '\ue760'),
    ARCHIVE("mdral-archive", '\ue05a'),
    ARROW_BACK("mdral-arrow_back", '\ue05c'),
    ARROW_BACK_IOS("mdral-arrow_back_ios", '\ue05d'),
    ARROW_CIRCLE_DOWN("mdral-arrow_circle_down", '\ue761'),
    ARROW_CIRCLE_UP("mdral-arrow_circle_up", '\ue763'),
    ARROW_DOWNWARD("mdral-arrow_downward", '\ue05e'),
    ARROW_DROP_DOWN("mdral-arrow_drop_down", '\ue05f'),
    ARROW_DROP_DOWN_CIRCLE("mdral-arrow_drop_down_circle", '\ue060'),
    ARROW_DROP_UP("mdral-arrow_drop_up", '\ue062'),
    ARROW_FORWARD("mdral-arrow_forward", '\ue063'),
    ARROW_FORWARD_IOS("mdral-arrow_forward_ios", '\ue064'),
    ARROW_LEFT("mdral-arrow_left", '\ue065'),
    ARROW_RIGHT("mdral-arrow_right", '\ue066'),
    ARROW_RIGHT_ALT("mdral-arrow_right_alt", '\ue067'),
    ARROW_UPWARD("mdral-arrow_upward", '\ue068'),
    ART_TRACK("mdral-art_track", '\ue069'),
    ARTICLE("mdral-article", '\ue765'),
    ASPECT_RATIO("mdral-aspect_ratio", '\ue06a'),
    ASSESSMENT("mdral-assessment", '\ue06c'),
    ASSIGNMENT("mdral-assignment", '\ue06e'),
    ASSIGNMENT_IND("mdral-assignment_ind", '\ue070'),
    ASSIGNMENT_LATE("mdral-assignment_late", '\ue072'),
    ASSIGNMENT_RETURN("mdral-assignment_return", '\ue074'),
    ASSIGNMENT_RETURNED("mdral-assignment_returned", '\ue076'),
    ASSIGNMENT_TURNED_IN("mdral-assignment_turned_in", '\ue078'),
    ASSISTANT("mdral-assistant", '\ue07a'),
    ASSISTANT_PHOTO("mdral-assistant_photo", '\ue07c'),
    ATM("mdral-atm", '\ue07e'),
    ATTACH_EMAIL("mdral-attach_email", '\ue767'),
    ATTACH_FILE("mdral-attach_file", '\ue07f'),
    ATTACH_MONEY("mdral-attach_money", '\ue080'),
    ATTACHMENT("mdral-attachment", '\ue081'),
    AUDIOTRACK("mdral-audiotrack", '\ue082'),
    AUTO_DELETE("mdral-auto_delete", '\ue768'),
    AUTORENEW("mdral-autorenew", '\ue084'),
    AV_TIMER("mdral-av_timer", '\ue085'),
    BABY_CHANGING_STATION("mdral-baby_changing_station", '\ue76a'),
    BACKPACK("mdral-backpack", '\ue76b'),
    BACKSPACE("mdral-backspace", '\ue086'),
    BACKUP("mdral-backup", '\ue088'),
    BACKUP_TABLE("mdral-backup_table", '\ue76d'),
    BALLOT("mdral-ballot", '\ue08a'),
    BAR_CHART("mdral-bar_chart", '\ue08c'),
    BARCODE("mdral-barcode", '\ue08d'),
    BATCH_PREDICTION("mdral-batch_prediction", '\ue76f'),
    BATHTUB("mdral-bathtub", '\ue08e'),
    BATTERY_20("mdral-battery_20", '\ue090'),
    BATTERY_30("mdral-battery_30", '\ue092'),
    BATTERY_50("mdral-battery_50", '\ue094'),
    BATTERY_60("mdral-battery_60", '\ue096'),
    BATTERY_80("mdral-battery_80", '\ue098'),
    BATTERY_90("mdral-battery_90", '\ue09a'),
    BATTERY_ALERT("mdral-battery_alert", '\ue09c'),
    BATTERY_CHARGING_20("mdral-battery_charging_20", '\ue09d'),
    BATTERY_CHARGING_30("mdral-battery_charging_30", '\ue09f'),
    BATTERY_CHARGING_50("mdral-battery_charging_50", '\ue0a1'),
    BATTERY_CHARGING_60("mdral-battery_charging_60", '\ue0a3'),
    BATTERY_CHARGING_80("mdral-battery_charging_80", '\ue0a5'),
    BATTERY_CHARGING_90("mdral-battery_charging_90", '\ue0a7'),
    BATTERY_CHARGING_FULL("mdral-battery_charging_full", '\ue0a9'),
    BATTERY_FULL("mdral-battery_full", '\ue0aa'),
    BATTERY_STD("mdral-battery_std", '\ue0ab'),
    BATTERY_UNKNOWN("mdral-battery_unknown", '\ue0ac'),
    BEACH_ACCESS("mdral-beach_access", '\ue0ad'),
    BEDTIME("mdral-bedtime", '\ue771'),
    BEENHERE("mdral-beenhere", '\ue0af'),
    BENTO("mdral-bento", '\ue864'),
    BIKE_SCOOTER("mdral-bike_scooter", '\ue773'),
    BIOTECH("mdral-biotech", '\ue774'),
    BLOCK("mdral-block", '\ue0b1'),
    BLUETOOTH("mdral-bluetooth", '\ue0b2'),
    BLUETOOTH_AUDIO("mdral-bluetooth_audio", '\ue0b3'),
    BLUETOOTH_CONNECTED("mdral-bluetooth_connected", '\ue0b4'),
    BLUETOOTH_DISABLED("mdral-bluetooth_disabled", '\ue0b5'),
    BLUETOOTH_SEARCHING("mdral-bluetooth_searching", '\ue0b6'),
    BLUR_CIRCULAR("mdral-blur_circular", '\ue0b7'),
    BLUR_LINEAR("mdral-blur_linear", '\ue0b8'),
    BLUR_OFF("mdral-blur_off", '\ue0b9'),
    BLUR_ON("mdral-blur_on", '\ue0ba'),
    BOOK("mdral-book", '\ue0bb'),
    BOOK_ONLINE("mdral-book_online", '\ue89b'),
    BOOKMARK("mdral-bookmark", '\ue0bd'),
    BOOKMARK_BORDER("mdral-bookmark_border", '\ue0bf'),
    BOOKMARKS("mdral-bookmarks", '\ue0c0'),
    BORDER_ALL("mdral-border_all", '\ue0c2'),
    BORDER_BOTTOM("mdral-border_bottom", '\ue0c3'),
    BORDER_CLEAR("mdral-border_clear", '\ue0c4'),
    BORDER_COLOR("mdral-border_color", '\ue0c5'),
    BORDER_HORIZONTAL("mdral-border_horizontal", '\ue0c7'),
    BORDER_INNER("mdral-border_inner", '\ue0c8'),
    BORDER_LEFT("mdral-border_left", '\ue0c9'),
    BORDER_OUTER("mdral-border_outer", '\ue0ca'),
    BORDER_RIGHT("mdral-border_right", '\ue0cb'),
    BORDER_STYLE("mdral-border_style", '\ue0cc'),
    BORDER_TOP("mdral-border_top", '\ue0cd'),
    BORDER_VERTICAL("mdral-border_vertical", '\ue0ce'),
    BRANDING_WATERMARK("mdral-branding_watermark", '\ue0cf'),
    BRIGHTNESS_1("mdral-brightness_1", '\ue0d1'),
    BRIGHTNESS_2("mdral-brightness_2", '\ue0d3'),
    BRIGHTNESS_3("mdral-brightness_3", '\ue0d5'),
    BRIGHTNESS_4("mdral-brightness_4", '\ue0d7'),
    BRIGHTNESS_5("mdral-brightness_5", '\ue0d9'),
    BRIGHTNESS_6("mdral-brightness_6", '\ue0db'),
    BRIGHTNESS_7("mdral-brightness_7", '\ue0dd'),
    BRIGHTNESS_AUTO("mdral-brightness_auto", '\ue0df'),
    BRIGHTNESS_HIGH("mdral-brightness_high", '\ue0e1'),
    BRIGHTNESS_LOW("mdral-brightness_low", '\ue0e3'),
    BRIGHTNESS_MEDIUM("mdral-brightness_medium", '\ue0e5'),
    BROKEN_IMAGE("mdral-broken_image", '\ue0e7'),
    BROWSER_NOT_SUPPORTED("mdral-browser_not_supported", '\ue776'),
    BRUSH("mdral-brush", '\ue0e9'),
    BUBBLE_CHART("mdral-bubble_chart", '\ue0eb'),
    BUG_REPORT("mdral-bug_report", '\ue0ed'),
    BUILD("mdral-build", '\ue0ef'),
    BUILD_CIRCLE("mdral-build_circle", '\ue777'),
    BURST_MODE("mdral-burst_mode", '\ue0f1'),
    BUSINESS("mdral-business", '\ue0f3'),
    BUSINESS_CENTER("mdral-business_center", '\ue0f5'),
    CACHED("mdral-cached", '\ue0f7'),
    CAKE("mdral-cake", '\ue0f8'),
    CALCULATE("mdral-calculate", '\ue779'),
    CALENDAR_TODAY("mdral-calendar_today", '\ue0fa'),
    CALENDAR_VIEW_DAY("mdral-calendar_view_day", '\ue0fc'),
    CALL("mdral-call", '\ue0fe'),
    CALL_END("mdral-call_end", '\ue100'),
    CALL_MADE("mdral-call_made", '\ue102'),
    CALL_MERGE("mdral-call_merge", '\ue103'),
    CALL_MISSED("mdral-call_missed", '\ue104'),
    CALL_MISSED_OUTGOING("mdral-call_missed_outgoing", '\ue105'),
    CALL_RECEIVED("mdral-call_received", '\ue106'),
    CALL_SPLIT("mdral-call_split", '\ue107'),
    CALL_TO_ACTION("mdral-call_to_action", '\ue108'),
    CAMERA("mdral-camera", '\ue10a'),
    CAMERA_ALT("mdral-camera_alt", '\ue10c'),
    CAMERA_ENHANCE("mdral-camera_enhance", '\ue10e'),
    CAMERA_FRONT("mdral-camera_front", '\ue110'),
    CAMERA_REAR("mdral-camera_rear", '\ue112'),
    CAMERA_ROLL("mdral-camera_roll", '\ue114'),
    CAMPAIGN("mdral-campaign", '\ue77b'),
    CANCEL("mdral-cancel", '\ue116'),
    CANCEL_PRESENTATION("mdral-cancel_presentation", '\ue118'),
    CANCEL_SCHEDULE_SEND("mdral-cancel_schedule_send", '\ue11a'),
    CARD_GIFTCARD("mdral-card_giftcard", '\ue11c'),
    CARD_MEMBERSHIP("mdral-card_membership", '\ue11e'),
    CARD_TRAVEL("mdral-card_travel", '\ue120'),
    CARPENTER("mdral-carpenter", '\ue866'),
    CASINO("mdral-casino", '\ue122'),
    CAST("mdral-cast", '\ue124'),
    CAST_CONNECTED("mdral-cast_connected", '\ue125'),
    CAST_FOR_EDUCATION("mdral-cast_for_education", '\ue127'),
    CATEGORY("mdral-category", '\ue128'),
    CELL_WIFI("mdral-cell_wifi", '\ue12a'),
    CENTER_FOCUS_STRONG("mdral-center_focus_strong", '\ue12c'),
    CENTER_FOCUS_WEAK("mdral-center_focus_weak", '\ue12e'),
    CHANGE_HISTORY("mdral-change_history", '\ue130'),
    CHARGING_STATION("mdral-charging_station", '\ue77d'),
    CHAT("mdral-chat", '\ue132'),
    CHAT_BUBBLE("mdral-chat_bubble", '\ue134'),
    CHAT_BUBBLE_OUTLINE("mdral-chat_bubble_outline", '\ue136'),
    CHECK("mdral-check", '\ue137'),
    CHECK_BOX("mdral-check_box", '\ue138'),
    CHECK_BOX_OUTLINE_BLANK("mdral-check_box_outline_blank", '\ue13a'),
    CHECK_CIRCLE("mdral-check_circle", '\ue13b'),
    CHECK_CIRCLE_OUTLINE("mdral-check_circle_outline", '\ue13d'),
    CHECKROOM("mdral-checkroom", '\ue77f'),
    CHEVRON_LEFT("mdral-chevron_left", '\ue13e'),
    CHEVRON_RIGHT("mdral-chevron_right", '\ue13f'),
    CHILD_CARE("mdral-child_care", '\ue140'),
    CHILD_FRIENDLY("mdral-child_friendly", '\ue142'),
    CHROME_READER_MODE("mdral-chrome_reader_mode", '\ue144'),
    CLASS("mdral-class", '\ue146'),
    CLEAN_HANDS("mdral-clean_hands", '\ue89d'),
    CLEANING_SERVICES("mdral-cleaning_services", '\ue780'),
    CLEAR("mdral-clear", '\ue148'),
    CLEAR_ALL("mdral-clear_all", '\ue149'),
    CLOSE("mdral-close", '\ue14a'),
    CLOSE_FULLSCREEN("mdral-close_fullscreen", '\ue782'),
    CLOSED_CAPTION("mdral-closed_caption", '\ue14b'),
    CLOSED_CAPTION_DISABLED("mdral-closed_caption_disabled", '\ue868'),
    CLOUD("mdral-cloud", '\ue14d'),
    CLOUD_CIRCLE("mdral-cloud_circle", '\ue14f'),
    CLOUD_DONE("mdral-cloud_done", '\ue151'),
    CLOUD_DOWNLOAD("mdral-cloud_download", '\ue153'),
    CLOUD_OFF("mdral-cloud_off", '\ue155'),
    CLOUD_QUEUE("mdral-cloud_queue", '\ue157'),
    CLOUD_UPLOAD("mdral-cloud_upload", '\ue159'),
    CODE("mdral-code", '\ue15b'),
    COLLECTIONS("mdral-collections", '\ue15c'),
    COLLECTIONS_BOOKMARK("mdral-collections_bookmark", '\ue15e'),
    COLOR_LENS("mdral-color_lens", '\ue160'),
    COLORIZE("mdral-colorize", '\ue162'),
    COMMENT("mdral-comment", '\ue164'),
    COMMENT_BANK("mdral-comment_bank", '\ue783'),
    COMMUTE("mdral-commute", '\ue166'),
    COMPARE("mdral-compare", '\ue167'),
    COMPARE_ARROWS("mdral-compare_arrows", '\ue169'),
    COMPASS_CALIBRATION("mdral-compass_calibration", '\ue16a'),
    COMPUTER("mdral-computer", '\ue16c'),
    CONFIRMATION_NUMBER("mdral-confirmation_number", '\ue16e'),
    CONNECT_WITHOUT_CONTACT("mdral-connect_without_contact", '\ue89f'),
    CONSTRUCTION("mdral-construction", '\ue785'),
    CONTACT_MAIL("mdral-contact_mail", '\ue170'),
    CONTACT_PAGE("mdral-contact_page", '\ue8b4'),
    CONTACT_PHONE("mdral-contact_phone", '\ue172'),
    CONTACT_SUPPORT("mdral-contact_support", '\ue174'),
    CONTACTLESS("mdral-contactless", '\ue176'),
    CONTACTS("mdral-contacts", '\ue178'),
    CONTENT_COPY("mdral-content_copy", '\ue17a'),
    CONTENT_CUT("mdral-content_cut", '\ue17c'),
    CONTENT_PASTE("mdral-content_paste", '\ue17e'),
    CONTROL_CAMERA("mdral-control_camera", '\ue180'),
    CONTROL_POINT("mdral-control_point", '\ue181'),
    CONTROL_POINT_DUPLICATE("mdral-control_point_duplicate", '\ue183'),
    COPYRIGHT("mdral-copyright", '\ue185'),
    CORONAVIRUS("mdral-coronavirus", '\ue8a0'),
    CORPORATE_FARE("mdral-corporate_fare", '\ue786'),
    COUNTERTOPS("mdral-countertops", '\ue86a'),
    CREATE("mdral-create", '\ue187'),
    CREATE_NEW_FOLDER("mdral-create_new_folder", '\ue189'),
    CREDIT_CARD("mdral-credit_card", '\ue18b'),
    CROP("mdral-crop", '\ue18d'),
    CROP_16_9("mdral-crop_16_9", '\ue18e'),
    CROP_3_2("mdral-crop_3_2", '\ue18f'),
    CROP_5_4("mdral-crop_5_4", '\ue190'),
    CROP_7_5("mdral-crop_7_5", '\ue191'),
    CROP_DIN("mdral-crop_din", '\ue192'),
    CROP_FREE("mdral-crop_free", '\ue193'),
    CROP_LANDSCAPE("mdral-crop_landscape", '\ue194'),
    CROP_ORIGINAL("mdral-crop_original", '\ue195'),
    CROP_PORTRAIT("mdral-crop_portrait", '\ue196'),
    CROP_ROTATE("mdral-crop_rotate", '\ue197'),
    CROP_SQUARE("mdral-crop_square", '\ue198'),
    DASHBOARD("mdral-dashboard", '\ue199'),
    DATA_USAGE("mdral-data_usage", '\ue19b'),
    DATE_RANGE("mdral-date_range", '\ue19c'),
    DECK("mdral-deck", '\ue19e'),
    DEHAZE("mdral-dehaze", '\ue1a0'),
    DELETE("mdral-delete", '\ue1a1'),
    DELETE_FOREVER("mdral-delete_forever", '\ue1a3'),
    DELETE_OUTLINE("mdral-delete_outline", '\ue1a5'),
    DELETE_SWEEP("mdral-delete_sweep", '\ue1a6'),
    DEPARTURE_BOARD("mdral-departure_board", '\ue1a8'),
    DESCRIPTION("mdral-description", '\ue1aa'),
    DESIGN_SERVICES("mdral-design_services", '\ue788'),
    DESKTOP_ACCESS_DISABLED("mdral-desktop_access_disabled", '\ue1ac'),
    DESKTOP_MAC("mdral-desktop_mac", '\ue1ae'),
    DESKTOP_WINDOWS("mdral-desktop_windows", '\ue1b0'),
    DETAILS("mdral-details", '\ue1b2'),
    DEVELOPER_BOARD("mdral-developer_board", '\ue1b4'),
    DEVELOPER_MODE("mdral-developer_mode", '\ue1b6'),
    DEVICE_HUB("mdral-device_hub", '\ue1b7'),
    DEVICE_UNKNOWN("mdral-device_unknown", '\ue1b8'),
    DEVICES("mdral-devices", '\ue1ba'),
    DEVICES_OTHER("mdral-devices_other", '\ue1bc'),
    DIALER_SIP("mdral-dialer_sip", '\ue1be'),
    DIALPAD("mdral-dialpad", '\ue1c0'),
    DIRECTIONS("mdral-directions", '\ue1c1'),
    DIRECTIONS_BIKE("mdral-directions_bike", '\ue1c3'),
    DIRECTIONS_BOAT("mdral-directions_boat", '\ue1c4'),
    DIRECTIONS_BUS("mdral-directions_bus", '\ue1c6'),
    DIRECTIONS_CAR("mdral-directions_car", '\ue1c8'),
    DIRECTIONS_OFF("mdral-directions_off", '\ue78a'),
    DIRECTIONS_RAILWAY("mdral-directions_railway", '\ue1ca'),
    DIRECTIONS_RUN("mdral-directions_run", '\ue1cc'),
    DIRECTIONS_SUBWAY("mdral-directions_subway", '\ue1cd'),
    DIRECTIONS_TRANSIT("mdral-directions_transit", '\ue1cf'),
    DIRECTIONS_WALK("mdral-directions_walk", '\ue1d1'),
    DISABLED_BY_DEFAULT("mdral-disabled_by_default", '\ue8b6'),
    DISC_FULL("mdral-disc_full", '\ue1d2'),
    DIVIDE("mdral-divide", '\ue1d4'),
    DNS("mdral-dns", '\ue1d6'),
    DO_NOT_DISTURB("mdral-do_not_disturb", '\ue1d8'),
    DO_NOT_DISTURB_ALT("mdral-do_not_disturb_alt", '\ue1da'),
    DO_NOT_DISTURB_OFF("mdral-do_not_disturb_off", '\ue1dc'),
    DO_NOT_STEP("mdral-do_not_step", '\ue78b'),
    DO_NOT_TOUCH("mdral-do_not_touch", '\ue78d'),
    DOCK("mdral-dock", '\ue1de'),
    DOMAIN("mdral-domain", '\ue1e0'),
    DOMAIN_DISABLED("mdral-domain_disabled", '\ue1e2'),
    DOMAIN_VERIFICATION("mdral-domain_verification", '\ue78f'),
    DONE("mdral-done", '\ue1e4'),
    DONE_ALL("mdral-done_all", '\ue1e5'),
    DONE_OUTLINE("mdral-done_outline", '\ue1e6'),
    DONUT_LARGE("mdral-donut_large", '\ue1e7'),
    DONUT_SMALL("mdral-donut_small", '\ue1e8'),
    DOUBLE_ARROW("mdral-double_arrow", '\ue1ea'),
    DRAFTS("mdral-drafts", '\ue1eb'),
    DRAG_HANDLE("mdral-drag_handle", '\ue1ed'),
    DRAG_INDICATOR("mdral-drag_indicator", '\ue1ee'),
    DRIVE_ETA("mdral-drive_eta", '\ue1ef'),
    DRY("mdral-dry", '\ue791'),
    DUO("mdral-duo", '\ue1f1'),
    DVR("mdral-dvr", '\ue1f2'),
    DYNAMIC_FEED("mdral-dynamic_feed", '\ue1f4'),
    DYNAMIC_FORM("mdral-dynamic_form", '\ue793'),
    EAST("mdral-east", '\ue86c'),
    ECO("mdral-eco", '\ue1f6'),
    EDIT("mdral-edit", '\ue1f8'),
    EDIT_ATTRIBUTES("mdral-edit_attributes", '\ue1fa'),
    EDIT_LOCATION("mdral-edit_location", '\ue1fc'),
    EDIT_ROAD("mdral-edit_road", '\ue795'),
    EJECT("mdral-eject", '\ue1fe'),
    ELDERLY("mdral-elderly", '\ue8a2'),
    ELECTRIC_BIKE("mdral-electric_bike", '\ue797'),
    ELECTRIC_CAR("mdral-electric_car", '\ue798'),
    ELECTRIC_MOPED("mdral-electric_moped", '\ue79a'),
    ELECTRIC_SCOOTER("mdral-electric_scooter", '\ue79c'),
    ELECTRICAL_SERVICES("mdral-electrical_services", '\ue79d'),
    ELEVATOR("mdral-elevator", '\ue79e'),
    EMAIL("mdral-email", '\ue200'),
    EMOJI_EMOTIONS("mdral-emoji_emotions", '\ue202'),
    EMOJI_EVENTS("mdral-emoji_events", '\ue204'),
    EMOJI_FLAGS("mdral-emoji_flags", '\ue206'),
    EMOJI_FOOD_BEVERAGE("mdral-emoji_food_beverage", '\ue208'),
    EMOJI_NATURE("mdral-emoji_nature", '\ue20a'),
    EMOJI_OBJECTS("mdral-emoji_objects", '\ue20c'),
    EMOJI_PEOPLE("mdral-emoji_people", '\ue20e'),
    EMOJI_SYMBOLS("mdral-emoji_symbols", '\ue20f'),
    EMOJI_TRANSPORTATION("mdral-emoji_transportation", '\ue210'),
    ENGINEERING("mdral-engineering", '\ue7a0'),
    ENHANCED_ENCRYPTION("mdral-enhanced_encryption", '\ue211'),
    EQUALIZER("mdral-equalizer", '\ue213'),
    EQUALS("mdral-equals", '\ue214'),
    ERROR("mdral-error", '\ue215'),
    ERROR_OUTLINE("mdral-error_outline", '\ue217'),
    ESCALATOR("mdral-escalator", '\ue7a2'),
    ESCALATOR_WARNING("mdral-escalator_warning", '\ue7a4'),
    EURO("mdral-euro", '\ue218'),
    EURO_SYMBOL("mdral-euro_symbol", '\ue219'),
    EV_STATION("mdral-ev_station", '\ue21a'),
    EVENT("mdral-event", '\ue21c'),
    EVENT_AVAILABLE("mdral-event_available", '\ue21e'),
    EVENT_BUSY("mdral-event_busy", '\ue220'),
    EVENT_NOTE("mdral-event_note", '\ue222'),
    EVENT_SEAT("mdral-event_seat", '\ue224'),
    EXIT_TO_APP("mdral-exit_to_app", '\ue226'),
    EXPAND_LESS("mdral-expand_less", '\ue227'),
    EXPAND_MORE("mdral-expand_more", '\ue228'),
    EXPLICIT("mdral-explicit", '\ue229'),
    EXPLORE("mdral-explore", '\ue22b'),
    EXPLORE_OFF("mdral-explore_off", '\ue22d'),
    EXPOSURE("mdral-exposure", '\ue22f'),
    EXPOSURE_NEG_1("mdral-exposure_neg_1", '\ue231'),
    EXPOSURE_NEG_2("mdral-exposure_neg_2", '\ue232'),
    EXPOSURE_PLUS_1("mdral-exposure_plus_1", '\ue233'),
    EXPOSURE_PLUS_2("mdral-exposure_plus_2", '\ue234'),
    EXPOSURE_ZERO("mdral-exposure_zero", '\ue235'),
    EXTENSION("mdral-extension", '\ue236'),
    FACE("mdral-face", '\ue238'),
    FACEBOOK("mdral-facebook", '\ue8b8'),
    FACT_CHECK("mdral-fact_check", '\ue7a5'),
    FAMILY_RESTROOM("mdral-family_restroom", '\ue7a7'),
    FAST_FORWARD("mdral-fast_forward", '\ue23a'),
    FAST_REWIND("mdral-fast_rewind", '\ue23c'),
    FASTFOOD("mdral-fastfood", '\ue23e'),
    FAVORITE("mdral-favorite", '\ue240'),
    FAVORITE_BORDER("mdral-favorite_border", '\ue242'),
    FEATURED_PLAY_LIST("mdral-featured_play_list", '\ue243'),
    FEATURED_VIDEO("mdral-featured_video", '\ue245'),
    FEEDBACK("mdral-feedback", '\ue247'),
    FENCE("mdral-fence", '\ue86d'),
    FIBER_DVR("mdral-fiber_dvr", '\ue249'),
    FIBER_MANUAL_RECORD("mdral-fiber_manual_record", '\ue24b'),
    FIBER_NEW("mdral-fiber_new", '\ue24d'),
    FIBER_PIN("mdral-fiber_pin", '\ue24f'),
    FIBER_SMART_RECORD("mdral-fiber_smart_record", '\ue251'),
    FILE_COPY("mdral-file_copy", '\ue253'),
    FILE_UPLOAD("mdral-file_upload", '\ue255'),
    FILTER("mdral-filter", '\ue257'),
    FILTER_1("mdral-filter_1", '\ue259'),
    FILTER_2("mdral-filter_2", '\ue25b'),
    FILTER_3("mdral-filter_3", '\ue25d'),
    FILTER_4("mdral-filter_4", '\ue25f'),
    FILTER_5("mdral-filter_5", '\ue261'),
    FILTER_6("mdral-filter_6", '\ue263'),
    FILTER_7("mdral-filter_7", '\ue265'),
    FILTER_8("mdral-filter_8", '\ue267'),
    FILTER_9("mdral-filter_9", '\ue269'),
    FILTER_9_PLUS("mdral-filter_9_plus", '\ue26b'),
    FILTER_ALT("mdral-filter_alt", '\ue7a8'),
    FILTER_B_AND_W("mdral-filter_b_and_w", '\ue26d'),
    FILTER_CENTER_FOCUS("mdral-filter_center_focus", '\ue26f'),
    FILTER_DRAMA("mdral-filter_drama", '\ue270'),
    FILTER_FRAMES("mdral-filter_frames", '\ue272'),
    FILTER_HDR("mdral-filter_hdr", '\ue274'),
    FILTER_LIST("mdral-filter_list", '\ue276'),
    FILTER_NONE("mdral-filter_none", '\ue277'),
    FILTER_TILT_SHIFT("mdral-filter_tilt_shift", '\ue279'),
    FILTER_VINTAGE("mdral-filter_vintage", '\ue27a'),
    FIND_IN_PAGE("mdral-find_in_page", '\ue27c'),
    FIND_REPLACE("mdral-find_replace", '\ue27e'),
    FINGERPRINT("mdral-fingerprint", '\ue27f'),
    FIRE_EXTINGUISHER("mdral-fire_extinguisher", '\ue86f'),
    FIREPLACE("mdral-fireplace", '\ue280'),
    FIRST_PAGE("mdral-first_page", '\ue282'),
    FITNESS_CENTER("mdral-fitness_center", '\ue283'),
    FLAG("mdral-flag", '\ue284'),
    FLAKY("mdral-flaky", '\ue7aa'),
    FLARE("mdral-flare", '\ue286'),
    FLASH_AUTO("mdral-flash_auto", '\ue287'),
    FLASH_OFF("mdral-flash_off", '\ue288'),
    FLASH_ON("mdral-flash_on", '\ue289'),
    FLIGHT("mdral-flight", '\ue28a'),
    FLIGHT_LAND("mdral-flight_land", '\ue28b'),
    FLIGHT_TAKEOFF("mdral-flight_takeoff", '\ue28c'),
    FLIP("mdral-flip", '\ue28d'),
    FLIP_CAMERA_ANDROID("mdral-flip_camera_android", '\ue28e'),
    FLIP_CAMERA_IOS("mdral-flip_camera_ios", '\ue290'),
    FLIP_TO_BACK("mdral-flip_to_back", '\ue292'),
    FLIP_TO_FRONT("mdral-flip_to_front", '\ue293'),
    FOLDER("mdral-folder", '\ue294'),
    FOLDER_OPEN("mdral-folder_open", '\ue296'),
    FOLDER_SHARED("mdral-folder_shared", '\ue298'),
    FOLDER_SPECIAL("mdral-folder_special", '\ue29a'),
    FOLLOW_THE_SIGNS("mdral-follow_the_signs", '\ue8a3'),
    FONT_DOWNLOAD("mdral-font_download", '\ue29c'),
    FOOD_BANK("mdral-food_bank", '\ue870'),
    FORMAT_ALIGN_CENTER("mdral-format_align_center", '\ue29e'),
    FORMAT_ALIGN_JUSTIFY("mdral-format_align_justify", '\ue29f'),
    FORMAT_ALIGN_LEFT("mdral-format_align_left", '\ue2a0'),
    FORMAT_ALIGN_RIGHT("mdral-format_align_right", '\ue2a1'),
    FORMAT_BOLD("mdral-format_bold", '\ue2a2'),
    FORMAT_CLEAR("mdral-format_clear", '\ue2a3'),
    FORMAT_COLOR_FILL("mdral-format_color_fill", '\ue2a4'),
    FORMAT_COLOR_RESET("mdral-format_color_reset", '\ue2a6'),
    FORMAT_COLOR_TEXT("mdral-format_color_text", '\ue2a8'),
    FORMAT_INDENT_DECREASE("mdral-format_indent_decrease", '\ue2aa'),
    FORMAT_INDENT_INCREASE("mdral-format_indent_increase", '\ue2ab'),
    FORMAT_ITALIC("mdral-format_italic", '\ue2ac'),
    FORMAT_LINE_SPACING("mdral-format_line_spacing", '\ue2ad'),
    FORMAT_LIST_BULLETED("mdral-format_list_bulleted", '\ue2ae'),
    FORMAT_LIST_NUMBERED("mdral-format_list_numbered", '\ue2af'),
    FORMAT_LIST_NUMBERED_RTL("mdral-format_list_numbered_rtl", '\ue2b0'),
    FORMAT_PAINT("mdral-format_paint", '\ue2b1'),
    FORMAT_QUOTE("mdral-format_quote", '\ue2b3'),
    FORMAT_SHAPES("mdral-format_shapes", '\ue2b5'),
    FORMAT_SIZE("mdral-format_size", '\ue2b7'),
    FORMAT_STRIKETHROUGH("mdral-format_strikethrough", '\ue2b8'),
    FORMAT_TEXTDIRECTION_L_TO_R("mdral-format_textdirection_l_to_r", '\ue2b9'),
    FORMAT_TEXTDIRECTION_R_TO_L("mdral-format_textdirection_r_to_l", '\ue2bb'),
    FORMAT_UNDERLINED("mdral-format_underlined", '\ue2bd'),
    FORUM("mdral-forum", '\ue2be'),
    FORWARD("mdral-forward", '\ue2c0'),
    FORWARD_10("mdral-forward_10", '\ue2c2'),
    FORWARD_30("mdral-forward_30", '\ue2c3'),
    FORWARD_5("mdral-forward_5", '\ue2c4'),
    FORWARD_TO_INBOX("mdral-forward_to_inbox", '\ue7ab'),
    FOUNDATION("mdral-foundation", '\ue872'),
    FREE_BREAKFAST("mdral-free_breakfast", '\ue2c5'),
    FULLSCREEN("mdral-fullscreen", '\ue2c7'),
    FULLSCREEN_EXIT("mdral-fullscreen_exit", '\ue2c8'),
    FUNCTIONS("mdral-functions", '\ue2c9'),
    G_TRANSLATE("mdral-g_translate", '\ue2ca'),
    GAMEPAD("mdral-gamepad", '\ue2cb'),
    GAMES("mdral-games", '\ue2cd'),
    GAVEL("mdral-gavel", '\ue2cf'),
    GESTURE("mdral-gesture", '\ue2d0'),
    GET_APP("mdral-get_app", '\ue2d1'),
    GIF("mdral-gif", '\ue2d3'),
    GOLF_COURSE("mdral-golf_course", '\ue2d5'),
    GPS_FIXED("mdral-gps_fixed", '\ue2d7'),
    GPS_NOT_FIXED("mdral-gps_not_fixed", '\ue2d9'),
    GPS_OFF("mdral-gps_off", '\ue2da'),
    GRADE("mdral-grade", '\ue2db'),
    GRADIENT("mdral-gradient", '\ue2dd'),
    GRADING("mdral-grading", '\ue7ad'),
    GRAIN("mdral-grain", '\ue2de'),
    GRAPHIC_EQ("mdral-graphic_eq", '\ue2df'),
    GRASS("mdral-grass", '\ue874'),
    GREATER_THAN("mdral-greater_than", '\ue2e0'),
    GREATER_THAN_EQUAL("mdral-greater_than_equal", '\ue2e1'),
    GRID_OFF("mdral-grid_off", '\ue2e2'),
    GRID_ON("mdral-grid_on", '\ue2e4'),
    GROUP("mdral-group", '\ue2e6'),
    GROUP_ADD("mdral-group_add", '\ue2e8'),
    GROUP_WORK("mdral-group_work", '\ue2ea'),
    GROUPS("mdral-groups", '\ue8b9'),
    HANDYMAN("mdral-handyman", '\ue7ae'),
    HD("mdral-hd", '\ue2ec'),
    HDR_OFF("mdral-hdr_off", '\ue2ee'),
    HDR_ON("mdral-hdr_on", '\ue2ef'),
    HDR_STRONG("mdral-hdr_strong", '\ue2f0'),
    HDR_WEAK("mdral-hdr_weak", '\ue2f2'),
    HEADSET("mdral-headset", '\ue2f4'),
    HEADSET_MIC("mdral-headset_mic", '\ue2f6'),
    HEALING("mdral-healing", '\ue2f8'),
    HEARING("mdral-hearing", '\ue2fa'),
    HEARING_DISABLED("mdral-hearing_disabled", '\ue7b0'),
    HEIGHT("mdral-height", '\ue2fb'),
    HELP("mdral-help", '\ue2fc'),
    HELP_CENTER("mdral-help_center", '\ue7b1'),
    HELP_OUTLINE("mdral-help_outline", '\ue2fe'),
    HIGH_QUALITY("mdral-high_quality", '\ue2ff'),
    HIGHLIGHT("mdral-highlight", '\ue301'),
    HIGHLIGHT_ALT("mdral-highlight_alt", '\ue7b3'),
    HIGHLIGHT_OFF("mdral-highlight_off", '\ue303'),
    HISTORY("mdral-history", '\ue305'),
    HISTORY_EDU("mdral-history_edu", '\ue7b4'),
    HISTORY_TOGGLE_OFF("mdral-history_toggle_off", '\ue7b6'),
    HOME("mdral-home", '\ue306'),
    HOME_REPAIR_SERVICE("mdral-home_repair_service", '\ue7b7'),
    HOME_WORK("mdral-home_work", '\ue308'),
    HORIZONTAL_DISTRIBUTE("mdral-horizontal_distribute", '\ue8d0'),
    HORIZONTAL_RULE("mdral-horizontal_rule", '\ue7b9'),
    HORIZONTAL_SPLIT("mdral-horizontal_split", '\ue30a'),
    HOT_TUB("mdral-hot_tub", '\ue30c'),
    HOTEL("mdral-hotel", '\ue30d'),
    HOURGLASS_BOTTOM("mdral-hourglass_bottom", '\ue7ba'),
    HOURGLASS_DISABLED("mdral-hourglass_disabled", '\ue7bc'),
    HOURGLASS_EMPTY("mdral-hourglass_empty", '\ue30f'),
    HOURGLASS_FULL("mdral-hourglass_full", '\ue310'),
    HOURGLASS_TOP("mdral-hourglass_top", '\ue7bd'),
    HOUSE("mdral-house", '\ue312'),
    HOUSE_SIDING("mdral-house_siding", '\ue875'),
    HOW_TO_REG("mdral-how_to_reg", '\ue314'),
    HOW_TO_VOTE("mdral-how_to_vote", '\ue316'),
    HTTP("mdral-http", '\ue318'),
    HTTPS("mdral-https", '\ue319'),
    HVAC("mdral-hvac", '\ue7bf'),
    IMAGE("mdral-image", '\ue31b'),
    IMAGE_ASPECT_RATIO("mdral-image_aspect_ratio", '\ue31d'),
    IMAGE_NOT_SUPPORTED("mdral-image_not_supported", '\ue7c1'),
    IMAGE_SEARCH("mdral-image_search", '\ue31f'),
    IMPORT_CONTACTS("mdral-import_contacts", '\ue321'),
    IMPORT_EXPORT("mdral-import_export", '\ue323'),
    IMPORTANT_DEVICES("mdral-important_devices", '\ue324'),
    INBOX("mdral-inbox", '\ue326'),
    INDETERMINATE_CHECK_BOX("mdral-indeterminate_check_box", '\ue328'),
    INFO("mdral-info", '\ue32a'),
    INPUT("mdral-input", '\ue32c'),
    INSERT_CHART("mdral-insert_chart", '\ue32d'),
    INSERT_CHART_OUTLINED("mdral-insert_chart_outlined", '\ue32f'),
    INSERT_COMMENT("mdral-insert_comment", '\ue330'),
    INSERT_DRIVE_FILE("mdral-insert_drive_file", '\ue332'),
    INSERT_EMOTICON("mdral-insert_emoticon", '\ue334'),
    INSERT_INVITATION("mdral-insert_invitation", '\ue336'),
    INSERT_LINK("mdral-insert_link", '\ue338'),
    INSERT_PHOTO("mdral-insert_photo", '\ue339'),
    INSIGHTS("mdral-insights", '\ue7c3'),
    INTEGRATION_INSTRUCTIONS("mdral-integration_instructions", '\ue7c4'),
    INVERT_COLORS("mdral-invert_colors", '\ue33b'),
    INVERT_COLORS_OFF("mdral-invert_colors_off", '\ue33d'),
    ISO("mdral-iso", '\ue33f'),
    KEYBOARD("mdral-keyboard", '\ue341'),
    KEYBOARD_ARROW_DOWN("mdral-keyboard_arrow_down", '\ue343'),
    KEYBOARD_ARROW_LEFT("mdral-keyboard_arrow_left", '\ue344'),
    KEYBOARD_ARROW_RIGHT("mdral-keyboard_arrow_right", '\ue345'),
    KEYBOARD_ARROW_UP("mdral-keyboard_arrow_up", '\ue346'),
    KEYBOARD_BACKSPACE("mdral-keyboard_backspace", '\ue347'),
    KEYBOARD_CAPSLOCK("mdral-keyboard_capslock", '\ue348'),
    KEYBOARD_HIDE("mdral-keyboard_hide", '\ue349'),
    KEYBOARD_RETURN("mdral-keyboard_return", '\ue34b'),
    KEYBOARD_TAB("mdral-keyboard_tab", '\ue34c'),
    KEYBOARD_VOICE("mdral-keyboard_voice", '\ue34d'),
    KING_BED("mdral-king_bed", '\ue34f'),
    KITCHEN("mdral-kitchen", '\ue351'),
    LABEL("mdral-label", '\ue353'),
    LABEL_IMPORTANT("mdral-label_important", '\ue355'),
    LABEL_OFF("mdral-label_off", '\ue357'),
    LANDSCAPE("mdral-landscape", '\ue359'),
    LANGUAGE("mdral-language", '\ue35b'),
    LAPTOP("mdral-laptop", '\ue35d'),
    LAPTOP_CHROMEBOOK("mdral-laptop_chromebook", '\ue35f'),
    LAPTOP_MAC("mdral-laptop_mac", '\ue361'),
    LAPTOP_WINDOWS("mdral-laptop_windows", '\ue363'),
    LAST_PAGE("mdral-last_page", '\ue365'),
    LAUNCH("mdral-launch", '\ue366'),
    LAYERS("mdral-layers", '\ue367'),
    LAYERS_CLEAR("mdral-layers_clear", '\ue369'),
    LEADERBOARD("mdral-leaderboard", '\ue877'),
    LEAK_ADD("mdral-leak_add", '\ue36b'),
    LEAK_REMOVE("mdral-leak_remove", '\ue36c'),
    LEAVE_BAGS_AT_HOME("mdral-leave_bags_at_home", '\ue8a5'),
    LEGEND_TOGGLE("mdral-legend_toggle", '\ue7c6'),
    LENS("mdral-lens", '\ue36d'),
    LESS_THAN("mdral-less_than", '\ue36f'),
    LESS_THAN_EQUAL("mdral-less_than_equal", '\ue370'),
    LIBRARY_ADD("mdral-library_add", '\ue371'),
    LIBRARY_ADD_CHECK("mdral-library_add_check", '\ue746'),
    LIBRARY_BOOKS("mdral-library_books", '\ue373'),
    LIBRARY_MUSIC("mdral-library_music", '\ue375'),
    LIGHTBULB("mdral-lightbulb", '\ue377'),
    LINE_STYLE("mdral-line_style", '\ue379'),
    LINE_WEIGHT("mdral-line_weight", '\ue37a'),
    LINEAR_SCALE("mdral-linear_scale", '\ue37b'),
    LINK("mdral-link", '\ue37c'),
    LINK_OFF("mdral-link_off", '\ue37e'),
    LINKED_CAMERA("mdral-linked_camera", '\ue37f'),
    LIST("mdral-list", '\ue381'),
    LIST_ALT("mdral-list_alt", '\ue382'),
    LIVE_HELP("mdral-live_help", '\ue384'),
    LIVE_TV("mdral-live_tv", '\ue386'),
    LOCAL_ACTIVITY("mdral-local_activity", '\ue388'),
    LOCAL_AIRPORT("mdral-local_airport", '\ue38a'),
    LOCAL_ATM("mdral-local_atm", '\ue38b'),
    LOCAL_BAR("mdral-local_bar", '\ue38d'),
    LOCAL_CAFE("mdral-local_cafe", '\ue38f'),
    LOCAL_CAR_WASH("mdral-local_car_wash", '\ue391'),
    LOCAL_CONVENIENCE_STORE("mdral-local_convenience_store", '\ue393'),
    LOCAL_DINING("mdral-local_dining", '\ue395'),
    LOCAL_DRINK("mdral-local_drink", '\ue396'),
    LOCAL_FIRE_DEPARTMENT("mdral-local_fire_department", '\ue8a7'),
    LOCAL_FLORIST("mdral-local_florist", '\ue398'),
    LOCAL_GAS_STATION("mdral-local_gas_station", '\ue39a'),
    LOCAL_GROCERY_STORE("mdral-local_grocery_store", '\ue39c'),
    LOCAL_HOSPITAL("mdral-local_hospital", '\ue39e'),
    LOCAL_HOTEL("mdral-local_hotel", '\ue3a0'),
    LOCAL_LAUNDRY_SERVICE("mdral-local_laundry_service", '\ue3a2'),
    LOCAL_LIBRARY("mdral-local_library", '\ue3a4'),
    LOCAL_MALL("mdral-local_mall", '\ue3a6'),
    LOCAL_MOVIES("mdral-local_movies", '\ue3a8'),
    LOCAL_OFFER("mdral-local_offer", '\ue3aa'),
    LOCAL_PARKING("mdral-local_parking", '\ue3ac'),
    LOCAL_PHARMACY("mdral-local_pharmacy", '\ue3ad'),
    LOCAL_PHONE("mdral-local_phone", '\ue3af'),
    LOCAL_PIZZA("mdral-local_pizza", '\ue3b1'),
    LOCAL_PLAY("mdral-local_play", '\ue3b3'),
    LOCAL_POLICE("mdral-local_police", '\ue8a9'),
    LOCAL_POST_OFFICE("mdral-local_post_office", '\ue3b5'),
    LOCAL_PRINTSHOP("mdral-local_printshop", '\ue3b7'),
    LOCAL_SEE("mdral-local_see", '\ue3b9'),
    LOCAL_SHIPPING("mdral-local_shipping", '\ue3bb'),
    LOCAL_TAXI("mdral-local_taxi", '\ue3bd'),
    LOCATION_CITY("mdral-location_city", '\ue3bf'),
    LOCATION_DISABLED("mdral-location_disabled", '\ue3c0'),
    LOCATION_OFF("mdral-location_off", '\ue3c1'),
    LOCATION_ON("mdral-location_on", '\ue3c2'),
    LOCATION_SEARCHING("mdral-location_searching", '\ue3c4'),
    LOCK("mdral-lock", '\ue3c5'),
    LOCK_OPEN("mdral-lock_open", '\ue3c7'),
    LOG_IN("mdral-log_in", '\ue3c9'),
    LOG_OUT("mdral-log_out", '\ue3ca'),
    LOGIN("mdral-login", '\ue7c7'),
    LOOKS("mdral-looks", '\ue3cb'),
    LOOKS_3("mdral-looks_3", '\ue3cc'),
    LOOKS_4("mdral-looks_4", '\ue3ce'),
    LOOKS_5("mdral-looks_5", '\ue3d0'),
    LOOKS_6("mdral-looks_6", '\ue3d2'),
    LOOKS_ONE("mdral-looks_one", '\ue3d4'),
    LOOKS_TWO("mdral-looks_two", '\ue3d6'),
    LOOP("mdral-loop", '\ue3d8'),
    LOUPE("mdral-loupe", '\ue3d9'),
    LOW_PRIORITY("mdral-low_priority", '\ue3db'),
    LOYALTY("mdral-loyalty", '\ue3dc'),
    LUGGAGE("mdral-luggage", '\ue8bb');
    
    public static Material2RoundAL findByDescription(String description) {
        for (Material2RoundAL font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2RoundAL(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}