/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2RoundMZ implements Ikon {
    MAIL("mdrmz-mail", '\ue3de'),
    MAIL_OUTLINE("mdrmz-mail_outline", '\ue3e0'),
    MAP("mdrmz-map", '\ue3e1'),
    MAPS_UGC("mdrmz-maps_ugc", '\ue7c8'),
    MARK_CHAT_READ("mdrmz-mark_chat_read", '\ue7ca'),
    MARK_CHAT_UNREAD("mdrmz-mark_chat_unread", '\ue7cc'),
    MARK_EMAIL_READ("mdrmz-mark_email_read", '\ue7ce'),
    MARK_EMAIL_UNREAD("mdrmz-mark_email_unread", '\ue7d0'),
    MARKUNREAD("mdrmz-markunread", '\ue3e3'),
    MARKUNREAD_MAILBOX("mdrmz-markunread_mailbox", '\ue3e5'),
    MASKS("mdrmz-masks", '\ue8ab'),
    MAXIMIZE("mdrmz-maximize", '\ue3e7'),
    MEDIATION("mdrmz-mediation", '\ue7d2'),
    MEDICAL_SERVICES("mdrmz-medical_services", '\ue7d3'),
    MEETING_ROOM("mdrmz-meeting_room", '\ue3e8'),
    MEMORY("mdrmz-memory", '\ue3ea'),
    MENU("mdrmz-menu", '\ue3ec'),
    MENU_BOOK("mdrmz-menu_book", '\ue3ed'),
    MENU_OPEN("mdrmz-menu_open", '\ue3ef'),
    MERGE_TYPE("mdrmz-merge_type", '\ue3f0'),
    MESSAGE("mdrmz-message", '\ue3f1'),
    MIC("mdrmz-mic", '\ue3f3'),
    MIC_NONE("mdrmz-mic_none", '\ue3f5'),
    MIC_OFF("mdrmz-mic_off", '\ue3f7'),
    MICROWAVE("mdrmz-microwave", '\ue879'),
    MILITARY_TECH("mdrmz-military_tech", '\ue7d5'),
    MINIMIZE("mdrmz-minimize", '\ue3f9'),
    MINUS("mdrmz-minus", '\ue3fa'),
    MISCELLANEOUS_SERVICES("mdrmz-miscellaneous_services", '\ue7d7'),
    MISSED_VIDEO_CALL("mdrmz-missed_video_call", '\ue3fb'),
    MMS("mdrmz-mms", '\ue3fd'),
    MOBILE_FRIENDLY("mdrmz-mobile_friendly", '\ue3ff'),
    MOBILE_OFF("mdrmz-mobile_off", '\ue400'),
    MOBILE_SCREEN_SHARE("mdrmz-mobile_screen_share", '\ue401'),
    MODE_COMMENT("mdrmz-mode_comment", '\ue403'),
    MODEL_TRAINING("mdrmz-model_training", '\ue7d8'),
    MONETIZATION_ON("mdrmz-monetization_on", '\ue405'),
    MONEY("mdrmz-money", '\ue407'),
    MONEY_OFF("mdrmz-money_off", '\ue409'),
    MONOCHROME_PHOTOS("mdrmz-monochrome_photos", '\ue40a'),
    MOOD("mdrmz-mood", '\ue40c'),
    MOOD_BAD("mdrmz-mood_bad", '\ue40e'),
    MOPED("mdrmz-moped", '\ue7d9'),
    MORE("mdrmz-more", '\ue410'),
    MORE_HORIZ("mdrmz-more_horiz", '\ue412'),
    MORE_TIME("mdrmz-more_time", '\ue7db'),
    MORE_VERT("mdrmz-more_vert", '\ue413'),
    MOTION_PHOTOS_ON("mdrmz-motion_photos_on", '\ue8ad'),
    MOTION_PHOTOS_PAUSE("mdrmz-motion_photos_pause", '\ue8bd'),
    MOTION_PHOTOS_PAUSED("mdrmz-motion_photos_paused", '\ue8ae'),
    MOTORCYCLE("mdrmz-motorcycle", '\ue414'),
    MOUSE("mdrmz-mouse", '\ue416'),
    MOVE_TO_INBOX("mdrmz-move_to_inbox", '\ue418'),
    MOVIE("mdrmz-movie", '\ue41a'),
    MOVIE_CREATION("mdrmz-movie_creation", '\ue41c'),
    MOVIE_FILTER("mdrmz-movie_filter", '\ue41e'),
    MULTILINE_CHART("mdrmz-multiline_chart", '\ue420'),
    MULTIPLE_STOP("mdrmz-multiple_stop", '\ue7dc'),
    MUSEUM("mdrmz-museum", '\ue421'),
    MUSIC_NOTE("mdrmz-music_note", '\ue423'),
    MUSIC_OFF("mdrmz-music_off", '\ue425'),
    MUSIC_VIDEO("mdrmz-music_video", '\ue427'),
    MY_LOCATION("mdrmz-my_location", '\ue429'),
    NAT("mdrmz-nat", '\ue7dd'),
    NATURE("mdrmz-nature", '\ue42b'),
    NATURE_PEOPLE("mdrmz-nature_people", '\ue42d'),
    NAVIGATE_BEFORE("mdrmz-navigate_before", '\ue42f'),
    NAVIGATE_NEXT("mdrmz-navigate_next", '\ue430'),
    NAVIGATION("mdrmz-navigation", '\ue431'),
    NEAR_ME("mdrmz-near_me", '\ue433'),
    NEAR_ME_DISABLED("mdrmz-near_me_disabled", '\ue87b'),
    NETWORK_CELL("mdrmz-network_cell", '\ue435'),
    NETWORK_CHECK("mdrmz-network_check", '\ue437'),
    NETWORK_LOCKED("mdrmz-network_locked", '\ue438'),
    NETWORK_WIFI("mdrmz-network_wifi", '\ue439'),
    NEW_RELEASES("mdrmz-new_releases", '\ue43b'),
    NEXT_PLAN("mdrmz-next_plan", '\ue7df'),
    NEXT_WEEK("mdrmz-next_week", '\ue43d'),
    NFC("mdrmz-nfc", '\ue43f'),
    NIGHT_SHELTER("mdrmz-night_shelter", '\ue87d'),
    NIGHTS_STAY("mdrmz-nights_stay", '\ue440'),
    NO_BACKPACK("mdrmz-no_backpack", '\ue8be'),
    NO_CELL("mdrmz-no_cell", '\ue7e1'),
    NO_DRINKS("mdrmz-no_drinks", '\ue7e3'),
    NO_ENCRYPTION("mdrmz-no_encryption", '\ue442'),
    NO_FLASH("mdrmz-no_flash", '\ue7e5'),
    NO_FOOD("mdrmz-no_food", '\ue7e7'),
    NO_LUGGAGE("mdrmz-no_luggage", '\ue8c0'),
    NO_MEALS("mdrmz-no_meals", '\ue87f'),
    NO_MEETING_ROOM("mdrmz-no_meeting_room", '\ue444'),
    NO_PHOTOGRAPHY("mdrmz-no_photography", '\ue7e9'),
    NO_SIM("mdrmz-no_sim", '\ue446'),
    NO_STROLLER("mdrmz-no_stroller", '\ue7eb'),
    NO_TRANSFER("mdrmz-no_transfer", '\ue880'),
    NORTH("mdrmz-north", '\ue882'),
    NORTH_EAST("mdrmz-north_east", '\ue883'),
    NORTH_WEST("mdrmz-north_west", '\ue884'),
    NOT_ACCESSIBLE("mdrmz-not_accessible", '\ue7ed'),
    NOT_EQUAL("mdrmz-not_equal", '\ue448'),
    NOT_INTERESTED("mdrmz-not_interested", '\ue449'),
    NOT_LISTED_LOCATION("mdrmz-not_listed_location", '\ue44a'),
    NOT_STARTED("mdrmz-not_started", '\ue7ee'),
    NOTE("mdrmz-note", '\ue44c'),
    NOTE_ADD("mdrmz-note_add", '\ue44e'),
    NOTES("mdrmz-notes", '\ue450'),
    NOTIFICATION_IMPORTANT("mdrmz-notification_important", '\ue451'),
    NOTIFICATIONS("mdrmz-notifications", '\ue453'),
    NOTIFICATIONS_ACTIVE("mdrmz-notifications_active", '\ue455'),
    NOTIFICATIONS_NONE("mdrmz-notifications_none", '\ue457'),
    NOTIFICATIONS_OFF("mdrmz-notifications_off", '\ue459'),
    NOTIFICATIONS_PAUSED("mdrmz-notifications_paused", '\ue45b'),
    OFFLINE_BOLT("mdrmz-offline_bolt", '\ue45d'),
    OFFLINE_PIN("mdrmz-offline_pin", '\ue45f'),
    ONDEMAND_VIDEO("mdrmz-ondemand_video", '\ue461'),
    ONLINE_PREDICTION("mdrmz-online_prediction", '\ue7f0'),
    OPACITY("mdrmz-opacity", '\ue463'),
    OPEN_IN_BROWSER("mdrmz-open_in_browser", '\ue465'),
    OPEN_IN_FULL("mdrmz-open_in_full", '\ue7f1'),
    OPEN_IN_NEW("mdrmz-open_in_new", '\ue466'),
    OPEN_WITH("mdrmz-open_with", '\ue467'),
    OUTBOND("mdrmz-outbond", '\ue8c2'),
    OUTDOOR_GRILL("mdrmz-outdoor_grill", '\ue468'),
    OUTLET("mdrmz-outlet", '\ue7f2'),
    OUTLINED_FLAG("mdrmz-outlined_flag", '\ue46a'),
    PAGES("mdrmz-pages", '\ue46b'),
    PAGEVIEW("mdrmz-pageview", '\ue46d'),
    PALETTE("mdrmz-palette", '\ue46f'),
    PAN_TOOL("mdrmz-pan_tool", '\ue471'),
    PANORAMA("mdrmz-panorama", '\ue473'),
    PANORAMA_FISH_EYE("mdrmz-panorama_fish_eye", '\ue475'),
    PANORAMA_HORIZONTAL("mdrmz-panorama_horizontal", '\ue477'),
    PANORAMA_VERTICAL("mdrmz-panorama_vertical", '\ue479'),
    PANORAMA_WIDE_ANGLE("mdrmz-panorama_wide_angle", '\ue47b'),
    PARTY_MODE("mdrmz-party_mode", '\ue47d'),
    PAUSE("mdrmz-pause", '\ue47f'),
    PAUSE_CIRCLE_FILLED("mdrmz-pause_circle_filled", '\ue480'),
    PAUSE_CIRCLE_OUTLINE("mdrmz-pause_circle_outline", '\ue482'),
    PAUSE_PRESENTATION("mdrmz-pause_presentation", '\ue483'),
    PAYMENT("mdrmz-payment", '\ue485'),
    PAYMENTS("mdrmz-payments", '\ue7f4'),
    PEDAL_BIKE("mdrmz-pedal_bike", '\ue7f6'),
    PENDING("mdrmz-pending", '\ue7f7'),
    PENDING_ACTIONS("mdrmz-pending_actions", '\ue7f9'),
    PEOPLE("mdrmz-people", '\ue487'),
    PEOPLE_ALT("mdrmz-people_alt", '\ue489'),
    PEOPLE_OUTLINE("mdrmz-people_outline", '\ue48b'),
    PERCENTAGE("mdrmz-percentage", '\ue48d'),
    PERM_CAMERA_MIC("mdrmz-perm_camera_mic", '\ue48f'),
    PERM_CONTACT_CALENDAR("mdrmz-perm_contact_calendar", '\ue491'),
    PERM_DATA_SETTING("mdrmz-perm_data_setting", '\ue493'),
    PERM_DEVICE_INFORMATION("mdrmz-perm_device_information", '\ue494'),
    PERM_IDENTITY("mdrmz-perm_identity", '\ue496'),
    PERM_MEDIA("mdrmz-perm_media", '\ue498'),
    PERM_PHONE_MSG("mdrmz-perm_phone_msg", '\ue49a'),
    PERM_SCAN_WIFI("mdrmz-perm_scan_wifi", '\ue49c'),
    PERSON("mdrmz-person", '\ue49e'),
    PERSON_ADD("mdrmz-person_add", '\ue4a0'),
    PERSON_ADD_ALT_1("mdrmz-person_add_alt_1", '\ue7fb'),
    PERSON_ADD_DISABLED("mdrmz-person_add_disabled", '\ue4a2'),
    PERSON_OUTLINE("mdrmz-person_outline", '\ue4a4'),
    PERSON_PIN("mdrmz-person_pin", '\ue4a6'),
    PERSON_PIN_CIRCLE("mdrmz-person_pin_circle", '\ue4a8'),
    PERSON_REMOVE("mdrmz-person_remove", '\ue7fd'),
    PERSON_REMOVE_ALT_1("mdrmz-person_remove_alt_1", '\ue7ff'),
    PERSON_SEARCH("mdrmz-person_search", '\ue801'),
    PERSONAL_VIDEO("mdrmz-personal_video", '\ue4aa'),
    PEST_CONTROL("mdrmz-pest_control", '\ue803'),
    PEST_CONTROL_RODENT("mdrmz-pest_control_rodent", '\ue805'),
    PETS("mdrmz-pets", '\ue4ac'),
    PHONE("mdrmz-phone", '\ue4ad'),
    PHONE_ANDROID("mdrmz-phone_android", '\ue4af'),
    PHONE_BLUETOOTH_SPEAKER("mdrmz-phone_bluetooth_speaker", '\ue4b1'),
    PHONE_CALLBACK("mdrmz-phone_callback", '\ue4b3'),
    PHONE_DISABLED("mdrmz-phone_disabled", '\ue4b5'),
    PHONE_ENABLED("mdrmz-phone_enabled", '\ue4b6'),
    PHONE_FORWARDED("mdrmz-phone_forwarded", '\ue4b7'),
    PHONE_IN_TALK("mdrmz-phone_in_talk", '\ue4b9'),
    PHONE_IPHONE("mdrmz-phone_iphone", '\ue4bb'),
    PHONE_LOCKED("mdrmz-phone_locked", '\ue4bd'),
    PHONE_MISSED("mdrmz-phone_missed", '\ue4bf'),
    PHONE_PAUSED("mdrmz-phone_paused", '\ue4c1'),
    PHONELINK("mdrmz-phonelink", '\ue4c3'),
    PHONELINK_ERASE("mdrmz-phonelink_erase", '\ue4c5'),
    PHONELINK_LOCK("mdrmz-phonelink_lock", '\ue4c6'),
    PHONELINK_OFF("mdrmz-phonelink_off", '\ue4c7'),
    PHONELINK_RING("mdrmz-phonelink_ring", '\ue4c9'),
    PHONELINK_SETUP("mdrmz-phonelink_setup", '\ue4cb'),
    PHOTO("mdrmz-photo", '\ue4cc'),
    PHOTO_ALBUM("mdrmz-photo_album", '\ue4ce'),
    PHOTO_CAMERA("mdrmz-photo_camera", '\ue4d0'),
    PHOTO_FILTER("mdrmz-photo_filter", '\ue4d2'),
    PHOTO_LIBRARY("mdrmz-photo_library", '\ue4d3'),
    PHOTO_SIZE_SELECT_ACTUAL("mdrmz-photo_size_select_actual", '\ue4d5'),
    PHOTO_SIZE_SELECT_LARGE("mdrmz-photo_size_select_large", '\ue4d7'),
    PHOTO_SIZE_SELECT_SMALL("mdrmz-photo_size_select_small", '\ue4d8'),
    PICTURE_AS_PDF("mdrmz-picture_as_pdf", '\ue4d9'),
    PICTURE_IN_PICTURE("mdrmz-picture_in_picture", '\ue4db'),
    PICTURE_IN_PICTURE_ALT("mdrmz-picture_in_picture_alt", '\ue4dd'),
    PIE_CHART("mdrmz-pie_chart", '\ue4df'),
    PIN("mdrmz-pin", '\ue4e1'),
    PIN_DROP("mdrmz-pin_drop", '\ue4e3'),
    PIN_OFF("mdrmz-pin_off", '\ue4e5'),
    PLACE("mdrmz-place", '\ue4e7'),
    PLAGIARISM("mdrmz-plagiarism", '\ue807'),
    PLAY_ARROW("mdrmz-play_arrow", '\ue4e9'),
    PLAY_CIRCLE_FILLED("mdrmz-play_circle_filled", '\ue4eb'),
    PLAY_CIRCLE_FILLED_WHITE("mdrmz-play_circle_filled_white", '\ue4ed'),
    PLAY_CIRCLE_OUTLINE("mdrmz-play_circle_outline", '\ue4ef'),
    PLAY_FOR_WORK("mdrmz-play_for_work", '\ue4f0'),
    PLAYLIST_ADD("mdrmz-playlist_add", '\ue4f1'),
    PLAYLIST_ADD_CHECK("mdrmz-playlist_add_check", '\ue4f2'),
    PLAYLIST_PLAY("mdrmz-playlist_play", '\ue4f3'),
    PLUMBING("mdrmz-plumbing", '\ue809'),
    PLUS("mdrmz-plus", '\ue4f4'),
    PLUS_MINUS("mdrmz-plus_minus", '\ue4f5'),
    PLUS_MINUS_ALT("mdrmz-plus_minus_alt", '\ue4f6'),
    PLUS_ONE("mdrmz-plus_one", '\ue4f7'),
    POINT_OF_SALE("mdrmz-point_of_sale", '\ue80a'),
    POLICY("mdrmz-policy", '\ue4f8'),
    POLL("mdrmz-poll", '\ue4fa'),
    POLYMER("mdrmz-polymer", '\ue4fc'),
    POOL("mdrmz-pool", '\ue4fd'),
    PORTABLE_WIFI_OFF("mdrmz-portable_wifi_off", '\ue4ff'),
    PORTRAIT("mdrmz-portrait", '\ue500'),
    POST_ADD("mdrmz-post_add", '\ue502'),
    POWER("mdrmz-power", '\ue503'),
    POWER_INPUT("mdrmz-power_input", '\ue505'),
    POWER_OFF("mdrmz-power_off", '\ue506'),
    POWER_SETTINGS_NEW("mdrmz-power_settings_new", '\ue508'),
    PREGNANT_WOMAN("mdrmz-pregnant_woman", '\ue509'),
    PRESENT_TO_ALL("mdrmz-present_to_all", '\ue50a'),
    PREVIEW("mdrmz-preview", '\ue80c'),
    PRINT("mdrmz-print", '\ue50c'),
    PRINT_DISABLED("mdrmz-print_disabled", '\ue50e'),
    PRIORITY_HIGH("mdrmz-priority_high", '\ue510'),
    PRIVACY_TIP("mdrmz-privacy_tip", '\ue80e'),
    PSYCHOLOGY("mdrmz-psychology", '\ue810'),
    PUBLIC("mdrmz-public", '\ue511'),
    PUBLIC_OFF("mdrmz-public_off", '\ue812'),
    PUBLISH("mdrmz-publish", '\ue513'),
    PUBLISHED_WITH_CHANGES("mdrmz-published_with_changes", '\ue8c4'),
    PUSH_PIN("mdrmz-push_pin", '\ue814'),
    QR_CODE("mdrmz-qr_code", '\ue816'),
    QR_CODE_2("mdrmz-qr_code_2", '\ue8d1'),
    QR_CODE_SCANNER("mdrmz-qr_code_scanner", '\ue885'),
    QRCODE("mdrmz-qrcode", '\ue515'),
    QUERY_BUILDER("mdrmz-query_builder", '\ue517'),
    QUESTION_ANSWER("mdrmz-question_answer", '\ue519'),
    QUEUE("mdrmz-queue", '\ue51b'),
    QUEUE_MUSIC("mdrmz-queue_music", '\ue51d'),
    QUEUE_PLAY_NEXT("mdrmz-queue_play_next", '\ue51f'),
    QUICKREPLY("mdrmz-quickreply", '\ue818'),
    RADIO("mdrmz-radio", '\ue520'),
    RADIO_BUTTON_CHECKED("mdrmz-radio_button_checked", '\ue522'),
    RADIO_BUTTON_UNCHECKED("mdrmz-radio_button_unchecked", '\ue523'),
    RATE_REVIEW("mdrmz-rate_review", '\ue524'),
    READ_MORE("mdrmz-read_more", '\ue81a'),
    RECEIPT("mdrmz-receipt", '\ue526'),
    RECEIPT_LONG("mdrmz-receipt_long", '\ue81b'),
    RECENT_ACTORS("mdrmz-recent_actors", '\ue528'),
    RECORD_VOICE_OVER("mdrmz-record_voice_over", '\ue52a'),
    REDEEM("mdrmz-redeem", '\ue52c'),
    REDO("mdrmz-redo", '\ue52e'),
    REDUCE_CAPACITY("mdrmz-reduce_capacity", '\ue8af'),
    REFRESH("mdrmz-refresh", '\ue52f'),
    REMOVE("mdrmz-remove", '\ue530'),
    REMOVE_CIRCLE("mdrmz-remove_circle", '\ue531'),
    REMOVE_CIRCLE_OUTLINE("mdrmz-remove_circle_outline", '\ue533'),
    REMOVE_FROM_QUEUE("mdrmz-remove_from_queue", '\ue534'),
    REMOVE_RED_EYE("mdrmz-remove_red_eye", '\ue536'),
    REMOVE_SHOPPING_CART("mdrmz-remove_shopping_cart", '\ue538'),
    REORDER("mdrmz-reorder", '\ue53a'),
    REPEAT("mdrmz-repeat", '\ue53b'),
    REPEAT_ONE("mdrmz-repeat_one", '\ue53c'),
    REPLAY("mdrmz-replay", '\ue53d'),
    REPLAY_10("mdrmz-replay_10", '\ue53e'),
    REPLAY_30("mdrmz-replay_30", '\ue53f'),
    REPLAY_5("mdrmz-replay_5", '\ue540'),
    REPLY("mdrmz-reply", '\ue541'),
    REPLY_ALL("mdrmz-reply_all", '\ue542'),
    REPORT("mdrmz-report", '\ue543'),
    REPORT_OFF("mdrmz-report_off", '\ue545'),
    REPORT_PROBLEM("mdrmz-report_problem", '\ue547'),
    REQUEST_PAGE("mdrmz-request_page", '\ue8c5'),
    REQUEST_QUOTE("mdrmz-request_quote", '\ue81d'),
    RESTAURANT("mdrmz-restaurant", '\ue549'),
    RESTAURANT_MENU("mdrmz-restaurant_menu", '\ue54a'),
    RESTORE("mdrmz-restore", '\ue54b'),
    RESTORE_FROM_TRASH("mdrmz-restore_from_trash", '\ue54c'),
    RESTORE_PAGE("mdrmz-restore_page", '\ue54e'),
    RICE_BOWL("mdrmz-rice_bowl", '\ue886'),
    RING_VOLUME("mdrmz-ring_volume", '\ue550'),
    ROCKET("mdrmz-rocket", '\ue552'),
    ROOFING("mdrmz-roofing", '\ue888'),
    ROOM("mdrmz-room", '\ue554'),
    ROOM_PREFERENCES("mdrmz-room_preferences", '\ue81f'),
    ROOM_SERVICE("mdrmz-room_service", '\ue556'),
    ROTATE_90_DEGREES_CCW("mdrmz-rotate_90_degrees_ccw", '\ue558'),
    ROTATE_LEFT("mdrmz-rotate_left", '\ue55a'),
    ROTATE_RIGHT("mdrmz-rotate_right", '\ue55b'),
    ROUNDED_CORNER("mdrmz-rounded_corner", '\ue55c'),
    ROUTER("mdrmz-router", '\ue55d'),
    ROWING("mdrmz-rowing", '\ue55f'),
    RSS_FEED("mdrmz-rss_feed", '\ue560'),
    RULE("mdrmz-rule", '\ue821'),
    RULE_FOLDER("mdrmz-rule_folder", '\ue822'),
    RUN_CIRCLE("mdrmz-run_circle", '\ue824'),
    RV_HOOKUP("mdrmz-rv_hookup", '\ue561'),
    SANITIZER("mdrmz-sanitizer", '\ue8b0'),
    SATELLITE("mdrmz-satellite", '\ue563'),
    SAVE("mdrmz-save", '\ue565'),
    SAVE_ALT("mdrmz-save_alt", '\ue567'),
    SCANNER("mdrmz-scanner", '\ue568'),
    SCATTER_PLOT("mdrmz-scatter_plot", '\ue56a'),
    SCHEDULE("mdrmz-schedule", '\ue56c'),
    SCHOOL("mdrmz-school", '\ue56e'),
    SCIENCE("mdrmz-science", '\ue826'),
    SCORE("mdrmz-score", '\ue570'),
    SCREEN_LOCK_LANDSCAPE("mdrmz-screen_lock_landscape", '\ue572'),
    SCREEN_LOCK_PORTRAIT("mdrmz-screen_lock_portrait", '\ue574'),
    SCREEN_LOCK_ROTATION("mdrmz-screen_lock_rotation", '\ue576'),
    SCREEN_ROTATION("mdrmz-screen_rotation", '\ue577'),
    SCREEN_SHARE("mdrmz-screen_share", '\ue579'),
    SD_CARD("mdrmz-sd_card", '\ue57b'),
    SD_STORAGE("mdrmz-sd_storage", '\ue57d'),
    SEARCH("mdrmz-search", '\ue57f'),
    SEARCH_OFF("mdrmz-search_off", '\ue828'),
    SECURITY("mdrmz-security", '\ue580'),
    SELECT_ALL("mdrmz-select_all", '\ue582'),
    SELF_IMPROVEMENT("mdrmz-self_improvement", '\ue829'),
    SEND("mdrmz-send", '\ue583'),
    SENSOR_DOOR("mdrmz-sensor_door", '\ue82a'),
    SENSOR_WINDOW("mdrmz-sensor_window", '\ue82c'),
    SENTIMENT_DISSATISFIED("mdrmz-sentiment_dissatisfied", '\ue585'),
    SENTIMENT_NEUTRAL("mdrmz-sentiment_neutral", '\ue587'),
    SENTIMENT_SATISFIED("mdrmz-sentiment_satisfied", '\ue589'),
    SENTIMENT_SATISFIED_ALT("mdrmz-sentiment_satisfied_alt", '\ue58b'),
    SENTIMENT_SLIGHTLY_DISSATISFIED("mdrmz-sentiment_slightly_dissatisfied", '\ue58d'),
    SENTIMENT_VERY_DISSATISFIED("mdrmz-sentiment_very_dissatisfied", '\ue58f'),
    SENTIMENT_VERY_SATISFIED("mdrmz-sentiment_very_satisfied", '\ue591'),
    SET_MEAL("mdrmz-set_meal", '\ue88a'),
    SETTINGS("mdrmz-settings", '\ue593'),
    SETTINGS_APPLICATIONS("mdrmz-settings_applications", '\ue595'),
    SETTINGS_BACKUP_RESTORE("mdrmz-settings_backup_restore", '\ue597'),
    SETTINGS_BLUETOOTH("mdrmz-settings_bluetooth", '\ue598'),
    SETTINGS_BRIGHTNESS("mdrmz-settings_brightness", '\ue599'),
    SETTINGS_CELL("mdrmz-settings_cell", '\ue59b'),
    SETTINGS_ETHERNET("mdrmz-settings_ethernet", '\ue59d'),
    SETTINGS_INPUT_ANTENNA("mdrmz-settings_input_antenna", '\ue59e'),
    SETTINGS_INPUT_COMPONENT("mdrmz-settings_input_component", '\ue59f'),
    SETTINGS_INPUT_COMPOSITE("mdrmz-settings_input_composite", '\ue5a1'),
    SETTINGS_INPUT_HDMI("mdrmz-settings_input_hdmi", '\ue5a3'),
    SETTINGS_INPUT_SVIDEO("mdrmz-settings_input_svideo", '\ue5a5'),
    SETTINGS_OVERSCAN("mdrmz-settings_overscan", '\ue5a7'),
    SETTINGS_PHONE("mdrmz-settings_phone", '\ue5a9'),
    SETTINGS_POWER("mdrmz-settings_power", '\ue5ab'),
    SETTINGS_REMOTE("mdrmz-settings_remote", '\ue5ac'),
    SETTINGS_SYSTEM_DAYDREAM("mdrmz-settings_system_daydream", '\ue5ae'),
    SETTINGS_VOICE("mdrmz-settings_voice", '\ue5b0'),
    SHARE("mdrmz-share", '\ue5b2'),
    SHOP("mdrmz-shop", '\ue5b4'),
    SHOP_TWO("mdrmz-shop_two", '\ue5b6'),
    SHOPPING_BAG("mdrmz-shopping_bag", '\ue82e'),
    SHOPPING_BASKET("mdrmz-shopping_basket", '\ue5b8'),
    SHOPPING_CART("mdrmz-shopping_cart", '\ue5ba'),
    SHORT_TEXT("mdrmz-short_text", '\ue5bc'),
    SHOW_CHART("mdrmz-show_chart", '\ue5bd'),
    SHUFFLE("mdrmz-shuffle", '\ue5be'),
    SHUTTER_SPEED("mdrmz-shutter_speed", '\ue5bf'),
    SICK("mdrmz-sick", '\ue8b2'),
    SIGNAL_CELLULAR_0_BAR("mdrmz-signal_cellular_0_bar", '\ue5c1'),
    SIGNAL_CELLULAR_1_BAR("mdrmz-signal_cellular_1_bar", '\ue5c3'),
    SIGNAL_CELLULAR_2_BAR("mdrmz-signal_cellular_2_bar", '\ue5c5'),
    SIGNAL_CELLULAR_3_BAR("mdrmz-signal_cellular_3_bar", '\ue5c7'),
    SIGNAL_CELLULAR_4_BAR("mdrmz-signal_cellular_4_bar", '\ue5c9'),
    SIGNAL_CELLULAR_ALT("mdrmz-signal_cellular_alt", '\ue5ca'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR("mdrmz-signal_cellular_connected_no_internet_0_bar", '\ue5cb'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR("mdrmz-signal_cellular_connected_no_internet_1_bar", '\ue5cd'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR("mdrmz-signal_cellular_connected_no_internet_2_bar", '\ue5cf'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR("mdrmz-signal_cellular_connected_no_internet_3_bar", '\ue5d1'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("mdrmz-signal_cellular_connected_no_internet_4_bar", '\ue5d3'),
    SIGNAL_CELLULAR_NO_SIM("mdrmz-signal_cellular_no_sim", '\ue5d4'),
    SIGNAL_CELLULAR_NULL("mdrmz-signal_cellular_null", '\ue5d6'),
    SIGNAL_CELLULAR_OFF("mdrmz-signal_cellular_off", '\ue5d7'),
    SIGNAL_WIFI_0_BAR("mdrmz-signal_wifi_0_bar", '\ue5d8'),
    SIGNAL_WIFI_1_BAR("mdrmz-signal_wifi_1_bar", '\ue5da'),
    SIGNAL_WIFI_1_BAR_LOCK("mdrmz-signal_wifi_1_bar_lock", '\ue5dc'),
    SIGNAL_WIFI_2_BAR("mdrmz-signal_wifi_2_bar", '\ue5de'),
    SIGNAL_WIFI_2_BAR_LOCK("mdrmz-signal_wifi_2_bar_lock", '\ue5e0'),
    SIGNAL_WIFI_3_BAR("mdrmz-signal_wifi_3_bar", '\ue5e2'),
    SIGNAL_WIFI_3_BAR_LOCK("mdrmz-signal_wifi_3_bar_lock", '\ue5e4'),
    SIGNAL_WIFI_4_BAR("mdrmz-signal_wifi_4_bar", '\ue5e6'),
    SIGNAL_WIFI_4_BAR_LOCK("mdrmz-signal_wifi_4_bar_lock", '\ue5e7'),
    SIGNAL_WIFI_OFF("mdrmz-signal_wifi_off", '\ue5e8'),
    SIM_CARD("mdrmz-sim_card", '\ue5e9'),
    SIM_CARD_ALERT("mdrmz-sim_card_alert", '\ue5eb'),
    SINGLE_BED("mdrmz-single_bed", '\ue5ed'),
    SKIP_NEXT("mdrmz-skip_next", '\ue5ef'),
    SKIP_PREVIOUS("mdrmz-skip_previous", '\ue5f1'),
    SLIDESHOW("mdrmz-slideshow", '\ue5f3'),
    SLOW_MOTION_VIDEO("mdrmz-slow_motion_video", '\ue5f5'),
    SMART_BUTTON("mdrmz-smart_button", '\ue830'),
    SMARTPHONE("mdrmz-smartphone", '\ue5f6'),
    SMOKE_FREE("mdrmz-smoke_free", '\ue5f8'),
    SMOKING_ROOMS("mdrmz-smoking_rooms", '\ue5f9'),
    SMS("mdrmz-sms", '\ue5fb'),
    SMS_FAILED("mdrmz-sms_failed", '\ue5fd'),
    SNIPPET_FOLDER("mdrmz-snippet_folder", '\ue831'),
    SNOOZE("mdrmz-snooze", '\ue5ff'),
    SOAP("mdrmz-soap", '\ue833'),
    SORT("mdrmz-sort", '\ue600'),
    SORT_BY_ALPHA("mdrmz-sort_by_alpha", '\ue601'),
    SOURCE("mdrmz-source", '\ue835'),
    SOUTH("mdrmz-south", '\ue88c'),
    SOUTH_EAST("mdrmz-south_east", '\ue88d'),
    SOUTH_WEST("mdrmz-south_west", '\ue88e'),
    SPA("mdrmz-spa", '\ue602'),
    SPACE_BAR("mdrmz-space_bar", '\ue604'),
    SPEAKER("mdrmz-speaker", '\ue605'),
    SPEAKER_GROUP("mdrmz-speaker_group", '\ue607'),
    SPEAKER_NOTES("mdrmz-speaker_notes", '\ue609'),
    SPEAKER_NOTES_OFF("mdrmz-speaker_notes_off", '\ue60b'),
    SPEAKER_PHONE("mdrmz-speaker_phone", '\ue60d'),
    SPEED("mdrmz-speed", '\ue60f'),
    SPELLCHECK("mdrmz-spellcheck", '\ue610'),
    SPORTS("mdrmz-sports", '\ue611'),
    SPORTS_BAR("mdrmz-sports_bar", '\ue88f'),
    SPORTS_BASEBALL("mdrmz-sports_baseball", '\ue612'),
    SPORTS_BASKETBALL("mdrmz-sports_basketball", '\ue614'),
    SPORTS_CRICKET("mdrmz-sports_cricket", '\ue616'),
    SPORTS_ESPORTS("mdrmz-sports_esports", '\ue618'),
    SPORTS_FOOTBALL("mdrmz-sports_football", '\ue61a'),
    SPORTS_GOLF("mdrmz-sports_golf", '\ue61c'),
    SPORTS_HANDBALL("mdrmz-sports_handball", '\ue61e'),
    SPORTS_HOCKEY("mdrmz-sports_hockey", '\ue61f'),
    SPORTS_KABADDI("mdrmz-sports_kabaddi", '\ue620'),
    SPORTS_MMA("mdrmz-sports_mma", '\ue621'),
    SPORTS_MOTORSPORTS("mdrmz-sports_motorsports", '\ue623'),
    SPORTS_RUGBY("mdrmz-sports_rugby", '\ue625'),
    SPORTS_SOCCER("mdrmz-sports_soccer", '\ue627'),
    SPORTS_TENNIS("mdrmz-sports_tennis", '\ue629'),
    SPORTS_VOLLEYBALL("mdrmz-sports_volleyball", '\ue62a'),
    SQUARE_FOOT("mdrmz-square_foot", '\ue62c'),
    STACKED_LINE_CHART("mdrmz-stacked_line_chart", '\ue8c7'),
    STAIRS("mdrmz-stairs", '\ue837'),
    STAR("mdrmz-star", '\ue62e'),
    STAR_BORDER("mdrmz-star_border", '\ue630'),
    STAR_HALF("mdrmz-star_half", '\ue631'),
    STAR_OUTLINE("mdrmz-star_outline", '\ue748'),
    STAR_RATE("mdrmz-star_rate", '\ue632'),
    STARS("mdrmz-stars", '\ue633'),
    STAY_CURRENT_LANDSCAPE("mdrmz-stay_current_landscape", '\ue635'),
    STAY_CURRENT_PORTRAIT("mdrmz-stay_current_portrait", '\ue637'),
    STAY_PRIMARY_LANDSCAPE("mdrmz-stay_primary_landscape", '\ue639'),
    STAY_PRIMARY_PORTRAIT("mdrmz-stay_primary_portrait", '\ue63b'),
    STICKY_NOTE_2("mdrmz-sticky_note_2", '\ue891'),
    STOP("mdrmz-stop", '\ue63d'),
    STOP_CIRCLE("mdrmz-stop_circle", '\ue63f'),
    STOP_SCREEN_SHARE("mdrmz-stop_screen_share", '\ue641'),
    STORAGE("mdrmz-storage", '\ue643'),
    STORE("mdrmz-store", '\ue644'),
    STORE_MALL_DIRECTORY("mdrmz-store_mall_directory", '\ue646'),
    STOREFRONT("mdrmz-storefront", '\ue648'),
    STRAIGHTEN("mdrmz-straighten", '\ue64a'),
    STREETVIEW("mdrmz-streetview", '\ue64c'),
    STRIKETHROUGH_S("mdrmz-strikethrough_s", '\ue64d'),
    STROLLER("mdrmz-stroller", '\ue839'),
    STYLE("mdrmz-style", '\ue64e'),
    SUBDIRECTORY_ARROW_LEFT("mdrmz-subdirectory_arrow_left", '\ue650'),
    SUBDIRECTORY_ARROW_RIGHT("mdrmz-subdirectory_arrow_right", '\ue651'),
    SUBJECT("mdrmz-subject", '\ue652'),
    SUBSCRIPT("mdrmz-subscript", '\ue83b'),
    SUBSCRIPTIONS("mdrmz-subscriptions", '\ue653'),
    SUBTITLES("mdrmz-subtitles", '\ue655'),
    SUBTITLES_OFF("mdrmz-subtitles_off", '\ue83c'),
    SUBWAY("mdrmz-subway", '\ue657'),
    SUPERSCRIPT("mdrmz-superscript", '\ue83e'),
    SUPERVISED_USER_CIRCLE("mdrmz-supervised_user_circle", '\ue659'),
    SUPERVISOR_ACCOUNT("mdrmz-supervisor_account", '\ue65b'),
    SUPPORT("mdrmz-support", '\ue83f'),
    SUPPORT_AGENT("mdrmz-support_agent", '\ue841'),
    SURROUND_SOUND("mdrmz-surround_sound", '\ue65d'),
    SWAP_CALLS("mdrmz-swap_calls", '\ue65f'),
    SWAP_HORIZ("mdrmz-swap_horiz", '\ue660'),
    SWAP_HORIZONTAL_CIRCLE("mdrmz-swap_horizontal_circle", '\ue661'),
    SWAP_VERT("mdrmz-swap_vert", '\ue663'),
    SWAP_VERTICAL_CIRCLE("mdrmz-swap_vertical_circle", '\ue664'),
    SWITCH_CAMERA("mdrmz-switch_camera", '\ue666'),
    SWITCH_LEFT("mdrmz-switch_left", '\ue842'),
    SWITCH_RIGHT("mdrmz-switch_right", '\ue844'),
    SWITCH_VIDEO("mdrmz-switch_video", '\ue668'),
    SYNC("mdrmz-sync", '\ue66a'),
    SYNC_ALT("mdrmz-sync_alt", '\ue66b'),
    SYNC_DISABLED("mdrmz-sync_disabled", '\ue66c'),
    SYNC_PROBLEM("mdrmz-sync_problem", '\ue66d'),
    SYSTEM_UPDATE("mdrmz-system_update", '\ue66e'),
    SYSTEM_UPDATE_ALT("mdrmz-system_update_alt", '\ue670'),
    TAB("mdrmz-tab", '\ue671'),
    TAB_UNSELECTED("mdrmz-tab_unselected", '\ue672'),
    TABLE_CHART("mdrmz-table_chart", '\ue673'),
    TABLE_ROWS("mdrmz-table_rows", '\ue846'),
    TABLE_VIEW("mdrmz-table_view", '\ue848'),
    TABLET("mdrmz-tablet", '\ue675'),
    TABLET_ANDROID("mdrmz-tablet_android", '\ue677'),
    TABLET_MAC("mdrmz-tablet_mac", '\ue679'),
    TAG_FACES("mdrmz-tag_faces", '\ue67b'),
    TAP_AND_PLAY("mdrmz-tap_and_play", '\ue67d'),
    TAPAS("mdrmz-tapas", '\ue893'),
    TERRAIN("mdrmz-terrain", '\ue67e'),
    TEXT_FIELDS("mdrmz-text_fields", '\ue680'),
    TEXT_FORMAT("mdrmz-text_format", '\ue681'),
    TEXT_ROTATE_UP("mdrmz-text_rotate_up", '\ue682'),
    TEXT_ROTATE_VERTICAL("mdrmz-text_rotate_vertical", '\ue683'),
    TEXT_ROTATION_ANGLEDOWN("mdrmz-text_rotation_angledown", '\ue684'),
    TEXT_ROTATION_ANGLEUP("mdrmz-text_rotation_angleup", '\ue685'),
    TEXT_ROTATION_DOWN("mdrmz-text_rotation_down", '\ue686'),
    TEXT_ROTATION_NONE("mdrmz-text_rotation_none", '\ue687'),
    TEXT_SNIPPET("mdrmz-text_snippet", '\ue84a'),
    TEXTSMS("mdrmz-textsms", '\ue688'),
    TEXTURE("mdrmz-texture", '\ue68a'),
    THEATERS("mdrmz-theaters", '\ue68b'),
    THUMB_DOWN("mdrmz-thumb_down", '\ue68d'),
    THUMB_DOWN_ALT("mdrmz-thumb_down_alt", '\ue68f'),
    THUMB_UP("mdrmz-thumb_up", '\ue691'),
    THUMB_UP_ALT("mdrmz-thumb_up_alt", '\ue693'),
    THUMBS_UP_DOWN("mdrmz-thumbs_up_down", '\ue695'),
    TIME_TO_LEAVE("mdrmz-time_to_leave", '\ue697'),
    TIMELAPSE("mdrmz-timelapse", '\ue699'),
    TIMELINE("mdrmz-timeline", '\ue69b'),
    TIMER("mdrmz-timer", '\ue69c'),
    TIMER_10("mdrmz-timer_10", '\ue69e'),
    TIMER_3("mdrmz-timer_3", '\ue69f'),
    TIMER_OFF("mdrmz-timer_off", '\ue6a0'),
    TITLE("mdrmz-title", '\ue6a2'),
    TOC("mdrmz-toc", '\ue6a3'),
    TODAY("mdrmz-today", '\ue6a4'),
    TOGGLE_OFF("mdrmz-toggle_off", '\ue6a6'),
    TOGGLE_ON("mdrmz-toggle_on", '\ue6a8'),
    TOLL("mdrmz-toll", '\ue6aa'),
    TONALITY("mdrmz-tonality", '\ue6ac'),
    TOPIC("mdrmz-topic", '\ue84c'),
    TOUCH_APP("mdrmz-touch_app", '\ue6ae'),
    TOUR("mdrmz-tour", '\ue84e'),
    TOYS("mdrmz-toys", '\ue6b0'),
    TRACK_CHANGES("mdrmz-track_changes", '\ue6b2'),
    TRAFFIC("mdrmz-traffic", '\ue6b3'),
    TRAIN("mdrmz-train", '\ue6b5'),
    TRAM("mdrmz-tram", '\ue6b7'),
    TRANSFER_WITHIN_A_STATION("mdrmz-transfer_within_a_station", '\ue6b9'),
    TRANSFORM("mdrmz-transform", '\ue6ba'),
    TRANSIT_ENTEREXIT("mdrmz-transit_enterexit", '\ue6bb'),
    TRANSLATE("mdrmz-translate", '\ue6bc'),
    TRENDING_DOWN("mdrmz-trending_down", '\ue6bd'),
    TRENDING_FLAT("mdrmz-trending_flat", '\ue6be'),
    TRENDING_UP("mdrmz-trending_up", '\ue6bf'),
    TRIP_ORIGIN("mdrmz-trip_origin", '\ue6c0'),
    TTY("mdrmz-tty", '\ue850'),
    TUNE("mdrmz-tune", '\ue6c1'),
    TURNED_IN("mdrmz-turned_in", '\ue6c2'),
    TURNED_IN_NOT("mdrmz-turned_in_not", '\ue6c4'),
    TV("mdrmz-tv", '\ue6c5'),
    TV_OFF("mdrmz-tv_off", '\ue6c7'),
    TWO_WHEELER("mdrmz-two_wheeler", '\ue749'),
    UMBRELLA("mdrmz-umbrella", '\ue852'),
    UNARCHIVE("mdrmz-unarchive", '\ue6c9'),
    UNDO("mdrmz-undo", '\ue6cb'),
    UNFOLD_LESS("mdrmz-unfold_less", '\ue6cc'),
    UNFOLD_MORE("mdrmz-unfold_more", '\ue6cd'),
    UNPUBLISHED("mdrmz-unpublished", '\ue8c8'),
    UNSUBSCRIBE("mdrmz-unsubscribe", '\ue6ce'),
    UPDATE("mdrmz-update", '\ue6d0'),
    UPDATE_DISABLED("mdrmz-update_disabled", '\ue8d2'),
    UPGRADE("mdrmz-upgrade", '\ue854'),
    USB("mdrmz-usb", '\ue6d1'),
    VERIFIED("mdrmz-verified", '\ue855'),
    VERIFIED_USER("mdrmz-verified_user", '\ue6d2'),
    VERTICAL_ALIGN_BOTTOM("mdrmz-vertical_align_bottom", '\ue6d4'),
    VERTICAL_ALIGN_CENTER("mdrmz-vertical_align_center", '\ue6d5'),
    VERTICAL_ALIGN_TOP("mdrmz-vertical_align_top", '\ue6d6'),
    VERTICAL_DISTRIBUTE("mdrmz-vertical_distribute", '\ue8d3'),
    VERTICAL_SPLIT("mdrmz-vertical_split", '\ue6d7'),
    VIBRATION("mdrmz-vibration", '\ue6d9'),
    VIDEO_CALL("mdrmz-video_call", '\ue6db'),
    VIDEO_LABEL("mdrmz-video_label", '\ue6dd'),
    VIDEO_LIBRARY("mdrmz-video_library", '\ue6df'),
    VIDEO_SETTINGS("mdrmz-video_settings", '\ue857'),
    VIDEOCAM("mdrmz-videocam", '\ue6e1'),
    VIDEOCAM_OFF("mdrmz-videocam_off", '\ue6e3'),
    VIDEOGAME_ASSET("mdrmz-videogame_asset", '\ue6e5'),
    VIEW_AGENDA("mdrmz-view_agenda", '\ue6e7'),
    VIEW_ARRAY("mdrmz-view_array", '\ue6e9'),
    VIEW_CAROUSEL("mdrmz-view_carousel", '\ue6eb'),
    VIEW_COLUMN("mdrmz-view_column", '\ue6ed'),
    VIEW_COMFY("mdrmz-view_comfy", '\ue6ef'),
    VIEW_COMPACT("mdrmz-view_compact", '\ue6f1'),
    VIEW_DAY("mdrmz-view_day", '\ue6f3'),
    VIEW_HEADLINE("mdrmz-view_headline", '\ue6f5'),
    VIEW_LIST("mdrmz-view_list", '\ue6f6'),
    VIEW_MODULE("mdrmz-view_module", '\ue6f8'),
    VIEW_QUILT("mdrmz-view_quilt", '\ue6fa'),
    VIEW_SIDEBAR("mdrmz-view_sidebar", '\ue858'),
    VIEW_STREAM("mdrmz-view_stream", '\ue6fc'),
    VIEW_WEEK("mdrmz-view_week", '\ue6fe'),
    VIGNETTE("mdrmz-vignette", '\ue700'),
    VISIBILITY("mdrmz-visibility", '\ue702'),
    VISIBILITY_OFF("mdrmz-visibility_off", '\ue704'),
    VOICE_CHAT("mdrmz-voice_chat", '\ue706'),
    VOICE_OVER_OFF("mdrmz-voice_over_off", '\ue708'),
    VOICEMAIL("mdrmz-voicemail", '\ue70a'),
    VOLUME_DOWN("mdrmz-volume_down", '\ue70b'),
    VOLUME_MUTE("mdrmz-volume_mute", '\ue70d'),
    VOLUME_OFF("mdrmz-volume_off", '\ue70f'),
    VOLUME_UP("mdrmz-volume_up", '\ue711'),
    VPN_KEY("mdrmz-vpn_key", '\ue713'),
    VPN_LOCK("mdrmz-vpn_lock", '\ue715'),
    WALLPAPER("mdrmz-wallpaper", '\ue717'),
    WARNING("mdrmz-warning", '\ue718'),
    WASH("mdrmz-wash", '\ue85a'),
    WATCH("mdrmz-watch", '\ue71a'),
    WATCH_LATER("mdrmz-watch_later", '\ue71c'),
    WATER_DAMAGE("mdrmz-water_damage", '\ue895'),
    WAVES("mdrmz-waves", '\ue71e'),
    WB_AUTO("mdrmz-wb_auto", '\ue71f'),
    WB_CLOUDY("mdrmz-wb_cloudy", '\ue721'),
    WB_INCANDESCENT("mdrmz-wb_incandescent", '\ue723'),
    WB_IRIDESCENT("mdrmz-wb_iridescent", '\ue725'),
    WB_SUNNY("mdrmz-wb_sunny", '\ue727'),
    WC("mdrmz-wc", '\ue729'),
    WEB("mdrmz-web", '\ue72a'),
    WEB_ASSET("mdrmz-web_asset", '\ue72c'),
    WEEKEND("mdrmz-weekend", '\ue72e'),
    WEST("mdrmz-west", '\ue897'),
    WHATSHOT("mdrmz-whatshot", '\ue730'),
    WHEELCHAIR_PICKUP("mdrmz-wheelchair_pickup", '\ue85c'),
    WHERE_TO_VOTE("mdrmz-where_to_vote", '\ue732'),
    WIDGETS("mdrmz-widgets", '\ue734'),
    WIFI("mdrmz-wifi", '\ue736'),
    WIFI_CALLING("mdrmz-wifi_calling", '\ue85d'),
    WIFI_LOCK("mdrmz-wifi_lock", '\ue737'),
    WIFI_OFF("mdrmz-wifi_off", '\ue738'),
    WIFI_PROTECTED_SETUP("mdrmz-wifi_protected_setup", '\ue85f'),
    WIFI_TETHERING("mdrmz-wifi_tethering", '\ue739'),
    WINE_BAR("mdrmz-wine_bar", '\ue898'),
    WORK("mdrmz-work", '\ue73a'),
    WORK_OFF("mdrmz-work_off", '\ue73c'),
    WORK_OUTLINE("mdrmz-work_outline", '\ue73e'),
    WRAP_TEXT("mdrmz-wrap_text", '\ue73f'),
    WRONG_LOCATION("mdrmz-wrong_location", '\ue860'),
    WYSIWYG("mdrmz-wysiwyg", '\ue861'),
    YOUTUBE_SEARCHED_FOR("mdrmz-youtube_searched_for", '\ue740'),
    ZOOM_IN("mdrmz-zoom_in", '\ue741'),
    ZOOM_OUT("mdrmz-zoom_out", '\ue742'),
    ZOOM_OUT_MAP("mdrmz-zoom_out_map", '\ue743');
    
    public static Material2RoundMZ findByDescription(String description) {
        for (Material2RoundMZ font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2RoundMZ(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}