/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2SharpAL implements Ikon {
    MDSAL_360("mdsal-360", '\ue000'),
    MDSAL_3D_ROTATION("mdsal-3d_rotation", '\ue001'),
    MDSAL_4K("mdsal-4k", '\ue002'),
    MDSAL_5G("mdsal-5g", '\ue74a'),
    MDSAL_6_FT_APART("mdsal-6_ft_apart", '\ue89a'),
    AC_UNIT("mdsal-ac_unit", '\ue004'),
    ACCESS_ALARM("mdsal-access_alarm", '\ue005'),
    ACCESS_ALARMS("mdsal-access_alarms", '\ue007'),
    ACCESS_TIME("mdsal-access_time", '\ue009'),
    ACCESSIBILITY("mdsal-accessibility", '\ue00b'),
    ACCESSIBILITY_NEW("mdsal-accessibility_new", '\ue00c'),
    ACCESSIBLE("mdsal-accessible", '\ue00d'),
    ACCESSIBLE_FORWARD("mdsal-accessible_forward", '\ue00e'),
    ACCOUNT_BALANCE("mdsal-account_balance", '\ue00f'),
    ACCOUNT_BALANCE_WALLET("mdsal-account_balance_wallet", '\ue011'),
    ACCOUNT_BOX("mdsal-account_box", '\ue013'),
    ACCOUNT_CIRCLE("mdsal-account_circle", '\ue015'),
    ACCOUNT_TREE("mdsal-account_tree", '\ue017'),
    AD_UNITS("mdsal-ad_units", '\ue74b'),
    ADB("mdsal-adb", '\ue019'),
    ADD("mdsal-add", '\ue01a'),
    ADD_A_PHOTO("mdsal-add_a_photo", '\ue01b'),
    ADD_ALARM("mdsal-add_alarm", '\ue01d'),
    ADD_ALERT("mdsal-add_alert", '\ue01f'),
    ADD_BOX("mdsal-add_box", '\ue021'),
    ADD_BUSINESS("mdsal-add_business", '\ue74d'),
    ADD_CIRCLE("mdsal-add_circle", '\ue023'),
    ADD_CIRCLE_OUTLINE("mdsal-add_circle_outline", '\ue025'),
    ADD_COMMENT("mdsal-add_comment", '\ue026'),
    ADD_IC_CALL("mdsal-add_ic_call", '\ue744'),
    ADD_LOCATION("mdsal-add_location", '\ue028'),
    ADD_LOCATION_ALT("mdsal-add_location_alt", '\ue74f'),
    ADD_PHOTO_ALTERNATE("mdsal-add_photo_alternate", '\ue02a'),
    ADD_ROAD("mdsal-add_road", '\ue751'),
    ADD_SHOPPING_CART("mdsal-add_shopping_cart", '\ue02c'),
    ADD_TASK("mdsal-add_task", '\ue8b3'),
    ADD_TO_HOME_SCREEN("mdsal-add_to_home_screen", '\ue02d'),
    ADD_TO_PHOTOS("mdsal-add_to_photos", '\ue02e'),
    ADD_TO_QUEUE("mdsal-add_to_queue", '\ue030'),
    ADDCHART("mdsal-addchart", '\ue752'),
    ADJUST("mdsal-adjust", '\ue032'),
    ADMIN_PANEL_SETTINGS("mdsal-admin_panel_settings", '\ue753'),
    AGRICULTURE("mdsal-agriculture", '\ue755'),
    AIRLINE_SEAT_FLAT("mdsal-airline_seat_flat", '\ue033'),
    AIRLINE_SEAT_FLAT_ANGLED("mdsal-airline_seat_flat_angled", '\ue035'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("mdsal-airline_seat_individual_suite", '\ue037'),
    AIRLINE_SEAT_LEGROOM_EXTRA("mdsal-airline_seat_legroom_extra", '\ue039'),
    AIRLINE_SEAT_LEGROOM_NORMAL("mdsal-airline_seat_legroom_normal", '\ue03a'),
    AIRLINE_SEAT_LEGROOM_REDUCED("mdsal-airline_seat_legroom_reduced", '\ue03b'),
    AIRLINE_SEAT_RECLINE_EXTRA("mdsal-airline_seat_recline_extra", '\ue03c'),
    AIRLINE_SEAT_RECLINE_NORMAL("mdsal-airline_seat_recline_normal", '\ue03d'),
    AIRPLANEMODE_ACTIVE("mdsal-airplanemode_active", '\ue03e'),
    AIRPLANEMODE_INACTIVE("mdsal-airplanemode_inactive", '\ue03f'),
    AIRPLAY("mdsal-airplay", '\ue040'),
    AIRPORT_SHUTTLE("mdsal-airport_shuttle", '\ue041'),
    ALARM("mdsal-alarm", '\ue043'),
    ALARM_ADD("mdsal-alarm_add", '\ue045'),
    ALARM_OFF("mdsal-alarm_off", '\ue047'),
    ALARM_ON("mdsal-alarm_on", '\ue048'),
    ALBUM("mdsal-album", '\ue04a'),
    ALIGN_HORIZONTAL_CENTER("mdsal-align_horizontal_center", '\ue8ca'),
    ALIGN_HORIZONTAL_LEFT("mdsal-align_horizontal_left", '\ue8cb'),
    ALIGN_HORIZONTAL_RIGHT("mdsal-align_horizontal_right", '\ue8cc'),
    ALIGN_VERTICAL_BOTTOM("mdsal-align_vertical_bottom", '\ue8cd'),
    ALIGN_VERTICAL_CENTER("mdsal-align_vertical_center", '\ue8ce'),
    ALIGN_VERTICAL_TOP("mdsal-align_vertical_top", '\ue8cf'),
    ALL_INBOX("mdsal-all_inbox", '\ue04c'),
    ALL_INCLUSIVE("mdsal-all_inclusive", '\ue04e'),
    ALL_OUT("mdsal-all_out", '\ue04f'),
    ALT_ROUTE("mdsal-alt_route", '\ue757'),
    ALTERNATE_EMAIL("mdsal-alternate_email", '\ue051'),
    AMP_STORIES("mdsal-amp_stories", '\ue053'),
    ANALYTICS("mdsal-analytics", '\ue758'),
    ANCHOR("mdsal-anchor", '\ue75a'),
    ANDROID("mdsal-android", '\ue055'),
    ANNOUNCEMENT("mdsal-announcement", '\ue056'),
    APARTMENT("mdsal-apartment", '\ue058'),
    API("mdsal-api", '\ue75b'),
    APP_BLOCKING("mdsal-app_blocking", '\ue75c'),
    APP_SETTINGS_ALT("mdsal-app_settings_alt", '\ue75e'),
    APPS("mdsal-apps", '\ue059'),
    ARCHITECTURE("mdsal-architecture", '\ue760'),
    ARCHIVE("mdsal-archive", '\ue05a'),
    ARROW_BACK("mdsal-arrow_back", '\ue05c'),
    ARROW_BACK_IOS("mdsal-arrow_back_ios", '\ue05d'),
    ARROW_CIRCLE_DOWN("mdsal-arrow_circle_down", '\ue761'),
    ARROW_CIRCLE_UP("mdsal-arrow_circle_up", '\ue763'),
    ARROW_DOWNWARD("mdsal-arrow_downward", '\ue05e'),
    ARROW_DROP_DOWN("mdsal-arrow_drop_down", '\ue05f'),
    ARROW_DROP_DOWN_CIRCLE("mdsal-arrow_drop_down_circle", '\ue060'),
    ARROW_DROP_UP("mdsal-arrow_drop_up", '\ue062'),
    ARROW_FORWARD("mdsal-arrow_forward", '\ue063'),
    ARROW_FORWARD_IOS("mdsal-arrow_forward_ios", '\ue064'),
    ARROW_LEFT("mdsal-arrow_left", '\ue065'),
    ARROW_RIGHT("mdsal-arrow_right", '\ue066'),
    ARROW_RIGHT_ALT("mdsal-arrow_right_alt", '\ue067'),
    ARROW_UPWARD("mdsal-arrow_upward", '\ue068'),
    ART_TRACK("mdsal-art_track", '\ue069'),
    ARTICLE("mdsal-article", '\ue765'),
    ASPECT_RATIO("mdsal-aspect_ratio", '\ue06a'),
    ASSESSMENT("mdsal-assessment", '\ue06c'),
    ASSIGNMENT("mdsal-assignment", '\ue06e'),
    ASSIGNMENT_IND("mdsal-assignment_ind", '\ue070'),
    ASSIGNMENT_LATE("mdsal-assignment_late", '\ue072'),
    ASSIGNMENT_RETURN("mdsal-assignment_return", '\ue074'),
    ASSIGNMENT_RETURNED("mdsal-assignment_returned", '\ue076'),
    ASSIGNMENT_TURNED_IN("mdsal-assignment_turned_in", '\ue078'),
    ASSISTANT("mdsal-assistant", '\ue07a'),
    ASSISTANT_PHOTO("mdsal-assistant_photo", '\ue07c'),
    ATM("mdsal-atm", '\ue07e'),
    ATTACH_EMAIL("mdsal-attach_email", '\ue767'),
    ATTACH_FILE("mdsal-attach_file", '\ue07f'),
    ATTACH_MONEY("mdsal-attach_money", '\ue080'),
    ATTACHMENT("mdsal-attachment", '\ue081'),
    AUDIOTRACK("mdsal-audiotrack", '\ue082'),
    AUTO_DELETE("mdsal-auto_delete", '\ue768'),
    AUTORENEW("mdsal-autorenew", '\ue084'),
    AV_TIMER("mdsal-av_timer", '\ue085'),
    BABY_CHANGING_STATION("mdsal-baby_changing_station", '\ue76a'),
    BACKPACK("mdsal-backpack", '\ue76b'),
    BACKSPACE("mdsal-backspace", '\ue086'),
    BACKUP("mdsal-backup", '\ue088'),
    BACKUP_TABLE("mdsal-backup_table", '\ue76d'),
    BALLOT("mdsal-ballot", '\ue08a'),
    BAR_CHART("mdsal-bar_chart", '\ue08c'),
    BARCODE("mdsal-barcode", '\ue08d'),
    BATCH_PREDICTION("mdsal-batch_prediction", '\ue76f'),
    BATHTUB("mdsal-bathtub", '\ue08e'),
    BATTERY_20("mdsal-battery_20", '\ue090'),
    BATTERY_30("mdsal-battery_30", '\ue092'),
    BATTERY_50("mdsal-battery_50", '\ue094'),
    BATTERY_60("mdsal-battery_60", '\ue096'),
    BATTERY_80("mdsal-battery_80", '\ue098'),
    BATTERY_90("mdsal-battery_90", '\ue09a'),
    BATTERY_ALERT("mdsal-battery_alert", '\ue09c'),
    BATTERY_CHARGING_20("mdsal-battery_charging_20", '\ue09d'),
    BATTERY_CHARGING_30("mdsal-battery_charging_30", '\ue09f'),
    BATTERY_CHARGING_50("mdsal-battery_charging_50", '\ue0a1'),
    BATTERY_CHARGING_60("mdsal-battery_charging_60", '\ue0a3'),
    BATTERY_CHARGING_80("mdsal-battery_charging_80", '\ue0a5'),
    BATTERY_CHARGING_90("mdsal-battery_charging_90", '\ue0a7'),
    BATTERY_CHARGING_FULL("mdsal-battery_charging_full", '\ue0a9'),
    BATTERY_FULL("mdsal-battery_full", '\ue0aa'),
    BATTERY_STD("mdsal-battery_std", '\ue0ab'),
    BATTERY_UNKNOWN("mdsal-battery_unknown", '\ue0ac'),
    BEACH_ACCESS("mdsal-beach_access", '\ue0ad'),
    BEDTIME("mdsal-bedtime", '\ue771'),
    BEENHERE("mdsal-beenhere", '\ue0af'),
    BENTO("mdsal-bento", '\ue864'),
    BIKE_SCOOTER("mdsal-bike_scooter", '\ue773'),
    BIOTECH("mdsal-biotech", '\ue774'),
    BLOCK("mdsal-block", '\ue0b1'),
    BLUETOOTH("mdsal-bluetooth", '\ue0b2'),
    BLUETOOTH_AUDIO("mdsal-bluetooth_audio", '\ue0b3'),
    BLUETOOTH_CONNECTED("mdsal-bluetooth_connected", '\ue0b4'),
    BLUETOOTH_DISABLED("mdsal-bluetooth_disabled", '\ue0b5'),
    BLUETOOTH_SEARCHING("mdsal-bluetooth_searching", '\ue0b6'),
    BLUR_CIRCULAR("mdsal-blur_circular", '\ue0b7'),
    BLUR_LINEAR("mdsal-blur_linear", '\ue0b8'),
    BLUR_OFF("mdsal-blur_off", '\ue0b9'),
    BLUR_ON("mdsal-blur_on", '\ue0ba'),
    BOOK("mdsal-book", '\ue0bb'),
    BOOK_ONLINE("mdsal-book_online", '\ue89b'),
    BOOKMARK("mdsal-bookmark", '\ue0bd'),
    BOOKMARK_BORDER("mdsal-bookmark_border", '\ue0bf'),
    BOOKMARKS("mdsal-bookmarks", '\ue0c0'),
    BORDER_ALL("mdsal-border_all", '\ue0c2'),
    BORDER_BOTTOM("mdsal-border_bottom", '\ue0c3'),
    BORDER_CLEAR("mdsal-border_clear", '\ue0c4'),
    BORDER_COLOR("mdsal-border_color", '\ue0c5'),
    BORDER_HORIZONTAL("mdsal-border_horizontal", '\ue0c7'),
    BORDER_INNER("mdsal-border_inner", '\ue0c8'),
    BORDER_LEFT("mdsal-border_left", '\ue0c9'),
    BORDER_OUTER("mdsal-border_outer", '\ue0ca'),
    BORDER_RIGHT("mdsal-border_right", '\ue0cb'),
    BORDER_STYLE("mdsal-border_style", '\ue0cc'),
    BORDER_TOP("mdsal-border_top", '\ue0cd'),
    BORDER_VERTICAL("mdsal-border_vertical", '\ue0ce'),
    BRANDING_WATERMARK("mdsal-branding_watermark", '\ue0cf'),
    BRIGHTNESS_1("mdsal-brightness_1", '\ue0d1'),
    BRIGHTNESS_2("mdsal-brightness_2", '\ue0d3'),
    BRIGHTNESS_3("mdsal-brightness_3", '\ue0d5'),
    BRIGHTNESS_4("mdsal-brightness_4", '\ue0d7'),
    BRIGHTNESS_5("mdsal-brightness_5", '\ue0d9'),
    BRIGHTNESS_6("mdsal-brightness_6", '\ue0db'),
    BRIGHTNESS_7("mdsal-brightness_7", '\ue0dd'),
    BRIGHTNESS_AUTO("mdsal-brightness_auto", '\ue0df'),
    BRIGHTNESS_HIGH("mdsal-brightness_high", '\ue0e1'),
    BRIGHTNESS_LOW("mdsal-brightness_low", '\ue0e3'),
    BRIGHTNESS_MEDIUM("mdsal-brightness_medium", '\ue0e5'),
    BROKEN_IMAGE("mdsal-broken_image", '\ue0e7'),
    BROWSER_NOT_SUPPORTED("mdsal-browser_not_supported", '\ue776'),
    BRUSH("mdsal-brush", '\ue0e9'),
    BUBBLE_CHART("mdsal-bubble_chart", '\ue0eb'),
    BUG_REPORT("mdsal-bug_report", '\ue0ed'),
    BUILD("mdsal-build", '\ue0ef'),
    BUILD_CIRCLE("mdsal-build_circle", '\ue777'),
    BURST_MODE("mdsal-burst_mode", '\ue0f1'),
    BUSINESS("mdsal-business", '\ue0f3'),
    BUSINESS_CENTER("mdsal-business_center", '\ue0f5'),
    CACHED("mdsal-cached", '\ue0f7'),
    CAKE("mdsal-cake", '\ue0f8'),
    CALCULATE("mdsal-calculate", '\ue779'),
    CALENDAR_TODAY("mdsal-calendar_today", '\ue0fa'),
    CALENDAR_VIEW_DAY("mdsal-calendar_view_day", '\ue0fc'),
    CALL("mdsal-call", '\ue0fe'),
    CALL_END("mdsal-call_end", '\ue100'),
    CALL_MADE("mdsal-call_made", '\ue102'),
    CALL_MERGE("mdsal-call_merge", '\ue103'),
    CALL_MISSED("mdsal-call_missed", '\ue104'),
    CALL_MISSED_OUTGOING("mdsal-call_missed_outgoing", '\ue105'),
    CALL_RECEIVED("mdsal-call_received", '\ue106'),
    CALL_SPLIT("mdsal-call_split", '\ue107'),
    CALL_TO_ACTION("mdsal-call_to_action", '\ue108'),
    CAMERA("mdsal-camera", '\ue10a'),
    CAMERA_ALT("mdsal-camera_alt", '\ue10c'),
    CAMERA_ENHANCE("mdsal-camera_enhance", '\ue10e'),
    CAMERA_FRONT("mdsal-camera_front", '\ue110'),
    CAMERA_REAR("mdsal-camera_rear", '\ue112'),
    CAMERA_ROLL("mdsal-camera_roll", '\ue114'),
    CAMPAIGN("mdsal-campaign", '\ue77b'),
    CANCEL("mdsal-cancel", '\ue116'),
    CANCEL_PRESENTATION("mdsal-cancel_presentation", '\ue118'),
    CANCEL_SCHEDULE_SEND("mdsal-cancel_schedule_send", '\ue11a'),
    CARD_GIFTCARD("mdsal-card_giftcard", '\ue11c'),
    CARD_MEMBERSHIP("mdsal-card_membership", '\ue11e'),
    CARD_TRAVEL("mdsal-card_travel", '\ue120'),
    CARPENTER("mdsal-carpenter", '\ue866'),
    CASINO("mdsal-casino", '\ue122'),
    CAST("mdsal-cast", '\ue124'),
    CAST_CONNECTED("mdsal-cast_connected", '\ue125'),
    CAST_FOR_EDUCATION("mdsal-cast_for_education", '\ue127'),
    CATEGORY("mdsal-category", '\ue128'),
    CELL_WIFI("mdsal-cell_wifi", '\ue12a'),
    CENTER_FOCUS_STRONG("mdsal-center_focus_strong", '\ue12c'),
    CENTER_FOCUS_WEAK("mdsal-center_focus_weak", '\ue12e'),
    CHANGE_HISTORY("mdsal-change_history", '\ue130'),
    CHARGING_STATION("mdsal-charging_station", '\ue77d'),
    CHAT("mdsal-chat", '\ue132'),
    CHAT_BUBBLE("mdsal-chat_bubble", '\ue134'),
    CHAT_BUBBLE_OUTLINE("mdsal-chat_bubble_outline", '\ue136'),
    CHECK("mdsal-check", '\ue137'),
    CHECK_BOX("mdsal-check_box", '\ue138'),
    CHECK_BOX_OUTLINE_BLANK("mdsal-check_box_outline_blank", '\ue13a'),
    CHECK_CIRCLE("mdsal-check_circle", '\ue13b'),
    CHECK_CIRCLE_OUTLINE("mdsal-check_circle_outline", '\ue13d'),
    CHECKROOM("mdsal-checkroom", '\ue77f'),
    CHEVRON_LEFT("mdsal-chevron_left", '\ue13e'),
    CHEVRON_RIGHT("mdsal-chevron_right", '\ue13f'),
    CHILD_CARE("mdsal-child_care", '\ue140'),
    CHILD_FRIENDLY("mdsal-child_friendly", '\ue142'),
    CHROME_READER_MODE("mdsal-chrome_reader_mode", '\ue144'),
    CLASS("mdsal-class", '\ue146'),
    CLEAN_HANDS("mdsal-clean_hands", '\ue89d'),
    CLEANING_SERVICES("mdsal-cleaning_services", '\ue780'),
    CLEAR("mdsal-clear", '\ue148'),
    CLEAR_ALL("mdsal-clear_all", '\ue149'),
    CLOSE("mdsal-close", '\ue14a'),
    CLOSE_FULLSCREEN("mdsal-close_fullscreen", '\ue782'),
    CLOSED_CAPTION("mdsal-closed_caption", '\ue14b'),
    CLOSED_CAPTION_DISABLED("mdsal-closed_caption_disabled", '\ue868'),
    CLOUD("mdsal-cloud", '\ue14d'),
    CLOUD_CIRCLE("mdsal-cloud_circle", '\ue14f'),
    CLOUD_DONE("mdsal-cloud_done", '\ue151'),
    CLOUD_DOWNLOAD("mdsal-cloud_download", '\ue153'),
    CLOUD_OFF("mdsal-cloud_off", '\ue155'),
    CLOUD_QUEUE("mdsal-cloud_queue", '\ue157'),
    CLOUD_UPLOAD("mdsal-cloud_upload", '\ue159'),
    CODE("mdsal-code", '\ue15b'),
    COLLECTIONS("mdsal-collections", '\ue15c'),
    COLLECTIONS_BOOKMARK("mdsal-collections_bookmark", '\ue15e'),
    COLOR_LENS("mdsal-color_lens", '\ue160'),
    COLORIZE("mdsal-colorize", '\ue162'),
    COMMENT("mdsal-comment", '\ue164'),
    COMMENT_BANK("mdsal-comment_bank", '\ue783'),
    COMMUTE("mdsal-commute", '\ue166'),
    COMPARE("mdsal-compare", '\ue167'),
    COMPARE_ARROWS("mdsal-compare_arrows", '\ue169'),
    COMPASS_CALIBRATION("mdsal-compass_calibration", '\ue16a'),
    COMPUTER("mdsal-computer", '\ue16c'),
    CONFIRMATION_NUMBER("mdsal-confirmation_number", '\ue16e'),
    CONNECT_WITHOUT_CONTACT("mdsal-connect_without_contact", '\ue89f'),
    CONSTRUCTION("mdsal-construction", '\ue785'),
    CONTACT_MAIL("mdsal-contact_mail", '\ue170'),
    CONTACT_PAGE("mdsal-contact_page", '\ue8b4'),
    CONTACT_PHONE("mdsal-contact_phone", '\ue172'),
    CONTACT_SUPPORT("mdsal-contact_support", '\ue174'),
    CONTACTLESS("mdsal-contactless", '\ue176'),
    CONTACTS("mdsal-contacts", '\ue178'),
    CONTENT_COPY("mdsal-content_copy", '\ue17a'),
    CONTENT_CUT("mdsal-content_cut", '\ue17c'),
    CONTENT_PASTE("mdsal-content_paste", '\ue17e'),
    CONTROL_CAMERA("mdsal-control_camera", '\ue180'),
    CONTROL_POINT("mdsal-control_point", '\ue181'),
    CONTROL_POINT_DUPLICATE("mdsal-control_point_duplicate", '\ue183'),
    COPYRIGHT("mdsal-copyright", '\ue185'),
    CORONAVIRUS("mdsal-coronavirus", '\ue8a0'),
    CORPORATE_FARE("mdsal-corporate_fare", '\ue786'),
    COUNTERTOPS("mdsal-countertops", '\ue86a'),
    CREATE("mdsal-create", '\ue187'),
    CREATE_NEW_FOLDER("mdsal-create_new_folder", '\ue189'),
    CREDIT_CARD("mdsal-credit_card", '\ue18b'),
    CROP("mdsal-crop", '\ue18d'),
    CROP_16_9("mdsal-crop_16_9", '\ue18e'),
    CROP_3_2("mdsal-crop_3_2", '\ue18f'),
    CROP_5_4("mdsal-crop_5_4", '\ue190'),
    CROP_7_5("mdsal-crop_7_5", '\ue191'),
    CROP_DIN("mdsal-crop_din", '\ue192'),
    CROP_FREE("mdsal-crop_free", '\ue193'),
    CROP_LANDSCAPE("mdsal-crop_landscape", '\ue194'),
    CROP_ORIGINAL("mdsal-crop_original", '\ue195'),
    CROP_PORTRAIT("mdsal-crop_portrait", '\ue196'),
    CROP_ROTATE("mdsal-crop_rotate", '\ue197'),
    CROP_SQUARE("mdsal-crop_square", '\ue198'),
    DASHBOARD("mdsal-dashboard", '\ue199'),
    DATA_USAGE("mdsal-data_usage", '\ue19b'),
    DATE_RANGE("mdsal-date_range", '\ue19c'),
    DECK("mdsal-deck", '\ue19e'),
    DEHAZE("mdsal-dehaze", '\ue1a0'),
    DELETE("mdsal-delete", '\ue1a1'),
    DELETE_FOREVER("mdsal-delete_forever", '\ue1a3'),
    DELETE_OUTLINE("mdsal-delete_outline", '\ue1a5'),
    DELETE_SWEEP("mdsal-delete_sweep", '\ue1a6'),
    DEPARTURE_BOARD("mdsal-departure_board", '\ue1a8'),
    DESCRIPTION("mdsal-description", '\ue1aa'),
    DESIGN_SERVICES("mdsal-design_services", '\ue788'),
    DESKTOP_ACCESS_DISABLED("mdsal-desktop_access_disabled", '\ue1ac'),
    DESKTOP_MAC("mdsal-desktop_mac", '\ue1ae'),
    DESKTOP_WINDOWS("mdsal-desktop_windows", '\ue1b0'),
    DETAILS("mdsal-details", '\ue1b2'),
    DEVELOPER_BOARD("mdsal-developer_board", '\ue1b4'),
    DEVELOPER_MODE("mdsal-developer_mode", '\ue1b6'),
    DEVICE_HUB("mdsal-device_hub", '\ue1b7'),
    DEVICE_UNKNOWN("mdsal-device_unknown", '\ue1b8'),
    DEVICES("mdsal-devices", '\ue1ba'),
    DEVICES_OTHER("mdsal-devices_other", '\ue1bc'),
    DIALER_SIP("mdsal-dialer_sip", '\ue1be'),
    DIALPAD("mdsal-dialpad", '\ue1c0'),
    DIRECTIONS("mdsal-directions", '\ue1c1'),
    DIRECTIONS_BIKE("mdsal-directions_bike", '\ue1c3'),
    DIRECTIONS_BOAT("mdsal-directions_boat", '\ue1c4'),
    DIRECTIONS_BUS("mdsal-directions_bus", '\ue1c6'),
    DIRECTIONS_CAR("mdsal-directions_car", '\ue1c8'),
    DIRECTIONS_OFF("mdsal-directions_off", '\ue78a'),
    DIRECTIONS_RAILWAY("mdsal-directions_railway", '\ue1ca'),
    DIRECTIONS_RUN("mdsal-directions_run", '\ue1cc'),
    DIRECTIONS_SUBWAY("mdsal-directions_subway", '\ue1cd'),
    DIRECTIONS_TRANSIT("mdsal-directions_transit", '\ue1cf'),
    DIRECTIONS_WALK("mdsal-directions_walk", '\ue1d1'),
    DISABLED_BY_DEFAULT("mdsal-disabled_by_default", '\ue8b6'),
    DISC_FULL("mdsal-disc_full", '\ue1d2'),
    DIVIDE("mdsal-divide", '\ue1d4'),
    DNS("mdsal-dns", '\ue1d6'),
    DO_NOT_DISTURB("mdsal-do_not_disturb", '\ue1d8'),
    DO_NOT_DISTURB_ALT("mdsal-do_not_disturb_alt", '\ue1da'),
    DO_NOT_DISTURB_OFF("mdsal-do_not_disturb_off", '\ue1dc'),
    DO_NOT_STEP("mdsal-do_not_step", '\ue78b'),
    DO_NOT_TOUCH("mdsal-do_not_touch", '\ue78d'),
    DOCK("mdsal-dock", '\ue1de'),
    DOMAIN("mdsal-domain", '\ue1e0'),
    DOMAIN_DISABLED("mdsal-domain_disabled", '\ue1e2'),
    DOMAIN_VERIFICATION("mdsal-domain_verification", '\ue78f'),
    DONE("mdsal-done", '\ue1e4'),
    DONE_ALL("mdsal-done_all", '\ue1e5'),
    DONE_OUTLINE("mdsal-done_outline", '\ue1e6'),
    DONUT_LARGE("mdsal-donut_large", '\ue1e7'),
    DONUT_SMALL("mdsal-donut_small", '\ue1e8'),
    DOUBLE_ARROW("mdsal-double_arrow", '\ue1ea'),
    DRAFTS("mdsal-drafts", '\ue1eb'),
    DRAG_HANDLE("mdsal-drag_handle", '\ue1ed'),
    DRAG_INDICATOR("mdsal-drag_indicator", '\ue1ee'),
    DRIVE_ETA("mdsal-drive_eta", '\ue1ef'),
    DRY("mdsal-dry", '\ue791'),
    DUO("mdsal-duo", '\ue1f1'),
    DVR("mdsal-dvr", '\ue1f2'),
    DYNAMIC_FEED("mdsal-dynamic_feed", '\ue1f4'),
    DYNAMIC_FORM("mdsal-dynamic_form", '\ue793'),
    EAST("mdsal-east", '\ue86c'),
    ECO("mdsal-eco", '\ue1f6'),
    EDIT("mdsal-edit", '\ue1f8'),
    EDIT_ATTRIBUTES("mdsal-edit_attributes", '\ue1fa'),
    EDIT_LOCATION("mdsal-edit_location", '\ue1fc'),
    EDIT_ROAD("mdsal-edit_road", '\ue795'),
    EJECT("mdsal-eject", '\ue1fe'),
    ELDERLY("mdsal-elderly", '\ue8a2'),
    ELECTRIC_BIKE("mdsal-electric_bike", '\ue797'),
    ELECTRIC_CAR("mdsal-electric_car", '\ue798'),
    ELECTRIC_MOPED("mdsal-electric_moped", '\ue79a'),
    ELECTRIC_SCOOTER("mdsal-electric_scooter", '\ue79c'),
    ELECTRICAL_SERVICES("mdsal-electrical_services", '\ue79d'),
    ELEVATOR("mdsal-elevator", '\ue79e'),
    EMAIL("mdsal-email", '\ue200'),
    EMOJI_EMOTIONS("mdsal-emoji_emotions", '\ue202'),
    EMOJI_EVENTS("mdsal-emoji_events", '\ue204'),
    EMOJI_FLAGS("mdsal-emoji_flags", '\ue206'),
    EMOJI_FOOD_BEVERAGE("mdsal-emoji_food_beverage", '\ue208'),
    EMOJI_NATURE("mdsal-emoji_nature", '\ue20a'),
    EMOJI_OBJECTS("mdsal-emoji_objects", '\ue20c'),
    EMOJI_PEOPLE("mdsal-emoji_people", '\ue20e'),
    EMOJI_SYMBOLS("mdsal-emoji_symbols", '\ue20f'),
    EMOJI_TRANSPORTATION("mdsal-emoji_transportation", '\ue210'),
    ENGINEERING("mdsal-engineering", '\ue7a0'),
    ENHANCED_ENCRYPTION("mdsal-enhanced_encryption", '\ue211'),
    EQUALIZER("mdsal-equalizer", '\ue213'),
    EQUALS("mdsal-equals", '\ue214'),
    ERROR("mdsal-error", '\ue215'),
    ERROR_OUTLINE("mdsal-error_outline", '\ue217'),
    ESCALATOR("mdsal-escalator", '\ue7a2'),
    ESCALATOR_WARNING("mdsal-escalator_warning", '\ue7a4'),
    EURO("mdsal-euro", '\ue218'),
    EURO_SYMBOL("mdsal-euro_symbol", '\ue219'),
    EV_STATION("mdsal-ev_station", '\ue21a'),
    EVENT("mdsal-event", '\ue21c'),
    EVENT_AVAILABLE("mdsal-event_available", '\ue21e'),
    EVENT_BUSY("mdsal-event_busy", '\ue220'),
    EVENT_NOTE("mdsal-event_note", '\ue222'),
    EVENT_SEAT("mdsal-event_seat", '\ue224'),
    EXIT_TO_APP("mdsal-exit_to_app", '\ue226'),
    EXPAND_LESS("mdsal-expand_less", '\ue227'),
    EXPAND_MORE("mdsal-expand_more", '\ue228'),
    EXPLICIT("mdsal-explicit", '\ue229'),
    EXPLORE("mdsal-explore", '\ue22b'),
    EXPLORE_OFF("mdsal-explore_off", '\ue22d'),
    EXPOSURE("mdsal-exposure", '\ue22f'),
    EXPOSURE_NEG_1("mdsal-exposure_neg_1", '\ue231'),
    EXPOSURE_NEG_2("mdsal-exposure_neg_2", '\ue232'),
    EXPOSURE_PLUS_1("mdsal-exposure_plus_1", '\ue233'),
    EXPOSURE_PLUS_2("mdsal-exposure_plus_2", '\ue234'),
    EXPOSURE_ZERO("mdsal-exposure_zero", '\ue235'),
    EXTENSION("mdsal-extension", '\ue236'),
    FACE("mdsal-face", '\ue238'),
    FACEBOOK("mdsal-facebook", '\ue8b8'),
    FACT_CHECK("mdsal-fact_check", '\ue7a5'),
    FAMILY_RESTROOM("mdsal-family_restroom", '\ue7a7'),
    FAST_FORWARD("mdsal-fast_forward", '\ue23a'),
    FAST_REWIND("mdsal-fast_rewind", '\ue23c'),
    FASTFOOD("mdsal-fastfood", '\ue23e'),
    FAVORITE("mdsal-favorite", '\ue240'),
    FAVORITE_BORDER("mdsal-favorite_border", '\ue242'),
    FEATURED_PLAY_LIST("mdsal-featured_play_list", '\ue243'),
    FEATURED_VIDEO("mdsal-featured_video", '\ue245'),
    FEEDBACK("mdsal-feedback", '\ue247'),
    FENCE("mdsal-fence", '\ue86d'),
    FIBER_DVR("mdsal-fiber_dvr", '\ue249'),
    FIBER_MANUAL_RECORD("mdsal-fiber_manual_record", '\ue24b'),
    FIBER_NEW("mdsal-fiber_new", '\ue24d'),
    FIBER_PIN("mdsal-fiber_pin", '\ue24f'),
    FIBER_SMART_RECORD("mdsal-fiber_smart_record", '\ue251'),
    FILE_COPY("mdsal-file_copy", '\ue253'),
    FILE_UPLOAD("mdsal-file_upload", '\ue255'),
    FILTER("mdsal-filter", '\ue257'),
    FILTER_1("mdsal-filter_1", '\ue259'),
    FILTER_2("mdsal-filter_2", '\ue25b'),
    FILTER_3("mdsal-filter_3", '\ue25d'),
    FILTER_4("mdsal-filter_4", '\ue25f'),
    FILTER_5("mdsal-filter_5", '\ue261'),
    FILTER_6("mdsal-filter_6", '\ue263'),
    FILTER_7("mdsal-filter_7", '\ue265'),
    FILTER_8("mdsal-filter_8", '\ue267'),
    FILTER_9("mdsal-filter_9", '\ue269'),
    FILTER_9_PLUS("mdsal-filter_9_plus", '\ue26b'),
    FILTER_ALT("mdsal-filter_alt", '\ue7a8'),
    FILTER_B_AND_W("mdsal-filter_b_and_w", '\ue26d'),
    FILTER_CENTER_FOCUS("mdsal-filter_center_focus", '\ue26f'),
    FILTER_DRAMA("mdsal-filter_drama", '\ue270'),
    FILTER_FRAMES("mdsal-filter_frames", '\ue272'),
    FILTER_HDR("mdsal-filter_hdr", '\ue274'),
    FILTER_LIST("mdsal-filter_list", '\ue276'),
    FILTER_NONE("mdsal-filter_none", '\ue277'),
    FILTER_TILT_SHIFT("mdsal-filter_tilt_shift", '\ue279'),
    FILTER_VINTAGE("mdsal-filter_vintage", '\ue27a'),
    FIND_IN_PAGE("mdsal-find_in_page", '\ue27c'),
    FIND_REPLACE("mdsal-find_replace", '\ue27e'),
    FINGERPRINT("mdsal-fingerprint", '\ue27f'),
    FIRE_EXTINGUISHER("mdsal-fire_extinguisher", '\ue86f'),
    FIREPLACE("mdsal-fireplace", '\ue280'),
    FIRST_PAGE("mdsal-first_page", '\ue282'),
    FITNESS_CENTER("mdsal-fitness_center", '\ue283'),
    FLAG("mdsal-flag", '\ue284'),
    FLAKY("mdsal-flaky", '\ue7aa'),
    FLARE("mdsal-flare", '\ue286'),
    FLASH_AUTO("mdsal-flash_auto", '\ue287'),
    FLASH_OFF("mdsal-flash_off", '\ue288'),
    FLASH_ON("mdsal-flash_on", '\ue289'),
    FLIGHT("mdsal-flight", '\ue28a'),
    FLIGHT_LAND("mdsal-flight_land", '\ue28b'),
    FLIGHT_TAKEOFF("mdsal-flight_takeoff", '\ue28c'),
    FLIP("mdsal-flip", '\ue28d'),
    FLIP_CAMERA_ANDROID("mdsal-flip_camera_android", '\ue28e'),
    FLIP_CAMERA_IOS("mdsal-flip_camera_ios", '\ue290'),
    FLIP_TO_BACK("mdsal-flip_to_back", '\ue292'),
    FLIP_TO_FRONT("mdsal-flip_to_front", '\ue293'),
    FOLDER("mdsal-folder", '\ue294'),
    FOLDER_OPEN("mdsal-folder_open", '\ue296'),
    FOLDER_SHARED("mdsal-folder_shared", '\ue298'),
    FOLDER_SPECIAL("mdsal-folder_special", '\ue29a'),
    FOLLOW_THE_SIGNS("mdsal-follow_the_signs", '\ue8a3'),
    FONT_DOWNLOAD("mdsal-font_download", '\ue29c'),
    FOOD_BANK("mdsal-food_bank", '\ue870'),
    FORMAT_ALIGN_CENTER("mdsal-format_align_center", '\ue29e'),
    FORMAT_ALIGN_JUSTIFY("mdsal-format_align_justify", '\ue29f'),
    FORMAT_ALIGN_LEFT("mdsal-format_align_left", '\ue2a0'),
    FORMAT_ALIGN_RIGHT("mdsal-format_align_right", '\ue2a1'),
    FORMAT_BOLD("mdsal-format_bold", '\ue2a2'),
    FORMAT_CLEAR("mdsal-format_clear", '\ue2a3'),
    FORMAT_COLOR_FILL("mdsal-format_color_fill", '\ue2a4'),
    FORMAT_COLOR_RESET("mdsal-format_color_reset", '\ue2a6'),
    FORMAT_COLOR_TEXT("mdsal-format_color_text", '\ue2a8'),
    FORMAT_INDENT_DECREASE("mdsal-format_indent_decrease", '\ue2aa'),
    FORMAT_INDENT_INCREASE("mdsal-format_indent_increase", '\ue2ab'),
    FORMAT_ITALIC("mdsal-format_italic", '\ue2ac'),
    FORMAT_LINE_SPACING("mdsal-format_line_spacing", '\ue2ad'),
    FORMAT_LIST_BULLETED("mdsal-format_list_bulleted", '\ue2ae'),
    FORMAT_LIST_NUMBERED("mdsal-format_list_numbered", '\ue2af'),
    FORMAT_LIST_NUMBERED_RTL("mdsal-format_list_numbered_rtl", '\ue2b0'),
    FORMAT_PAINT("mdsal-format_paint", '\ue2b1'),
    FORMAT_QUOTE("mdsal-format_quote", '\ue2b3'),
    FORMAT_SHAPES("mdsal-format_shapes", '\ue2b5'),
    FORMAT_SIZE("mdsal-format_size", '\ue2b7'),
    FORMAT_STRIKETHROUGH("mdsal-format_strikethrough", '\ue2b8'),
    FORMAT_TEXTDIRECTION_L_TO_R("mdsal-format_textdirection_l_to_r", '\ue2b9'),
    FORMAT_TEXTDIRECTION_R_TO_L("mdsal-format_textdirection_r_to_l", '\ue2bb'),
    FORMAT_UNDERLINED("mdsal-format_underlined", '\ue2bd'),
    FORUM("mdsal-forum", '\ue2be'),
    FORWARD("mdsal-forward", '\ue2c0'),
    FORWARD_10("mdsal-forward_10", '\ue2c2'),
    FORWARD_30("mdsal-forward_30", '\ue2c3'),
    FORWARD_5("mdsal-forward_5", '\ue2c4'),
    FORWARD_TO_INBOX("mdsal-forward_to_inbox", '\ue7ab'),
    FOUNDATION("mdsal-foundation", '\ue872'),
    FREE_BREAKFAST("mdsal-free_breakfast", '\ue2c5'),
    FULLSCREEN("mdsal-fullscreen", '\ue2c7'),
    FULLSCREEN_EXIT("mdsal-fullscreen_exit", '\ue2c8'),
    FUNCTIONS("mdsal-functions", '\ue2c9'),
    G_TRANSLATE("mdsal-g_translate", '\ue2ca'),
    GAMEPAD("mdsal-gamepad", '\ue2cb'),
    GAMES("mdsal-games", '\ue2cd'),
    GAVEL("mdsal-gavel", '\ue2cf'),
    GESTURE("mdsal-gesture", '\ue2d0'),
    GET_APP("mdsal-get_app", '\ue2d1'),
    GIF("mdsal-gif", '\ue2d3'),
    GOLF_COURSE("mdsal-golf_course", '\ue2d5'),
    GPS_FIXED("mdsal-gps_fixed", '\ue2d7'),
    GPS_NOT_FIXED("mdsal-gps_not_fixed", '\ue2d9'),
    GPS_OFF("mdsal-gps_off", '\ue2da'),
    GRADE("mdsal-grade", '\ue2db'),
    GRADIENT("mdsal-gradient", '\ue2dd'),
    GRADING("mdsal-grading", '\ue7ad'),
    GRAIN("mdsal-grain", '\ue2de'),
    GRAPHIC_EQ("mdsal-graphic_eq", '\ue2df'),
    GRASS("mdsal-grass", '\ue874'),
    GREATER_THAN("mdsal-greater_than", '\ue2e0'),
    GREATER_THAN_EQUAL("mdsal-greater_than_equal", '\ue2e1'),
    GRID_OFF("mdsal-grid_off", '\ue2e2'),
    GRID_ON("mdsal-grid_on", '\ue2e4'),
    GROUP("mdsal-group", '\ue2e6'),
    GROUP_ADD("mdsal-group_add", '\ue2e8'),
    GROUP_WORK("mdsal-group_work", '\ue2ea'),
    GROUPS("mdsal-groups", '\ue8b9'),
    HANDYMAN("mdsal-handyman", '\ue7ae'),
    HD("mdsal-hd", '\ue2ec'),
    HDR_OFF("mdsal-hdr_off", '\ue2ee'),
    HDR_ON("mdsal-hdr_on", '\ue2ef'),
    HDR_STRONG("mdsal-hdr_strong", '\ue2f0'),
    HDR_WEAK("mdsal-hdr_weak", '\ue2f2'),
    HEADSET("mdsal-headset", '\ue2f4'),
    HEADSET_MIC("mdsal-headset_mic", '\ue2f6'),
    HEALING("mdsal-healing", '\ue2f8'),
    HEARING("mdsal-hearing", '\ue2fa'),
    HEARING_DISABLED("mdsal-hearing_disabled", '\ue7b0'),
    HEIGHT("mdsal-height", '\ue2fb'),
    HELP("mdsal-help", '\ue2fc'),
    HELP_CENTER("mdsal-help_center", '\ue7b1'),
    HELP_OUTLINE("mdsal-help_outline", '\ue2fe'),
    HIGH_QUALITY("mdsal-high_quality", '\ue2ff'),
    HIGHLIGHT("mdsal-highlight", '\ue301'),
    HIGHLIGHT_ALT("mdsal-highlight_alt", '\ue7b3'),
    HIGHLIGHT_OFF("mdsal-highlight_off", '\ue303'),
    HISTORY("mdsal-history", '\ue305'),
    HISTORY_EDU("mdsal-history_edu", '\ue7b4'),
    HISTORY_TOGGLE_OFF("mdsal-history_toggle_off", '\ue7b6'),
    HOME("mdsal-home", '\ue306'),
    HOME_REPAIR_SERVICE("mdsal-home_repair_service", '\ue7b7'),
    HOME_WORK("mdsal-home_work", '\ue308'),
    HORIZONTAL_DISTRIBUTE("mdsal-horizontal_distribute", '\ue8d0'),
    HORIZONTAL_RULE("mdsal-horizontal_rule", '\ue7b9'),
    HORIZONTAL_SPLIT("mdsal-horizontal_split", '\ue30a'),
    HOT_TUB("mdsal-hot_tub", '\ue30c'),
    HOTEL("mdsal-hotel", '\ue30d'),
    HOURGLASS_BOTTOM("mdsal-hourglass_bottom", '\ue7ba'),
    HOURGLASS_DISABLED("mdsal-hourglass_disabled", '\ue7bc'),
    HOURGLASS_EMPTY("mdsal-hourglass_empty", '\ue30f'),
    HOURGLASS_FULL("mdsal-hourglass_full", '\ue310'),
    HOURGLASS_TOP("mdsal-hourglass_top", '\ue7bd'),
    HOUSE("mdsal-house", '\ue312'),
    HOUSE_SIDING("mdsal-house_siding", '\ue875'),
    HOW_TO_REG("mdsal-how_to_reg", '\ue314'),
    HOW_TO_VOTE("mdsal-how_to_vote", '\ue316'),
    HTTP("mdsal-http", '\ue318'),
    HTTPS("mdsal-https", '\ue319'),
    HVAC("mdsal-hvac", '\ue7bf'),
    IMAGE("mdsal-image", '\ue31b'),
    IMAGE_ASPECT_RATIO("mdsal-image_aspect_ratio", '\ue31d'),
    IMAGE_NOT_SUPPORTED("mdsal-image_not_supported", '\ue7c1'),
    IMAGE_SEARCH("mdsal-image_search", '\ue31f'),
    IMPORT_CONTACTS("mdsal-import_contacts", '\ue321'),
    IMPORT_EXPORT("mdsal-import_export", '\ue323'),
    IMPORTANT_DEVICES("mdsal-important_devices", '\ue324'),
    INBOX("mdsal-inbox", '\ue326'),
    INDETERMINATE_CHECK_BOX("mdsal-indeterminate_check_box", '\ue328'),
    INFO("mdsal-info", '\ue32a'),
    INPUT("mdsal-input", '\ue32c'),
    INSERT_CHART("mdsal-insert_chart", '\ue32d'),
    INSERT_CHART_OUTLINED("mdsal-insert_chart_outlined", '\ue32f'),
    INSERT_COMMENT("mdsal-insert_comment", '\ue330'),
    INSERT_DRIVE_FILE("mdsal-insert_drive_file", '\ue332'),
    INSERT_EMOTICON("mdsal-insert_emoticon", '\ue334'),
    INSERT_INVITATION("mdsal-insert_invitation", '\ue336'),
    INSERT_LINK("mdsal-insert_link", '\ue338'),
    INSERT_PHOTO("mdsal-insert_photo", '\ue339'),
    INSIGHTS("mdsal-insights", '\ue7c3'),
    INTEGRATION_INSTRUCTIONS("mdsal-integration_instructions", '\ue7c4'),
    INVERT_COLORS("mdsal-invert_colors", '\ue33b'),
    INVERT_COLORS_OFF("mdsal-invert_colors_off", '\ue33d'),
    ISO("mdsal-iso", '\ue33f'),
    KEYBOARD("mdsal-keyboard", '\ue341'),
    KEYBOARD_ARROW_DOWN("mdsal-keyboard_arrow_down", '\ue343'),
    KEYBOARD_ARROW_LEFT("mdsal-keyboard_arrow_left", '\ue344'),
    KEYBOARD_ARROW_RIGHT("mdsal-keyboard_arrow_right", '\ue345'),
    KEYBOARD_ARROW_UP("mdsal-keyboard_arrow_up", '\ue346'),
    KEYBOARD_BACKSPACE("mdsal-keyboard_backspace", '\ue347'),
    KEYBOARD_CAPSLOCK("mdsal-keyboard_capslock", '\ue348'),
    KEYBOARD_HIDE("mdsal-keyboard_hide", '\ue349'),
    KEYBOARD_RETURN("mdsal-keyboard_return", '\ue34b'),
    KEYBOARD_TAB("mdsal-keyboard_tab", '\ue34c'),
    KEYBOARD_VOICE("mdsal-keyboard_voice", '\ue34d'),
    KING_BED("mdsal-king_bed", '\ue34f'),
    KITCHEN("mdsal-kitchen", '\ue351'),
    LABEL("mdsal-label", '\ue353'),
    LABEL_IMPORTANT("mdsal-label_important", '\ue355'),
    LABEL_OFF("mdsal-label_off", '\ue357'),
    LANDSCAPE("mdsal-landscape", '\ue359'),
    LANGUAGE("mdsal-language", '\ue35b'),
    LAPTOP("mdsal-laptop", '\ue35d'),
    LAPTOP_CHROMEBOOK("mdsal-laptop_chromebook", '\ue35f'),
    LAPTOP_MAC("mdsal-laptop_mac", '\ue361'),
    LAPTOP_WINDOWS("mdsal-laptop_windows", '\ue363'),
    LAST_PAGE("mdsal-last_page", '\ue365'),
    LAUNCH("mdsal-launch", '\ue366'),
    LAYERS("mdsal-layers", '\ue367'),
    LAYERS_CLEAR("mdsal-layers_clear", '\ue369'),
    LEADERBOARD("mdsal-leaderboard", '\ue877'),
    LEAK_ADD("mdsal-leak_add", '\ue36b'),
    LEAK_REMOVE("mdsal-leak_remove", '\ue36c'),
    LEAVE_BAGS_AT_HOME("mdsal-leave_bags_at_home", '\ue8a5'),
    LEGEND_TOGGLE("mdsal-legend_toggle", '\ue7c6'),
    LENS("mdsal-lens", '\ue36d'),
    LESS_THAN("mdsal-less_than", '\ue36f'),
    LESS_THAN_EQUAL("mdsal-less_than_equal", '\ue370'),
    LIBRARY_ADD("mdsal-library_add", '\ue371'),
    LIBRARY_ADD_CHECK("mdsal-library_add_check", '\ue746'),
    LIBRARY_BOOKS("mdsal-library_books", '\ue373'),
    LIBRARY_MUSIC("mdsal-library_music", '\ue375'),
    LIGHTBULB("mdsal-lightbulb", '\ue377'),
    LINE_STYLE("mdsal-line_style", '\ue379'),
    LINE_WEIGHT("mdsal-line_weight", '\ue37a'),
    LINEAR_SCALE("mdsal-linear_scale", '\ue37b'),
    LINK("mdsal-link", '\ue37c'),
    LINK_OFF("mdsal-link_off", '\ue37e'),
    LINKED_CAMERA("mdsal-linked_camera", '\ue37f'),
    LIST("mdsal-list", '\ue381'),
    LIST_ALT("mdsal-list_alt", '\ue382'),
    LIVE_HELP("mdsal-live_help", '\ue384'),
    LIVE_TV("mdsal-live_tv", '\ue386'),
    LOCAL_ACTIVITY("mdsal-local_activity", '\ue388'),
    LOCAL_AIRPORT("mdsal-local_airport", '\ue38a'),
    LOCAL_ATM("mdsal-local_atm", '\ue38b'),
    LOCAL_BAR("mdsal-local_bar", '\ue38d'),
    LOCAL_CAFE("mdsal-local_cafe", '\ue38f'),
    LOCAL_CAR_WASH("mdsal-local_car_wash", '\ue391'),
    LOCAL_CONVENIENCE_STORE("mdsal-local_convenience_store", '\ue393'),
    LOCAL_DINING("mdsal-local_dining", '\ue395'),
    LOCAL_DRINK("mdsal-local_drink", '\ue396'),
    LOCAL_FIRE_DEPARTMENT("mdsal-local_fire_department", '\ue8a7'),
    LOCAL_FLORIST("mdsal-local_florist", '\ue398'),
    LOCAL_GAS_STATION("mdsal-local_gas_station", '\ue39a'),
    LOCAL_GROCERY_STORE("mdsal-local_grocery_store", '\ue39c'),
    LOCAL_HOSPITAL("mdsal-local_hospital", '\ue39e'),
    LOCAL_HOTEL("mdsal-local_hotel", '\ue3a0'),
    LOCAL_LAUNDRY_SERVICE("mdsal-local_laundry_service", '\ue3a2'),
    LOCAL_LIBRARY("mdsal-local_library", '\ue3a4'),
    LOCAL_MALL("mdsal-local_mall", '\ue3a6'),
    LOCAL_MOVIES("mdsal-local_movies", '\ue3a8'),
    LOCAL_OFFER("mdsal-local_offer", '\ue3aa'),
    LOCAL_PARKING("mdsal-local_parking", '\ue3ac'),
    LOCAL_PHARMACY("mdsal-local_pharmacy", '\ue3ad'),
    LOCAL_PHONE("mdsal-local_phone", '\ue3af'),
    LOCAL_PIZZA("mdsal-local_pizza", '\ue3b1'),
    LOCAL_PLAY("mdsal-local_play", '\ue3b3'),
    LOCAL_POLICE("mdsal-local_police", '\ue8a9'),
    LOCAL_POST_OFFICE("mdsal-local_post_office", '\ue3b5'),
    LOCAL_PRINTSHOP("mdsal-local_printshop", '\ue3b7'),
    LOCAL_SEE("mdsal-local_see", '\ue3b9'),
    LOCAL_SHIPPING("mdsal-local_shipping", '\ue3bb'),
    LOCAL_TAXI("mdsal-local_taxi", '\ue3bd'),
    LOCATION_CITY("mdsal-location_city", '\ue3bf'),
    LOCATION_DISABLED("mdsal-location_disabled", '\ue3c0'),
    LOCATION_OFF("mdsal-location_off", '\ue3c1'),
    LOCATION_ON("mdsal-location_on", '\ue3c2'),
    LOCATION_SEARCHING("mdsal-location_searching", '\ue3c4'),
    LOCK("mdsal-lock", '\ue3c5'),
    LOCK_OPEN("mdsal-lock_open", '\ue3c7'),
    LOG_IN("mdsal-log_in", '\ue3c9'),
    LOG_OUT("mdsal-log_out", '\ue3ca'),
    LOGIN("mdsal-login", '\ue7c7'),
    LOOKS("mdsal-looks", '\ue3cb'),
    LOOKS_3("mdsal-looks_3", '\ue3cc'),
    LOOKS_4("mdsal-looks_4", '\ue3ce'),
    LOOKS_5("mdsal-looks_5", '\ue3d0'),
    LOOKS_6("mdsal-looks_6", '\ue3d2'),
    LOOKS_ONE("mdsal-looks_one", '\ue3d4'),
    LOOKS_TWO("mdsal-looks_two", '\ue3d6'),
    LOOP("mdsal-loop", '\ue3d8'),
    LOUPE("mdsal-loupe", '\ue3d9'),
    LOW_PRIORITY("mdsal-low_priority", '\ue3db'),
    LOYALTY("mdsal-loyalty", '\ue3dc'),
    LUGGAGE("mdsal-luggage", '\ue8bb');
    
    public static Material2SharpAL findByDescription(String description) {
        for (Material2SharpAL font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2SharpAL(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}