/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material2;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material2SharpMZ implements Ikon {
    MAIL("mdsmz-mail", '\ue3de'),
    MAIL_OUTLINE("mdsmz-mail_outline", '\ue3e0'),
    MAP("mdsmz-map", '\ue3e1'),
    MAPS_UGC("mdsmz-maps_ugc", '\ue7c8'),
    MARK_CHAT_READ("mdsmz-mark_chat_read", '\ue7ca'),
    MARK_CHAT_UNREAD("mdsmz-mark_chat_unread", '\ue7cc'),
    MARK_EMAIL_READ("mdsmz-mark_email_read", '\ue7ce'),
    MARK_EMAIL_UNREAD("mdsmz-mark_email_unread", '\ue7d0'),
    MARKUNREAD("mdsmz-markunread", '\ue3e3'),
    MARKUNREAD_MAILBOX("mdsmz-markunread_mailbox", '\ue3e5'),
    MASKS("mdsmz-masks", '\ue8ab'),
    MAXIMIZE("mdsmz-maximize", '\ue3e7'),
    MEDIATION("mdsmz-mediation", '\ue7d2'),
    MEDICAL_SERVICES("mdsmz-medical_services", '\ue7d3'),
    MEETING_ROOM("mdsmz-meeting_room", '\ue3e8'),
    MEMORY("mdsmz-memory", '\ue3ea'),
    MENU("mdsmz-menu", '\ue3ec'),
    MENU_BOOK("mdsmz-menu_book", '\ue3ed'),
    MENU_OPEN("mdsmz-menu_open", '\ue3ef'),
    MERGE_TYPE("mdsmz-merge_type", '\ue3f0'),
    MESSAGE("mdsmz-message", '\ue3f1'),
    MIC("mdsmz-mic", '\ue3f3'),
    MIC_NONE("mdsmz-mic_none", '\ue3f5'),
    MIC_OFF("mdsmz-mic_off", '\ue3f7'),
    MICROWAVE("mdsmz-microwave", '\ue879'),
    MILITARY_TECH("mdsmz-military_tech", '\ue7d5'),
    MINIMIZE("mdsmz-minimize", '\ue3f9'),
    MINUS("mdsmz-minus", '\ue3fa'),
    MISCELLANEOUS_SERVICES("mdsmz-miscellaneous_services", '\ue7d7'),
    MISSED_VIDEO_CALL("mdsmz-missed_video_call", '\ue3fb'),
    MMS("mdsmz-mms", '\ue3fd'),
    MOBILE_FRIENDLY("mdsmz-mobile_friendly", '\ue3ff'),
    MOBILE_OFF("mdsmz-mobile_off", '\ue400'),
    MOBILE_SCREEN_SHARE("mdsmz-mobile_screen_share", '\ue401'),
    MODE_COMMENT("mdsmz-mode_comment", '\ue403'),
    MODEL_TRAINING("mdsmz-model_training", '\ue7d8'),
    MONETIZATION_ON("mdsmz-monetization_on", '\ue405'),
    MONEY("mdsmz-money", '\ue407'),
    MONEY_OFF("mdsmz-money_off", '\ue409'),
    MONOCHROME_PHOTOS("mdsmz-monochrome_photos", '\ue40a'),
    MOOD("mdsmz-mood", '\ue40c'),
    MOOD_BAD("mdsmz-mood_bad", '\ue40e'),
    MOPED("mdsmz-moped", '\ue7d9'),
    MORE("mdsmz-more", '\ue410'),
    MORE_HORIZ("mdsmz-more_horiz", '\ue412'),
    MORE_TIME("mdsmz-more_time", '\ue7db'),
    MORE_VERT("mdsmz-more_vert", '\ue413'),
    MOTION_PHOTOS_ON("mdsmz-motion_photos_on", '\ue8ad'),
    MOTION_PHOTOS_PAUSE("mdsmz-motion_photos_pause", '\ue8bd'),
    MOTION_PHOTOS_PAUSED("mdsmz-motion_photos_paused", '\ue8ae'),
    MOTORCYCLE("mdsmz-motorcycle", '\ue414'),
    MOUSE("mdsmz-mouse", '\ue416'),
    MOVE_TO_INBOX("mdsmz-move_to_inbox", '\ue418'),
    MOVIE("mdsmz-movie", '\ue41a'),
    MOVIE_CREATION("mdsmz-movie_creation", '\ue41c'),
    MOVIE_FILTER("mdsmz-movie_filter", '\ue41e'),
    MULTILINE_CHART("mdsmz-multiline_chart", '\ue420'),
    MULTIPLE_STOP("mdsmz-multiple_stop", '\ue7dc'),
    MUSEUM("mdsmz-museum", '\ue421'),
    MUSIC_NOTE("mdsmz-music_note", '\ue423'),
    MUSIC_OFF("mdsmz-music_off", '\ue425'),
    MUSIC_VIDEO("mdsmz-music_video", '\ue427'),
    MY_LOCATION("mdsmz-my_location", '\ue429'),
    NAT("mdsmz-nat", '\ue7dd'),
    NATURE("mdsmz-nature", '\ue42b'),
    NATURE_PEOPLE("mdsmz-nature_people", '\ue42d'),
    NAVIGATE_BEFORE("mdsmz-navigate_before", '\ue42f'),
    NAVIGATE_NEXT("mdsmz-navigate_next", '\ue430'),
    NAVIGATION("mdsmz-navigation", '\ue431'),
    NEAR_ME("mdsmz-near_me", '\ue433'),
    NEAR_ME_DISABLED("mdsmz-near_me_disabled", '\ue87b'),
    NETWORK_CELL("mdsmz-network_cell", '\ue435'),
    NETWORK_CHECK("mdsmz-network_check", '\ue437'),
    NETWORK_LOCKED("mdsmz-network_locked", '\ue438'),
    NETWORK_WIFI("mdsmz-network_wifi", '\ue439'),
    NEW_RELEASES("mdsmz-new_releases", '\ue43b'),
    NEXT_PLAN("mdsmz-next_plan", '\ue7df'),
    NEXT_WEEK("mdsmz-next_week", '\ue43d'),
    NFC("mdsmz-nfc", '\ue43f'),
    NIGHT_SHELTER("mdsmz-night_shelter", '\ue87d'),
    NIGHTS_STAY("mdsmz-nights_stay", '\ue440'),
    NO_BACKPACK("mdsmz-no_backpack", '\ue8be'),
    NO_CELL("mdsmz-no_cell", '\ue7e1'),
    NO_DRINKS("mdsmz-no_drinks", '\ue7e3'),
    NO_ENCRYPTION("mdsmz-no_encryption", '\ue442'),
    NO_FLASH("mdsmz-no_flash", '\ue7e5'),
    NO_FOOD("mdsmz-no_food", '\ue7e7'),
    NO_LUGGAGE("mdsmz-no_luggage", '\ue8c0'),
    NO_MEALS("mdsmz-no_meals", '\ue87f'),
    NO_MEETING_ROOM("mdsmz-no_meeting_room", '\ue444'),
    NO_PHOTOGRAPHY("mdsmz-no_photography", '\ue7e9'),
    NO_SIM("mdsmz-no_sim", '\ue446'),
    NO_STROLLER("mdsmz-no_stroller", '\ue7eb'),
    NO_TRANSFER("mdsmz-no_transfer", '\ue880'),
    NORTH("mdsmz-north", '\ue882'),
    NORTH_EAST("mdsmz-north_east", '\ue883'),
    NORTH_WEST("mdsmz-north_west", '\ue884'),
    NOT_ACCESSIBLE("mdsmz-not_accessible", '\ue7ed'),
    NOT_EQUAL("mdsmz-not_equal", '\ue448'),
    NOT_INTERESTED("mdsmz-not_interested", '\ue449'),
    NOT_LISTED_LOCATION("mdsmz-not_listed_location", '\ue44a'),
    NOT_STARTED("mdsmz-not_started", '\ue7ee'),
    NOTE("mdsmz-note", '\ue44c'),
    NOTE_ADD("mdsmz-note_add", '\ue44e'),
    NOTES("mdsmz-notes", '\ue450'),
    NOTIFICATION_IMPORTANT("mdsmz-notification_important", '\ue451'),
    NOTIFICATIONS("mdsmz-notifications", '\ue453'),
    NOTIFICATIONS_ACTIVE("mdsmz-notifications_active", '\ue455'),
    NOTIFICATIONS_NONE("mdsmz-notifications_none", '\ue457'),
    NOTIFICATIONS_OFF("mdsmz-notifications_off", '\ue459'),
    NOTIFICATIONS_PAUSED("mdsmz-notifications_paused", '\ue45b'),
    OFFLINE_BOLT("mdsmz-offline_bolt", '\ue45d'),
    OFFLINE_PIN("mdsmz-offline_pin", '\ue45f'),
    ONDEMAND_VIDEO("mdsmz-ondemand_video", '\ue461'),
    ONLINE_PREDICTION("mdsmz-online_prediction", '\ue7f0'),
    OPACITY("mdsmz-opacity", '\ue463'),
    OPEN_IN_BROWSER("mdsmz-open_in_browser", '\ue465'),
    OPEN_IN_FULL("mdsmz-open_in_full", '\ue7f1'),
    OPEN_IN_NEW("mdsmz-open_in_new", '\ue466'),
    OPEN_WITH("mdsmz-open_with", '\ue467'),
    OUTBOND("mdsmz-outbond", '\ue8c2'),
    OUTDOOR_GRILL("mdsmz-outdoor_grill", '\ue468'),
    OUTLET("mdsmz-outlet", '\ue7f2'),
    OUTLINED_FLAG("mdsmz-outlined_flag", '\ue46a'),
    PAGES("mdsmz-pages", '\ue46b'),
    PAGEVIEW("mdsmz-pageview", '\ue46d'),
    PALETTE("mdsmz-palette", '\ue46f'),
    PAN_TOOL("mdsmz-pan_tool", '\ue471'),
    PANORAMA("mdsmz-panorama", '\ue473'),
    PANORAMA_FISH_EYE("mdsmz-panorama_fish_eye", '\ue475'),
    PANORAMA_HORIZONTAL("mdsmz-panorama_horizontal", '\ue477'),
    PANORAMA_VERTICAL("mdsmz-panorama_vertical", '\ue479'),
    PANORAMA_WIDE_ANGLE("mdsmz-panorama_wide_angle", '\ue47b'),
    PARTY_MODE("mdsmz-party_mode", '\ue47d'),
    PAUSE("mdsmz-pause", '\ue47f'),
    PAUSE_CIRCLE_FILLED("mdsmz-pause_circle_filled", '\ue480'),
    PAUSE_CIRCLE_OUTLINE("mdsmz-pause_circle_outline", '\ue482'),
    PAUSE_PRESENTATION("mdsmz-pause_presentation", '\ue483'),
    PAYMENT("mdsmz-payment", '\ue485'),
    PAYMENTS("mdsmz-payments", '\ue7f4'),
    PEDAL_BIKE("mdsmz-pedal_bike", '\ue7f6'),
    PENDING("mdsmz-pending", '\ue7f7'),
    PENDING_ACTIONS("mdsmz-pending_actions", '\ue7f9'),
    PEOPLE("mdsmz-people", '\ue487'),
    PEOPLE_ALT("mdsmz-people_alt", '\ue489'),
    PEOPLE_OUTLINE("mdsmz-people_outline", '\ue48b'),
    PERCENTAGE("mdsmz-percentage", '\ue48d'),
    PERM_CAMERA_MIC("mdsmz-perm_camera_mic", '\ue48f'),
    PERM_CONTACT_CALENDAR("mdsmz-perm_contact_calendar", '\ue491'),
    PERM_DATA_SETTING("mdsmz-perm_data_setting", '\ue493'),
    PERM_DEVICE_INFORMATION("mdsmz-perm_device_information", '\ue494'),
    PERM_IDENTITY("mdsmz-perm_identity", '\ue496'),
    PERM_MEDIA("mdsmz-perm_media", '\ue498'),
    PERM_PHONE_MSG("mdsmz-perm_phone_msg", '\ue49a'),
    PERM_SCAN_WIFI("mdsmz-perm_scan_wifi", '\ue49c'),
    PERSON("mdsmz-person", '\ue49e'),
    PERSON_ADD("mdsmz-person_add", '\ue4a0'),
    PERSON_ADD_ALT_1("mdsmz-person_add_alt_1", '\ue7fb'),
    PERSON_ADD_DISABLED("mdsmz-person_add_disabled", '\ue4a2'),
    PERSON_OUTLINE("mdsmz-person_outline", '\ue4a4'),
    PERSON_PIN("mdsmz-person_pin", '\ue4a6'),
    PERSON_PIN_CIRCLE("mdsmz-person_pin_circle", '\ue4a8'),
    PERSON_REMOVE("mdsmz-person_remove", '\ue7fd'),
    PERSON_REMOVE_ALT_1("mdsmz-person_remove_alt_1", '\ue7ff'),
    PERSON_SEARCH("mdsmz-person_search", '\ue801'),
    PERSONAL_VIDEO("mdsmz-personal_video", '\ue4aa'),
    PEST_CONTROL("mdsmz-pest_control", '\ue803'),
    PEST_CONTROL_RODENT("mdsmz-pest_control_rodent", '\ue805'),
    PETS("mdsmz-pets", '\ue4ac'),
    PHONE("mdsmz-phone", '\ue4ad'),
    PHONE_ANDROID("mdsmz-phone_android", '\ue4af'),
    PHONE_BLUETOOTH_SPEAKER("mdsmz-phone_bluetooth_speaker", '\ue4b1'),
    PHONE_CALLBACK("mdsmz-phone_callback", '\ue4b3'),
    PHONE_DISABLED("mdsmz-phone_disabled", '\ue4b5'),
    PHONE_ENABLED("mdsmz-phone_enabled", '\ue4b6'),
    PHONE_FORWARDED("mdsmz-phone_forwarded", '\ue4b7'),
    PHONE_IN_TALK("mdsmz-phone_in_talk", '\ue4b9'),
    PHONE_IPHONE("mdsmz-phone_iphone", '\ue4bb'),
    PHONE_LOCKED("mdsmz-phone_locked", '\ue4bd'),
    PHONE_MISSED("mdsmz-phone_missed", '\ue4bf'),
    PHONE_PAUSED("mdsmz-phone_paused", '\ue4c1'),
    PHONELINK("mdsmz-phonelink", '\ue4c3'),
    PHONELINK_ERASE("mdsmz-phonelink_erase", '\ue4c5'),
    PHONELINK_LOCK("mdsmz-phonelink_lock", '\ue4c6'),
    PHONELINK_OFF("mdsmz-phonelink_off", '\ue4c7'),
    PHONELINK_RING("mdsmz-phonelink_ring", '\ue4c9'),
    PHONELINK_SETUP("mdsmz-phonelink_setup", '\ue4cb'),
    PHOTO("mdsmz-photo", '\ue4cc'),
    PHOTO_ALBUM("mdsmz-photo_album", '\ue4ce'),
    PHOTO_CAMERA("mdsmz-photo_camera", '\ue4d0'),
    PHOTO_FILTER("mdsmz-photo_filter", '\ue4d2'),
    PHOTO_LIBRARY("mdsmz-photo_library", '\ue4d3'),
    PHOTO_SIZE_SELECT_ACTUAL("mdsmz-photo_size_select_actual", '\ue4d5'),
    PHOTO_SIZE_SELECT_LARGE("mdsmz-photo_size_select_large", '\ue4d7'),
    PHOTO_SIZE_SELECT_SMALL("mdsmz-photo_size_select_small", '\ue4d8'),
    PICTURE_AS_PDF("mdsmz-picture_as_pdf", '\ue4d9'),
    PICTURE_IN_PICTURE("mdsmz-picture_in_picture", '\ue4db'),
    PICTURE_IN_PICTURE_ALT("mdsmz-picture_in_picture_alt", '\ue4dd'),
    PIE_CHART("mdsmz-pie_chart", '\ue4df'),
    PIN("mdsmz-pin", '\ue4e1'),
    PIN_DROP("mdsmz-pin_drop", '\ue4e3'),
    PIN_OFF("mdsmz-pin_off", '\ue4e5'),
    PLACE("mdsmz-place", '\ue4e7'),
    PLAGIARISM("mdsmz-plagiarism", '\ue807'),
    PLAY_ARROW("mdsmz-play_arrow", '\ue4e9'),
    PLAY_CIRCLE_FILLED("mdsmz-play_circle_filled", '\ue4eb'),
    PLAY_CIRCLE_FILLED_WHITE("mdsmz-play_circle_filled_white", '\ue4ed'),
    PLAY_CIRCLE_OUTLINE("mdsmz-play_circle_outline", '\ue4ef'),
    PLAY_FOR_WORK("mdsmz-play_for_work", '\ue4f0'),
    PLAYLIST_ADD("mdsmz-playlist_add", '\ue4f1'),
    PLAYLIST_ADD_CHECK("mdsmz-playlist_add_check", '\ue4f2'),
    PLAYLIST_PLAY("mdsmz-playlist_play", '\ue4f3'),
    PLUMBING("mdsmz-plumbing", '\ue809'),
    PLUS("mdsmz-plus", '\ue4f4'),
    PLUS_MINUS("mdsmz-plus_minus", '\ue4f5'),
    PLUS_MINUS_ALT("mdsmz-plus_minus_alt", '\ue4f6'),
    PLUS_ONE("mdsmz-plus_one", '\ue4f7'),
    POINT_OF_SALE("mdsmz-point_of_sale", '\ue80a'),
    POLICY("mdsmz-policy", '\ue4f8'),
    POLL("mdsmz-poll", '\ue4fa'),
    POLYMER("mdsmz-polymer", '\ue4fc'),
    POOL("mdsmz-pool", '\ue4fd'),
    PORTABLE_WIFI_OFF("mdsmz-portable_wifi_off", '\ue4ff'),
    PORTRAIT("mdsmz-portrait", '\ue500'),
    POST_ADD("mdsmz-post_add", '\ue502'),
    POWER("mdsmz-power", '\ue503'),
    POWER_INPUT("mdsmz-power_input", '\ue505'),
    POWER_OFF("mdsmz-power_off", '\ue506'),
    POWER_SETTINGS_NEW("mdsmz-power_settings_new", '\ue508'),
    PREGNANT_WOMAN("mdsmz-pregnant_woman", '\ue509'),
    PRESENT_TO_ALL("mdsmz-present_to_all", '\ue50a'),
    PREVIEW("mdsmz-preview", '\ue80c'),
    PRINT("mdsmz-print", '\ue50c'),
    PRINT_DISABLED("mdsmz-print_disabled", '\ue50e'),
    PRIORITY_HIGH("mdsmz-priority_high", '\ue510'),
    PRIVACY_TIP("mdsmz-privacy_tip", '\ue80e'),
    PSYCHOLOGY("mdsmz-psychology", '\ue810'),
    PUBLIC("mdsmz-public", '\ue511'),
    PUBLIC_OFF("mdsmz-public_off", '\ue812'),
    PUBLISH("mdsmz-publish", '\ue513'),
    PUBLISHED_WITH_CHANGES("mdsmz-published_with_changes", '\ue8c4'),
    PUSH_PIN("mdsmz-push_pin", '\ue814'),
    QR_CODE("mdsmz-qr_code", '\ue816'),
    QR_CODE_2("mdsmz-qr_code_2", '\ue8d1'),
    QR_CODE_SCANNER("mdsmz-qr_code_scanner", '\ue885'),
    QRCODE("mdsmz-qrcode", '\ue515'),
    QUERY_BUILDER("mdsmz-query_builder", '\ue517'),
    QUESTION_ANSWER("mdsmz-question_answer", '\ue519'),
    QUEUE("mdsmz-queue", '\ue51b'),
    QUEUE_MUSIC("mdsmz-queue_music", '\ue51d'),
    QUEUE_PLAY_NEXT("mdsmz-queue_play_next", '\ue51f'),
    QUICKREPLY("mdsmz-quickreply", '\ue818'),
    RADIO("mdsmz-radio", '\ue520'),
    RADIO_BUTTON_CHECKED("mdsmz-radio_button_checked", '\ue522'),
    RADIO_BUTTON_UNCHECKED("mdsmz-radio_button_unchecked", '\ue523'),
    RATE_REVIEW("mdsmz-rate_review", '\ue524'),
    READ_MORE("mdsmz-read_more", '\ue81a'),
    RECEIPT("mdsmz-receipt", '\ue526'),
    RECEIPT_LONG("mdsmz-receipt_long", '\ue81b'),
    RECENT_ACTORS("mdsmz-recent_actors", '\ue528'),
    RECORD_VOICE_OVER("mdsmz-record_voice_over", '\ue52a'),
    REDEEM("mdsmz-redeem", '\ue52c'),
    REDO("mdsmz-redo", '\ue52e'),
    REDUCE_CAPACITY("mdsmz-reduce_capacity", '\ue8af'),
    REFRESH("mdsmz-refresh", '\ue52f'),
    REMOVE("mdsmz-remove", '\ue530'),
    REMOVE_CIRCLE("mdsmz-remove_circle", '\ue531'),
    REMOVE_CIRCLE_OUTLINE("mdsmz-remove_circle_outline", '\ue533'),
    REMOVE_FROM_QUEUE("mdsmz-remove_from_queue", '\ue534'),
    REMOVE_RED_EYE("mdsmz-remove_red_eye", '\ue536'),
    REMOVE_SHOPPING_CART("mdsmz-remove_shopping_cart", '\ue538'),
    REORDER("mdsmz-reorder", '\ue53a'),
    REPEAT("mdsmz-repeat", '\ue53b'),
    REPEAT_ONE("mdsmz-repeat_one", '\ue53c'),
    REPLAY("mdsmz-replay", '\ue53d'),
    REPLAY_10("mdsmz-replay_10", '\ue53e'),
    REPLAY_30("mdsmz-replay_30", '\ue53f'),
    REPLAY_5("mdsmz-replay_5", '\ue540'),
    REPLY("mdsmz-reply", '\ue541'),
    REPLY_ALL("mdsmz-reply_all", '\ue542'),
    REPORT("mdsmz-report", '\ue543'),
    REPORT_OFF("mdsmz-report_off", '\ue545'),
    REPORT_PROBLEM("mdsmz-report_problem", '\ue547'),
    REQUEST_PAGE("mdsmz-request_page", '\ue8c5'),
    REQUEST_QUOTE("mdsmz-request_quote", '\ue81d'),
    RESTAURANT("mdsmz-restaurant", '\ue549'),
    RESTAURANT_MENU("mdsmz-restaurant_menu", '\ue54a'),
    RESTORE("mdsmz-restore", '\ue54b'),
    RESTORE_FROM_TRASH("mdsmz-restore_from_trash", '\ue54c'),
    RESTORE_PAGE("mdsmz-restore_page", '\ue54e'),
    RICE_BOWL("mdsmz-rice_bowl", '\ue886'),
    RING_VOLUME("mdsmz-ring_volume", '\ue550'),
    ROCKET("mdsmz-rocket", '\ue552'),
    ROOFING("mdsmz-roofing", '\ue888'),
    ROOM("mdsmz-room", '\ue554'),
    ROOM_PREFERENCES("mdsmz-room_preferences", '\ue81f'),
    ROOM_SERVICE("mdsmz-room_service", '\ue556'),
    ROTATE_90_DEGREES_CCW("mdsmz-rotate_90_degrees_ccw", '\ue558'),
    ROTATE_LEFT("mdsmz-rotate_left", '\ue55a'),
    ROTATE_RIGHT("mdsmz-rotate_right", '\ue55b'),
    ROUNDED_CORNER("mdsmz-rounded_corner", '\ue55c'),
    ROUTER("mdsmz-router", '\ue55d'),
    ROWING("mdsmz-rowing", '\ue55f'),
    RSS_FEED("mdsmz-rss_feed", '\ue560'),
    RULE("mdsmz-rule", '\ue821'),
    RULE_FOLDER("mdsmz-rule_folder", '\ue822'),
    RUN_CIRCLE("mdsmz-run_circle", '\ue824'),
    RV_HOOKUP("mdsmz-rv_hookup", '\ue561'),
    SANITIZER("mdsmz-sanitizer", '\ue8b0'),
    SATELLITE("mdsmz-satellite", '\ue563'),
    SAVE("mdsmz-save", '\ue565'),
    SAVE_ALT("mdsmz-save_alt", '\ue567'),
    SCANNER("mdsmz-scanner", '\ue568'),
    SCATTER_PLOT("mdsmz-scatter_plot", '\ue56a'),
    SCHEDULE("mdsmz-schedule", '\ue56c'),
    SCHOOL("mdsmz-school", '\ue56e'),
    SCIENCE("mdsmz-science", '\ue826'),
    SCORE("mdsmz-score", '\ue570'),
    SCREEN_LOCK_LANDSCAPE("mdsmz-screen_lock_landscape", '\ue572'),
    SCREEN_LOCK_PORTRAIT("mdsmz-screen_lock_portrait", '\ue574'),
    SCREEN_LOCK_ROTATION("mdsmz-screen_lock_rotation", '\ue576'),
    SCREEN_ROTATION("mdsmz-screen_rotation", '\ue577'),
    SCREEN_SHARE("mdsmz-screen_share", '\ue579'),
    SD_CARD("mdsmz-sd_card", '\ue57b'),
    SD_STORAGE("mdsmz-sd_storage", '\ue57d'),
    SEARCH("mdsmz-search", '\ue57f'),
    SEARCH_OFF("mdsmz-search_off", '\ue828'),
    SECURITY("mdsmz-security", '\ue580'),
    SELECT_ALL("mdsmz-select_all", '\ue582'),
    SELF_IMPROVEMENT("mdsmz-self_improvement", '\ue829'),
    SEND("mdsmz-send", '\ue583'),
    SENSOR_DOOR("mdsmz-sensor_door", '\ue82a'),
    SENSOR_WINDOW("mdsmz-sensor_window", '\ue82c'),
    SENTIMENT_DISSATISFIED("mdsmz-sentiment_dissatisfied", '\ue585'),
    SENTIMENT_NEUTRAL("mdsmz-sentiment_neutral", '\ue587'),
    SENTIMENT_SATISFIED("mdsmz-sentiment_satisfied", '\ue589'),
    SENTIMENT_SATISFIED_ALT("mdsmz-sentiment_satisfied_alt", '\ue58b'),
    SENTIMENT_SLIGHTLY_DISSATISFIED("mdsmz-sentiment_slightly_dissatisfied", '\ue58d'),
    SENTIMENT_VERY_DISSATISFIED("mdsmz-sentiment_very_dissatisfied", '\ue58f'),
    SENTIMENT_VERY_SATISFIED("mdsmz-sentiment_very_satisfied", '\ue591'),
    SET_MEAL("mdsmz-set_meal", '\ue88a'),
    SETTINGS("mdsmz-settings", '\ue593'),
    SETTINGS_APPLICATIONS("mdsmz-settings_applications", '\ue595'),
    SETTINGS_BACKUP_RESTORE("mdsmz-settings_backup_restore", '\ue597'),
    SETTINGS_BLUETOOTH("mdsmz-settings_bluetooth", '\ue598'),
    SETTINGS_BRIGHTNESS("mdsmz-settings_brightness", '\ue599'),
    SETTINGS_CELL("mdsmz-settings_cell", '\ue59b'),
    SETTINGS_ETHERNET("mdsmz-settings_ethernet", '\ue59d'),
    SETTINGS_INPUT_ANTENNA("mdsmz-settings_input_antenna", '\ue59e'),
    SETTINGS_INPUT_COMPONENT("mdsmz-settings_input_component", '\ue59f'),
    SETTINGS_INPUT_COMPOSITE("mdsmz-settings_input_composite", '\ue5a1'),
    SETTINGS_INPUT_HDMI("mdsmz-settings_input_hdmi", '\ue5a3'),
    SETTINGS_INPUT_SVIDEO("mdsmz-settings_input_svideo", '\ue5a5'),
    SETTINGS_OVERSCAN("mdsmz-settings_overscan", '\ue5a7'),
    SETTINGS_PHONE("mdsmz-settings_phone", '\ue5a9'),
    SETTINGS_POWER("mdsmz-settings_power", '\ue5ab'),
    SETTINGS_REMOTE("mdsmz-settings_remote", '\ue5ac'),
    SETTINGS_SYSTEM_DAYDREAM("mdsmz-settings_system_daydream", '\ue5ae'),
    SETTINGS_VOICE("mdsmz-settings_voice", '\ue5b0'),
    SHARE("mdsmz-share", '\ue5b2'),
    SHOP("mdsmz-shop", '\ue5b4'),
    SHOP_TWO("mdsmz-shop_two", '\ue5b6'),
    SHOPPING_BAG("mdsmz-shopping_bag", '\ue82e'),
    SHOPPING_BASKET("mdsmz-shopping_basket", '\ue5b8'),
    SHOPPING_CART("mdsmz-shopping_cart", '\ue5ba'),
    SHORT_TEXT("mdsmz-short_text", '\ue5bc'),
    SHOW_CHART("mdsmz-show_chart", '\ue5bd'),
    SHUFFLE("mdsmz-shuffle", '\ue5be'),
    SHUTTER_SPEED("mdsmz-shutter_speed", '\ue5bf'),
    SICK("mdsmz-sick", '\ue8b2'),
    SIGNAL_CELLULAR_0_BAR("mdsmz-signal_cellular_0_bar", '\ue5c1'),
    SIGNAL_CELLULAR_1_BAR("mdsmz-signal_cellular_1_bar", '\ue5c3'),
    SIGNAL_CELLULAR_2_BAR("mdsmz-signal_cellular_2_bar", '\ue5c5'),
    SIGNAL_CELLULAR_3_BAR("mdsmz-signal_cellular_3_bar", '\ue5c7'),
    SIGNAL_CELLULAR_4_BAR("mdsmz-signal_cellular_4_bar", '\ue5c9'),
    SIGNAL_CELLULAR_ALT("mdsmz-signal_cellular_alt", '\ue5ca'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR("mdsmz-signal_cellular_connected_no_internet_0_bar", '\ue5cb'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_1_BAR("mdsmz-signal_cellular_connected_no_internet_1_bar", '\ue5cd'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_2_BAR("mdsmz-signal_cellular_connected_no_internet_2_bar", '\ue5cf'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_3_BAR("mdsmz-signal_cellular_connected_no_internet_3_bar", '\ue5d1'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("mdsmz-signal_cellular_connected_no_internet_4_bar", '\ue5d3'),
    SIGNAL_CELLULAR_NO_SIM("mdsmz-signal_cellular_no_sim", '\ue5d4'),
    SIGNAL_CELLULAR_NULL("mdsmz-signal_cellular_null", '\ue5d6'),
    SIGNAL_CELLULAR_OFF("mdsmz-signal_cellular_off", '\ue5d7'),
    SIGNAL_WIFI_0_BAR("mdsmz-signal_wifi_0_bar", '\ue5d8'),
    SIGNAL_WIFI_1_BAR("mdsmz-signal_wifi_1_bar", '\ue5da'),
    SIGNAL_WIFI_1_BAR_LOCK("mdsmz-signal_wifi_1_bar_lock", '\ue5dc'),
    SIGNAL_WIFI_2_BAR("mdsmz-signal_wifi_2_bar", '\ue5de'),
    SIGNAL_WIFI_2_BAR_LOCK("mdsmz-signal_wifi_2_bar_lock", '\ue5e0'),
    SIGNAL_WIFI_3_BAR("mdsmz-signal_wifi_3_bar", '\ue5e2'),
    SIGNAL_WIFI_3_BAR_LOCK("mdsmz-signal_wifi_3_bar_lock", '\ue5e4'),
    SIGNAL_WIFI_4_BAR("mdsmz-signal_wifi_4_bar", '\ue5e6'),
    SIGNAL_WIFI_4_BAR_LOCK("mdsmz-signal_wifi_4_bar_lock", '\ue5e7'),
    SIGNAL_WIFI_OFF("mdsmz-signal_wifi_off", '\ue5e8'),
    SIM_CARD("mdsmz-sim_card", '\ue5e9'),
    SIM_CARD_ALERT("mdsmz-sim_card_alert", '\ue5eb'),
    SINGLE_BED("mdsmz-single_bed", '\ue5ed'),
    SKIP_NEXT("mdsmz-skip_next", '\ue5ef'),
    SKIP_PREVIOUS("mdsmz-skip_previous", '\ue5f1'),
    SLIDESHOW("mdsmz-slideshow", '\ue5f3'),
    SLOW_MOTION_VIDEO("mdsmz-slow_motion_video", '\ue5f5'),
    SMART_BUTTON("mdsmz-smart_button", '\ue830'),
    SMARTPHONE("mdsmz-smartphone", '\ue5f6'),
    SMOKE_FREE("mdsmz-smoke_free", '\ue5f8'),
    SMOKING_ROOMS("mdsmz-smoking_rooms", '\ue5f9'),
    SMS("mdsmz-sms", '\ue5fb'),
    SMS_FAILED("mdsmz-sms_failed", '\ue5fd'),
    SNIPPET_FOLDER("mdsmz-snippet_folder", '\ue831'),
    SNOOZE("mdsmz-snooze", '\ue5ff'),
    SOAP("mdsmz-soap", '\ue833'),
    SORT("mdsmz-sort", '\ue600'),
    SORT_BY_ALPHA("mdsmz-sort_by_alpha", '\ue601'),
    SOURCE("mdsmz-source", '\ue835'),
    SOUTH("mdsmz-south", '\ue88c'),
    SOUTH_EAST("mdsmz-south_east", '\ue88d'),
    SOUTH_WEST("mdsmz-south_west", '\ue88e'),
    SPA("mdsmz-spa", '\ue602'),
    SPACE_BAR("mdsmz-space_bar", '\ue604'),
    SPEAKER("mdsmz-speaker", '\ue605'),
    SPEAKER_GROUP("mdsmz-speaker_group", '\ue607'),
    SPEAKER_NOTES("mdsmz-speaker_notes", '\ue609'),
    SPEAKER_NOTES_OFF("mdsmz-speaker_notes_off", '\ue60b'),
    SPEAKER_PHONE("mdsmz-speaker_phone", '\ue60d'),
    SPEED("mdsmz-speed", '\ue60f'),
    SPELLCHECK("mdsmz-spellcheck", '\ue610'),
    SPORTS("mdsmz-sports", '\ue611'),
    SPORTS_BAR("mdsmz-sports_bar", '\ue88f'),
    SPORTS_BASEBALL("mdsmz-sports_baseball", '\ue612'),
    SPORTS_BASKETBALL("mdsmz-sports_basketball", '\ue614'),
    SPORTS_CRICKET("mdsmz-sports_cricket", '\ue616'),
    SPORTS_ESPORTS("mdsmz-sports_esports", '\ue618'),
    SPORTS_FOOTBALL("mdsmz-sports_football", '\ue61a'),
    SPORTS_GOLF("mdsmz-sports_golf", '\ue61c'),
    SPORTS_HANDBALL("mdsmz-sports_handball", '\ue61e'),
    SPORTS_HOCKEY("mdsmz-sports_hockey", '\ue61f'),
    SPORTS_KABADDI("mdsmz-sports_kabaddi", '\ue620'),
    SPORTS_MMA("mdsmz-sports_mma", '\ue621'),
    SPORTS_MOTORSPORTS("mdsmz-sports_motorsports", '\ue623'),
    SPORTS_RUGBY("mdsmz-sports_rugby", '\ue625'),
    SPORTS_SOCCER("mdsmz-sports_soccer", '\ue627'),
    SPORTS_TENNIS("mdsmz-sports_tennis", '\ue629'),
    SPORTS_VOLLEYBALL("mdsmz-sports_volleyball", '\ue62a'),
    SQUARE_FOOT("mdsmz-square_foot", '\ue62c'),
    STACKED_LINE_CHART("mdsmz-stacked_line_chart", '\ue8c7'),
    STAIRS("mdsmz-stairs", '\ue837'),
    STAR("mdsmz-star", '\ue62e'),
    STAR_BORDER("mdsmz-star_border", '\ue630'),
    STAR_HALF("mdsmz-star_half", '\ue631'),
    STAR_OUTLINE("mdsmz-star_outline", '\ue748'),
    STAR_RATE("mdsmz-star_rate", '\ue632'),
    STARS("mdsmz-stars", '\ue633'),
    STAY_CURRENT_LANDSCAPE("mdsmz-stay_current_landscape", '\ue635'),
    STAY_CURRENT_PORTRAIT("mdsmz-stay_current_portrait", '\ue637'),
    STAY_PRIMARY_LANDSCAPE("mdsmz-stay_primary_landscape", '\ue639'),
    STAY_PRIMARY_PORTRAIT("mdsmz-stay_primary_portrait", '\ue63b'),
    STICKY_NOTE_2("mdsmz-sticky_note_2", '\ue891'),
    STOP("mdsmz-stop", '\ue63d'),
    STOP_CIRCLE("mdsmz-stop_circle", '\ue63f'),
    STOP_SCREEN_SHARE("mdsmz-stop_screen_share", '\ue641'),
    STORAGE("mdsmz-storage", '\ue643'),
    STORE("mdsmz-store", '\ue644'),
    STORE_MALL_DIRECTORY("mdsmz-store_mall_directory", '\ue646'),
    STOREFRONT("mdsmz-storefront", '\ue648'),
    STRAIGHTEN("mdsmz-straighten", '\ue64a'),
    STREETVIEW("mdsmz-streetview", '\ue64c'),
    STRIKETHROUGH_S("mdsmz-strikethrough_s", '\ue64d'),
    STROLLER("mdsmz-stroller", '\ue839'),
    STYLE("mdsmz-style", '\ue64e'),
    SUBDIRECTORY_ARROW_LEFT("mdsmz-subdirectory_arrow_left", '\ue650'),
    SUBDIRECTORY_ARROW_RIGHT("mdsmz-subdirectory_arrow_right", '\ue651'),
    SUBJECT("mdsmz-subject", '\ue652'),
    SUBSCRIPT("mdsmz-subscript", '\ue83b'),
    SUBSCRIPTIONS("mdsmz-subscriptions", '\ue653'),
    SUBTITLES("mdsmz-subtitles", '\ue655'),
    SUBTITLES_OFF("mdsmz-subtitles_off", '\ue83c'),
    SUBWAY("mdsmz-subway", '\ue657'),
    SUPERSCRIPT("mdsmz-superscript", '\ue83e'),
    SUPERVISED_USER_CIRCLE("mdsmz-supervised_user_circle", '\ue659'),
    SUPERVISOR_ACCOUNT("mdsmz-supervisor_account", '\ue65b'),
    SUPPORT("mdsmz-support", '\ue83f'),
    SUPPORT_AGENT("mdsmz-support_agent", '\ue841'),
    SURROUND_SOUND("mdsmz-surround_sound", '\ue65d'),
    SWAP_CALLS("mdsmz-swap_calls", '\ue65f'),
    SWAP_HORIZ("mdsmz-swap_horiz", '\ue660'),
    SWAP_HORIZONTAL_CIRCLE("mdsmz-swap_horizontal_circle", '\ue661'),
    SWAP_VERT("mdsmz-swap_vert", '\ue663'),
    SWAP_VERTICAL_CIRCLE("mdsmz-swap_vertical_circle", '\ue664'),
    SWITCH_CAMERA("mdsmz-switch_camera", '\ue666'),
    SWITCH_LEFT("mdsmz-switch_left", '\ue842'),
    SWITCH_RIGHT("mdsmz-switch_right", '\ue844'),
    SWITCH_VIDEO("mdsmz-switch_video", '\ue668'),
    SYNC("mdsmz-sync", '\ue66a'),
    SYNC_ALT("mdsmz-sync_alt", '\ue66b'),
    SYNC_DISABLED("mdsmz-sync_disabled", '\ue66c'),
    SYNC_PROBLEM("mdsmz-sync_problem", '\ue66d'),
    SYSTEM_UPDATE("mdsmz-system_update", '\ue66e'),
    SYSTEM_UPDATE_ALT("mdsmz-system_update_alt", '\ue670'),
    TAB("mdsmz-tab", '\ue671'),
    TAB_UNSELECTED("mdsmz-tab_unselected", '\ue672'),
    TABLE_CHART("mdsmz-table_chart", '\ue673'),
    TABLE_ROWS("mdsmz-table_rows", '\ue846'),
    TABLE_VIEW("mdsmz-table_view", '\ue848'),
    TABLET("mdsmz-tablet", '\ue675'),
    TABLET_ANDROID("mdsmz-tablet_android", '\ue677'),
    TABLET_MAC("mdsmz-tablet_mac", '\ue679'),
    TAG_FACES("mdsmz-tag_faces", '\ue67b'),
    TAP_AND_PLAY("mdsmz-tap_and_play", '\ue67d'),
    TAPAS("mdsmz-tapas", '\ue893'),
    TERRAIN("mdsmz-terrain", '\ue67e'),
    TEXT_FIELDS("mdsmz-text_fields", '\ue680'),
    TEXT_FORMAT("mdsmz-text_format", '\ue681'),
    TEXT_ROTATE_UP("mdsmz-text_rotate_up", '\ue682'),
    TEXT_ROTATE_VERTICAL("mdsmz-text_rotate_vertical", '\ue683'),
    TEXT_ROTATION_ANGLEDOWN("mdsmz-text_rotation_angledown", '\ue684'),
    TEXT_ROTATION_ANGLEUP("mdsmz-text_rotation_angleup", '\ue685'),
    TEXT_ROTATION_DOWN("mdsmz-text_rotation_down", '\ue686'),
    TEXT_ROTATION_NONE("mdsmz-text_rotation_none", '\ue687'),
    TEXT_SNIPPET("mdsmz-text_snippet", '\ue84a'),
    TEXTSMS("mdsmz-textsms", '\ue688'),
    TEXTURE("mdsmz-texture", '\ue68a'),
    THEATERS("mdsmz-theaters", '\ue68b'),
    THUMB_DOWN("mdsmz-thumb_down", '\ue68d'),
    THUMB_DOWN_ALT("mdsmz-thumb_down_alt", '\ue68f'),
    THUMB_UP("mdsmz-thumb_up", '\ue691'),
    THUMB_UP_ALT("mdsmz-thumb_up_alt", '\ue693'),
    THUMBS_UP_DOWN("mdsmz-thumbs_up_down", '\ue695'),
    TIME_TO_LEAVE("mdsmz-time_to_leave", '\ue697'),
    TIMELAPSE("mdsmz-timelapse", '\ue699'),
    TIMELINE("mdsmz-timeline", '\ue69b'),
    TIMER("mdsmz-timer", '\ue69c'),
    TIMER_10("mdsmz-timer_10", '\ue69e'),
    TIMER_3("mdsmz-timer_3", '\ue69f'),
    TIMER_OFF("mdsmz-timer_off", '\ue6a0'),
    TITLE("mdsmz-title", '\ue6a2'),
    TOC("mdsmz-toc", '\ue6a3'),
    TODAY("mdsmz-today", '\ue6a4'),
    TOGGLE_OFF("mdsmz-toggle_off", '\ue6a6'),
    TOGGLE_ON("mdsmz-toggle_on", '\ue6a8'),
    TOLL("mdsmz-toll", '\ue6aa'),
    TONALITY("mdsmz-tonality", '\ue6ac'),
    TOPIC("mdsmz-topic", '\ue84c'),
    TOUCH_APP("mdsmz-touch_app", '\ue6ae'),
    TOUR("mdsmz-tour", '\ue84e'),
    TOYS("mdsmz-toys", '\ue6b0'),
    TRACK_CHANGES("mdsmz-track_changes", '\ue6b2'),
    TRAFFIC("mdsmz-traffic", '\ue6b3'),
    TRAIN("mdsmz-train", '\ue6b5'),
    TRAM("mdsmz-tram", '\ue6b7'),
    TRANSFER_WITHIN_A_STATION("mdsmz-transfer_within_a_station", '\ue6b9'),
    TRANSFORM("mdsmz-transform", '\ue6ba'),
    TRANSIT_ENTEREXIT("mdsmz-transit_enterexit", '\ue6bb'),
    TRANSLATE("mdsmz-translate", '\ue6bc'),
    TRENDING_DOWN("mdsmz-trending_down", '\ue6bd'),
    TRENDING_FLAT("mdsmz-trending_flat", '\ue6be'),
    TRENDING_UP("mdsmz-trending_up", '\ue6bf'),
    TRIP_ORIGIN("mdsmz-trip_origin", '\ue6c0'),
    TTY("mdsmz-tty", '\ue850'),
    TUNE("mdsmz-tune", '\ue6c1'),
    TURNED_IN("mdsmz-turned_in", '\ue6c2'),
    TURNED_IN_NOT("mdsmz-turned_in_not", '\ue6c4'),
    TV("mdsmz-tv", '\ue6c5'),
    TV_OFF("mdsmz-tv_off", '\ue6c7'),
    TWO_WHEELER("mdsmz-two_wheeler", '\ue749'),
    UMBRELLA("mdsmz-umbrella", '\ue852'),
    UNARCHIVE("mdsmz-unarchive", '\ue6c9'),
    UNDO("mdsmz-undo", '\ue6cb'),
    UNFOLD_LESS("mdsmz-unfold_less", '\ue6cc'),
    UNFOLD_MORE("mdsmz-unfold_more", '\ue6cd'),
    UNPUBLISHED("mdsmz-unpublished", '\ue8c8'),
    UNSUBSCRIBE("mdsmz-unsubscribe", '\ue6ce'),
    UPDATE("mdsmz-update", '\ue6d0'),
    UPDATE_DISABLED("mdsmz-update_disabled", '\ue8d2'),
    UPGRADE("mdsmz-upgrade", '\ue854'),
    USB("mdsmz-usb", '\ue6d1'),
    VERIFIED("mdsmz-verified", '\ue855'),
    VERIFIED_USER("mdsmz-verified_user", '\ue6d2'),
    VERTICAL_ALIGN_BOTTOM("mdsmz-vertical_align_bottom", '\ue6d4'),
    VERTICAL_ALIGN_CENTER("mdsmz-vertical_align_center", '\ue6d5'),
    VERTICAL_ALIGN_TOP("mdsmz-vertical_align_top", '\ue6d6'),
    VERTICAL_DISTRIBUTE("mdsmz-vertical_distribute", '\ue8d3'),
    VERTICAL_SPLIT("mdsmz-vertical_split", '\ue6d7'),
    VIBRATION("mdsmz-vibration", '\ue6d9'),
    VIDEO_CALL("mdsmz-video_call", '\ue6db'),
    VIDEO_LABEL("mdsmz-video_label", '\ue6dd'),
    VIDEO_LIBRARY("mdsmz-video_library", '\ue6df'),
    VIDEO_SETTINGS("mdsmz-video_settings", '\ue857'),
    VIDEOCAM("mdsmz-videocam", '\ue6e1'),
    VIDEOCAM_OFF("mdsmz-videocam_off", '\ue6e3'),
    VIDEOGAME_ASSET("mdsmz-videogame_asset", '\ue6e5'),
    VIEW_AGENDA("mdsmz-view_agenda", '\ue6e7'),
    VIEW_ARRAY("mdsmz-view_array", '\ue6e9'),
    VIEW_CAROUSEL("mdsmz-view_carousel", '\ue6eb'),
    VIEW_COLUMN("mdsmz-view_column", '\ue6ed'),
    VIEW_COMFY("mdsmz-view_comfy", '\ue6ef'),
    VIEW_COMPACT("mdsmz-view_compact", '\ue6f1'),
    VIEW_DAY("mdsmz-view_day", '\ue6f3'),
    VIEW_HEADLINE("mdsmz-view_headline", '\ue6f5'),
    VIEW_LIST("mdsmz-view_list", '\ue6f6'),
    VIEW_MODULE("mdsmz-view_module", '\ue6f8'),
    VIEW_QUILT("mdsmz-view_quilt", '\ue6fa'),
    VIEW_SIDEBAR("mdsmz-view_sidebar", '\ue858'),
    VIEW_STREAM("mdsmz-view_stream", '\ue6fc'),
    VIEW_WEEK("mdsmz-view_week", '\ue6fe'),
    VIGNETTE("mdsmz-vignette", '\ue700'),
    VISIBILITY("mdsmz-visibility", '\ue702'),
    VISIBILITY_OFF("mdsmz-visibility_off", '\ue704'),
    VOICE_CHAT("mdsmz-voice_chat", '\ue706'),
    VOICE_OVER_OFF("mdsmz-voice_over_off", '\ue708'),
    VOICEMAIL("mdsmz-voicemail", '\ue70a'),
    VOLUME_DOWN("mdsmz-volume_down", '\ue70b'),
    VOLUME_MUTE("mdsmz-volume_mute", '\ue70d'),
    VOLUME_OFF("mdsmz-volume_off", '\ue70f'),
    VOLUME_UP("mdsmz-volume_up", '\ue711'),
    VPN_KEY("mdsmz-vpn_key", '\ue713'),
    VPN_LOCK("mdsmz-vpn_lock", '\ue715'),
    WALLPAPER("mdsmz-wallpaper", '\ue717'),
    WARNING("mdsmz-warning", '\ue718'),
    WASH("mdsmz-wash", '\ue85a'),
    WATCH("mdsmz-watch", '\ue71a'),
    WATCH_LATER("mdsmz-watch_later", '\ue71c'),
    WATER_DAMAGE("mdsmz-water_damage", '\ue895'),
    WAVES("mdsmz-waves", '\ue71e'),
    WB_AUTO("mdsmz-wb_auto", '\ue71f'),
    WB_CLOUDY("mdsmz-wb_cloudy", '\ue721'),
    WB_INCANDESCENT("mdsmz-wb_incandescent", '\ue723'),
    WB_IRIDESCENT("mdsmz-wb_iridescent", '\ue725'),
    WB_SUNNY("mdsmz-wb_sunny", '\ue727'),
    WC("mdsmz-wc", '\ue729'),
    WEB("mdsmz-web", '\ue72a'),
    WEB_ASSET("mdsmz-web_asset", '\ue72c'),
    WEEKEND("mdsmz-weekend", '\ue72e'),
    WEST("mdsmz-west", '\ue897'),
    WHATSHOT("mdsmz-whatshot", '\ue730'),
    WHEELCHAIR_PICKUP("mdsmz-wheelchair_pickup", '\ue85c'),
    WHERE_TO_VOTE("mdsmz-where_to_vote", '\ue732'),
    WIDGETS("mdsmz-widgets", '\ue734'),
    WIFI("mdsmz-wifi", '\ue736'),
    WIFI_CALLING("mdsmz-wifi_calling", '\ue85d'),
    WIFI_LOCK("mdsmz-wifi_lock", '\ue737'),
    WIFI_OFF("mdsmz-wifi_off", '\ue738'),
    WIFI_PROTECTED_SETUP("mdsmz-wifi_protected_setup", '\ue85f'),
    WIFI_TETHERING("mdsmz-wifi_tethering", '\ue739'),
    WINE_BAR("mdsmz-wine_bar", '\ue898'),
    WORK("mdsmz-work", '\ue73a'),
    WORK_OFF("mdsmz-work_off", '\ue73c'),
    WORK_OUTLINE("mdsmz-work_outline", '\ue73e'),
    WRAP_TEXT("mdsmz-wrap_text", '\ue73f'),
    WRONG_LOCATION("mdsmz-wrong_location", '\ue860'),
    WYSIWYG("mdsmz-wysiwyg", '\ue861'),
    YOUTUBE_SEARCHED_FOR("mdsmz-youtube_searched_for", '\ue740'),
    ZOOM_IN("mdsmz-zoom_in", '\ue741'),
    ZOOM_OUT("mdsmz-zoom_out", '\ue742'),
    ZOOM_OUT_MAP("mdsmz-zoom_out_map", '\ue743');
    
    public static Material2SharpMZ findByDescription(String description) {
        for (Material2SharpMZ font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material2SharpMZ(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}