/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Icon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.swing.IkonResolver;

public class FontIcon
implements Icon {
    private static final Object LOCK = new Object[0];
    private Font font;
    private int width = 16;
    private int height = 16;
    private BufferedImage buffer;
    private int iconSize = 16;
    private Color iconColor = Color.BLACK;
    private Ikon ikon;

    public static FontIcon of(Ikon ikon) {
        return FontIcon.of(ikon, 16, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, int iconSize) {
        return FontIcon.of(ikon, iconSize, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, Color iconColor) {
        return FontIcon.of(ikon, 16, iconColor);
    }

    public static FontIcon of(Ikon ikon, int iconSize, Color iconColor) {
        FontIcon icon = new FontIcon();
        icon.setIkon(ikon);
        icon.setIconSize(iconSize);
        icon.setIconColor(iconColor);
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Object object = LOCK;
        synchronized (object) {
            if (this.buffer == null) {
                this.buffer = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setFont(this.font);
                g2.setColor(this.iconColor);
                int sy = g2.getFontMetrics().getAscent();
                g2.drawString(String.valueOf(this.ikon.getCode()), 0, sy);
                g2.dispose();
            }
            g.drawImage(this.buffer, x, y, null);
        }
    }

    public Ikon getIkon() {
        return this.ikon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIkon(Ikon ikon) {
        Objects.requireNonNull(this.iconColor, "Argument 'iconFont' must not be null");
        this.ikon = ikon;
        Object object = LOCK;
        synchronized (object) {
            IkonHandler ikonHandler = IkonResolver.getInstance().resolve(ikon.getDescription());
            this.font = ((Font)ikonHandler.getFont()).deriveFont(0, this.iconSize);
            this.setProperties();
        }
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        if (iconSize > 0) {
            this.iconSize = iconSize;
            if (null != this.font) {
                this.font = this.font.deriveFont(0, iconSize);
                this.setProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperties() {
        BufferedImage tmp = new BufferedImage(this.iconSize, this.iconSize, 2);
        Graphics2D g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
        g2.setFont(this.font);
        this.width = g2.getFontMetrics().charWidth(this.ikon.getCode());
        this.height = g2.getFontMetrics().getHeight();
        g2.dispose();
        Object object = LOCK;
        synchronized (object) {
            this.buffer = null;
        }
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconColor(Color iconColor) {
        Objects.requireNonNull(iconColor, "Argument 'iconColor' must not be null");
        this.iconColor = iconColor;
        Object object = LOCK;
        synchronized (object) {
            this.buffer = null;
        }
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }
}

