/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jipsy.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TypeLoader.class);
    private static final String HASH = "#";

    private TypeLoader() {
    }

    public static boolean load(ClassLoader classLoader, Class<?> type, LineProcessor processor) {
        return TypeLoader.load(classLoader, "META-INF/types", type, processor);
    }

    public static boolean load(ClassLoader classLoader, String path, Class<?> type, LineProcessor processor) {
        Enumeration<URL> urls;
        Objects.requireNonNull(classLoader, "Argument 'classLoader' must not be null");
        TypeLoader.requireNonBlank(path, "Argument 'path' must not be blank");
        Objects.requireNonNull(type, "Argument 'type' must not be null");
        Objects.requireNonNull(processor, "Argument 'processor' must not be null");
        String normalizedPath = path.endsWith("/") ? path : path + "/";
        try {
            urls = classLoader.getResources(normalizedPath + type.getName());
        }
        catch (IOException ioe) {
            LOG.error(ioe.getClass().getName() + " error loading resources of type \"" + type.getName() + "\" from \"" + normalizedPath + "\".");
            return false;
        }
        if (urls == null) {
            return false;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            LOG.debug("Reading {} definitions from {}", (Object)type.getName(), (Object)url);
            try {
                Scanner scanner = new Scanner(url.openStream());
                Throwable throwable = null;
                try {
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line.startsWith(HASH) || TypeLoader.isBlank(line)) continue;
                        processor.process(classLoader, type, line);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Could not load " + type.getName() + " definitions from " + url, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean load(ClassLoader classLoader, String path, PathFilter pathFilter, ResourceProcessor processor) {
        Enumeration<URL> urls;
        Objects.requireNonNull(classLoader, "Argument 'classLoader' must not be null");
        TypeLoader.requireNonBlank(path, "Argument 'path' must not be blank");
        Objects.requireNonNull(pathFilter, "Argument 'pathFilter' must not be blank");
        Objects.requireNonNull(processor, "Argument 'processor' must not be null");
        try {
            urls = classLoader.getResources(path);
        }
        catch (IOException ioe) {
            LOG.debug(ioe.getClass().getName() + " error loading resources from \"" + path + "\".");
            return false;
        }
        if (urls == null) {
            return false;
        }
        block10: while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            LOG.debug("Reading definitions from " + url);
            switch (url.getProtocol()) {
                case "file": {
                    TypeLoader.handleFileResource(url, classLoader, path, pathFilter, processor);
                    continue block10;
                }
                case "jar": {
                    TypeLoader.handleJarResource(url, classLoader, path, pathFilter, processor);
                    continue block10;
                }
            }
            LOG.warn("Could not load definitions from " + url);
        }
        return true;
    }

    private static void handleFileResource(URL url, ClassLoader classLoader, String path, PathFilter pathFilter, ResourceProcessor processor) {
        try {
            File file = new File(url.toURI());
            for (File entry : file.listFiles()) {
                if (!pathFilter.accept(entry.getName())) continue;
                try (Scanner scanner = new Scanner(entry);){
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line.startsWith(HASH) || TypeLoader.isBlank(line)) continue;
                        processor.process(classLoader, line);
                    }
                }
                catch (IOException e) {
                    LOG.warn("An error occurred while loading resources from " + entry.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("An error occurred while loading resources from " + url, (Throwable)e);
        }
    }

    private static void handleJarResource(URL url, ClassLoader classLoader, String path, PathFilter pathFilter, ResourceProcessor processor) {
        block16: {
            try {
                URLConnection urlConnection = url.openConnection();
                if (!(urlConnection instanceof JarURLConnection)) break block16;
                JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                JarFile jar = jarURLConnection.getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (!jarEntry.getName().startsWith(path) || !pathFilter.accept(jarEntry.getName())) continue;
                    try {
                        Scanner scanner = new Scanner(jar.getInputStream(jarEntry));
                        Throwable throwable = null;
                        try {
                            while (scanner.hasNextLine()) {
                                String line = scanner.nextLine();
                                if (line.startsWith(HASH) || TypeLoader.isBlank(line)) continue;
                                processor.process(classLoader, line);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("An error occurred while loading resources from " + jarEntry.getName(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("An error occurred while loading resources from " + url, (Throwable)e);
            }
        }
    }

    private static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static String requireNonBlank(String str, String message) {
        if (TypeLoader.isBlank(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static interface ResourceProcessor {
        public void process(ClassLoader var1, String var2);
    }

    public static interface LineProcessor {
        public void process(ClassLoader var1, Class<?> var2, String var3);
    }

    public static interface PathFilter {
        public boolean accept(String var1);
    }
}

