/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.maven.plugin.checker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class Banner {
    private static final String ORG_KORDAMP_BANNER = "org.kordamp.banner";
    private static final Banner INSTANCE = new Banner();
    private final ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
    private final String productVersion = this.bundle.getString("product.version");
    private final String productId = this.bundle.getString("product.id");
    private final String productName = this.bundle.getString("product.name");
    private final String message = MessageFormat.format(this.bundle.getString("product.banner"), this.productName, this.productVersion);
    private final List<String> visited = new ArrayList<String>();

    private Banner() {
    }

    private File getMarkerFile(File parent) {
        return new File(parent, "kordamp" + File.separator + this.productId + File.separator + this.productVersion + File.separator + "marker.txt");
    }

    public static void display(MavenProject project, Log log) {
        block9: {
            if (Banner.INSTANCE.visited.contains(project.getName())) {
                return;
            }
            Banner.INSTANCE.visited.add(project.getName());
            boolean quiet = log.isErrorEnabled() && !log.isWarnEnabled() && !log.isInfoEnabled() && !log.isDebugEnabled();
            boolean printBanner = null == System.getProperty(ORG_KORDAMP_BANNER) || Boolean.getBoolean(ORG_KORDAMP_BANNER);
            try {
                File parent = new File(System.getProperty("user.home"), ".m2/caches");
                File markerFile = INSTANCE.getMarkerFile(parent);
                if (!markerFile.exists()) {
                    if (printBanner && !quiet) {
                        System.out.println(Banner.INSTANCE.message);
                    }
                    markerFile.getParentFile().mkdirs();
                    PrintStream out = new PrintStream(new FileOutputStream(markerFile));
                    out.println("1");
                    out.close();
                    Banner.writeQuietly(markerFile, "1");
                    break block9;
                }
                try {
                    int count = Integer.parseInt(Banner.readQuietly(markerFile));
                    if (count < 3 && printBanner && !quiet) {
                        System.out.println(Banner.INSTANCE.message);
                    }
                    Banner.writeQuietly(markerFile, count + 1 + "");
                }
                catch (NumberFormatException e) {
                    Banner.writeQuietly(markerFile, "1");
                    if (printBanner && !quiet) {
                        System.out.println(Banner.INSTANCE.message);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        try {
            Scanner in = new Scanner(new FileInputStream(file));
            return in.next();
        }
        catch (Exception ignored) {
            return "";
        }
    }
}

