/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.ActionRunner;
import org.kquiet.browser.DynamicActionSequence;
import org.kquiet.browser.action.Composable;
import org.kquiet.utility.Stopwatch;
import org.openqa.selenium.By;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionComposer
extends CompletableFuture<Void>
implements ActionComposer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractActionComposer.class);
    protected final Stack<DynamicActionSequence> executionContextStack = new Stack();
    protected final Stopwatch totalCostWatch = new Stopwatch();
    private final Deque<Composable> mainActionList = new LinkedList<Composable>();
    private final Map<String, Object> variableMap = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> registeredWindows = new LinkedHashMap<String, String>();
    private int priority = Integer.MIN_VALUE;
    private Consumer<ActionComposer> onFailFunc = ac -> {};
    private Consumer<ActionComposer> onSuccessFunc = ac -> {};
    private Consumer<ActionComposer> onDoneFunc = ac -> {};
    private Function<ActionComposer, Consumer<Composable>> actionPerformedFunc = ac -> at -> {};
    private Function<ActionComposer, Consumer<Composable>> actionPerformingFunc = ac -> at -> {};
    private ActionRunner actionRunner = null;
    private String name = "";
    private String focusWindowIdentity = null;

    @Override
    public AbstractActionComposer setActionRunner(ActionRunner actionRunner) {
        this.actionRunner = actionRunner;
        return this;
    }

    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    @Override
    public String getRootWindow() {
        return this.actionRunner.getRootWindowIdentity();
    }

    @Override
    public boolean registerWindow(String name, String windowIdentity) {
        if (name == null || windowIdentity == null || windowIdentity.isEmpty()) {
            return false;
        }
        if (this.registeredWindows.containsKey(name)) {
            return false;
        }
        this.registeredWindows.put(name, windowIdentity);
        return true;
    }

    @Override
    public String getRegisteredWindow(String registerName) {
        return this.registeredWindows.getOrDefault(registerName, "");
    }

    @Override
    public Map<String, String> getRegisteredWindows() {
        return new LinkedHashMap<String, String>(this.registeredWindows);
    }

    @Override
    public Object getVariable(String variableName) {
        return this.variableMap.get(variableName);
    }

    @Override
    public AbstractActionComposer setVariable(String variableName, Object value) {
        this.variableMap.put(variableName, value);
        return this;
    }

    @Override
    public CompletableFuture<Void> callBrowser(Runnable runnable) {
        return this.actionRunner.executeAction(runnable, this.getPriority());
    }

    @Override
    public void perform(Composable action) {
        if (action == null) {
            return;
        }
        try {
            this.getActionPerformingFunction().apply(this).accept(action);
        }
        catch (Exception e) {
            LOGGER.warn("{}({}) action performing function error", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
            throw e;
        }
        boolean isSequenceContainer = action instanceof DynamicActionSequence;
        try {
            if (isSequenceContainer) {
                this.executionContextStack.push((DynamicActionSequence)((Object)action));
            }
            action.setComposer(this);
            action.perform();
        }
        finally {
            if (isSequenceContainer) {
                this.executionContextStack.pop();
            }
        }
        try {
            this.getActionPerformedFunction().apply(this).accept(action);
        }
        catch (Exception e) {
            LOGGER.warn("{}({}) action performed function error", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
            throw e;
        }
    }

    @Override
    public boolean switchToFocusWindow() {
        return this.switchToWindow(this.getFocusWindow());
    }

    @Override
    public boolean switchToWindow(String windowIdentity) {
        try {
            this.getWebDriver().switchTo().window(windowIdentity);
            return true;
        }
        catch (Exception ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} switchToWindow error", (Object)this.getName(), (Object)ex);
            }
            return false;
        }
    }

    @Override
    public void switchToInnerFrame(List<By> frameBySequence) {
        if (frameBySequence != null) {
            WebDriver driver = this.getWebDriver();
            for (By frameBy : frameBySequence) {
                driver.switchTo().frame(driver.findElement(frameBy));
            }
        }
    }

    @Override
    public boolean switchToTop() {
        try {
            this.getWebDriver().switchTo().defaultContent();
            return true;
        }
        catch (UnhandledAlertException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} switchToTop error", (Object)this.getName(), (Object)ex);
            }
            return false;
        }
    }

    @Override
    public ActionComposer onFail(Consumer<ActionComposer> onFailFunc) {
        this.onFailFunc = onFailFunc != null ? onFailFunc : ac -> {};
        return this;
    }

    protected Consumer<ActionComposer> getFailFunction() {
        return this.onFailFunc;
    }

    @Override
    public ActionComposer onSuccess(Consumer<ActionComposer> onSuccessFunc) {
        this.onSuccessFunc = onSuccessFunc != null ? onSuccessFunc : ac -> {};
        return this;
    }

    protected Consumer<ActionComposer> getSuccessFunction() {
        return this.onSuccessFunc;
    }

    @Override
    public ActionComposer onDone(Consumer<ActionComposer> onDoneFunc) {
        this.onDoneFunc = onDoneFunc != null ? onDoneFunc : ac -> {};
        return this;
    }

    protected Function<ActionComposer, Consumer<Composable>> getActionPerformedFunction() {
        return this.actionPerformedFunc;
    }

    @Override
    public ActionComposer actionPerformed(Function<ActionComposer, Consumer<Composable>> func) {
        this.actionPerformedFunc = func != null ? func : ac -> at -> {};
        return this;
    }

    protected Function<ActionComposer, Consumer<Composable>> getActionPerformingFunction() {
        return this.actionPerformingFunc;
    }

    @Override
    public ActionComposer actionPerforming(Function<ActionComposer, Consumer<Composable>> func) {
        this.actionPerformingFunc = func != null ? func : ac -> at -> {};
        return this;
    }

    protected Consumer<ActionComposer> getDoneFunction() {
        return this.onDoneFunc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractActionComposer setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public AbstractActionComposer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public Duration getCostTime() {
        return this.totalCostWatch.getDuration();
    }

    @Override
    public WebDriver getWebDriver() {
        return this.actionRunner.getWebDriver();
    }

    @Override
    public String getFocusWindow() {
        if (this.focusWindowIdentity == null) {
            this.focusWindowIdentity = this.getRootWindow();
        }
        return this.focusWindowIdentity;
    }

    @Override
    public AbstractActionComposer setFocusWindow(String windowIdentity) {
        this.focusWindowIdentity = windowIdentity;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractActionComposer addToHead(Composable action) {
        if (action == null) {
            return this;
        }
        AbstractActionComposer abstractActionComposer = this;
        synchronized (abstractActionComposer) {
            this.mainActionList.addFirst(action);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractActionComposer addToTail(Composable action) {
        if (action == null) {
            return this;
        }
        AbstractActionComposer abstractActionComposer = this;
        synchronized (abstractActionComposer) {
            this.mainActionList.addLast(action);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractActionComposer addToPosition(Composable action, int position) {
        if (action == null) {
            return this;
        }
        AbstractActionComposer abstractActionComposer = this;
        synchronized (abstractActionComposer) {
            ArrayList<Composable> temp = new ArrayList<Composable>(this.mainActionList);
            temp.add(position, action);
            this.mainActionList.clear();
            this.mainActionList.addAll(temp);
        }
        return this;
    }

    @Override
    public DynamicActionSequence addToHeadByContext(Composable action) {
        DynamicActionSequence context = this.executionContextStack.peek();
        return context.addToHead(action);
    }

    @Override
    public DynamicActionSequence addToTailByContext(Composable action) {
        DynamicActionSequence context = this.executionContextStack.peek();
        return context.addToTail(action);
    }

    @Override
    public DynamicActionSequence addToPositionByContext(Composable action, int position) {
        DynamicActionSequence context = this.executionContextStack.peek();
        return context.addToPosition(action, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Composable> getAllActionInSequence() {
        ArrayList<Composable> actionList = new ArrayList<Composable>();
        AbstractActionComposer abstractActionComposer = this;
        synchronized (abstractActionComposer) {
            actionList.addAll(this.mainActionList);
        }
        return actionList;
    }

    @Override
    public List<Exception> getErrors() {
        List<Composable> actionList = this.getAllActionInSequence();
        ArrayList<Exception> result = new ArrayList<Exception>();
        for (Composable action : actionList) {
            if (!action.isFail() || action.getErrors() == null) continue;
            result.addAll(action.getErrors());
        }
        return result;
    }
}

