/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.BasicActionComposer;
import org.kquiet.browser.action.Click;
import org.kquiet.browser.action.CloseWindow;
import org.kquiet.browser.action.Composable;
import org.kquiet.browser.action.Custom;
import org.kquiet.browser.action.Extract;
import org.kquiet.browser.action.GetUrl;
import org.kquiet.browser.action.IfThenElse;
import org.kquiet.browser.action.JustWait;
import org.kquiet.browser.action.MouseOver;
import org.kquiet.browser.action.MultiPhased;
import org.kquiet.browser.action.OpenWindow;
import org.kquiet.browser.action.PostForm;
import org.kquiet.browser.action.ReplyAlert;
import org.kquiet.browser.action.ScrollToView;
import org.kquiet.browser.action.Select;
import org.kquiet.browser.action.SendKey;
import org.kquiet.browser.action.Upload;
import org.kquiet.browser.action.WaitUntil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class ActionComposerBuilder {
    private final Deque<Composable> actionList = new LinkedList<Composable>();
    private Consumer<ActionComposer> failFunc;
    private Consumer<ActionComposer> successFunc;
    private Consumer<ActionComposer> doneFunc;
    private Function<ActionComposer, Consumer<Composable>> actionPerformedFunc;
    private Function<ActionComposer, Consumer<Composable>> actionPerformingFunc;
    private volatile ActionComposer actionComposer;

    private ActionComposerBuilder add(Composable action) {
        this.actionList.addLast(action);
        return this;
    }

    public ActionComposerBuilder onFail(Consumer<ActionComposer> func) {
        this.failFunc = func;
        return this;
    }

    public ActionComposerBuilder onSuccess(Consumer<ActionComposer> func) {
        this.successFunc = func;
        return this;
    }

    public ActionComposerBuilder onDone(Consumer<ActionComposer> func) {
        this.doneFunc = func;
        return this;
    }

    public ActionComposerBuilder actionPerforming(Function<ActionComposer, Consumer<Composable>> func) {
        this.actionPerformingFunc = func;
        return this;
    }

    public ActionComposerBuilder actionPerformed(Function<ActionComposer, Consumer<Composable>> func) {
        this.actionPerformedFunc = func;
        return this;
    }

    private void commonBuild(ActionComposer actionComposer, String name) {
        actionComposer.setName(name).actionPerforming(this.actionPerformingFunc).actionPerformed(this.actionPerformedFunc).onFail(this.failFunc).onSuccess(this.successFunc).onDone(this.doneFunc);
        this.actionList.forEach(s -> actionComposer.addToTail((Composable)s));
    }

    public BasicActionComposer buildBasic() {
        return this.buildBasic(UUID.randomUUID().toString());
    }

    public BasicActionComposer buildBasic(String name) {
        if (this.actionComposer == null) {
            BasicActionComposer actionComposer = new BasicActionComposer();
            this.commonBuild(actionComposer, name);
            this.actionComposer = actionComposer;
            return actionComposer;
        }
        return (BasicActionComposer)this.actionComposer;
    }

    public <T extends ActionComposer> T build(Class<T> composerType) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return (T)this.build((T)((Object)composerType), UUID.randomUUID().toString());
    }

    public <T extends ActionComposer> T build(Class<T> composerType, String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (this.actionComposer == null) {
            ActionComposer obj = this.build((ActionComposer)Class.forName(composerType.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), name);
            return (T)obj;
        }
        ActionComposer obj = this.actionComposer;
        return (T)obj;
    }

    public <T extends ActionComposer> T build(T actionComposer, String name) {
        if (this.actionComposer == null) {
            this.commonBuild(actionComposer, name);
            this.actionComposer = actionComposer;
            return actionComposer;
        }
        ActionComposer obj = this.actionComposer;
        return (T)obj;
    }

    public ActionSequenceBuilder prepareActionSequence() {
        return new ActionSequenceBuilder(this);
    }

    public class ActionSequenceBuilder {
        private final ActionComposerBuilder parentComposerBuilder;
        private final IfThenElseBuilder parentIfThenElseBuilder;
        private final List<Composable> actionList = new ArrayList<Composable>();

        public ActionSequenceBuilder(ActionComposerBuilder parentComposerBuilder) {
            if (parentComposerBuilder == null) {
                throw new IllegalArgumentException("No parent builder");
            }
            this.parentComposerBuilder = parentComposerBuilder;
            this.parentIfThenElseBuilder = null;
        }

        public ActionSequenceBuilder(IfThenElseBuilder parentIfThenElseBuilder) {
            if (parentIfThenElseBuilder == null) {
                throw new IllegalArgumentException("No parent builder");
            }
            this.parentComposerBuilder = null;
            this.parentIfThenElseBuilder = parentIfThenElseBuilder;
        }

        private ActionSequenceBuilder add(Composable action) {
            if (action != null) {
                this.actionList.add(action);
            }
            return this;
        }

        public ActionComposerBuilder returnToComposerBuilder() {
            if (this.parentIfThenElseBuilder != null) {
                this.actionList.forEach(action -> this.parentIfThenElseBuilder.add((Composable)action));
                return this.parentIfThenElseBuilder.returnToComposerBuilder();
            }
            this.actionList.forEach(action -> this.parentComposerBuilder.add((Composable)action));
            return this.parentComposerBuilder;
        }

        public IfThenElseBuilder endActionSequence() {
            if (this.parentIfThenElseBuilder == null) {
                throw new UnsupportedOperationException("Parent builder is not IfThenElseBuilder");
            }
            this.actionList.forEach(action -> this.parentIfThenElseBuilder.add((Composable)action));
            return this.parentIfThenElseBuilder;
        }

        public ActionSequenceBuilder closeWindow(boolean closeAllRegistered) {
            return new CloseWindowBuilder(this, closeAllRegistered).done();
        }

        public CloseWindowBuilder prepareCloseWindow(boolean closeAllRegistered) {
            return new CloseWindowBuilder(this, closeAllRegistered);
        }

        public ActionSequenceBuilder openWindow() {
            return new OpenWindowBuilder(this).done();
        }

        public OpenWindowBuilder prepareOpenWindow() {
            return new OpenWindowBuilder(this);
        }

        public <V> ActionSequenceBuilder waitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout) {
            return new WaitUntilBuilder<V>(this, conditionFunc, totalTimeout).done();
        }

        public <V> WaitUntilBuilder<V> prepareWaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout) {
            return new WaitUntilBuilder<V>(this, conditionFunc, totalTimeout);
        }

        public ActionSequenceBuilder justWait(int totalTimeout) {
            return new JustWaitBuilder(this, totalTimeout).done();
        }

        public JustWaitBuilder prepareJustWait(int totalTimeout) {
            return new JustWaitBuilder(this, totalTimeout);
        }

        public ActionSequenceBuilder postForm(String url, List<AbstractMap.SimpleImmutableEntry<String, String>> formData) {
            return new PostFormBuilder(this, url, formData).done();
        }

        public PostFormBuilder preparePostForm(String url, List<AbstractMap.SimpleImmutableEntry<String, String>> formData) {
            return new PostFormBuilder(this, url, formData);
        }

        public ActionSequenceBuilder getUrl(String url) {
            return new GetUrlBuilder(this, url).done();
        }

        public GetUrlBuilder prepareGetUrl(String url) {
            return new GetUrlBuilder(this, url);
        }

        public ActionSequenceBuilder selectByIndex(By by, Integer ... options) {
            return new SelectBuilder(this, by).selectByIndex(options).done();
        }

        public ActionSequenceBuilder selectByText(By by, String ... options) {
            return new SelectBuilder(this, by).selectByText(options).done();
        }

        public ActionSequenceBuilder selectByValue(By by, String ... options) {
            return new SelectBuilder(this, by).selectByValue(options).done();
        }

        public SelectBuilder prepareSelect(By by) {
            return new SelectBuilder(this, by);
        }

        public ActionSequenceBuilder sendKey(By by, CharSequence ... keysToSend) {
            return new SendKeyBuilder(this, by, keysToSend).done();
        }

        public SendKeyBuilder prepareSendKey(By by, CharSequence ... keysToSend) {
            return new SendKeyBuilder(this, by, keysToSend);
        }

        public ExtractBuilder prepareExtract(By by) {
            return new ExtractBuilder(this, by);
        }

        public ActionSequenceBuilder click(By by) {
            return new ClickBuilder(this, by).done();
        }

        public ClickBuilder prepareClick(By by) {
            return new ClickBuilder(this, by);
        }

        public ActionSequenceBuilder mouseOver(By by) {
            return new MouseOverBuilder(this, by).done();
        }

        public MouseOverBuilder prepareMouseOver(By by) {
            return new MouseOverBuilder(this, by);
        }

        public ActionSequenceBuilder custom(Consumer<ActionComposer> customAction) {
            return new CustomBuilder(this, customAction).done();
        }

        public ActionSequenceBuilder customMultiPhase(Function<MultiPhased, Consumer<ActionComposer>> multiPhasedCustomAction) {
            return new CustomBuilder(this, multiPhasedCustomAction).done();
        }

        public CustomBuilder prepareCustom(Consumer<ActionComposer> customAction) {
            return new CustomBuilder(this, customAction);
        }

        public CustomBuilder prepareCustomMultiPhase(Function<MultiPhased, Consumer<ActionComposer>> multiPhasedCustomAction) {
            return new CustomBuilder(this, multiPhasedCustomAction);
        }

        public ActionSequenceBuilder scrollToView(By by, boolean toTop) {
            return new ScrollToViewBuilder(this, by, toTop).done();
        }

        public ScrollToViewBuilder prepareScrollToView(By by, boolean toTop) {
            return new ScrollToViewBuilder(this, by, toTop);
        }

        public ActionSequenceBuilder upload(By by, String ... pathOfFiles) {
            return new UploadBuilder(this, by, pathOfFiles).done();
        }

        public UploadBuilder prepareUpload(By by, String ... pathOfFiles) {
            return new UploadBuilder(this, by, pathOfFiles);
        }

        public ActionSequenceBuilder replyAlert(ReplyAlert.Decision decision) {
            return new ReplyAlertBuilder(this, decision).done();
        }

        public ReplyAlertBuilder prepareReplyAlert(ReplyAlert.Decision decision) {
            return new ReplyAlertBuilder(this, decision);
        }

        public IfThenElseBuilder prepareIfThenElse(Function<ActionComposer, ?> evalFunction) {
            return new IfThenElseBuilder(this, evalFunction);
        }

        public class IfThenElseBuilder
        extends InnerBuilderBase {
            private final Function<ActionComposer, ?> evalFunction;
            private boolean isPrepareThenAction;
            private final List<Composable> positiveActionList;
            private final List<Composable> negativeActionList;

            public IfThenElseBuilder(ActionSequenceBuilder parentActionSequenceBuilder, Function<ActionComposer, ?> evalFunction) {
                super(parentActionSequenceBuilder);
                this.isPrepareThenAction = true;
                this.positiveActionList = new ArrayList<Composable>();
                this.negativeActionList = new ArrayList<Composable>();
                if (evalFunction == null) {
                    throw new IllegalArgumentException("No evaluation function specified to build");
                }
                this.evalFunction = evalFunction;
            }

            private IfThenElseBuilder add(Composable action) {
                if (action != null) {
                    if (this.isPrepareThenAction) {
                        this.positiveActionList.add(action);
                    } else {
                        this.negativeActionList.add(action);
                    }
                }
                return this;
            }

            public ActionComposerBuilder returnToComposerBuilder() {
                this.parentActionSequenceBuilder.add(new IfThenElse(this.evalFunction, this.positiveActionList, this.negativeActionList));
                return this.parentActionSequenceBuilder.returnToComposerBuilder();
            }

            public ActionSequenceBuilder then() {
                this.isPrepareThenAction = true;
                return new ActionSequenceBuilder(this);
            }

            public ActionSequenceBuilder otherwise() {
                this.isPrepareThenAction = false;
                return new ActionSequenceBuilder(this);
            }

            public ActionSequenceBuilder endIf() {
                this.parentActionSequenceBuilder.add(new IfThenElse(this.evalFunction, this.positiveActionList, this.negativeActionList));
                return this.parentActionSequenceBuilder;
            }
        }

        public class CloseWindowBuilder
        extends InnerBuilderBase {
            private final boolean closeAllRegistered;

            public CloseWindowBuilder(ActionSequenceBuilder parentActionSequenceBuilder, boolean closeAllRegistered) {
                super(parentActionSequenceBuilder);
                this.closeAllRegistered = closeAllRegistered;
            }

            public ActionSequenceBuilder done() {
                CloseWindow action = new CloseWindow(this.closeAllRegistered);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class OpenWindowBuilder
        extends InnerBuilderBase {
            private boolean asComposerFocusWindow;
            private String registerName;

            public OpenWindowBuilder(ActionSequenceBuilder parentActionSequenceBuilder) {
                super(parentActionSequenceBuilder);
                this.asComposerFocusWindow = false;
                this.registerName = UUID.randomUUID().toString();
            }

            public OpenWindowBuilder withComposerFocus() {
                this.asComposerFocusWindow = true;
                return this;
            }

            public OpenWindowBuilder registerAs(String registerName) {
                this.registerName = registerName;
                return this;
            }

            public ActionSequenceBuilder done() {
                OpenWindow action = new OpenWindow(this.asComposerFocusWindow, this.registerName);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class WaitUntilBuilder<V>
        extends InnerBuilderBase {
            private final int totalTimeout;
            private final Function<WebDriver, V> conditionFunc;
            private int phaseTimeout;
            private int pollInterval;
            private Set<Class<? extends Throwable>> ignoreExceptions;
            private Consumer<ActionComposer> timeoutCallback;

            public WaitUntilBuilder(ActionSequenceBuilder parentActionSequenceBuilder, Function<WebDriver, V> conditionFunc, int totalTimeout) {
                super(parentActionSequenceBuilder);
                this.phaseTimeout = 10;
                this.pollInterval = 5;
                if (conditionFunc == null) {
                    throw new IllegalArgumentException("No evaluate function to build");
                }
                if (totalTimeout <= 0) {
                    throw new IllegalArgumentException("Illegal timeout to build");
                }
                this.conditionFunc = conditionFunc;
                this.totalTimeout = totalTimeout;
            }

            public WaitUntilBuilder<V> withPhaseTimeout(int phaseTimeout) {
                if (phaseTimeout <= 0) {
                    throw new IllegalArgumentException("Illegal phase timeout to build");
                }
                this.phaseTimeout = phaseTimeout;
                return this;
            }

            public WaitUntilBuilder<V> withPollInterval(int pollInterval) {
                if (pollInterval <= 0) {
                    throw new IllegalArgumentException("Illegal poll interval to build");
                }
                this.pollInterval = pollInterval;
                return this;
            }

            public WaitUntilBuilder<V> withIgnoredException(Set<Class<? extends Throwable>> ignoreExceptions) {
                if (ignoreExceptions == null) {
                    throw new IllegalArgumentException("Illegal ignore exception list to build");
                }
                this.ignoreExceptions = ignoreExceptions;
                return this;
            }

            public WaitUntilBuilder<V> withTimeoutCallback(Consumer<ActionComposer> timeoutCallback) {
                if (timeoutCallback == null) {
                    throw new IllegalArgumentException("Illegal timeout callback to build");
                }
                this.timeoutCallback = timeoutCallback;
                return this;
            }

            public ActionSequenceBuilder done() {
                WaitUntil<V> action = new WaitUntil<V>(this.conditionFunc, this.totalTimeout, this.phaseTimeout, this.pollInterval, this.ignoreExceptions, this.timeoutCallback);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class JustWaitBuilder
        extends InnerBuilderBase {
            private final int totalTimeout;
            private int phaseTimeout;

            public JustWaitBuilder(ActionSequenceBuilder parentActionSequenceBuilder, int totalTimeout) {
                super(parentActionSequenceBuilder);
                this.phaseTimeout = 10;
                if (totalTimeout <= 0) {
                    throw new IllegalArgumentException("Illegal timeout to build");
                }
                this.totalTimeout = totalTimeout;
            }

            public JustWaitBuilder withPhaseTimeout(int phaseTimeout) {
                if (phaseTimeout <= 0) {
                    throw new IllegalArgumentException("Illegal phase timeout to build");
                }
                this.phaseTimeout = phaseTimeout;
                return this;
            }

            public ActionSequenceBuilder done() {
                JustWait action = new JustWait(this.totalTimeout, this.phaseTimeout);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class PostFormBuilder
        extends InnerBuilderBase {
            private final String url;
            private final List<AbstractMap.SimpleImmutableEntry<String, String>> formData;
            private String acceptCharset;

            public PostFormBuilder(ActionSequenceBuilder parentActionSequenceBuilder, String url, List<AbstractMap.SimpleImmutableEntry<String, String>> formData) {
                super(parentActionSequenceBuilder);
                if (url == null || url.isEmpty()) {
                    throw new IllegalArgumentException("No url specified to build");
                }
                this.url = url;
                this.formData = formData;
            }

            public PostFormBuilder withAcceptCharset(String acceptCharset) {
                if (acceptCharset == null || acceptCharset.isEmpty()) {
                    throw new IllegalArgumentException("Illegal accept charset to build");
                }
                this.acceptCharset = acceptCharset;
                return this;
            }

            public ActionSequenceBuilder done() {
                PostForm action = new PostForm(this.url, this.formData, this.acceptCharset);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class GetUrlBuilder
        extends InnerBuilderBase {
            private final String url;

            public GetUrlBuilder(ActionSequenceBuilder parentActionSequenceBuilder, String url) {
                super(parentActionSequenceBuilder);
                if (url == null || url.isEmpty()) {
                    throw new IllegalArgumentException("No url specified to build");
                }
                this.url = url;
            }

            public ActionSequenceBuilder done() {
                GetUrl action = new GetUrl(this.url);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class SelectBuilder
        extends InnerBuilderBase {
            private final By by;
            private List<By> frameBySequence;
            private Select.SelectBy selectBy;
            private Object[] options;

            public SelectBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
            }

            public SelectBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            private SelectBuilder selectBy(Select.SelectBy selectBy, Object ... options) {
                if (options == null || options.length == 0) {
                    throw new IllegalArgumentException("No options to build");
                }
                this.selectBy = selectBy;
                this.options = options;
                return this;
            }

            public SelectBuilder selectByIndex(Integer ... options) {
                return this.selectBy(Select.SelectBy.Index, options);
            }

            public SelectBuilder selectByText(String ... options) {
                return this.selectBy(Select.SelectBy.Text, options);
            }

            public SelectBuilder selectByValue(String ... options) {
                return this.selectBy(Select.SelectBy.Value, options);
            }

            public ActionSequenceBuilder done() {
                Select action = new Select(this.by, this.frameBySequence, this.selectBy, this.options);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class SendKeyBuilder
        extends InnerBuilderBase {
            private final By by;
            private final CharSequence[] keysToSend;
            private List<By> frameBySequence;
            private boolean clearBeforeSend;

            public SendKeyBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by, CharSequence ... keysToSend) {
                super(parentActionSequenceBuilder);
                this.clearBeforeSend = false;
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                if (keysToSend == null) {
                    throw new IllegalArgumentException("No keys specified to build");
                }
                this.by = by;
                this.keysToSend = keysToSend;
            }

            public SendKeyBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public SendKeyBuilder withClearBeforeSend() {
                this.clearBeforeSend = true;
                return this;
            }

            public ActionSequenceBuilder done() {
                SendKey action = new SendKey(this.by, this.frameBySequence, this.clearBeforeSend, this.keysToSend);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class ExtractBuilder
        extends InnerBuilderBase {
            private final By by;
            private List<By> frameBySequence;
            private String textVariableName;
            private Map<String, String> attrVariableNames;

            public ExtractBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
            }

            public ExtractBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ExtractBuilder withTextAsVariable(String textVariableName) {
                if (textVariableName == null) {
                    throw new IllegalArgumentException("Illegal text variable name to build");
                }
                this.textVariableName = textVariableName;
                return this;
            }

            public ExtractBuilder withAttributeAsVariable(Map<String, String> attrVariableNames) {
                if (attrVariableNames == null) {
                    throw new IllegalArgumentException("Illegal attribute variable names to build");
                }
                this.attrVariableNames = attrVariableNames;
                return this;
            }

            public ActionSequenceBuilder done() {
                Extract action = new Extract(this.by, this.frameBySequence, this.textVariableName, this.attrVariableNames);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class ClickBuilder
        extends InnerBuilderBase {
            private final By by;
            private List<By> frameBySequence;

            public ClickBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
            }

            public ClickBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ActionSequenceBuilder done() {
                Click action = new Click(this.by, this.frameBySequence);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class MouseOverBuilder
        extends InnerBuilderBase {
            private final By by;
            private List<By> frameBySequence;

            public MouseOverBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
            }

            public MouseOverBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ActionSequenceBuilder done() {
                MouseOver action = new MouseOver(this.by, this.frameBySequence);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class CustomBuilder
        extends InnerBuilderBase {
            private Consumer<ActionComposer> customAction;
            private Function<MultiPhased, Consumer<ActionComposer>> multiPhasedCustomAction;
            private List<By> frameBySequence;

            public CustomBuilder(ActionSequenceBuilder parentActionSequenceBuilder, Consumer<ActionComposer> customAction) {
                super(parentActionSequenceBuilder);
                if (customAction == null) {
                    throw new IllegalArgumentException("No composer consumer specified to build");
                }
                this.customAction = customAction;
            }

            public CustomBuilder(ActionSequenceBuilder parentActionSequenceBuilder, Function<MultiPhased, Consumer<ActionComposer>> multiPhasedCustomAction) {
                super(parentActionSequenceBuilder);
                if (multiPhasedCustomAction == null) {
                    throw new IllegalArgumentException("No multiple-phase custom action specified to build");
                }
                this.multiPhasedCustomAction = multiPhasedCustomAction;
            }

            public CustomBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ActionSequenceBuilder done() {
                Custom action = this.customAction != null ? new Custom(this.customAction, this.frameBySequence) : new Custom(this.multiPhasedCustomAction, this.frameBySequence);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class ScrollToViewBuilder
        extends InnerBuilderBase {
            private final By by;
            private final boolean toTop;
            private List<By> frameBySequence;

            public ScrollToViewBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by, boolean toTop) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
                this.toTop = toTop;
            }

            public ScrollToViewBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ActionSequenceBuilder done() {
                ScrollToView action = new ScrollToView(this.by, this.frameBySequence, this.toTop);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class UploadBuilder
        extends InnerBuilderBase {
            private final By by;
            private final String[] pathOfFiles;
            private List<By> frameBySequence;

            public UploadBuilder(ActionSequenceBuilder parentActionSequenceBuilder, By by, String ... pathOfFiles) {
                super(parentActionSequenceBuilder);
                if (by == null) {
                    throw new IllegalArgumentException("No locator specified to build");
                }
                this.by = by;
                this.pathOfFiles = pathOfFiles;
            }

            public UploadBuilder withInFrame(List<By> frameBySequence) {
                if (frameBySequence == null) {
                    throw new IllegalArgumentException("Illegal frame locator to build");
                }
                this.frameBySequence = frameBySequence;
                return this;
            }

            public ActionSequenceBuilder done() {
                Upload action = new Upload(this.by, this.frameBySequence, this.pathOfFiles);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        public class ReplyAlertBuilder
        extends InnerBuilderBase {
            private final ReplyAlert.Decision decision;
            private String textVariableName;
            private String keysToSend;

            public ReplyAlertBuilder(ActionSequenceBuilder parentActionSequenceBuilder, ReplyAlert.Decision decision) {
                super(parentActionSequenceBuilder);
                if (decision == null) {
                    throw new IllegalArgumentException("No decision specified to build");
                }
                this.decision = decision;
            }

            public ReplyAlertBuilder withTextAsVariable(String textVariableName) {
                if (textVariableName == null) {
                    throw new IllegalArgumentException("Illegal text variable name to build");
                }
                this.textVariableName = textVariableName;
                return this;
            }

            public ReplyAlertBuilder withKeysToSend(String keysToSend) {
                if (keysToSend == null) {
                    throw new IllegalArgumentException("Illegal keys-to-send to build");
                }
                this.keysToSend = keysToSend;
                return this;
            }

            public ActionSequenceBuilder done() {
                ReplyAlert action = new ReplyAlert(this.decision, this.textVariableName, this.keysToSend);
                return this.parentActionSequenceBuilder.add(action);
            }
        }

        private class InnerBuilderBase {
            final ActionSequenceBuilder parentActionSequenceBuilder;

            private InnerBuilderBase(ActionSequenceBuilder parentActionSequenceBuilder) {
                if (parentActionSequenceBuilder == null) {
                    throw new IllegalArgumentException("No parent builder");
                }
                this.parentActionSequenceBuilder = parentActionSequenceBuilder;
            }
        }
    }
}

