/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.kquiet.browser.AbstractActionComposer;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.ActionRunner;
import org.kquiet.browser.action.CloseWindow;
import org.kquiet.browser.action.Composable;
import org.kquiet.browser.action.OpenWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicActionComposer
extends AbstractActionComposer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicActionComposer.class);
    private final Composable initAction = new OpenWindow(true, "");
    private final Composable finalAction = new CloseWindow(true);
    private volatile boolean runOnce = false;
    private volatile boolean isFail = false;
    private volatile boolean skipAction = false;
    private volatile boolean keepFailInfo = true;
    private volatile boolean openWindowFlag = true;
    private volatile boolean closeWindowFlag = true;
    private String failUrl = null;
    private String failPage = null;
    private BasicActionComposer parent = null;
    private BasicActionComposer child = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.runOnce) {
            BasicActionComposer basicActionComposer = this;
            synchronized (basicActionComposer) {
                if (this.runOnce) {
                    return;
                }
                this.executionContextStack.push(this);
                this.runOnce = true;
            }
        }
        boolean successful = true;
        try {
            this.totalCostWatch.start();
            boolean anyActionFail = false;
            if (this.needOpenWindow()) {
                try {
                    this.perform(this.initAction);
                    anyActionFail = anyActionFail || this.initAction.isFail();
                }
                catch (Exception ex) {
                    LOGGER.warn("{}({}) init action error:{}", new Object[]{this.getClass().getSimpleName(), this.getName(), this.initAction.toString(), ex});
                    anyActionFail = true;
                }
            }
            if (!this.isFail() && !anyActionFail) {
                ArrayList<Composable> actionList = new ArrayList<Composable>(super.getAllActionInSequence());
                for (int index = 0; index < actionList.size() && !this.isFail() && !this.skipped(); ++index) {
                    Composable action = (Composable)actionList.get(index);
                    try {
                        this.perform(action);
                        anyActionFail = anyActionFail || action.isFail();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("{}({}) action error:{}", new Object[]{this.getClass().getSimpleName(), this.getName(), action.toString(), ex});
                        anyActionFail = true;
                    }
                    if (anyActionFail || this.skipped()) break;
                    actionList = new ArrayList<Composable>(super.getAllActionInSequence());
                }
            }
            if (this.isFail() || anyActionFail) {
                successful = false;
            }
        }
        catch (Exception ex) {
            successful = false;
            LOGGER.warn("{}({}) run error", new Object[]{this.getClass().getSimpleName(), this.getName(), ex});
        }
        try {
            if (successful) {
                this.runSuccess();
            } else {
                this.runFail();
            }
            this.runDone();
            this.complete(null);
        }
        catch (Exception ex) {
            this.completeExceptionally(ex);
            LOGGER.warn("{}({}) run error", new Object[]{this.getClass().getSimpleName(), this.getName(), ex});
        }
    }

    private void runFail() {
        this.skipToFail();
        if (this.keepFailInfo) {
            try {
                this.setFailInfo(this.getWebDriver().getCurrentUrl(), this.getWebDriver().getPageSource());
            }
            catch (Exception e) {
                LOGGER.warn("{}({}) set fail info error!", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
            }
        }
        try {
            this.getFailFunction().accept(this);
        }
        catch (Exception e) {
            LOGGER.warn("{}({}) fail function error", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
        }
    }

    private void runSuccess() {
        try {
            this.getSuccessFunction().accept(this);
        }
        catch (Exception e) {
            LOGGER.warn("{}({}) success function error", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
        }
    }

    private void runDone() {
        try {
            this.getDoneFunction().accept(this);
        }
        catch (Exception e) {
            LOGGER.warn("{}({}) done function error", new Object[]{this.getClass().getSimpleName(), this.getName(), e});
        }
        if (this.needCloseWindow()) {
            try {
                this.perform(this.finalAction);
            }
            catch (Exception ex) {
                LOGGER.warn("{}({}) final action error:{}", new Object[]{this.getClass().getSimpleName(), this.getName(), this.finalAction.toString(), ex});
            }
        }
        this.totalCostWatch.stop();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}({}) costs {} milliseconds", new Object[]{this.getClass().getSimpleName(), this.getName(), this.getCostTime().toMillis()});
        }
        if (this.hasChild()) {
            try {
                BasicActionComposer tempChild = this.getChild();
                if (!this.needCloseWindow() && !tempChild.needOpenWindow()) {
                    tempChild.setFocusWindow(this.getFocusWindow());
                    tempChild.registerWindow("", tempChild.getFocusWindow());
                }
                this.getActionRunner().executeComposer(tempChild);
            }
            catch (Exception ex) {
                LOGGER.warn("{}({}) execute child composer error", new Object[]{this.getClass().getSimpleName(), this.getName(), ex});
            }
        }
    }

    @Override
    public BasicActionComposer setActionRunner(ActionRunner actionRunner) {
        super.setActionRunner(actionRunner);
        return this;
    }

    @Override
    public BasicActionComposer setVariable(String variableName, Object value) {
        super.setVariable(variableName, value);
        return this;
    }

    public BasicActionComposer continueWith(BasicActionComposer childActionComposer) {
        if (childActionComposer == null) {
            return this;
        }
        BasicActionComposer oldChild = this.getChild();
        this.setChild(childActionComposer);
        childActionComposer.setParent(this);
        if (oldChild != null) {
            BasicActionComposer temp = this.getChild();
            while (temp.hasChild()) {
                temp = temp.getChild();
            }
            temp.setChild(oldChild);
        }
        return childActionComposer;
    }

    public boolean hasChild() {
        return this.child != null;
    }

    public BasicActionComposer getChild() {
        return this.child;
    }

    private void setChild(BasicActionComposer child) {
        this.child = child;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public BasicActionComposer getParent() {
        return this.parent;
    }

    private void setParent(BasicActionComposer parent) {
        this.parent = parent;
    }

    @Override
    public BasicActionComposer onFail(Consumer<ActionComposer> onFailFunc) {
        super.onFail(onFailFunc);
        return this;
    }

    @Override
    public BasicActionComposer onSuccess(Consumer<ActionComposer> onSuccessFunc) {
        super.onSuccess(onSuccessFunc);
        return this;
    }

    @Override
    public BasicActionComposer onDone(Consumer<ActionComposer> onDoneFunc) {
        super.onDone(onDoneFunc);
        return this;
    }

    @Override
    public BasicActionComposer setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public BasicActionComposer setPriority(int priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public boolean skipped() {
        return this.skipAction;
    }

    @Override
    public boolean isFail() {
        return this.isFail;
    }

    @Override
    public boolean isSuccessfulDone() {
        return this.isDone() && !this.isFail;
    }

    @Override
    public String getFailUrl() {
        return this.failUrl;
    }

    @Override
    public String getFailPage() {
        return this.failPage;
    }

    private void setFailInfo(String failUrl, String failPage) {
        this.failUrl = failUrl;
        this.failPage = failPage;
    }

    @Override
    public BasicActionComposer keepFailInfo(boolean flag) {
        this.keepFailInfo = flag;
        return this;
    }

    @Override
    public BasicActionComposer setFocusWindow(String windowIdentity) {
        super.setFocusWindow(windowIdentity);
        return this;
    }

    @Override
    public BasicActionComposer addToHead(Composable action) {
        super.addToHead(action);
        return this;
    }

    @Override
    public BasicActionComposer addToTail(Composable action) {
        super.addToTail(action);
        return this;
    }

    @Override
    public BasicActionComposer addToPosition(Composable action, int position) {
        super.addToPosition(action, position);
        return this;
    }

    @Override
    protected List<Composable> getAllActionInSequence() {
        ArrayList<Composable> actionList = new ArrayList<Composable>();
        if (this.initAction != null) {
            actionList.add(this.initAction);
        }
        actionList.addAll(super.getAllActionInSequence());
        if (this.finalAction != null) {
            actionList.add(this.finalAction);
        }
        return actionList;
    }

    @Override
    public void skipToFail() {
        this.isFail = true;
        this.skipAction = true;
    }

    @Override
    public void skipToSuccess() {
        this.isFail = false;
        this.skipAction = true;
    }

    private boolean needOpenWindow() {
        return this.openWindowFlag;
    }

    public BasicActionComposer setOpenWindow(boolean openWindowFlag) {
        this.openWindowFlag = openWindowFlag;
        return this;
    }

    private boolean needCloseWindow() {
        return this.closeWindowFlag;
    }

    public BasicActionComposer setCloseWindow(boolean closeWindowFlag) {
        this.closeWindowFlag = closeWindowFlag;
        return this;
    }
}

