/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.ActionRunner;
import org.kquiet.browser.BrowserType;
import org.kquiet.concurrent.PausablePriorityThreadPoolExecutor;
import org.kquiet.concurrent.PriorityRunnable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicActionRunner
implements ActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicActionRunner.class);
    private String name = "";
    private final WebDriver brsDriver;
    private final String rootWindowIdentity;
    private volatile boolean isPaused = false;
    private final PausablePriorityThreadPoolExecutor browserActionExecutor = new PausablePriorityThreadPoolExecutor("BrowserActionExecutorPool", 1, 1);
    private final PausablePriorityThreadPoolExecutor composerExecutor;

    public BasicActionRunner() {
        this(1);
    }

    public BasicActionRunner(int maxConcurrentComposer) {
        this(PageLoadStrategy.NONE, BrowserType.CHROME, maxConcurrentComposer);
    }

    public BasicActionRunner(PageLoadStrategy pageLoadStrategy, BrowserType browserType) {
        this(pageLoadStrategy, browserType, 1);
    }

    public BasicActionRunner(PageLoadStrategy pageLoadStrategy, BrowserType browserType, int maxConcurrentComposer) {
        this.composerExecutor = new PausablePriorityThreadPoolExecutor("ActionComposerExecutorPool", maxConcurrentComposer, maxConcurrentComposer);
        this.brsDriver = BasicActionRunner.createBrowserDriver(browserType, pageLoadStrategy);
        this.brsDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(1L));
        this.rootWindowIdentity = this.brsDriver.getWindowHandle();
    }

    private static WebDriver createBrowserDriver(BrowserType browserType, PageLoadStrategy pageLoadStrategy) {
        String defaultProfileDir;
        ImmutableCapabilities extraCapabilities = new ImmutableCapabilities("pageLoadStrategy", (Object)pageLoadStrategy.toString().toLowerCase());
        switch (browserType) {
            case CHROME: {
                String defaultUserDataDir;
                ChromeOptions chromeOption = new ChromeOptions();
                List<String> chromeOptionArguments = List.of(Optional.ofNullable(System.getProperty("chrome_option_args")).orElse(";").split(";"));
                if (chromeOptionArguments.size() > 0) {
                    chromeOption.addArguments(chromeOptionArguments);
                }
                if ("yes".equalsIgnoreCase(System.getProperty("webdriver_headless"))) {
                    chromeOption.addArguments(new String[]{"--headless=new"});
                    LOGGER.info("headless chrome used");
                }
                if ("yes".equalsIgnoreCase(System.getProperty("webdriver_use_default_user_data_dir")) && (defaultUserDataDir = BasicActionRunner.getDefaultUserDataDir(browserType)) != null) {
                    chromeOption.addArguments(new String[]{"user-data-dir=" + defaultUserDataDir});
                    LOGGER.info("default user data dir used:{}", (Object)defaultUserDataDir);
                }
                return new ChromeDriver(chromeOption.merge((Capabilities)extraCapabilities));
            }
        }
        FirefoxOptions firefoxOption = new FirefoxOptions();
        List<String> firefoxOptionArguments = List.of(Optional.ofNullable(System.getProperty("firefox_option_args")).orElse(";").split(";"));
        if (firefoxOptionArguments.size() > 0) {
            firefoxOption.addArguments(firefoxOptionArguments);
        }
        if ("yes".equalsIgnoreCase(System.getProperty("webdriver_headless"))) {
            firefoxOption.addArguments(new String[]{"-headless"});
            LOGGER.info("headless firefox used");
        }
        if ("yes".equalsIgnoreCase(System.getProperty("webdriver_use_default_user_data_dir")) && (defaultProfileDir = BasicActionRunner.getDefaultUserDataDir(browserType)) != null) {
            firefoxOption.setProfile(new FirefoxProfile(new File(defaultProfileDir)));
            LOGGER.info("default user profile dir used:{}", (Object)defaultProfileDir);
        }
        return new FirefoxDriver(firefoxOption.merge((Capabilities)extraCapabilities));
    }

    private static String getDefaultUserDataDir(BrowserType browserType) {
        Object path;
        boolean isWindows = Optional.ofNullable(System.getProperty("os.name")).orElse("").toLowerCase(Locale.ENGLISH).startsWith("windows");
        switch (browserType) {
            case CHROME: {
                if (isWindows) {
                    path = System.getenv("LOCALAPPDATA") + "\\Google\\Chrome\\User Data";
                    if (!new File((String)path).isDirectory()) {
                        path = System.getenv("LOCALAPPDATA") + "\\Chromium\\User Data";
                    }
                } else {
                    path = "~/.config/google-chrome";
                    if (!new File((String)path).isDirectory()) {
                        path = "~/.config/chromium";
                    }
                }
                if (new File((String)path).isDirectory()) break;
                path = null;
                break;
            }
            case FIREFOX: {
                path = isWindows ? System.getenv("APPDATA") + "\\Mozilla\\Firefox\\Profiles" : "~/.mozilla/firefox";
                File pathFile = new File((String)path);
                if (!pathFile.isDirectory()) {
                    path = null;
                    break;
                }
                String[] dirs = pathFile.list((current, name) -> new File(current, name).isDirectory() && name.toLowerCase().endsWith(".default"));
                if (dirs != null && dirs.length > 0) {
                    path = new File(pathFile, dirs[0]).getAbsolutePath();
                    break;
                }
                path = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported browser type:" + browserType.toString());
            }
        }
        return path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BasicActionRunner setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getRootWindowIdentity() {
        return this.rootWindowIdentity;
    }

    @Override
    public CompletableFuture<Void> executeAction(Runnable browserAction, int priority) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        PriorityRunnable runnable = new PriorityRunnable(() -> {
            try {
                browserAction.run();
                future.complete(null);
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        }, priority);
        this.browserActionExecutor.submit(runnable);
        return future;
    }

    @Override
    public CompletableFuture<Void> executeComposer(ActionComposer actionComposer) {
        actionComposer.setActionRunner(this);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        PriorityRunnable runnable = new PriorityRunnable(() -> {
            try {
                actionComposer.run();
                future.complete(null);
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        }, actionComposer.getPriority());
        this.composerExecutor.submit(runnable);
        return future;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.brsDriver;
    }

    @Override
    public boolean isBrowserAlive() {
        if (this.brsDriver == null) {
            return false;
        }
        try {
            Set windowSet = this.brsDriver.getWindowHandles();
            return windowSet != null && !windowSet.isEmpty() && windowSet.contains(this.getRootWindowIdentity());
        }
        catch (Exception ex) {
            LOGGER.warn("[{}] check browser alive error!", (Object)this.name, (Object)ex);
            return false;
        }
    }

    @Override
    public void pause() {
        if (this.isPaused) {
            return;
        }
        this.isPaused = true;
        this.browserActionExecutor.pause();
        this.composerExecutor.pause();
    }

    @Override
    public void resume() {
        if (!this.isPaused) {
            return;
        }
        this.isPaused = false;
        this.browserActionExecutor.resume();
        this.composerExecutor.resume();
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public void close() {
        try {
            if (this.browserActionExecutor != null) {
                this.browserActionExecutor.shutdownNow();
                LOGGER.info("[{}] Close BrowserActionExecutor done!", (Object)this.name);
            }
            if (this.composerExecutor != null) {
                this.composerExecutor.shutdown();
                LOGGER.info("[{}] Close ActionComposerExecutor done!", (Object)this.name);
            }
            if (this.brsDriver != null) {
                this.brsDriver.quit();
                LOGGER.info("[{}] Close BrsDriver done!", (Object)this.name);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[{}] Close {} fail!", new Object[]{this.name, this.getClass().getSimpleName(), ex});
        }
    }
}

