/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.SinglePhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseWindow
extends SinglePhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseWindow.class);
    private final boolean closeAllRegistered;

    public CloseWindow(boolean closeAllRegistered) {
        this.closeAllRegistered = closeAllRegistered;
    }

    @Override
    protected void performSinglePhase() {
        ActionComposer actionComposer = this.getComposer();
        String rootWindow = actionComposer.getRootWindow();
        if (this.closeAllRegistered) {
            List windowList = actionComposer.getRegisteredWindows().values().stream().distinct().collect(Collectors.toList());
            ArrayList<String> failList = new ArrayList<String>();
            for (String window : windowList) {
                if (!window.equals(rootWindow)) {
                    if (actionComposer.switchToWindow(window)) {
                        actionComposer.getWebDriver().close();
                        continue;
                    }
                    failList.add(window);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("{}({}): root window({}) can't be closed:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), window});
            }
            if (!failList.isEmpty()) {
                throw new ActionException(String.format("close registered windows(%s) fail; it may have been closed or equal to the root window", String.join((CharSequence)",", failList)));
            }
        } else {
            String focusWindow = actionComposer.getFocusWindow();
            if (!focusWindow.equals(rootWindow) && actionComposer.switchToWindow(focusWindow)) {
                actionComposer.getWebDriver().close();
            } else {
                throw new ActionException(String.format("close focus window(%s) fail; it may have been closed or is the root window", focusWindow));
            }
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s", CloseWindow.class.getSimpleName(), String.valueOf(this.closeAllRegistered));
    }
}

