/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.MultiPhased;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;

public class Custom
extends MultiPhaseAction {
    private final Consumer<ActionComposer> customFunc;
    private final boolean actAsSinglePhase;
    private final List<By> frameBySequence = new ArrayList<By>();

    public Custom(Function<MultiPhased, Consumer<ActionComposer>> customAction) {
        this(customAction, null);
    }

    public Custom(Function<MultiPhased, Consumer<ActionComposer>> customAction, List<By> frameBySequence) {
        this.customFunc = customAction.apply(this);
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        this.actAsSinglePhase = false;
    }

    public Custom(Consumer<ActionComposer> customAction) {
        this(customAction, null);
    }

    public Custom(Consumer<ActionComposer> customAction, List<By> frameBySequence) {
        this.customFunc = customAction;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        this.actAsSinglePhase = true;
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            this.customFunc.accept(actionComposer);
            if (this.actAsSinglePhase) {
                this.noNextPhase();
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s(%s):%s", Custom.class.getSimpleName(), String.valueOf(this.actAsSinglePhase), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())));
    }
}

