/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Extract
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Extract.class);
    private final By by;
    private final List<By> frameBySequence = new ArrayList<By>();
    private final String textVariableName;
    private final Map<String, String> attrVariableNames = new LinkedHashMap<String, String>();

    public Extract(By by, String textVariableName) {
        this(by, null, textVariableName, null);
    }

    public Extract(By by, List<By> frameBySequence, String textVariableName) {
        this(by, frameBySequence, textVariableName, null);
    }

    public Extract(By by, Map<String, String> attrVariableNames) {
        this(by, null, null, attrVariableNames);
    }

    public Extract(By by, List<By> frameBySequence, Map<String, String> attrVariableNames) {
        this(by, frameBySequence, null, attrVariableNames);
    }

    public Extract(By by, String textVariableName, Map<String, String> attrVariableNames) {
        this(by, null, textVariableName, attrVariableNames);
    }

    public Extract(By by, List<By> frameBySequence, String textVariableName, Map<String, String> attrVariableNames) {
        this.by = by;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        this.textVariableName = Optional.ofNullable(textVariableName).orElse("");
        if (attrVariableNames != null) {
            this.attrVariableNames.putAll(attrVariableNames);
        }
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            WebElement element = actionComposer.getWebDriver().findElement(this.by);
            if (!this.textVariableName.isEmpty()) {
                actionComposer.setVariable(this.textVariableName, element.getText());
            }
            for (Map.Entry<String, String> entry : this.attrVariableNames.entrySet()) {
                actionComposer.setVariable(entry.getValue(), element.getAttribute(entry.getKey()));
            }
            this.noNextPhase();
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s/%s", Extract.class.getSimpleName(), this.by.toString(), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())), this.textVariableName, String.join((CharSequence)",", this.attrVariableNames.entrySet().stream().map(s -> (String)s.getKey() + ":" + (String)s.getValue()).collect(Collectors.toList())));
    }
}

