/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.DynamicActionSequence;
import org.kquiet.browser.action.Composable;
import org.kquiet.browser.action.Custom;
import org.kquiet.browser.action.NonBrowserable;
import org.kquiet.browser.action.SinglePhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonBrowserable
public class IfThenElse
extends SinglePhaseAction
implements DynamicActionSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfThenElse.class);
    private final Deque<Composable> positiveActionList = new LinkedList<Composable>();
    private final Deque<Composable> negativeActionList = new LinkedList<Composable>();
    private final Function<ActionComposer, ?> evalFunction;
    private volatile Boolean evaluationResult = null;

    public IfThenElse(Function<ActionComposer, ?> evalFunction, List<Composable> positiveActionList, List<Composable> negativeActionList) {
        this.evalFunction = evalFunction;
        if (positiveActionList != null) {
            this.positiveActionList.addAll(positiveActionList);
        }
        if (negativeActionList != null) {
            this.negativeActionList.addAll(negativeActionList);
        }
    }

    private boolean evaluate() throws Exception {
        AtomicBoolean evalResult = new AtomicBoolean(true);
        Custom customAction = new Custom(ps -> ac -> {
            Object obj = null;
            try {
                obj = this.evalFunction.apply((ActionComposer)ac);
                ps.noNextPhase();
            }
            catch (StaleElementReferenceException ignoreE) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), ac.getName(), ps, ignoreE});
                }
            }
            catch (NoSuchElementException skipE) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}({}): no such element:{}", new Object[]{ActionComposer.class.getSimpleName(), ac.getName(), ps, skipE});
                }
                obj = null;
                ps.noNextPhase();
            }
            catch (Exception e) {
                ps.noNextPhase();
                throw new ActionException(e);
            }
            evalResult.set(obj != null && (Boolean.class != obj.getClass() || Boolean.TRUE.equals(obj)));
        }, null);
        this.getComposer().perform(customAction);
        List<Exception> errors = customAction.getErrors();
        if (!errors.isEmpty()) {
            throw errors.get(errors.size() - 1);
        }
        return evalResult.get();
    }

    @Override
    protected void performSinglePhase() {
        try {
            this.evaluationResult = this.evaluate();
            Deque<Composable> actualActionList = this.evaluationResult != false ? this.positiveActionList : this.negativeActionList;
            ArrayList<Composable> temp = new ArrayList<Composable>(actualActionList);
            boolean anyActionFail = false;
            for (int index = 0; index < temp.size() && !this.isFail() && !this.getComposer().skipped(); ++index) {
                Composable action = (Composable)temp.get(index);
                this.getComposer().perform(action);
                boolean bl = anyActionFail = anyActionFail || action.isFail();
                if (!anyActionFail && !this.getComposer().skipped()) {
                    temp = new ArrayList<Composable>(actualActionList);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return IfThenElse.class.getSimpleName();
    }

    @Override
    public boolean isFail() {
        return super.isFail() || this.positiveActionList.stream().anyMatch(s -> s.isFail()) || this.negativeActionList.stream().anyMatch(s -> s.isFail());
    }

    @Override
    public List<Exception> getErrors() {
        ArrayList<Exception> errList = new ArrayList<Exception>(super.getErrors());
        this.positiveActionList.forEach(action -> errList.addAll(action.getErrors()));
        this.negativeActionList.forEach(action -> errList.addAll(action.getErrors()));
        return errList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicActionSequence addToHead(Composable action) {
        if (action != null && this.evaluationResult != null) {
            Deque<Composable> actualActionList;
            Deque<Composable> deque = actualActionList = this.evaluationResult != false ? this.positiveActionList : this.negativeActionList;
            synchronized (deque) {
                actualActionList.addFirst(action);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicActionSequence addToTail(Composable action) {
        if (action != null && this.evaluationResult != null) {
            Deque<Composable> actualActionList;
            Deque<Composable> deque = actualActionList = this.evaluationResult != false ? this.positiveActionList : this.negativeActionList;
            synchronized (deque) {
                actualActionList.addLast(action);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicActionSequence addToPosition(Composable action, int position) {
        if (action != null && this.evaluationResult != null) {
            Deque<Composable> actualActionList;
            Deque<Composable> deque = actualActionList = this.evaluationResult != false ? this.positiveActionList : this.negativeActionList;
            synchronized (deque) {
                ArrayList<Composable> temp = new ArrayList<Composable>(actualActionList);
                temp.add(position, action);
                actualActionList.clear();
                actualActionList.addAll(temp);
            }
        }
        return this;
    }
}

