/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.kquiet.utility.Stopwatch;

public class JustWait
extends MultiPhaseAction {
    private final Stopwatch costWatch = new Stopwatch();
    private final int totalTimeout;
    private final int phaseTimeout;

    public JustWait(int totalTimeout) {
        this(totalTimeout, 10);
    }

    public JustWait(int totalTimeout, int phaseTimeout) {
        this.totalTimeout = totalTimeout;
        this.phaseTimeout = phaseTimeout;
    }

    private boolean isTimeout() {
        return this.costWatch.getElapsedMilliSecond() >= (long)this.totalTimeout;
    }

    @Override
    protected void performMultiPhase() {
        this.costWatch.start();
        if (this.isTimeout()) {
            this.noNextPhase();
            return;
        }
        try {
            Thread.sleep(this.phaseTimeout);
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
        if (this.isTimeout()) {
            this.noNextPhase();
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s", JustWait.class.getSimpleName(), String.valueOf(this.totalTimeout), String.valueOf(this.phaseTimeout));
    }
}

