/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MouseOver
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MouseOver.class);
    private final By by;
    private final List<By> frameBySequence = new ArrayList<By>();

    public MouseOver(By by) {
        this(by, null);
    }

    public MouseOver(By by, List<By> frameBySequence) {
        this.by = by;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            WebElement element = actionComposer.getWebDriver().findElement(this.by);
            new Actions(actionComposer.getWebDriver()).moveToElement(element).perform();
            this.noNextPhase();
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s", MouseOver.class.getSimpleName(), this.by.toString(), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())));
    }
}

