/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.ActionState;
import org.kquiet.browser.action.Composable;
import org.kquiet.browser.action.MultiPhased;
import org.kquiet.browser.action.NonBrowserable;
import org.kquiet.browser.action.exception.ActionException;
import org.kquiet.utility.Stopwatch;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiPhaseAction
implements Composable,
MultiPhased {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPhaseAction.class);
    private ActionComposer containingComposer;
    private volatile ActionState actionState = ActionState.CREATED;
    private final List<Exception> errorList = new ArrayList<Exception>();
    private final Stopwatch stopWatch = new Stopwatch();
    private volatile boolean hasNextPhase = true;

    @Override
    public void noNextPhase() {
        this.hasNextPhase = false;
    }

    @Override
    public boolean hasNextPhase() {
        return this.hasNextPhase;
    }

    @Override
    public void perform() {
        while (this.hasNextPhase()) {
            try {
                this.stopWatch.start();
                this.setActionState(ActionState.RUNNING);
                if (this.getClass().isAnnotationPresent(NonBrowserable.class)) {
                    this.performMultiPhase();
                } else {
                    CompletableFuture<Void> future = this.getComposer().callBrowser(() -> {
                        if (!this.getComposer().switchToFocusWindow()) {
                            throw new ActionException("can't switch to focus window");
                        }
                        this.performMultiPhase();
                    });
                    future.get();
                }
                if (this.hasNextPhase()) {
                    this.setActionState(ActionState.WAIT_FOR_NEXT_PHASE);
                    continue;
                }
                this.setActionState(ActionState.COMPLETE);
            }
            catch (Exception e) {
                this.noNextPhase();
                this.setActionState(ActionState.COMPLETE_WITH_ERROR);
                this.errorList.add(e);
                LOGGER.warn("{}({}) {} error:{}", new Object[]{ActionComposer.class.getSimpleName(), this.getComposer().getName(), this.getClass().getSimpleName(), this.toString(), e});
            }
            finally {
                this.stopWatch.stop();
            }
        }
    }

    protected abstract void performMultiPhase();

    @Override
    public boolean isDone() {
        return Arrays.asList(ActionState.COMPLETE_WITH_ERROR, ActionState.COMPLETE).contains((Object)this.getActionState());
    }

    @Override
    public boolean isFail() {
        return this.getActionState() == ActionState.COMPLETE_WITH_ERROR;
    }

    @Override
    public List<Exception> getErrors() {
        return this.errorList;
    }

    public String toString() {
        return MultiPhaseAction.class.getSimpleName();
    }

    public Duration getCostTime() {
        return this.stopWatch.getDuration();
    }

    @Override
    public ActionComposer getComposer() {
        return this.containingComposer;
    }

    @Override
    public MultiPhaseAction setComposer(ActionComposer containingComposer) {
        this.containingComposer = containingComposer;
        return this;
    }

    public ActionState getActionState() {
        return this.actionState;
    }

    protected void setActionState(ActionState actionState) {
        this.actionState = actionState;
    }

    protected void switchToTopForFirefox() {
        WebDriver driver = this.getComposer().getWebDriver();
        if (driver instanceof FirefoxDriver) {
            try {
                driver.switchTo().alert();
            }
            catch (NoAlertPresentException e) {
                this.getComposer().switchToTop();
            }
        }
    }
}

