/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.LinkedHashSet;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.SinglePhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWindow
extends SinglePhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenWindow.class);
    private final boolean asComposerFocusWindow;
    private final String registerName;

    public OpenWindow(boolean asComposerFocusWindow) {
        this(asComposerFocusWindow, null);
    }

    public OpenWindow(String registerName) {
        this(false, registerName);
    }

    public OpenWindow(boolean asComposerFocusWindow, String registerName) {
        this.asComposerFocusWindow = asComposerFocusWindow;
        this.registerName = registerName;
    }

    @Override
    protected void performSinglePhase() {
        String rootWindow;
        LinkedHashSet<String> beforeWindowSet;
        WebDriver brsDriver;
        ActionComposer actionComposer;
        block7: {
            actionComposer = this.getComposer();
            brsDriver = actionComposer.getWebDriver();
            beforeWindowSet = new LinkedHashSet<String>();
            for (String winHandle : brsDriver.getWindowHandles()) {
                beforeWindowSet.add(winHandle);
            }
            rootWindow = actionComposer.getRootWindow();
            try {
                ((JavascriptExecutor)actionComposer.getWebDriver().switchTo().window(rootWindow)).executeScript("window.open('about:blank','_blank');", new Object[0]);
            }
            catch (Exception ex) {
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug("{}({}): open new window script error!", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), ex});
            }
        }
        String actualHandle = null;
        LinkedHashSet<String> afterWindowSet = new LinkedHashSet<String>();
        for (String winHandle : brsDriver.getWindowHandles()) {
            afterWindowSet.add(winHandle);
        }
        for (String winHandle : afterWindowSet) {
            if (winHandle.equals(rootWindow) || beforeWindowSet.contains(winHandle)) continue;
            actualHandle = winHandle;
            if (this.asComposerFocusWindow) {
                actionComposer.setFocusWindow(actualHandle);
            }
            if (this.registerName == null || actionComposer.registerWindow(this.registerName, actualHandle)) break;
            throw new ActionException(String.format("can't register new window:%s", this.registerName));
        }
        if (actualHandle == null) {
            throw new ActionException("can't find new window!");
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s", OpenWindow.class.getSimpleName(), String.valueOf(this.asComposerFocusWindow), this.registerName);
    }
}

