/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.AbstractMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.SinglePhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.JavascriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostForm
extends SinglePhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostForm.class);
    private final String url;
    private final List<AbstractMap.SimpleImmutableEntry<String, String>> formData;
    private final String acceptCharset;

    public PostForm(String url, List<AbstractMap.SimpleImmutableEntry<String, String>> formData) {
        this(url, formData, null);
    }

    public PostForm(String url, List<AbstractMap.SimpleImmutableEntry<String, String>> formData, String acceptCharset) {
        this.url = url;
        this.formData = formData;
        this.acceptCharset = acceptCharset;
    }

    @Override
    protected void performSinglePhase() {
        String formId = UUID.randomUUID().toString();
        ActionComposer actionComposer = this.getComposer();
        try {
            List<AbstractMap.SimpleImmutableEntry<String, String>> formDataList;
            StringBuilder scriptStr = new StringBuilder(String.format("var formE = document.createElement('form');formE.setAttribute('id','%s');formE.setAttribute('name','%s');formE.setAttribute('method','post');formE.setAttribute('enctype','application/x-www-form-urlencoded');formE.setAttribute('action','%s');", formId.replaceAll("'", "'"), formId.replaceAll("'", "'"), this.url));
            if (this.acceptCharset != null && !this.acceptCharset.isEmpty()) {
                scriptStr.append("formE.setAttribute('accept-charset','" + this.acceptCharset.replaceAll("'", "'") + "');");
            }
            if (this.formData != null && !(formDataList = this.formData).isEmpty()) {
                scriptStr.append("var customE;");
                for (AbstractMap.SimpleImmutableEntry<String, String> input : formDataList) {
                    scriptStr.append(String.format("customE = document.createElement('input');customE.setAttribute('type','hidden');customE.setAttribute('name','%s');customE.setAttribute('value','%s');formE.appendChild(customE);", input.getKey().replaceAll("'", "'"), input.getValue().replaceAll("'", "'")));
                }
            }
            scriptStr.append(String.format("document.body.appendChild(formE);document.getElementById('%s').submit();", formId.replaceAll("'", "'")));
            try {
                ((JavascriptExecutor)actionComposer.getWebDriver()).executeScript(scriptStr.toString(), new Object[0]);
            }
            catch (Exception ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}({}): Execute javascript error:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ex});
                }
            }
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s", PostForm.class.getSimpleName(), this.url, String.join((CharSequence)",", this.formData.stream().map(s -> (String)s.getKey() + "=" + (String)s.getValue()).collect(Collectors.toList())), this.acceptCharset);
    }
}

