/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.Optional;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.Alert;
import org.openqa.selenium.StaleElementReferenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyAlert
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplyAlert.class);
    private final Decision decision;
    private final String textVariableName;
    private final String keysToSend;

    public ReplyAlert(Decision decision, String textVariableName, String keysToSend) {
        this.decision = decision;
        this.textVariableName = Optional.ofNullable(textVariableName).orElse("");
        this.keysToSend = Optional.ofNullable(keysToSend).orElse("");
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            Alert alertBox = actionComposer.getWebDriver().switchTo().alert();
            if (!this.textVariableName.isEmpty()) {
                actionComposer.setVariable(this.textVariableName, alertBox.getText());
            }
            if (!this.keysToSend.isEmpty()) {
                alertBox.sendKeys(this.keysToSend);
            }
            switch (this.decision) {
                case Accept: {
                    alertBox.accept();
                    break;
                }
                case Dismiss: {
                    alertBox.dismiss();
                    break;
                }
            }
            this.noNextPhase();
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s", ReplyAlert.class.getSimpleName(), this.decision.toString(), this.textVariableName, this.keysToSend);
    }

    public static enum Decision {
        Accept,
        Dismiss,
        None;

    }
}

