/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Select.class);
    private final By by;
    private final List<By> frameBySequence = new ArrayList<By>();
    private final SelectBy selectBy;
    private final Object[] options;

    public Select(By by, SelectBy selectBy, Object ... options) {
        this(by, null, selectBy, options);
    }

    public Select(By by, List<By> frameBySequence, SelectBy selectBy, Object ... options) {
        this.by = by;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        this.selectBy = selectBy;
        this.options = options;
    }

    public static void clickToSelect(WebElement element, SelectBy selectBy, Object ... options) {
        element.click();
        org.openqa.selenium.support.ui.Select elementToSelect = new org.openqa.selenium.support.ui.Select(element);
        if ((options == null || options.length == 0) && elementToSelect.isMultiple()) {
            elementToSelect.deselectAll();
        } else if (options != null) {
            switch (selectBy) {
                case Index: {
                    for (Object obj : options) {
                        elementToSelect.selectByIndex(((Integer)obj).intValue());
                    }
                    break;
                }
                case Value: {
                    for (Object obj : options) {
                        elementToSelect.selectByValue((String)obj);
                    }
                    break;
                }
                default: {
                    for (Object obj : options) {
                        elementToSelect.selectByVisibleText((String)obj);
                    }
                }
            }
        }
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            WebElement element = actionComposer.getWebDriver().findElement(this.by);
            Select.clickToSelect(element, this.selectBy, this.options);
            this.noNextPhase();
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(this.toString(), e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s/%s", Select.class.getSimpleName(), this.by.toString(), this.selectBy.toString(), String.join((CharSequence)",", Arrays.asList(this.options).stream().map(s -> s.toString()).collect(Collectors.toList())), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())));
    }

    public static enum SelectBy {
        Index,
        Value,
        Text;

    }
}

