/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendKey
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendKey.class);
    private final By by;
    private final List<By> frameBySequence = new ArrayList<By>();
    private final CharSequence[] keysToSend;
    private final boolean clearBeforeSend;

    public SendKey(By by, boolean clearBeforeSend, CharSequence ... keysToSend) {
        this(by, null, clearBeforeSend, keysToSend);
    }

    public SendKey(By by, List<By> frameBySequence, boolean clearBeforeSend, CharSequence ... keysToSend) {
        this.by = by;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        this.clearBeforeSend = clearBeforeSend;
        this.keysToSend = this.purifyCharSequences(keysToSend);
    }

    private CharSequence[] purifyCharSequences(CharSequence ... sequence) {
        if (sequence == null) {
            sequence = new CharSequence[]{};
        } else {
            for (int i = 0; i < sequence.length; ++i) {
                if (sequence[i] != null) continue;
                sequence[i] = "";
            }
        }
        return sequence;
    }

    public static void clickToSendKeys(WebElement element, boolean clearBeforeSend, CharSequence ... keysToSend) {
        element.click();
        if (clearBeforeSend) {
            element.clear();
            element.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        } else {
            element.sendKeys(new CharSequence[]{Keys.END});
        }
        element.sendKeys(keysToSend);
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            WebElement element = actionComposer.getWebDriver().findElement(this.by);
            SendKey.clickToSendKeys(element, this.clearBeforeSend, this.keysToSend);
            this.noNextPhase();
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(this.toString(), e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s", SendKey.class.getSimpleName(), this.by.toString(), String.join((CharSequence)",", this.keysToSend), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())));
    }
}

