/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends MultiPhaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Upload.class);
    private final By by;
    private final List<By> frameBySequence = new ArrayList<By>();
    private final List<String> pathOfFileList = new ArrayList<String>();

    public Upload(By by, String ... pathOfFiles) {
        this(by, (List<By>)null, pathOfFiles);
    }

    public Upload(By by, List<By> frameBySequence, String ... pathOfFiles) {
        this.by = by;
        if (frameBySequence != null) {
            this.frameBySequence.addAll(frameBySequence);
        }
        if (pathOfFiles != null) {
            this.pathOfFileList.addAll(Arrays.asList(pathOfFiles));
        }
    }

    @Override
    protected void performMultiPhase() {
        ActionComposer actionComposer = this.getComposer();
        try {
            this.switchToTopForFirefox();
            actionComposer.switchToInnerFrame(this.frameBySequence);
            WebElement element = actionComposer.getWebDriver().findElement(this.by);
            ((JavascriptExecutor)actionComposer.getWebDriver()).executeScript("arguments[0].style.display = 'inline-block';arguments[0].style.visibility = 'visible'; arguments[0].style.height = '1px'; arguments[0].style.width = '1px'; arguments[0].style.opacity = 1;", new Object[]{element});
            if (element.isDisplayed() && element.isEnabled()) {
                for (String pathOfFile : this.pathOfFileList) {
                    element.sendKeys(new CharSequence[]{pathOfFile});
                }
                this.noNextPhase();
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): continue to wait upload element to be clickable:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString()});
            }
        }
        catch (StaleElementReferenceException ignoreE) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}({}): encounter stale element:{}", new Object[]{ActionComposer.class.getSimpleName(), actionComposer.getName(), this.toString(), ignoreE});
            }
        }
        catch (Exception e) {
            this.noNextPhase();
            throw new ActionException(this.toString(), e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s", Upload.class.getSimpleName(), this.by.toString(), String.join((CharSequence)",", this.frameBySequence.stream().map(s -> s.toString()).collect(Collectors.toList())), String.join((CharSequence)",", this.pathOfFileList));
    }
}

