/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.browser.action;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.action.MultiPhaseAction;
import org.kquiet.browser.action.exception.ActionException;
import org.kquiet.utility.Stopwatch;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class WaitUntil<V>
extends MultiPhaseAction {
    private static final int DEFAULT_PHASE_TIMEOUT = 10;
    private static final int DEFAULT_POLL_INTERVAL = 5;
    private final Stopwatch costWatch = new Stopwatch();
    private final int totalTimeout;
    private final int phaseTimeout;
    private final int pollInterval;
    private final Function<WebDriver, V> conditionFunc;
    private final Set<Class<? extends Throwable>> ignoreExceptions = new HashSet<Class<? extends Throwable>>();
    private final Consumer<ActionComposer> timeoutCallback;

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout) {
        this(conditionFunc, totalTimeout, 10, 5, null, null);
    }

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout, int phaseTimeout, int pollInterval) {
        this(conditionFunc, totalTimeout, phaseTimeout, pollInterval, null, null);
    }

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout, Consumer<ActionComposer> timeoutCallback) {
        this(conditionFunc, totalTimeout, 10, 5, null, timeoutCallback);
    }

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout, Set<Class<? extends Throwable>> ignoreExceptions) {
        this(conditionFunc, totalTimeout, 10, 5, ignoreExceptions, null);
    }

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout, Set<Class<? extends Throwable>> ignoreExceptions, Consumer<ActionComposer> timeoutCallback) {
        this(conditionFunc, totalTimeout, 10, 5, ignoreExceptions, timeoutCallback);
    }

    public WaitUntil(Function<WebDriver, V> conditionFunc, int totalTimeout, int phaseTimeout, int pollInterval, Set<Class<? extends Throwable>> ignoreExceptions, Consumer<ActionComposer> timeoutCallback) {
        this.totalTimeout = totalTimeout;
        this.phaseTimeout = phaseTimeout;
        this.pollInterval = pollInterval;
        this.conditionFunc = conditionFunc;
        if (ignoreExceptions != null && !ignoreExceptions.isEmpty()) {
            this.ignoreExceptions.addAll(ignoreExceptions);
        } else {
            this.ignoreExceptions.add(StaleElementReferenceException.class);
            this.ignoreExceptions.add(NoSuchElementException.class);
        }
        this.timeoutCallback = timeoutCallback;
    }

    private void timeoutToDo() {
        ActionComposer actionComposer;
        this.noNextPhase();
        if (this.timeoutCallback != null) {
            actionComposer = this.getComposer();
            if (!actionComposer.switchToFocusWindow()) {
                throw new ActionException("can't switch to focus window");
            }
        } else {
            throw new ActionException("Timeout!");
        }
        this.switchToTopForFirefox();
        this.timeoutCallback.accept(actionComposer);
    }

    private boolean isTimeout() {
        return this.costWatch.getElapsedMilliSecond() >= (long)this.totalTimeout;
    }

    @Override
    protected void performMultiPhase() {
        Object result;
        block6: {
            this.costWatch.start();
            if (this.isTimeout()) {
                this.timeoutToDo();
                return;
            }
            ActionComposer actionComposer = this.getComposer();
            FluentWait wait = new FluentWait((Object)actionComposer.getWebDriver()).withTimeout(Duration.ofMillis(this.phaseTimeout)).pollingEvery(Duration.ofMillis(this.pollInterval)).ignoreAll(this.ignoreExceptions);
            result = null;
            try {
                this.switchToTopForFirefox();
                result = wait.until(this.conditionFunc);
            }
            catch (TimeoutException e) {
                if (!this.isTimeout()) break block6;
                this.timeoutToDo();
                return;
            }
        }
        if (result == null || Boolean.class == result.getClass() && Boolean.FALSE.equals(result)) {
            if (this.isTimeout()) {
                this.timeoutToDo();
            }
        } else {
            this.noNextPhase();
        }
    }

    @Override
    public String toString() {
        return String.format("%s:%s/%s/%s", WaitUntil.class.getSimpleName(), String.valueOf(this.totalTimeout), String.valueOf(this.phaseTimeout), String.valueOf(this.pollInterval));
    }
}

