/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class CommonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public CommonThreadFactory(String poolName) {
        this.namePrefix = poolName != null && !poolName.isEmpty() ? poolName + "(" + POOL_NUMBER.getAndIncrement() + ")-" : "pool(" + POOL_NUMBER.getAndIncrement() + ")-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

