/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.kquiet.concurrent.CommonThreadFactory;
import org.kquiet.concurrent.PausableThreadPoolExecutor;
import org.kquiet.concurrent.Prioritized;
import org.kquiet.concurrent.PriorityRunnableFuture;
import org.kquiet.concurrent.PriorityRunnableFutureComparator;

public class PausablePriorityThreadPoolExecutor
extends PausableThreadPoolExecutor {
    public PausablePriorityThreadPoolExecutor() {
        this("", 1, 1);
    }

    public PausablePriorityThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize) {
        this(poolPrefix, corePoolSize, maximumPoolSize, 5);
    }

    public PausablePriorityThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize) {
        this(poolPrefix, corePoolSize, maximumPoolSize, queueSize, null);
    }

    public PausablePriorityThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, Consumer<Runnable> afterExecuteFunc) {
        this(poolPrefix, corePoolSize, maximumPoolSize, 5, afterExecuteFunc);
    }

    public PausablePriorityThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize, Consumer<Runnable> afterExecuteFunc) {
        this(poolPrefix, corePoolSize, maximumPoolSize, queueSize, 10L, TimeUnit.MINUTES, afterExecuteFunc);
    }

    public PausablePriorityThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize, long keepAliveTime, TimeUnit unit, Consumer<Runnable> afterExecuteFunc) {
        super(poolPrefix, corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(queueSize, new PriorityRunnableFutureComparator()), new CommonThreadFactory(poolPrefix), afterExecuteFunc);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        RunnableFuture<T> newTaskFor = super.newTaskFor(callable);
        return new PriorityRunnableFuture<T>(newTaskFor, ((Prioritized)((Object)callable)).getPriority());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        RunnableFuture<T> newTaskFor = super.newTaskFor(runnable, value);
        return new PriorityRunnableFuture<T>(newTaskFor, ((Prioritized)((Object)runnable)).getPriority());
    }
}

