/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.concurrent;

import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Consumer;
import org.kquiet.concurrent.CommonThreadFactory;
import org.kquiet.concurrent.PausableThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PausableThreadPoolExecutor.class);
    private volatile boolean isPaused = false;
    private final Phaser pausePhaser = new Phaser(1);
    private volatile int pausePhaseNumber = this.pausePhaser.getPhase();
    private final String poolPrefix;
    private final Consumer<Runnable> afterExecuteFunc;

    public PausableScheduledThreadPoolExecutor() {
        this("", 1);
    }

    public PausableScheduledThreadPoolExecutor(String poolPrefix, int corePoolSize) {
        this(poolPrefix, corePoolSize, null);
    }

    public PausableScheduledThreadPoolExecutor(String poolPrefix, int corePoolSize, Consumer<Runnable> afterExecuteFunc) {
        super(corePoolSize, new CommonThreadFactory(poolPrefix));
        this.poolPrefix = poolPrefix;
        this.afterExecuteFunc = afterExecuteFunc;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        try {
            while (this.isPaused) {
                LOGGER.info("{}: thread-{} is pending...", (Object)this.poolPrefix, (Object)t.getId());
                this.pausePhaser.awaitAdvanceInterruptibly(this.pausePhaseNumber);
                LOGGER.info("{}: thread-{} comes back to service.", (Object)this.poolPrefix, (Object)t.getId());
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            if (this.afterExecuteFunc != null) {
                this.afterExecuteFunc.accept(r);
            }
        }
    }

    public synchronized void pause() {
        this.isPaused = true;
    }

    public synchronized void resume() {
        this.isPaused = false;
        this.pausePhaser.arrive();
        this.pausePhaseNumber = this.pausePhaser.getPhase();
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }
}

