/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.kquiet.concurrent.CommonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PausableThreadPoolExecutor.class);
    private volatile boolean isPaused = false;
    private final Phaser pausePhaser = new Phaser(1);
    private volatile int pausePhaseNumber = this.pausePhaser.getPhase();
    private final String poolPrefix;
    private final Consumer<Runnable> afterExecuteFunc;

    public PausableThreadPoolExecutor() {
        this("", 1, 1);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize) {
        this(poolPrefix, corePoolSize, maximumPoolSize, Integer.MAX_VALUE);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize) {
        this(poolPrefix, corePoolSize, maximumPoolSize, queueSize, null);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, Consumer<Runnable> afterExecuteFunc) {
        this(poolPrefix, corePoolSize, maximumPoolSize, Integer.MAX_VALUE, afterExecuteFunc);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize, Consumer<Runnable> afterExecuteFunc) {
        this(poolPrefix, corePoolSize, maximumPoolSize, queueSize, 10L, TimeUnit.MINUTES, afterExecuteFunc);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, int queueSize, long keepAliveTime, TimeUnit unit, Consumer<Runnable> afterExecuteFunc) {
        this(poolPrefix, corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)((Object)(queueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize))), new CommonThreadFactory(poolPrefix), afterExecuteFunc);
    }

    public PausableThreadPoolExecutor(String poolPrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Consumer<Runnable> afterExecuteFunc) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.poolPrefix = poolPrefix;
        this.afterExecuteFunc = afterExecuteFunc;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        try {
            while (this.isPaused) {
                LOGGER.info("{}: thread-{} is pending...", (Object)this.poolPrefix, (Object)t.getId());
                this.pausePhaser.awaitAdvanceInterruptibly(this.pausePhaseNumber);
                LOGGER.info("{}: thread-{} comes back to service.", (Object)this.poolPrefix, (Object)t.getId());
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            if (this.afterExecuteFunc != null) {
                this.afterExecuteFunc.accept(r);
            }
        }
    }

    public synchronized void pause() {
        this.isPaused = true;
    }

    public synchronized void resume() {
        this.isPaused = false;
        this.pausePhaser.arrive();
        this.pausePhaseNumber = this.pausePhaser.getPhase();
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }
}

