/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.kquiet.concurrent.Prioritized;

class PriorityRunnableFuture<T>
implements RunnableFuture<T>,
Prioritized {
    private static final AtomicLong CREATE_SEQUENCE = new AtomicLong(Long.MIN_VALUE);
    private final RunnableFuture<T> src;
    private final int priority;
    private final long seqNum;

    PriorityRunnableFuture(RunnableFuture<T> runnableFuture, int priority) {
        this.src = runnableFuture;
        this.priority = priority;
        this.seqNum = CREATE_SEQUENCE.getAndIncrement();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    long getCreateSequence() {
        return this.seqNum;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.src.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.src.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.src.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.src.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.src.get();
    }

    @Override
    public void run() {
        this.src.run();
    }
}

