/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.utility;

import java.time.Duration;

public class Stopwatch {
    private volatile long startTime = 0L;
    private volatile long stopTime = 0L;
    private volatile boolean running = false;

    public void start() {
        this.start(false);
    }

    public void start(boolean resetFlag) {
        if (resetFlag) {
            this.startTime = 0L;
            this.stopTime = 0L;
        }
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        this.running = true;
    }

    public void stop() {
        if (this.running) {
            this.stopTime = System.nanoTime();
            this.running = false;
        }
    }

    public long getElapsedMilliSecond() {
        long elapsed = this.running ? (System.nanoTime() - this.startTime) / 1000000L : (this.stopTime - this.startTime) / 1000000L;
        return elapsed;
    }

    public long getElapsedNanoSecond() {
        long elapsed = this.running ? System.nanoTime() - this.startTime : this.stopTime - this.startTime;
        return elapsed;
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.getElapsedNanoSecond());
    }
}

