/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import org.kramerlab.bmad.algorithms.CandidateGenerator;
import org.kramerlab.bmad.matrix.BooleanMatrix;

public class AssociationGenerator
implements CandidateGenerator {
    protected double confidenceThreshold;

    public AssociationGenerator(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public BooleanMatrix generateCandidates(BooleanMatrix a, int dimension) {
        int w = a.getWidth();
        BooleanMatrix result = new BooleanMatrix(w, w);
        for (int r = 0; r < w; ++r) {
            for (int c = 0; c < w; ++c) {
                int ones = 0;
                int implications = 0;
                for (int k = 0; k < a.getHeight(); ++k) {
                    if (a.apply(k, r) != 3) continue;
                    ++ones;
                    if (a.apply(k, c) != 3) continue;
                    ++implications;
                }
                if (!((double)implications > this.confidenceThreshold * (double)ones)) continue;
                result.update(r, c, (byte)3);
            }
        }
        return result;
    }

    public String toString() {
        return "Assoc[" + this.confidenceThreshold + "]";
    }
}

