/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.kramerlab.bmad.algorithms.BasisSelector;
import org.kramerlab.bmad.algorithms.Cover;
import org.kramerlab.bmad.general.Package;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.BooleanMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLoc
implements BasisSelector {
    @Override
    public Tuple<BooleanMatrix, BooleanMatrix> selectBasis(BooleanMatrix candidates, BooleanMatrix a, int dimension, double onesWeight) {
        if (dimension > candidates.getHeight()) {
            throw new IllegalArgumentException("dimension too high: cannot choose " + dimension + " basis rows out of " + candidates.getHeight() + " candidates!");
        }
        int w = a.getWidth();
        int h = a.getHeight();
        int numCandidates = candidates.getHeight();
        ArrayList<Cover> cover = new ArrayList<Cover>(numCandidates);
        for (int r = 0; r < h; ++r) {
            cover.add(new Cover(w, onesWeight));
        }
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        for (int i = 0; i < numCandidates; ++i) {
            permutation.add(i);
        }
        Collections.shuffle(permutation);
        double threshold = 0.0;
        int[][] potentiallyCoverableRowsOfA = new int[numCandidates][];
        Cover zeroCover = new Cover(w, onesWeight);
        for (int cand = 0; cand < numCandidates; ++cand) {
            BooleanMatrix basisRow = candidates.getRow(cand);
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int aRow = 0; aRow < h; ++aRow) {
                if (!(zeroCover.coverChangeDensityOnInclusion(a.getRow(aRow), basisRow) > threshold)) continue;
                list.add(aRow);
            }
            potentiallyCoverableRowsOfA[cand] = new int[list.size()];
            int i = 0;
            for (Integer e : list) {
                potentiallyCoverableRowsOfA[cand][i++] = e;
            }
        }
        BooleanMatrix combination = new BooleanMatrix(h, dimension);
        boolean basisImproves = true;
        while (basisImproves) {
            basisImproves = false;
            for (int b = 0; b < dimension; ++b) {
                int bestPermutationIndex = b;
                double bestCoverChange = 0.0;
                BooleanMatrix actualCandidate = candidates.getRow((Integer)permutation.get(b));
                for (int aRow = 0; aRow < h; ++aRow) {
                    Cover currentCover = (Cover)cover.get(aRow);
                    if (combination.apply(aRow, b) != 3) continue;
                    combination.update(aRow, b, (byte)0);
                    bestCoverChange -= currentCover.coverChangeOnExclusion(a.getRow(aRow), actualCandidate);
                    currentCover.exclude(actualCandidate);
                }
                for (int alternativePermutationIndex = dimension; alternativePermutationIndex < permutation.size(); ++alternativePermutationIndex) {
                    BooleanMatrix alternativeCandidate = candidates.getRow((Integer)permutation.get(alternativePermutationIndex));
                    double alternativeCoverChange = 0.0;
                    for (int aRow : potentiallyCoverableRowsOfA[(Integer)permutation.get(alternativePermutationIndex)]) {
                        alternativeCoverChange += Math.max(0.0, ((Cover)cover.get(aRow)).coverChangeOnInclusion(a.getRow(aRow), alternativeCandidate));
                    }
                    if (!(alternativeCoverChange > bestCoverChange)) continue;
                    bestCoverChange = alternativeCoverChange;
                    bestPermutationIndex = alternativePermutationIndex;
                }
                if (b != bestPermutationIndex) {
                    basisImproves = true;
                    int temp = (Integer)permutation.get(b);
                    permutation.set(b, (Integer)permutation.get(bestPermutationIndex));
                    permutation.set(bestPermutationIndex, temp);
                }
                BooleanMatrix newBasisRow = candidates.getRow((Integer)permutation.get(b));
                for (int aRow : potentiallyCoverableRowsOfA[(Integer)permutation.get(b)]) {
                    Cover currentCover = (Cover)cover.get(aRow);
                    if (!(currentCover.coverChangeOnInclusion(a.getRow(aRow), newBasisRow) > 0.0)) continue;
                    currentCover.include(newBasisRow);
                    combination.update(aRow, b, (byte)3);
                }
            }
        }
        BooleanMatrix basis = new BooleanMatrix(dimension, w);
        for (int b = 0; b < dimension; ++b) {
            basis.setRow(b, candidates.getRow((Integer)permutation.get(b)));
        }
        return Package.tuple(combination, basis);
    }

    public String toString() {
        return "FastLoc";
    }
}

