/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import java.util.HashSet;
import java.util.Iterator;
import org.kramerlab.bmad.algorithms.Combinator;
import org.kramerlab.bmad.algorithms.Cover;
import org.kramerlab.bmad.matrix.BooleanMatrix;

public abstract class GreedyCombinator
extends Combinator {
    protected abstract double usefulness(Cover var1, BooleanMatrix var2, BooleanMatrix var3);

    public BooleanMatrix combineRow(BooleanMatrix row, BooleanMatrix _, BooleanMatrix basis, double onesWeight) {
        int dim = basis.getHeight();
        BooleanMatrix combination = new BooleanMatrix(1, dim);
        HashSet<Integer> remainingIndices = new HashSet<Integer>();
        for (int i = 0; i < dim; ++i) {
            remainingIndices.add(i);
        }
        Cover cover = new Cover(row.getWidth(), onesWeight);
        while (true) {
            double maxUsefulness = Double.NEGATIVE_INFINITY;
            int bestIndex = -1;
            Iterator i$ = remainingIndices.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                BooleanMatrix basisRow = basis.getRow(i);
                double usefulness = this.usefulness(cover, row, basisRow);
                if (!(usefulness > maxUsefulness)) continue;
                maxUsefulness = usefulness;
                bestIndex = i;
            }
            if (!(maxUsefulness > 0.0)) break;
            remainingIndices.remove(bestIndex);
            cover.include(basis.getRow(bestIndex));
            combination.update(bestIndex, (byte)3);
        }
        return combination;
    }
}

